
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .country_code import TypeHelpCountryCode
    from ....gadgets.byteutils import Reader


class Country(TLObject, family='TypeHelpCountry'):
    """
    Name, ISO code, localized name and phone codes/patterns of a specific country
    """

    _id = 0XC3878E23
    _group_id = 0XD1EA5215

    def __init__(
        self,
        iso2: str,
        default_name: str,
        country_codes: List['TypeHelpCountryCode'],
        hidden: bool = False,
        name: Optional[str] = None
    ):

        """
        Name, ISO code, localized name and phone codes/patterns of a specific country

        Args:
            iso2 (str): ISO code of country
            default_name (str): Name of the country in the country's language
            country_codes (List['TypeHelpCountryCode']): Phone codes/patterns
            hidden (bool, optional): Whether this country should not be shown in the list
            name (Optional[str], optional): Name of the country in the user's language, if different from the original name
        """

        self.iso2 = iso2
        self.default_name = default_name
        self.country_codes = country_codes
        self.hidden = hidden
        self.name = name

    def to_bytes(self, boxed: bool=True):
        with Writer(b'#\x8e\x87\xc3' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.hidden, 0)
                writer.string(self.iso2)
                writer.string(self.default_name)

                if flags(self.name, 1):
                    writer.string(self.name)
                writer.vector(
                    self.country_codes,
                    lambda value: writer.object(
                        value,
                        group_id=0X8A9D3BF1
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        iso2_ = reader.string()
        default_name_ = reader.string()
        name_ = (
            reader.string()
            if flags(1) else None
        )

        country_codes_ = reader.vector(
            lambda: reader.object(
                group_id=0X8A9D3BF1
            )
        )

        return cls(
            iso2=iso2_,
            default_name=default_name_,
            country_codes=country_codes_,
            hidden=flags(0),
            name=name_
        )

TypeHelpCountry = Country