
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .input_user import TypeInputUser
    from ...gadgets.byteutils import Reader


class InputBusinessBotRecipients(TLObject, family='TypeInputBusinessBotRecipients'):
    """
    Specifies the private chats that a [connected business bot](https://core.telegram.org/api/business#connected-bots) may interact with.
    """

    _id = 0XC4E5921E
    _group_id = 0X25CF3823

    def __init__(
        self,
        existing_chats: bool = False,
        new_chats: bool = False,
        contacts: bool = False,
        non_contacts: bool = False,
        exclude_selected: bool = False,
        users: Optional[List['TypeInputUser']] = None,
        exclude_users: Optional[List['TypeInputUser']] = None
    ):

        """
        Specifies the private chats that a [connected business bot](https://core.telegram.org/api/business#connected-bots) may interact with.

        Args:
            existing_chats (bool, optional): Selects all existing private chats.
            new_chats (bool, optional): Selects all new private chats.
            contacts (bool, optional): Selects all private chats with contacts.
            non_contacts (bool, optional): Selects all private chats with non-contacts.
            exclude_selected (bool, optional): If set, then all private chats except the ones selected by existing_chats, new_chats, contacts, non_contacts and users are chosen. Note that if this flag is set, any values passed in exclude_users will be merged and moved into users by the server.
            users (Optional[List['TypeInputUser']], optional): Explicitly selected private chats.
            exclude_users (Optional[List['TypeInputUser']], optional): Identifiers of private chats that are always excluded.
        """

        self.existing_chats = existing_chats
        self.new_chats = new_chats
        self.contacts = contacts
        self.non_contacts = non_contacts
        self.exclude_selected = exclude_selected
        self.users = users
        self.exclude_users = exclude_users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1e\x92\xe5\xc4' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.existing_chats, 0)
                flags(self.new_chats, 1)
                flags(self.contacts, 2)
                flags(self.non_contacts, 3)
                flags(self.exclude_selected, 5)

                if flags(self.users, 4):
                    writer.vector(
                        self.users,
                        lambda value: writer.object(
                            value,
                            group_id=0XB628962F
                        )
                    )

                if flags(self.exclude_users, 6):
                    writer.vector(
                        self.exclude_users,
                        lambda value: writer.object(
                            value,
                            group_id=0XB628962F
                        )
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        users_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0XB628962F
                )
            )
            if flags(4) else None
        )

        exclude_users_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0XB628962F
                )
            )
            if flags(6) else None
        )

        return cls(
            existing_chats=flags(0),
            new_chats=flags(1),
            contacts=flags(2),
            non_contacts=flags(3),
            exclude_selected=flags(5),
            users=users_,
            exclude_users=exclude_users_
        )

TypeInputBusinessBotRecipients = InputBusinessBotRecipients