
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class InputEncryptedFileEmpty(TLObject, family='TypeInputEncryptedFile'):
    """
    Empty constructor.
    """

    _id = 0X1837C364
    _group_id = 0X7D7FFAC2


    def to_bytes(self, boxed: bool=True):
        return b'd\xc37\x18' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputEncryptedFileUploaded(TLObject, family='TypeInputEncryptedFile'):
    """
    Sets new encrypted file saved by parts using upload.saveFilePart method.
    """

    _id = 0X64BD0306
    _group_id = 0X7D7FFAC2

    def __init__(
        self,
        id: int,
        parts: int,
        md5_checksum: str,
        key_fingerprint: int
    ):

        """
        Sets new encrypted file saved by parts using upload.saveFilePart method.

        Args:
            id (int): Random file ID created by client
            parts (int): Number of saved parts
            md5_checksum (str): In case [md5-HASH](https://en.wikipedia.org/wiki/MD5) of the (already encrypted) file was transmitted, file content will be checked prior to use
            key_fingerprint (int): 32-bit fingerprint of the key used to encrypt a file
        """

        self.id = id
        self.parts = parts
        self.md5_checksum = md5_checksum
        self.key_fingerprint = key_fingerprint

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x06\x03\xbdd' if boxed else b'') as writer:
            writer.long(self.id)
            writer.int(self.parts)
            writer.string(self.md5_checksum)
            writer.int(self.key_fingerprint)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        parts_ = reader.int()
        md5_checksum_ = reader.string()
        key_fingerprint_ = reader.int()

        return cls(
            id=id_,
            parts=parts_,
            md5_checksum=md5_checksum_,
            key_fingerprint=key_fingerprint_
        )

class InputEncryptedFile(TLObject, family='TypeInputEncryptedFile'):
    """
    Sets forwarded encrypted file for attachment.
    """

    _id = 0X5A17B5E5
    _group_id = 0X7D7FFAC2

    def __init__(
        self,
        id: int,
        access_hash: int
    ):

        """
        Sets forwarded encrypted file for attachment.

        Args:
            id (int): File ID, value of id parameter from [encryptedFile](https://core.telegram.org/constructor/encryptedFile)
            access_hash (int): Checking sum, value of access_hash parameter from [encryptedFile](https://core.telegram.org/constructor/encryptedFile)
        """

        self.id = id
        self.access_hash = access_hash

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe5\xb5\x17Z' if boxed else b'') as writer:
            writer.long(self.id)
            writer.long(self.access_hash)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        access_hash_ = reader.long()

        return cls(
            id=id_,
            access_hash=access_hash_
        )

class InputEncryptedFileBigUploaded(TLObject, family='TypeInputEncryptedFile'):
    """
    Assigns a new big encrypted file (over 10 MB in size), saved in parts using the method [upload.saveBigFilePart](https://core.telegram.org/method/upload.saveBigFilePart).
    """

    _id = 0X2DC173C8
    _group_id = 0X7D7FFAC2

    def __init__(
        self,
        id: int,
        parts: int,
        key_fingerprint: int
    ):

        """
        Assigns a new big encrypted file (over 10 MB in size), saved in parts using the method [upload.saveBigFilePart](https://core.telegram.org/method/upload.saveBigFilePart).

        Args:
            id (int): Random file id, created by the client
            parts (int): Number of saved parts
            key_fingerprint (int): 32-bit imprint of the key used to encrypt the file
        """

        self.id = id
        self.parts = parts
        self.key_fingerprint = key_fingerprint

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc8s\xc1-' if boxed else b'') as writer:
            writer.long(self.id)
            writer.int(self.parts)
            writer.int(self.key_fingerprint)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        parts_ = reader.int()
        key_fingerprint_ = reader.int()

        return cls(
            id=id_,
            parts=parts_,
            key_fingerprint=key_fingerprint_
        )

TypeInputEncryptedFile = Union[
    InputEncryptedFileEmpty,
    InputEncryptedFileUploaded,
    InputEncryptedFile,
    InputEncryptedFileBigUploaded
]