
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .mask_coords import TypeMaskCoords
    from .input_document import TypeInputDocument
    from ...gadgets.byteutils import Reader


class InputStickerSetItem(TLObject, family='TypeInputStickerSetItem'):
    """
    Sticker in a stickerset
    """

    _id = 0X32DA9E9C
    _group_id = 0X6B1BC0F3

    def __init__(
        self,
        document: 'TypeInputDocument',
        emoji: str,
        mask_coords: Optional['TypeMaskCoords'] = None,
        keywords: Optional[str] = None
    ):

        """
        Sticker in a stickerset

        Args:
            document ('TypeInputDocument'): The sticker
            emoji (str): Associated emoji
            mask_coords (Optional['TypeMaskCoords'], optional): Coordinates for mask sticker
            keywords (Optional[str], optional): Set of keywords, separated by commas (can't be provided for mask stickers)
        """

        self.document = document
        self.emoji = emoji
        self.mask_coords = mask_coords
        self.keywords = keywords

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9c\x9e\xda2' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.document,
                    group_id=0X84313E
                )
                writer.string(self.emoji)

                if flags(self.mask_coords, 0):
                    writer.object(
                        self.mask_coords,
                        group_id=0X32852A28
                    )

                if flags(self.keywords, 1):
                    writer.string(self.keywords)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        document_ = reader.object(
            group_id=0X84313E
        )

        emoji_ = reader.string()
        mask_coords_ = (
            reader.object(
                group_id=0X32852A28
            )
            if flags(0) else None
        )

        keywords_ = (
            reader.string()
            if flags(1) else None
        )

        return cls(
            document=document_,
            emoji=emoji_,
            mask_coords=mask_coords_,
            keywords=keywords_
        )

TypeInputStickerSetItem = InputStickerSetItem