
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class LangPackLanguage(TLObject, family='TypeLangPackLanguage'):
    """
    Identifies a localization pack
    """

    _id = 0XEECA5CE3
    _group_id = 0X3BBFAA24

    def __init__(
        self,
        name: str,
        native_name: str,
        lang_code: str,
        plural_code: str,
        strings_count: int,
        translated_count: int,
        translations_url: str,
        official: bool = False,
        rtl: bool = False,
        beta: bool = False,
        base_lang_code: Optional[str] = None
    ):

        """
        Identifies a localization pack

        Args:
            name (str): Language name
            native_name (str): Language name in the language itself
            lang_code (str): Language code (pack identifier)
            plural_code (str): A language code to be used to apply plural forms. See [https://www.unicode.org/cldr/charts/latest/supplemental/language_plural_rules.html](https://www.unicode.org/cldr/charts/latest/supplemental/language_plural_rules.html) for more info
            strings_count (int): Total number of non-deleted strings from the language pack
            translated_count (int): Total number of translated strings from the language pack
            translations_url (str): Link to language translation interface; empty for custom local language packs
            official (bool, optional): Whether the language pack is official
            rtl (bool, optional): Is this a localization pack for an RTL language
            beta (bool, optional): Is this a beta localization pack?
            base_lang_code (Optional[str], optional): Identifier of a base language pack; may be empty. If a string is missed in the language pack, then it should be fetched from base language pack. Unsupported in custom language packs
        """

        self.name = name
        self.native_name = native_name
        self.lang_code = lang_code
        self.plural_code = plural_code
        self.strings_count = strings_count
        self.translated_count = translated_count
        self.translations_url = translations_url
        self.official = official
        self.rtl = rtl
        self.beta = beta
        self.base_lang_code = base_lang_code

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe3\\\xca\xee' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.official, 0)
                flags(self.rtl, 2)
                flags(self.beta, 3)
                writer.string(self.name)
                writer.string(self.native_name)
                writer.string(self.lang_code)

                if flags(self.base_lang_code, 1):
                    writer.string(self.base_lang_code)
                writer.string(self.plural_code)
                writer.int(self.strings_count)
                writer.int(self.translated_count)
                writer.string(self.translations_url)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        name_ = reader.string()
        native_name_ = reader.string()
        lang_code_ = reader.string()
        base_lang_code_ = (
            reader.string()
            if flags(1) else None
        )

        plural_code_ = reader.string()
        strings_count_ = reader.int()
        translated_count_ = reader.int()
        translations_url_ = reader.string()

        return cls(
            name=name_,
            native_name=native_name_,
            lang_code=lang_code_,
            plural_code=plural_code_,
            strings_count=strings_count_,
            translated_count=translated_count_,
            translations_url=translations_url_,
            official=flags(0),
            rtl=flags(2),
            beta=flags(3),
            base_lang_code=base_lang_code_
        )

TypeLangPackLanguage = LangPackLanguage