
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class MaskCoords(TLObject, family='TypeMaskCoords'):
    """
    Position on a photo where a mask should be placed when [attaching stickers to media](https://core.telegram.org/api/stickers#attached-stickers)
    """

    _id = 0XAED6DBB2
    _group_id = 0X32852A28

    def __init__(
        self,
        n: int,
        x: float,
        y: float,
        zoom: float
    ):

        """
        Position on a photo where a mask should be placed when [attaching stickers to media](https://core.telegram.org/api/stickers#attached-stickers)

        Args:
            n (int): Part of the face, relative to which the mask should be placed
            x (float): Shift by X-axis measured in widths of the mask scaled to the face size, from left to right. (For example, -1.0 will place the mask just to the left of the default mask position)
            y (float): Shift by Y-axis measured in widths of the mask scaled to the face size, from left to right. (For example, -1.0 will place the mask just below the default mask position)
            zoom (float): Mask scaling coefficient. (For example, 2.0 means a doubled size)
        """

        self.n = n
        self.x = x
        self.y = y
        self.zoom = zoom

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb2\xdb\xd6\xae' if boxed else b'') as writer:
            writer.int(self.n)
            writer.double(self.x)
            writer.double(self.y)
            writer.double(self.zoom)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        n_ = reader.int()
        x_ = reader.double()
        y_ = reader.double()
        zoom_ = reader.double()

        return cls(
            n=n_,
            x=x_,
            y=y_,
            zoom=zoom_
        )

TypeMaskCoords = MaskCoords