
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from ...gadgets.byteutils import Reader


class MessageFwdHeader(TLObject, family='TypeMessageFwdHeader'):
    """
    Info about a forwarded message
    """

    _id = 0X4E4DF4BB
    _group_id = 0XEA3B4B97

    def __init__(
        self,
        date: int,
        imported: bool = False,
        saved_out: bool = False,
        from_id: Optional['TypePeer'] = None,
        from_name: Optional[str] = None,
        channel_post: Optional[int] = None,
        post_author: Optional[str] = None,
        saved_from_peer: Optional['TypePeer'] = None,
        saved_from_msg_id: Optional[int] = None,
        saved_from_id: Optional['TypePeer'] = None,
        saved_from_name: Optional[str] = None,
        saved_date: Optional[int] = None,
        psa_type: Optional[str] = None
    ):

        """
        Info about a forwarded message

        Args:
            date (int): When was the message originally sent
            imported (bool, optional): Whether this message was [imported from a foreign chat service, click here for more info](https://core.telegram.org/api/import)
            saved_out (bool, optional): Only for messages forwarded to [saved messages](https://core.telegram.org/api/saved-messages), set if the original message was outgoing (though the message may have been originally outgoing even if this flag is not set, if from_id points to the current user).
            from_id (Optional['TypePeer'], optional): The ID of the user that originally sent the message
            from_name (Optional[str], optional): The name of the user that originally sent the message
            channel_post (Optional[int], optional): ID of the channel message that was forwarded
            post_author (Optional[str], optional): For channels and if signatures are enabled, author of the channel message
            saved_from_peer (Optional['TypePeer'], optional): Only for messages forwarded to [saved messages](https://core.telegram.org/api/saved-messages), contains the dialog where the message was originally sent.
            saved_from_msg_id (Optional[int], optional): Only for messages forwarded to [saved messages](https://core.telegram.org/api/saved-messages), contains the original ID of the message in saved_from_peer.
            saved_from_id (Optional['TypePeer'], optional): Only for forwarded messages reforwarded to [saved messages](https://core.telegram.org/api/saved-messages), contains the sender of the original message (i.e. if user A sends a message, then user B forwards it somewhere, then user C saves it to saved messages, this field will contain the ID of user B and from_id will contain the ID of user A).
            saved_from_name (Optional[str], optional): Only for forwarded messages from users with forward privacy enabled, sent by users with forward privacy enabled, reforwarded to [saved messages](https://core.telegram.org/api/saved-messages), contains the sender of the original message (i.e. if user A (fwd privacy enabled) sends a message, then user B (fwd privacy enabled) forwards it somewhere, then user C saves it to saved messages, this field will contain the name of user B and from_name will contain the name of user A).
            saved_date (Optional[int], optional): Only for forwarded messages reforwarded to [saved messages](https://core.telegram.org/api/saved-messages), indicates when was the original message sent (i.e. if user A sends a message @ unixtime 1, then user B forwards it somewhere @ unixtime 2, then user C saves it to saved messages @ unixtime 3, this field will contain 2, date will contain 1 and the date of the containing [message](https://core.telegram.org/constructor/message) will contain 3).
            psa_type (Optional[str], optional): PSA type
        """

        self.date = date
        self.imported = imported
        self.saved_out = saved_out
        self.from_id = from_id
        self.from_name = from_name
        self.channel_post = channel_post
        self.post_author = post_author
        self.saved_from_peer = saved_from_peer
        self.saved_from_msg_id = saved_from_msg_id
        self.saved_from_id = saved_from_id
        self.saved_from_name = saved_from_name
        self.saved_date = saved_date
        self.psa_type = psa_type

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xbb\xf4MN' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.imported, 7)
                flags(self.saved_out, 11)

                if flags(self.from_id, 0):
                    writer.object(
                        self.from_id,
                        group_id=0XB4DECBCA
                    )

                if flags(self.from_name, 5):
                    writer.string(self.from_name)
                writer.int(self.date)

                if flags(self.channel_post, 2):
                    writer.int(self.channel_post)

                if flags(self.post_author, 3):
                    writer.string(self.post_author)

                if flags(self.saved_from_peer, 4):
                    writer.object(
                        self.saved_from_peer,
                        group_id=0XB4DECBCA
                    )

                if flags(self.saved_from_msg_id, 4):
                    writer.int(self.saved_from_msg_id)

                if flags(self.saved_from_id, 8):
                    writer.object(
                        self.saved_from_id,
                        group_id=0XB4DECBCA
                    )

                if flags(self.saved_from_name, 9):
                    writer.string(self.saved_from_name)

                if flags(self.saved_date, 10):
                    writer.int(self.saved_date)

                if flags(self.psa_type, 6):
                    writer.string(self.psa_type)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        from_id_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(0) else None
        )

        from_name_ = (
            reader.string()
            if flags(5) else None
        )

        date_ = reader.int()
        channel_post_ = (
            reader.int()
            if flags(2) else None
        )

        post_author_ = (
            reader.string()
            if flags(3) else None
        )

        saved_from_peer_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(4) else None
        )

        saved_from_msg_id_ = (
            reader.int()
            if flags(4) else None
        )

        saved_from_id_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(8) else None
        )

        saved_from_name_ = (
            reader.string()
            if flags(9) else None
        )

        saved_date_ = (
            reader.int()
            if flags(10) else None
        )

        psa_type_ = (
            reader.string()
            if flags(6) else None
        )

        return cls(
            date=date_,
            imported=flags(7),
            saved_out=flags(11),
            from_id=from_id_,
            from_name=from_name_,
            channel_post=channel_post_,
            post_author=post_author_,
            saved_from_peer=saved_from_peer_,
            saved_from_msg_id=saved_from_msg_id_,
            saved_from_id=saved_from_id_,
            saved_from_name=saved_from_name_,
            saved_date=saved_date_,
            psa_type=psa_type_
        )

TypeMessageFwdHeader = MessageFwdHeader