
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ....gadgets.byteutils import Reader


class AffectedHistory(TLObject, family='TypeMessagesAffectedHistory'):
    """
    Affected part of communication history with the user or in a chat.
    """

    _id = 0XB45C69D1
    _group_id = 0XC038BDBA

    def __init__(
        self,
        pts: int,
        pts_count: int,
        offset: int
    ):

        """
        Affected part of communication history with the user or in a chat.

        Args:
            pts (int): Number of events occurred in a text box
            pts_count (int): Number of affected events
            offset (int): If a parameter contains positive value, it is necessary to repeat the method call using the given value; during the proceeding of all the history the value itself shall gradually decrease
        """

        self.pts = pts
        self.pts_count = pts_count
        self.offset = offset

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd1i\\\xb4' if boxed else b'') as writer:
            writer.int(self.pts)
            writer.int(self.pts_count)
            writer.int(self.offset)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        pts_ = reader.int()
        pts_count_ = reader.int()
        offset_ = reader.int()

        return cls(
            pts=pts_,
            pts_count=pts_count_,
            offset=offset_
        )

TypeMessagesAffectedHistory = AffectedHistory