
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..message import TypeMessage
    from ....gadgets.byteutils import Reader
    from ..search_results_calendar_period import TypeSearchResultsCalendarPeriod


class SearchResultsCalendar(TLObject, family='TypeMessagesSearchResultsCalendar'):
    """
    Information about found messages sent on a specific day
    """

    _id = 0X147EE23C
    _group_id = 0XB3425669

    def __init__(
        self,
        count: int,
        min_date: int,
        min_msg_id: int,
        periods: List['TypeSearchResultsCalendarPeriod'],
        messages: List['TypeMessage'],
        chats: List['TypeChat'],
        users: List['TypeUser'],
        inexact: bool = False,
        offset_id_offset: Optional[int] = None
    ):

        """
        Information about found messages sent on a specific day

        Args:
            count (int): Total number of results matching query
            min_date (int): Starting timestamp of attached messages
            min_msg_id (int): Ending timestamp of attached messages
            periods (List['TypeSearchResultsCalendarPeriod']): Used to split the messages by days: multiple [SearchResultsCalendarPeriod](https://core.telegram.org/type/SearchResultsCalendarPeriod) constructors are returned, each containing information about the first, last and total number of messages matching the filter that were sent on a specific day.  This information can be easily used to split the returned messages by day.
            messages (List['TypeMessage']): Messages
            chats (List['TypeChat']): Mentioned chats
            users (List['TypeUser']): Mentioned users
            inexact (bool, optional): If set, indicates that the results may be inexact
            offset_id_offset (Optional[int], optional): Indicates the absolute position of messages[0] within the total result set with count count. This is useful, for example, if we need to display a progress/total counter (like photo 134 of 200, for all media in a chat, we could simply use photo ${offset_id_offset} of ${count}.
        """

        self.count = count
        self.min_date = min_date
        self.min_msg_id = min_msg_id
        self.periods = periods
        self.messages = messages
        self.chats = chats
        self.users = users
        self.inexact = inexact
        self.offset_id_offset = offset_id_offset

    def to_bytes(self, boxed: bool=True):
        with Writer(b'<\xe2~\x14' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.inexact, 0)
                writer.int(self.count)
                writer.int(self.min_date)
                writer.int(self.min_msg_id)

                if flags(self.offset_id_offset, 1):
                    writer.int(self.offset_id_offset)
                writer.vector(
                    self.periods,
                    lambda value: writer.object(
                        value,
                        group_id=0XBC0E1D3C
                    )
                )
                writer.vector(
                    self.messages,
                    lambda value: writer.object(
                        value,
                        group_id=0X25780A8F
                    )
                )
                writer.vector(
                    self.chats,
                    lambda value: writer.object(
                        value,
                        group_id=0X73A5C0D9
                    )
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        count_ = reader.int()
        min_date_ = reader.int()
        min_msg_id_ = reader.int()
        offset_id_offset_ = (
            reader.int()
            if flags(1) else None
        )

        periods_ = reader.vector(
            lambda: reader.object(
                group_id=0XBC0E1D3C
            )
        )

        messages_ = reader.vector(
            lambda: reader.object(
                group_id=0X25780A8F
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            count=count_,
            min_date=min_date_,
            min_msg_id=min_msg_id_,
            periods=periods_,
            messages=messages_,
            chats=chats_,
            users=users_,
            inexact=flags(0),
            offset_id_offset=offset_id_offset_
        )

TypeMessagesSearchResultsCalendar = SearchResultsCalendar