
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from ...gadgets.byteutils import Reader


class NotifyPeer(TLObject, family='TypeNotifyPeer'):
    """
    Notifications generated by a certain user or group.
    """

    _id = 0X9FD40BD8
    _group_id = 0XEBD6F8FB

    def __init__(
        self,
        peer: 'TypePeer'
    ):

        """
        Notifications generated by a certain user or group.

        Args:
            peer ('TypePeer'): user or group
        """

        self.peer = peer

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd8\x0b\xd4\x9f' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        return cls(
            peer=peer_
        )

class NotifyUsers(TLObject, family='TypeNotifyPeer'):
    """
    Notifications generated by all users.
    """

    _id = 0XB4C83B4C
    _group_id = 0XEBD6F8FB


    def to_bytes(self, boxed: bool=True):
        return b'L;\xc8\xb4' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class NotifyChats(TLObject, family='TypeNotifyPeer'):
    """
    Notifications generated by all groups.
    """

    _id = 0XC007CEC3
    _group_id = 0XEBD6F8FB


    def to_bytes(self, boxed: bool=True):
        return b'\xc3\xce\x07\xc0' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class NotifyBroadcasts(TLObject, family='TypeNotifyPeer'):
    """
    Channel notification settings
    """

    _id = 0XD612E8EF
    _group_id = 0XEBD6F8FB


    def to_bytes(self, boxed: bool=True):
        return b'\xef\xe8\x12\xd6' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class NotifyForumTopic(TLObject, family='TypeNotifyPeer'):
    """
    Notifications generated by a [topic](https://core.telegram.org/api/forum#forum-topics) in a [forum](https://core.telegram.org/api/forum).
    """

    _id = 0X226E6308
    _group_id = 0XEBD6F8FB

    def __init__(
        self,
        peer: 'TypePeer',
        top_msg_id: int
    ):

        """
        Notifications generated by a [topic](https://core.telegram.org/api/forum#forum-topics) in a [forum](https://core.telegram.org/api/forum).

        Args:
            peer ('TypePeer'): Forum ID
            top_msg_id (int): [Topic ID](https://core.telegram.org/api/forum#forum-topics)
        """

        self.peer = peer
        self.top_msg_id = top_msg_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x08cn"' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.int(self.top_msg_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        top_msg_id_ = reader.int()

        return cls(
            peer=peer_,
            top_msg_id=top_msg_id_
        )

TypeNotifyPeer = Union[
    NotifyPeer,
    NotifyUsers,
    NotifyChats,
    NotifyBroadcasts,
    NotifyForumTopic
]