
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..stats_graph import TypeStatsGraph
    from ....gadgets.byteutils import Reader
    from ..stars_revenue_status import TypeStarsRevenueStatus


class StarsRevenueStats(TLObject, family='TypePaymentsStarsRevenueStats'):
    """
    [Star revenue statistics, see here](https://core.telegram.org/api/stars) for more info.
    """

    _id = 0X6C207376
    _group_id = 0X51B5B14C

    def __init__(
        self,
        revenue_graph: 'TypeStatsGraph',
        status: 'TypeStarsRevenueStatus',
        usd_rate: float,
        top_hours_graph: Optional['TypeStatsGraph'] = None
    ):

        """
        [Star revenue statistics, see here](https://core.telegram.org/api/stars) for more info.

        Args:
            revenue_graph ('TypeStatsGraph'): Star revenue graph (number of earned stars)
            status ('TypeStarsRevenueStatus'): Current balance, current withdrawable balance and overall earned Telegram Stars
            usd_rate (float): Current conversion rate of Telegram Stars to USD
            top_hours_graph (Optional['TypeStatsGraph'], optional): ...
        """

        self.revenue_graph = revenue_graph
        self.status = status
        self.usd_rate = usd_rate
        self.top_hours_graph = top_hours_graph

    def to_bytes(self, boxed: bool=True):
        with Writer(b'vs l' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.top_hours_graph, 0):
                    writer.object(
                        self.top_hours_graph,
                        group_id=0XAFAEA986
                    )
                writer.object(
                    self.revenue_graph,
                    group_id=0XAFAEA986
                )
                writer.object(
                    self.status,
                    group_id=0XC576A749
                )
                writer.double(self.usd_rate)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        top_hours_graph_ = (
            reader.object(
                group_id=0XAFAEA986
            )
            if flags(0) else None
        )

        revenue_graph_ = reader.object(
            group_id=0XAFAEA986
        )

        status_ = reader.object(
            group_id=0XC576A749
        )

        usd_rate_ = reader.double()

        return cls(
            revenue_graph=revenue_graph_,
            status=status_,
            usd_rate=usd_rate_,
            top_hours_graph=top_hours_graph_
        )

TypePaymentsStarsRevenueStats = StarsRevenueStats