
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING, List, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .photo_size import TypePhotoSize
    from .video_size import TypeVideoSize
    from ...gadgets.byteutils import Reader


class PhotoEmpty(TLObject, family='TypePhoto'):
    """
    Empty constructor, non-existent photo
    """

    _id = 0X2331B22D
    _group_id = 0XDDAD9CAC

    def __init__(
        self,
        id: int
    ):

        """
        Empty constructor, non-existent photo

        Args:
            id (int): Photo identifier
        """

        self.id = id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'-\xb21#' if boxed else b'') as writer:
            writer.long(self.id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()

        return cls(
            id=id_
        )

class Photo(TLObject, family='TypePhoto'):
    """
    Photo
    """

    _id = 0XFB197A65
    _group_id = 0XDDAD9CAC

    def __init__(
        self,
        id: int,
        access_hash: int,
        file_reference: bytes,
        date: int,
        sizes: List['TypePhotoSize'],
        dc_id: int,
        has_stickers: bool = False,
        video_sizes: Optional[List['TypeVideoSize']] = None
    ):

        """
        Photo

        Args:
            id (int): ID
            access_hash (int): Access hash
            file_reference (bytes): [file reference](https://core.telegram.org/api/file_reference)
            date (int): Date of upload
            sizes (List['TypePhotoSize']): Available sizes for download
            dc_id (int): DC ID to use for download
            has_stickers (bool, optional): Whether the photo has mask stickers attached to it
            video_sizes (Optional[List['TypeVideoSize']], optional): [For animated profiles](https://core.telegram.org/api/files#animated-profile-pictures), the MPEG4 videos
        """

        self.id = id
        self.access_hash = access_hash
        self.file_reference = file_reference
        self.date = date
        self.sizes = sizes
        self.dc_id = dc_id
        self.has_stickers = has_stickers
        self.video_sizes = video_sizes

    def to_bytes(self, boxed: bool=True):
        with Writer(b'ez\x19\xfb' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.has_stickers, 0)
                writer.long(self.id)
                writer.long(self.access_hash)
                writer.bytes(self.file_reference)
                writer.int(self.date)
                writer.vector(
                    self.sizes,
                    lambda value: writer.object(
                        value,
                        group_id=0X478D00B0
                    )
                )

                if flags(self.video_sizes, 1):
                    writer.vector(
                        self.video_sizes,
                        lambda value: writer.object(
                            value,
                            group_id=0X32B0FC60
                        )
                    )
                writer.int(self.dc_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.long()
        access_hash_ = reader.long()
        file_reference_ = reader.bytes()
        date_ = reader.int()
        sizes_ = reader.vector(
            lambda: reader.object(
                group_id=0X478D00B0
            )
        )

        video_sizes_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X32B0FC60
                )
            )
            if flags(1) else None
        )

        dc_id_ = reader.int()

        return cls(
            id=id_,
            access_hash=access_hash_,
            file_reference=file_reference_,
            date=date_,
            sizes=sizes_,
            dc_id=dc_id_,
            has_stickers=flags(0),
            video_sizes=video_sizes_
        )

TypePhoto = Union[
    PhotoEmpty,
    Photo
]