
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from .message_entity import TypeMessageEntity
    from .poll_answer_voters import TypePollAnswerVoters
    from ...gadgets.byteutils import Reader


class PollResults(TLObject, family='TypePollResults'):
    """
    Results of poll
    """

    _id = 0X7ADF2420
    _group_id = 0X3539EE44

    def __init__(
        self,
        min: bool = False,
        results: Optional[List['TypePollAnswerVoters']] = None,
        total_voters: Optional[int] = None,
        recent_voters: Optional[List['TypePeer']] = None,
        solution: Optional[str] = None,
        solution_entities: Optional[List['TypeMessageEntity']] = None
    ):

        """
        Results of poll

        Args:
            min (bool, optional): Similar to [min](https://core.telegram.org/api/min) objects, used for poll constructors that are the same for all users so they don't have the option chosen by the current user (you can use [messages.getPollResults](https://core.telegram.org/method/messages.getPollResults) to get the full poll results).
            results (Optional[List['TypePollAnswerVoters']], optional): Poll results
            total_voters (Optional[int], optional): Total number of people that voted in the poll
            recent_voters (Optional[List['TypePeer']], optional): IDs of the last users that recently voted in the poll
            solution (Optional[str], optional): Explanation of quiz solution
            solution_entities (Optional[List['TypeMessageEntity']], optional): [Message entities for styled text in quiz solution](https://core.telegram.org/api/entities)
        """

        self.min = min
        self.results = results
        self.total_voters = total_voters
        self.recent_voters = recent_voters
        self.solution = solution
        self.solution_entities = solution_entities

    def to_bytes(self, boxed: bool=True):
        with Writer(b' $\xdfz' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.min, 0)

                if flags(self.results, 1):
                    writer.vector(
                        self.results,
                        lambda value: writer.object(
                            value,
                            group_id=0XECF3EC02
                        )
                    )

                if flags(self.total_voters, 2):
                    writer.int(self.total_voters)

                if flags(self.recent_voters, 3):
                    writer.vector(
                        self.recent_voters,
                        lambda value: writer.object(
                            value,
                            group_id=0XB4DECBCA
                        )
                    )

                if flags(self.solution, 4):
                    writer.string(self.solution)

                if flags(self.solution_entities, 4):
                    writer.vector(
                        self.solution_entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        results_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0XECF3EC02
                )
            )
            if flags(1) else None
        )

        total_voters_ = (
            reader.int()
            if flags(2) else None
        )

        recent_voters_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0XB4DECBCA
                )
            )
            if flags(3) else None
        )

        solution_ = (
            reader.string()
            if flags(4) else None
        )

        solution_entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(4) else None
        )

        return cls(
            min=flags(0),
            results=results_,
            total_voters=total_voters_,
            recent_voters=recent_voters_,
            solution=solution_,
            solution_entities=solution_entities_
        )

TypePollResults = PollResults