
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class PremiumSubscriptionOption(TLObject, family='TypePremiumSubscriptionOption'):
    """
    Describes a Telegram Premium subscription option
    """

    _id = 0X5F2D1DF2
    _group_id = 0XE19C4C61

    def __init__(
        self,
        months: int,
        currency: str,
        amount: int,
        bot_url: str,
        current: bool = False,
        can_purchase_upgrade: bool = False,
        transaction: Optional[str] = None,
        store_product: Optional[str] = None
    ):

        """
        Describes a Telegram Premium subscription option

        Args:
            months (int): Duration of subscription in months
            currency (str): Three-letter ISO 4217 [currency](https://core.telegram.org/bots/payments#supported-currencies) code
            amount (int): Total price in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
            bot_url (str): [Deep link](https://core.telegram.org/api/links) used to initiate payment
            current (bool, optional): Whether this subscription option is currently in use.
            can_purchase_upgrade (bool, optional): Whether this subscription option can be used to upgrade the existing Telegram Premium subscription. When upgrading Telegram Premium subscriptions bought through stores, make sure that the store transaction ID is equal to transaction, to avoid upgrading someone else's account, if the client is currently logged into multiple accounts.
            transaction (Optional[str], optional): Identifier of the last in-store transaction for the currently used subscription on the current account.
            store_product (Optional[str], optional): Store product ID, only for official apps
        """

        self.months = months
        self.currency = currency
        self.amount = amount
        self.bot_url = bot_url
        self.current = current
        self.can_purchase_upgrade = can_purchase_upgrade
        self.transaction = transaction
        self.store_product = store_product

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf2\x1d-_' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.current, 1)
                flags(self.can_purchase_upgrade, 2)

                if flags(self.transaction, 3):
                    writer.string(self.transaction)
                writer.int(self.months)
                writer.string(self.currency)
                writer.long(self.amount)
                writer.string(self.bot_url)

                if flags(self.store_product, 0):
                    writer.string(self.store_product)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        transaction_ = (
            reader.string()
            if flags(3) else None
        )

        months_ = reader.int()
        currency_ = reader.string()
        amount_ = reader.long()
        bot_url_ = reader.string()
        store_product_ = (
            reader.string()
            if flags(0) else None
        )

        return cls(
            months=months_,
            currency=currency_,
            amount=amount_,
            bot_url=bot_url_,
            current=flags(1),
            can_purchase_upgrade=flags(2),
            transaction=transaction_,
            store_product=store_product_
        )

TypePremiumSubscriptionOption = PremiumSubscriptionOption