
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class ReactionEmpty(TLObject, family='TypeReaction'):
    """
    No reaction
    """

    _id = 0X79F5D419
    _group_id = 0X19F930D1


    def to_bytes(self, boxed: bool=True):
        return b'\x19\xd4\xf5y' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class ReactionEmoji(TLObject, family='TypeReaction'):
    """
    Normal emoji message reaction
    """

    _id = 0X1B2286B8
    _group_id = 0X19F930D1

    def __init__(
        self,
        emoticon: str
    ):

        """
        Normal emoji message reaction

        Args:
            emoticon (str): Emoji
        """

        self.emoticon = emoticon

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb8\x86"\x1b' if boxed else b'') as writer:
            writer.string(self.emoticon)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        emoticon_ = reader.string()

        return cls(
            emoticon=emoticon_
        )

class ReactionCustomEmoji(TLObject, family='TypeReaction'):
    """
    [Custom emoji](https://core.telegram.org/api/custom-emoji) message reaction
    """

    _id = 0X8935FC73
    _group_id = 0X19F930D1

    def __init__(
        self,
        document_id: int
    ):

        """
        [Custom emoji](https://core.telegram.org/api/custom-emoji) message reaction

        Args:
            document_id (int): [Custom emoji document ID](https://core.telegram.org/api/custom-emoji)
        """

        self.document_id = document_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b's\xfc5\x89' if boxed else b'') as writer:
            writer.long(self.document_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        document_id_ = reader.long()

        return cls(
            document_id=document_id_
        )

class ReactionPaid(TLObject, family='TypeReaction'):
    """
    Represents a [paid Telegram Star reaction](https://core.telegram.org/api/reactions#paid-reactions).
    """

    _id = 0X523DA4EB
    _group_id = 0X19F930D1


    def to_bytes(self, boxed: bool=True):
        return b'\xeb\xa4=R' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

TypeReaction = Union[
    ReactionEmpty,
    ReactionEmoji,
    ReactionCustomEmoji,
    ReactionPaid
]