
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from .star_gift import TypeStarGift
    from .stars_amount import TypeStarsAmount
    from .web_document import TypeWebDocument
    from .message_media import TypeMessageMedia
    from ...gadgets.byteutils import Reader
    from .stars_transaction_peer import TypeStarsTransactionPeer


class StarsTransaction(TLObject, family='TypeStarsTransaction'):
    """
    Represents a [Telegram Stars transaction](https://core.telegram.org/api/stars).
    """

    _id = 0X13659EB0
    _group_id = 0X169B64E1

    def __init__(
        self,
        id: str,
        amount: 'TypeStarsAmount',
        date: int,
        peer: 'TypeStarsTransactionPeer',
        refund: bool = False,
        pending: bool = False,
        failed: bool = False,
        gift: bool = False,
        reaction: bool = False,
        stargift_upgrade: bool = False,
        business_transfer: bool = False,
        stargift_resale: bool = False,
        posts_search: bool = False,
        stargift_prepaid_upgrade: bool = False,
        title: Optional[str] = None,
        description: Optional[str] = None,
        photo: Optional['TypeWebDocument'] = None,
        transaction_date: Optional[int] = None,
        transaction_url: Optional[str] = None,
        bot_payload: Optional[bytes] = None,
        msg_id: Optional[int] = None,
        extended_media: Optional[List['TypeMessageMedia']] = None,
        subscription_period: Optional[int] = None,
        giveaway_post_id: Optional[int] = None,
        stargift: Optional['TypeStarGift'] = None,
        floodskip_number: Optional[int] = None,
        starref_commission_permille: Optional[int] = None,
        starref_peer: Optional['TypePeer'] = None,
        starref_amount: Optional['TypeStarsAmount'] = None,
        paid_messages: Optional[int] = None,
        premium_gift_months: Optional[int] = None,
        ads_proceeds_from_date: Optional[int] = None,
        ads_proceeds_to_date: Optional[int] = None
    ):

        """
        Represents a [Telegram Stars transaction](https://core.telegram.org/api/stars).

        Args:
            id (str): Transaction ID.
            amount ('TypeStarsAmount'): ...
            date (int): Date of the transaction (unixtime).
            peer ('TypeStarsTransactionPeer'): Source of the incoming transaction, or its recipient for outgoing transactions.
            refund (bool, optional): Whether this transaction is a refund.
            pending (bool, optional): The transaction is currently pending.
            failed (bool, optional): This transaction has failed.
            gift (bool, optional): This transaction was a gift from the user in peer.peer.
            reaction (bool, optional): This transaction is a [paid reaction](https://core.telegram.org/api/reactions#paid-reactions).
            stargift_upgrade (bool, optional): ...
            business_transfer (bool, optional): ...
            stargift_resale (bool, optional): ...
            posts_search (bool, optional): ...
            stargift_prepaid_upgrade (bool, optional): ...
            title (Optional[str], optional): For transactions with bots, title of the bought product.
            description (Optional[str], optional): For transactions with bots, description of the bought product.
            photo (Optional['TypeWebDocument'], optional): For transactions with bots, photo of the bought product.
            transaction_date (Optional[int], optional): If neither pending nor failed are set, the transaction was completed successfully, and this field will contain the point in time (Unix timestamp) when the withdrawal was completed successfully.
            transaction_url (Optional[str], optional): If neither pending nor failed are set, the transaction was completed successfully, and this field will contain a URL where the withdrawal transaction can be viewed.
            bot_payload (Optional[bytes], optional): Bot specified invoice payload (i.e. the payload passed to [inputMediaInvoice](https://core.telegram.org/constructor/inputMediaInvoice) when [creating the invoice](https://core.telegram.org/api/payments)).
            msg_id (Optional[int], optional): For [paid media transactions](https://core.telegram.org/api/paid-media), message ID of the paid media posted to peer.peer (can point to a deleted message; either way, extended_media will always contain the bought media).
            extended_media (Optional[List['TypeMessageMedia']], optional): The purchased [paid media](https://core.telegram.org/api/paid-media).
            subscription_period (Optional[int], optional): The number of seconds between consecutive Telegram Star debiting for [Telegram Star subscriptions](https://core.telegram.org/api/stars#star-subscriptions).
            giveaway_post_id (Optional[int], optional): ID of the message containing the [messageMediaGiveaway](https://core.telegram.org/constructor/messageMediaGiveaway), for incoming [star giveaway prizes](https://core.telegram.org/api/giveaways#star-giveaways).
            stargift (Optional['TypeStarGift'], optional): This transaction indicates a purchase or a sale (conversion back to Stars) of a [gift](https://core.telegram.org/api/stars).
            floodskip_number (Optional[int], optional): This transaction is payment for [paid bot broadcasts](https://core.telegram.org/bots/faq#how-can-i-message-all-of-my-bot-39s-subscribers-at-once).  Paid broadcasts are only allowed if the allow_paid_floodskip parameter of [messages.sendMessage](https://core.telegram.org/method/messages.sendMessage) and other message sending methods is set while trying to broadcast more than 30 messages per second to bot users. The integer value returned by this flag indicates the number of billed API calls.
            starref_commission_permille (Optional[int], optional): This transaction is the receival (or refund) of an [affiliate commission](https://core.telegram.org/api/bots/referrals) (i.e. this is the transaction received by the peer that created the [referral link](https://core.telegram.org/api/links#referral-links), flag 17 is for transactions made by users that imported the referral link).
            starref_peer (Optional['TypePeer'], optional): For transactions made by [referred users](https://core.telegram.org/api/bots/referrals), the peer that received the affiliate commission.
            starref_amount (Optional['TypeStarsAmount'], optional): For transactions made by [referred users](https://core.telegram.org/api/bots/referrals), the amount of Telegram Stars received by the affiliate, can be negative for refunds.
            paid_messages (Optional[int], optional): ...
            premium_gift_months (Optional[int], optional): ...
            ads_proceeds_from_date (Optional[int], optional): ...
            ads_proceeds_to_date (Optional[int], optional): ...
        """

        self.id = id
        self.amount = amount
        self.date = date
        self.peer = peer
        self.refund = refund
        self.pending = pending
        self.failed = failed
        self.gift = gift
        self.reaction = reaction
        self.stargift_upgrade = stargift_upgrade
        self.business_transfer = business_transfer
        self.stargift_resale = stargift_resale
        self.posts_search = posts_search
        self.stargift_prepaid_upgrade = stargift_prepaid_upgrade
        self.title = title
        self.description = description
        self.photo = photo
        self.transaction_date = transaction_date
        self.transaction_url = transaction_url
        self.bot_payload = bot_payload
        self.msg_id = msg_id
        self.extended_media = extended_media
        self.subscription_period = subscription_period
        self.giveaway_post_id = giveaway_post_id
        self.stargift = stargift
        self.floodskip_number = floodskip_number
        self.starref_commission_permille = starref_commission_permille
        self.starref_peer = starref_peer
        self.starref_amount = starref_amount
        self.paid_messages = paid_messages
        self.premium_gift_months = premium_gift_months
        self.ads_proceeds_from_date = ads_proceeds_from_date
        self.ads_proceeds_to_date = ads_proceeds_to_date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb0\x9ee\x13' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.refund, 3)
                flags(self.pending, 4)
                flags(self.failed, 6)
                flags(self.gift, 10)
                flags(self.reaction, 11)
                flags(self.stargift_upgrade, 18)
                flags(self.business_transfer, 21)
                flags(self.stargift_resale, 22)
                flags(self.posts_search, 24)
                flags(self.stargift_prepaid_upgrade, 25)
                writer.string(self.id)
                writer.object(
                    self.amount,
                    group_id=0XC3D62A83
                )
                writer.int(self.date)
                writer.object(
                    self.peer,
                    group_id=0X45A8F5A6
                )

                if flags(self.title, 0):
                    writer.string(self.title)

                if flags(self.description, 1):
                    writer.string(self.description)

                if flags(self.photo, 2):
                    writer.object(
                        self.photo,
                        group_id=0XCDE930D7
                    )

                if flags(self.transaction_date, 5):
                    writer.int(self.transaction_date)

                if flags(self.transaction_url, 5):
                    writer.string(self.transaction_url)

                if flags(self.bot_payload, 7):
                    writer.bytes(self.bot_payload)

                if flags(self.msg_id, 8):
                    writer.int(self.msg_id)

                if flags(self.extended_media, 9):
                    writer.vector(
                        self.extended_media,
                        lambda value: writer.object(
                            value,
                            group_id=0X45F7A020
                        )
                    )

                if flags(self.subscription_period, 12):
                    writer.int(self.subscription_period)

                if flags(self.giveaway_post_id, 13):
                    writer.int(self.giveaway_post_id)

                if flags(self.stargift, 14):
                    writer.object(
                        self.stargift,
                        group_id=0X87440C7B
                    )

                if flags(self.floodskip_number, 15):
                    writer.int(self.floodskip_number)

                if flags(self.starref_commission_permille, 16):
                    writer.int(self.starref_commission_permille)

                if flags(self.starref_peer, 17):
                    writer.object(
                        self.starref_peer,
                        group_id=0XB4DECBCA
                    )

                if flags(self.starref_amount, 17):
                    writer.object(
                        self.starref_amount,
                        group_id=0XC3D62A83
                    )

                if flags(self.paid_messages, 19):
                    writer.int(self.paid_messages)

                if flags(self.premium_gift_months, 20):
                    writer.int(self.premium_gift_months)

                if flags(self.ads_proceeds_from_date, 23):
                    writer.int(self.ads_proceeds_from_date)

                if flags(self.ads_proceeds_to_date, 23):
                    writer.int(self.ads_proceeds_to_date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.string()
        amount_ = reader.object(
            group_id=0XC3D62A83
        )

        date_ = reader.int()
        peer_ = reader.object(
            group_id=0X45A8F5A6
        )

        title_ = (
            reader.string()
            if flags(0) else None
        )

        description_ = (
            reader.string()
            if flags(1) else None
        )

        photo_ = (
            reader.object(
                group_id=0XCDE930D7
            )
            if flags(2) else None
        )

        transaction_date_ = (
            reader.int()
            if flags(5) else None
        )

        transaction_url_ = (
            reader.string()
            if flags(5) else None
        )

        bot_payload_ = (
            reader.bytes()
            if flags(7) else None
        )

        msg_id_ = (
            reader.int()
            if flags(8) else None
        )

        extended_media_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X45F7A020
                )
            )
            if flags(9) else None
        )

        subscription_period_ = (
            reader.int()
            if flags(12) else None
        )

        giveaway_post_id_ = (
            reader.int()
            if flags(13) else None
        )

        stargift_ = (
            reader.object(
                group_id=0X87440C7B
            )
            if flags(14) else None
        )

        floodskip_number_ = (
            reader.int()
            if flags(15) else None
        )

        starref_commission_permille_ = (
            reader.int()
            if flags(16) else None
        )

        starref_peer_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(17) else None
        )

        starref_amount_ = (
            reader.object(
                group_id=0XC3D62A83
            )
            if flags(17) else None
        )

        paid_messages_ = (
            reader.int()
            if flags(19) else None
        )

        premium_gift_months_ = (
            reader.int()
            if flags(20) else None
        )

        ads_proceeds_from_date_ = (
            reader.int()
            if flags(23) else None
        )

        ads_proceeds_to_date_ = (
            reader.int()
            if flags(23) else None
        )

        return cls(
            id=id_,
            amount=amount_,
            date=date_,
            peer=peer_,
            refund=flags(3),
            pending=flags(4),
            failed=flags(6),
            gift=flags(10),
            reaction=flags(11),
            stargift_upgrade=flags(18),
            business_transfer=flags(21),
            stargift_resale=flags(22),
            posts_search=flags(24),
            stargift_prepaid_upgrade=flags(25),
            title=title_,
            description=description_,
            photo=photo_,
            transaction_date=transaction_date_,
            transaction_url=transaction_url_,
            bot_payload=bot_payload_,
            msg_id=msg_id_,
            extended_media=extended_media_,
            subscription_period=subscription_period_,
            giveaway_post_id=giveaway_post_id_,
            stargift=stargift_,
            floodskip_number=floodskip_number_,
            starref_commission_permille=starref_commission_permille_,
            starref_peer=starref_peer_,
            starref_amount=starref_amount_,
            paid_messages=paid_messages_,
            premium_gift_months=premium_gift_months_,
            ads_proceeds_from_date=ads_proceeds_from_date_,
            ads_proceeds_to_date=ads_proceeds_to_date_
        )

TypeStarsTransaction = StarsTransaction