
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .photo_size import TypePhotoSize
    from ...gadgets.byteutils import Reader


class StickerSet(TLObject, family='TypeStickerSet'):
    """
    Represents a stickerset (stickerpack)
    """

    _id = 0X2DD14EDC
    _group_id = 0X8EED6744

    def __init__(
        self,
        id: int,
        access_hash: int,
        title: str,
        short_name: str,
        count: int,
        hash: int,
        archived: bool = False,
        official: bool = False,
        masks: bool = False,
        emojis: bool = False,
        text_color: bool = False,
        channel_emoji_status: bool = False,
        creator: bool = False,
        installed_date: Optional[int] = None,
        thumbs: Optional[List['TypePhotoSize']] = None,
        thumb_dc_id: Optional[int] = None,
        thumb_version: Optional[int] = None,
        thumb_document_id: Optional[int] = None
    ):

        """
        Represents a stickerset (stickerpack)

        Args:
            id (int): ID of the stickerset
            access_hash (int): Access hash of stickerset
            title (str): Title of stickerset
            short_name (str): Short name of stickerset, used when sharing stickerset using [stickerset deep links](https://core.telegram.org/api/links#stickerset-links).
            count (int): Number of stickers in pack
            hash (int): Hash
            archived (bool, optional): Whether this stickerset was archived (due to too many saved stickers in the current account)
            official (bool, optional): Is this stickerset official
            masks (bool, optional): Is this a mask stickerset
            emojis (bool, optional): This is a custom emoji stickerset
            text_color (bool, optional): Whether the color of this TGS custom emoji stickerset should be changed to the text color when used in messages, the accent color if used as emoji status, white on chat photos, or another appropriate color based on context.
            channel_emoji_status (bool, optional): If set, this custom emoji stickerset can be used in [channel/supergroup emoji statuses](https://core.telegram.org/api/emoji-status).
            creator (bool, optional): Whether we created this stickerset
            installed_date (Optional[int], optional): When was this stickerset installed
            thumbs (Optional[List['TypePhotoSize']], optional): Stickerset thumbnail
            thumb_dc_id (Optional[int], optional): DC ID of thumbnail
            thumb_version (Optional[int], optional): Thumbnail version
            thumb_document_id (Optional[int], optional): Document ID of custom emoji thumbnail, fetch the document using [messages.getCustomEmojiDocuments](https://core.telegram.org/method/messages.getCustomEmojiDocuments)
        """

        self.id = id
        self.access_hash = access_hash
        self.title = title
        self.short_name = short_name
        self.count = count
        self.hash = hash
        self.archived = archived
        self.official = official
        self.masks = masks
        self.emojis = emojis
        self.text_color = text_color
        self.channel_emoji_status = channel_emoji_status
        self.creator = creator
        self.installed_date = installed_date
        self.thumbs = thumbs
        self.thumb_dc_id = thumb_dc_id
        self.thumb_version = thumb_version
        self.thumb_document_id = thumb_document_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xdcN\xd1-' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.archived, 1)
                flags(self.official, 2)
                flags(self.masks, 3)
                flags(self.emojis, 7)
                flags(self.text_color, 9)
                flags(self.channel_emoji_status, 10)
                flags(self.creator, 11)

                if flags(self.installed_date, 0):
                    writer.int(self.installed_date)
                writer.long(self.id)
                writer.long(self.access_hash)
                writer.string(self.title)
                writer.string(self.short_name)

                if flags(self.thumbs, 4):
                    writer.vector(
                        self.thumbs,
                        lambda value: writer.object(
                            value,
                            group_id=0X478D00B0
                        )
                    )

                if flags(self.thumb_dc_id, 4):
                    writer.int(self.thumb_dc_id)

                if flags(self.thumb_version, 4):
                    writer.int(self.thumb_version)

                if flags(self.thumb_document_id, 8):
                    writer.long(self.thumb_document_id)
                writer.int(self.count)
                writer.int(self.hash)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        installed_date_ = (
            reader.int()
            if flags(0) else None
        )

        id_ = reader.long()
        access_hash_ = reader.long()
        title_ = reader.string()
        short_name_ = reader.string()
        thumbs_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X478D00B0
                )
            )
            if flags(4) else None
        )

        thumb_dc_id_ = (
            reader.int()
            if flags(4) else None
        )

        thumb_version_ = (
            reader.int()
            if flags(4) else None
        )

        thumb_document_id_ = (
            reader.long()
            if flags(8) else None
        )

        count_ = reader.int()
        hash_ = reader.int()

        return cls(
            id=id_,
            access_hash=access_hash_,
            title=title_,
            short_name=short_name_,
            count=count_,
            hash=hash_,
            archived=flags(1),
            official=flags(2),
            masks=flags(3),
            emojis=flags(7),
            text_color=flags(9),
            channel_emoji_status=flags(10),
            creator=flags(11),
            installed_date=installed_date_,
            thumbs=thumbs_,
            thumb_dc_id=thumb_dc_id_,
            thumb_version=thumb_version_,
            thumb_document_id=thumb_document_id_
        )

TypeStickerSet = StickerSet