
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..story_view import TypeStoryView
    from ....gadgets.byteutils import Reader


class StoryViewsList(TLObject, family='TypeStoriesStoryViewsList'):
    """
    Reaction and view counters for a [story](https://core.telegram.org/api/stories)
    """

    _id = 0X59D78FC5
    _group_id = 0X408F23A6

    def __init__(
        self,
        count: int,
        views_count: int,
        forwards_count: int,
        reactions_count: int,
        views: List['TypeStoryView'],
        chats: List['TypeChat'],
        users: List['TypeUser'],
        next_offset: Optional[str] = None
    ):

        """
        Reaction and view counters for a [story](https://core.telegram.org/api/stories)

        Args:
            count (int): Total number of results that can be fetched
            views_count (int): Total number of story views
            forwards_count (int): Total number of story forwards/reposts
            reactions_count (int): Number of reactions that were added to the story
            views (List['TypeStoryView']): Story view date and reaction information
            chats (List['TypeChat']): Mentioned chats
            users (List['TypeUser']): Mentioned users
            next_offset (Optional[str], optional): Offset for pagination
        """

        self.count = count
        self.views_count = views_count
        self.forwards_count = forwards_count
        self.reactions_count = reactions_count
        self.views = views
        self.chats = chats
        self.users = users
        self.next_offset = next_offset

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc5\x8f\xd7Y' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.int(self.count)
                writer.int(self.views_count)
                writer.int(self.forwards_count)
                writer.int(self.reactions_count)
                writer.vector(
                    self.views,
                    lambda value: writer.object(
                        value,
                        group_id=0X65D016CA
                    )
                )
                writer.vector(
                    self.chats,
                    lambda value: writer.object(
                        value,
                        group_id=0X73A5C0D9
                    )
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

                if flags(self.next_offset, 0):
                    writer.string(self.next_offset)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        count_ = reader.int()
        views_count_ = reader.int()
        forwards_count_ = reader.int()
        reactions_count_ = reader.int()
        views_ = reader.vector(
            lambda: reader.object(
                group_id=0X65D016CA
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        next_offset_ = (
            reader.string()
            if flags(0) else None
        )

        return cls(
            count=count_,
            views_count=views_count_,
            forwards_count=forwards_count_,
            reactions_count=reactions_count_,
            views=views_,
            chats=chats_,
            users=users_,
            next_offset=next_offset_
        )

TypeStoriesStoryViewsList = StoryViewsList