
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING, List, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from .reaction import TypeReaction
    from .media_area import TypeMediaArea
    from .story_views import TypeStoryViews
    from .privacy_rule import TypePrivacyRule
    from .message_media import TypeMessageMedia
    from .message_entity import TypeMessageEntity
    from .story_fwd_header import TypeStoryFwdHeader
    from ...gadgets.byteutils import Reader


class StoryItemDeleted(TLObject, family='TypeStoryItem'):
    """
    Represents a previously active story, that was deleted
    """

    _id = 0X51E6EE4F
    _group_id = 0X8436985A

    def __init__(
        self,
        id: int
    ):

        """
        Represents a previously active story, that was deleted

        Args:
            id (int): Story ID
        """

        self.id = id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'O\xee\xe6Q' if boxed else b'') as writer:
            writer.int(self.id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.int()

        return cls(
            id=id_
        )

class StoryItemSkipped(TLObject, family='TypeStoryItem'):
    """
    Represents an active story, whose full information was omitted for space and performance reasons; use [stories.getStoriesByID](https://core.telegram.org/method/stories.getStoriesByID) to fetch full info about the skipped story when and if needed.
    """

    _id = 0XFFADC913
    _group_id = 0X8436985A

    def __init__(
        self,
        id: int,
        date: int,
        expire_date: int,
        close_friends: bool = False
    ):

        """
        Represents an active story, whose full information was omitted for space and performance reasons; use [stories.getStoriesByID](https://core.telegram.org/method/stories.getStoriesByID) to fetch full info about the skipped story when and if needed.

        Args:
            id (int): Story ID
            date (int): When was the story posted.
            expire_date (int): When does the story expire.
            close_friends (bool, optional): Whether this story can only be viewed by [our close friends, see here](https://core.telegram.org/api/privacy) for more info
        """

        self.id = id
        self.date = date
        self.expire_date = expire_date
        self.close_friends = close_friends

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x13\xc9\xad\xff' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.close_friends, 8)
                writer.int(self.id)
                writer.int(self.date)
                writer.int(self.expire_date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.int()
        date_ = reader.int()
        expire_date_ = reader.int()

        return cls(
            id=id_,
            date=date_,
            expire_date=expire_date_,
            close_friends=flags(8)
        )

class StoryItem(TLObject, family='TypeStoryItem'):
    """
    Represents a [story](https://core.telegram.org/api/stories).
    """

    _id = 0XEDF164F1
    _group_id = 0X8436985A

    def __init__(
        self,
        id: int,
        date: int,
        expire_date: int,
        media: 'TypeMessageMedia',
        pinned: bool = False,
        public: bool = False,
        close_friends: bool = False,
        min: bool = False,
        noforwards: bool = False,
        edited: bool = False,
        contacts: bool = False,
        selected_contacts: bool = False,
        out: bool = False,
        from_id: Optional['TypePeer'] = None,
        fwd_from: Optional['TypeStoryFwdHeader'] = None,
        caption: Optional[str] = None,
        entities: Optional[List['TypeMessageEntity']] = None,
        media_areas: Optional[List['TypeMediaArea']] = None,
        privacy: Optional[List['TypePrivacyRule']] = None,
        views: Optional['TypeStoryViews'] = None,
        sent_reaction: Optional['TypeReaction'] = None,
        albums: Optional[List[int]] = None
    ):

        """
        Represents a [story](https://core.telegram.org/api/stories).

        Args:
            id (int): ID of the story.
            date (int): When was the story posted.
            expire_date (int): When does the story expire.
            media ('TypeMessageMedia'): Story media.
            pinned (bool, optional): Whether this story is pinned on the user's profile
            public (bool, optional): Whether this story is public and can be viewed by everyone
            close_friends (bool, optional): Whether this story can only be viewed by [our close friends, see here](https://core.telegram.org/api/privacy) for more info
            min (bool, optional): Full information about this story was omitted for space and performance reasons; use [stories.getStoriesByID](https://core.telegram.org/method/stories.getStoriesByID) to fetch full info about this story when and if needed.
            noforwards (bool, optional): Whether this story is [protected](https://telegram.org/blog/protected-content-delete-by-date-and-more) and thus cannot be forwarded; clients should also prevent users from saving attached media (i.e. videos should only be streamed, photos should be kept in RAM, et cetera).
            edited (bool, optional): Indicates whether the story was edited.
            contacts (bool, optional): Whether this story can only be viewed by our contacts
            selected_contacts (bool, optional): Whether this story can only be viewed by a select list of our contacts
            out (bool, optional): indicates whether we sent this story.
            from_id (Optional['TypePeer'], optional): Sender of the story.
            fwd_from (Optional['TypeStoryFwdHeader'], optional): For [reposted stories](https://core.telegram.org/api/stories#reposting-stories), contains info about the original story.
            caption (Optional[str], optional): Story caption.
            entities (Optional[List['TypeMessageEntity']], optional): [Message entities for styled text](https://core.telegram.org/api/entities)
            media_areas (Optional[List['TypeMediaArea']], optional): List of media areas, see [here](https://core.telegram.org/api/stories#media-areas) for more info on media areas.
            privacy (Optional[List['TypePrivacyRule']], optional): [Privacy rules](https://core.telegram.org/api/privacy) indicating who can and can't view this story
            views (Optional['TypeStoryViews'], optional): View date and reaction information
            sent_reaction (Optional['TypeReaction'], optional): The reaction we sent.
            albums (Optional[List[int]], optional): ...
        """

        self.id = id
        self.date = date
        self.expire_date = expire_date
        self.media = media
        self.pinned = pinned
        self.public = public
        self.close_friends = close_friends
        self.min = min
        self.noforwards = noforwards
        self.edited = edited
        self.contacts = contacts
        self.selected_contacts = selected_contacts
        self.out = out
        self.from_id = from_id
        self.fwd_from = fwd_from
        self.caption = caption
        self.entities = entities
        self.media_areas = media_areas
        self.privacy = privacy
        self.views = views
        self.sent_reaction = sent_reaction
        self.albums = albums

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf1d\xf1\xed' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.pinned, 5)
                flags(self.public, 7)
                flags(self.close_friends, 8)
                flags(self.min, 9)
                flags(self.noforwards, 10)
                flags(self.edited, 11)
                flags(self.contacts, 12)
                flags(self.selected_contacts, 13)
                flags(self.out, 16)
                writer.int(self.id)
                writer.int(self.date)

                if flags(self.from_id, 18):
                    writer.object(
                        self.from_id,
                        group_id=0XB4DECBCA
                    )

                if flags(self.fwd_from, 17):
                    writer.object(
                        self.fwd_from,
                        group_id=0X284BFE07
                    )
                writer.int(self.expire_date)

                if flags(self.caption, 0):
                    writer.string(self.caption)

                if flags(self.entities, 1):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )
                writer.object(
                    self.media,
                    group_id=0X45F7A020
                )

                if flags(self.media_areas, 14):
                    writer.vector(
                        self.media_areas,
                        lambda value: writer.object(
                            value,
                            group_id=0XA32C529B
                        )
                    )

                if flags(self.privacy, 2):
                    writer.vector(
                        self.privacy,
                        lambda value: writer.object(
                            value,
                            group_id=0X1D3AEAB3
                        )
                    )

                if flags(self.views, 3):
                    writer.object(
                        self.views,
                        group_id=0X60DA34B3
                    )

                if flags(self.sent_reaction, 15):
                    writer.object(
                        self.sent_reaction,
                        group_id=0X19F930D1
                    )

                if flags(self.albums, 19):
                    writer.vector(
                        self.albums,
                        writer.int
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.int()
        date_ = reader.int()
        from_id_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(18) else None
        )

        fwd_from_ = (
            reader.object(
                group_id=0X284BFE07
            )
            if flags(17) else None
        )

        expire_date_ = reader.int()
        caption_ = (
            reader.string()
            if flags(0) else None
        )

        entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(1) else None
        )

        media_ = reader.object(
            group_id=0X45F7A020
        )

        media_areas_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0XA32C529B
                )
            )
            if flags(14) else None
        )

        privacy_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X1D3AEAB3
                )
            )
            if flags(2) else None
        )

        views_ = (
            reader.object(
                group_id=0X60DA34B3
            )
            if flags(3) else None
        )

        sent_reaction_ = (
            reader.object(
                group_id=0X19F930D1
            )
            if flags(15) else None
        )

        albums_ = (
            reader.vector(
                reader.int
            )
            if flags(19) else None
        )

        return cls(
            id=id_,
            date=date_,
            expire_date=expire_date_,
            media=media_,
            pinned=flags(5),
            public=flags(7),
            close_friends=flags(8),
            min=flags(9),
            noforwards=flags(10),
            edited=flags(11),
            contacts=flags(12),
            selected_contacts=flags(13),
            out=flags(16),
            from_id=from_id_,
            fwd_from=fwd_from_,
            caption=caption_,
            entities=entities_,
            media_areas=media_areas_,
            privacy=privacy_,
            views=views_,
            sent_reaction=sent_reaction_,
            albums=albums_
        )

TypeStoryItem = Union[
    StoryItemDeleted,
    StoryItemSkipped,
    StoryItem
]