
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .document import TypeDocument
    from .theme_settings import TypeThemeSettings
    from ...gadgets.byteutils import Reader


class Theme(TLObject, family='TypeTheme'):
    """
    Theme
    """

    _id = 0XA00E67D6
    _group_id = 0X5E6FFFBC

    def __init__(
        self,
        id: int,
        access_hash: int,
        slug: str,
        title: str,
        creator: bool = False,
        default: bool = False,
        for_chat: bool = False,
        document: Optional['TypeDocument'] = None,
        settings: Optional[List['TypeThemeSettings']] = None,
        emoticon: Optional[str] = None,
        installs_count: Optional[int] = None
    ):

        """
        Theme

        Args:
            id (int): Theme ID
            access_hash (int): Theme access hash
            slug (str): Unique theme ID
            title (str): Theme name
            creator (bool, optional): Whether the current user is the creator of this theme
            default (bool, optional): Whether this is the default theme
            for_chat (bool, optional): Whether this theme is meant to be used as a [chat theme](https://telegram.org/blog/chat-themes-interactive-emoji-read-receipts)
            document (Optional['TypeDocument'], optional): Theme
            settings (Optional[List['TypeThemeSettings']], optional): Theme settings
            emoticon (Optional[str], optional): Theme emoji
            installs_count (Optional[int], optional): Installation count
        """

        self.id = id
        self.access_hash = access_hash
        self.slug = slug
        self.title = title
        self.creator = creator
        self.default = default
        self.for_chat = for_chat
        self.document = document
        self.settings = settings
        self.emoticon = emoticon
        self.installs_count = installs_count

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd6g\x0e\xa0' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.creator, 0)
                flags(self.default, 1)
                flags(self.for_chat, 5)
                writer.long(self.id)
                writer.long(self.access_hash)
                writer.string(self.slug)
                writer.string(self.title)

                if flags(self.document, 2):
                    writer.object(
                        self.document,
                        group_id=0X6547BD50
                    )

                if flags(self.settings, 3):
                    writer.vector(
                        self.settings,
                        lambda value: writer.object(
                            value,
                            group_id=0X71DD876E
                        )
                    )

                if flags(self.emoticon, 6):
                    writer.string(self.emoticon)

                if flags(self.installs_count, 4):
                    writer.int(self.installs_count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.long()
        access_hash_ = reader.long()
        slug_ = reader.string()
        title_ = reader.string()
        document_ = (
            reader.object(
                group_id=0X6547BD50
            )
            if flags(2) else None
        )

        settings_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X71DD876E
                )
            )
            if flags(3) else None
        )

        emoticon_ = (
            reader.string()
            if flags(6) else None
        )

        installs_count_ = (
            reader.int()
            if flags(4) else None
        )

        return cls(
            id=id_,
            access_hash=access_hash_,
            slug=slug_,
            title=title_,
            creator=flags(0),
            default=flags(1),
            for_chat=flags(5),
            document=document_,
            settings=settings_,
            emoticon=emoticon_,
            installs_count=installs_count_
        )

TypeTheme = Theme