
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .base_theme import TypeBaseTheme
    from .wall_paper import TypeWallPaper
    from ...gadgets.byteutils import Reader


class ThemeSettings(TLObject, family='TypeThemeSettings'):
    """
    Theme settings
    """

    _id = 0XFA58B6D4
    _group_id = 0X71DD876E

    def __init__(
        self,
        base_theme: 'TypeBaseTheme',
        accent_color: int,
        message_colors_animated: bool = False,
        outbox_accent_color: Optional[int] = None,
        message_colors: Optional[List[int]] = None,
        wallpaper: Optional['TypeWallPaper'] = None
    ):

        """
        Theme settings

        Args:
            base_theme ('TypeBaseTheme'): Base theme
            accent_color (int): Accent color, ARGB format
            message_colors_animated (bool, optional): If set, the freeform gradient fill needs to be animated on every sent message.
            outbox_accent_color (Optional[int], optional): Accent color of outgoing messages in ARGB format
            message_colors (Optional[List[int]], optional): The fill to be used as a background for outgoing messages, in RGB24 format. If just one or two equal colors are provided, describes a solid fill of a background. If two different colors are provided, describes the top and bottom colors of a 0-degree gradient. If three or four colors are provided, describes a freeform gradient fill of a background.
            wallpaper (Optional['TypeWallPaper'], optional): [Wallpaper](https://core.telegram.org/api/wallpapers)
        """

        self.base_theme = base_theme
        self.accent_color = accent_color
        self.message_colors_animated = message_colors_animated
        self.outbox_accent_color = outbox_accent_color
        self.message_colors = message_colors
        self.wallpaper = wallpaper

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd4\xb6X\xfa' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.message_colors_animated, 2)
                writer.object(
                    self.base_theme,
                    group_id=0X4F42DD2D
                )
                writer.int(self.accent_color)

                if flags(self.outbox_accent_color, 3):
                    writer.int(self.outbox_accent_color)

                if flags(self.message_colors, 0):
                    writer.vector(
                        self.message_colors,
                        writer.int
                    )

                if flags(self.wallpaper, 1):
                    writer.object(
                        self.wallpaper,
                        group_id=0XC6E3E0E2
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        base_theme_ = reader.object(
            group_id=0X4F42DD2D
        )

        accent_color_ = reader.int()
        outbox_accent_color_ = (
            reader.int()
            if flags(3) else None
        )

        message_colors_ = (
            reader.vector(
                reader.int
            )
            if flags(0) else None
        )

        wallpaper_ = (
            reader.object(
                group_id=0XC6E3E0E2
            )
            if flags(1) else None
        )

        return cls(
            base_theme=base_theme_,
            accent_color=accent_color_,
            message_colors_animated=flags(2),
            outbox_accent_color=outbox_accent_color_,
            message_colors=message_colors_,
            wallpaper=wallpaper_
        )

TypeThemeSettings = ThemeSettings