
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Union
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..file_hash import TypeFileHash
    from ..storage.file_type import TypeStorageFileType
    from ....gadgets.byteutils import Reader


class File(TLObject, family='TypeUploadFile'):
    """
    File content.
    """

    _id = 0X96A18D5
    _group_id = 0X2063BCC2

    def __init__(
        self,
        type: 'TypeStorageFileType',
        mtime: int,
        bytes: bytes
    ):

        """
        File content.

        Args:
            type ('TypeStorageFileType'): File type
            mtime (int): Modification time
            bytes (bytes): Binary data, file content
        """

        self.type = type
        self.mtime = mtime
        self.bytes = bytes

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd5\x18j\t' if boxed else b'') as writer:
            writer.object(
                self.type,
                group_id=0X903DE3AC
            )
            writer.int(self.mtime)
            writer.bytes(self.bytes)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        type_ = reader.object(
            group_id=0X903DE3AC
        )

        mtime_ = reader.int()
        bytes_ = reader.bytes()

        return cls(
            type=type_,
            mtime=mtime_,
            bytes=bytes_
        )

class FileCdnRedirect(TLObject, family='TypeUploadFile'):
    """
    The file must be downloaded from a [CDN DC](https://core.telegram.org/cdn).
    """

    _id = 0XF18CDA44
    _group_id = 0X2063BCC2

    def __init__(
        self,
        dc_id: int,
        file_token: bytes,
        encryption_key: bytes,
        encryption_iv: bytes,
        file_hashes: List['TypeFileHash']
    ):

        """
        The file must be downloaded from a [CDN DC](https://core.telegram.org/cdn).

        Args:
            dc_id (int): [CDN DC](https://core.telegram.org/cdn) ID
            file_token (bytes): File token (see [CDN files](https://core.telegram.org/cdn))
            encryption_key (bytes): Encryption key (see [CDN files](https://core.telegram.org/cdn))
            encryption_iv (bytes): Encryption IV (see [CDN files](https://core.telegram.org/cdn))
            file_hashes (List['TypeFileHash']): File hashes (see [CDN files](https://core.telegram.org/cdn))
        """

        self.dc_id = dc_id
        self.file_token = file_token
        self.encryption_key = encryption_key
        self.encryption_iv = encryption_iv
        self.file_hashes = file_hashes

    def to_bytes(self, boxed: bool=True):
        with Writer(b'D\xda\x8c\xf1' if boxed else b'') as writer:
            writer.int(self.dc_id)
            writer.bytes(self.file_token)
            writer.bytes(self.encryption_key)
            writer.bytes(self.encryption_iv)
            writer.vector(
                self.file_hashes,
                lambda value: writer.object(
                    value,
                    group_id=0XAE8C6DC3
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        dc_id_ = reader.int()
        file_token_ = reader.bytes()
        encryption_key_ = reader.bytes()
        encryption_iv_ = reader.bytes()
        file_hashes_ = reader.vector(
            lambda: reader.object(
                group_id=0XAE8C6DC3
            )
        )

        return cls(
            dc_id=dc_id_,
            file_token=file_token_,
            encryption_key=encryption_key_,
            encryption_iv=encryption_iv_,
            file_hashes=file_hashes_
        )

TypeUploadFile = Union[
    File,
    FileCdnRedirect
]