
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class Username(TLObject, family='TypeUsername'):
    """
    Contains information about a username.
    """

    _id = 0XB4073647
    _group_id = 0X45703151

    def __init__(
        self,
        username: str,
        editable: bool = False,
        active: bool = False
    ):

        """
        Contains information about a username.

        Args:
            username (str): The username.
            editable (bool, optional): Whether the username is editable, meaning it wasn't bought on [fragment](https://fragment.com).
            active (bool, optional): Whether the username is active.
        """

        self.username = username
        self.editable = editable
        self.active = active

    def to_bytes(self, boxed: bool=True):
        with Writer(b'G6\x07\xb4' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.editable, 0)
                flags(self.active, 1)
                writer.string(self.username)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        username_ = reader.string()

        return cls(
            username=username_,
            editable=flags(0),
            active=flags(1)
        )

TypeUsername = Username