# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from vald.v1.payload import payload_pb2 as vald_dot_v1_dot_payload_dot_payload__pb2


class ObjectStub(object):
    """Overview
    Object Service is responsible for getting inserted vectors and checking whether vectors are inserted into the `vald-agent`.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Exists = channel.unary_unary(
                '/vald.v1.Object/Exists',
                request_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.ID.SerializeToString,
                response_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.ID.FromString,
                _registered_method=True)
        self.GetObject = channel.unary_unary(
                '/vald.v1.Object/GetObject',
                request_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.VectorRequest.SerializeToString,
                response_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.Vector.FromString,
                _registered_method=True)
        self.StreamGetObject = channel.stream_stream(
                '/vald.v1.Object/StreamGetObject',
                request_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.VectorRequest.SerializeToString,
                response_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.StreamVector.FromString,
                _registered_method=True)
        self.StreamListObject = channel.unary_stream(
                '/vald.v1.Object/StreamListObject',
                request_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.List.Request.SerializeToString,
                response_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.List.Response.FromString,
                _registered_method=True)
        self.GetTimestamp = channel.unary_unary(
                '/vald.v1.Object/GetTimestamp',
                request_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.TimestampRequest.SerializeToString,
                response_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.Timestamp.FromString,
                _registered_method=True)


class ObjectServicer(object):
    """Overview
    Object Service is responsible for getting inserted vectors and checking whether vectors are inserted into the `vald-agent`.
    """

    def Exists(self, request, context):
        """Overview
        Exists RPC is the method to check that a vector exists in the `vald-agent`.
        ---
        Status Code
        |  0   | OK                |
        |  1   | CANCELLED         |
        |  3   | INVALID_ARGUMENT  |
        |  4   | DEADLINE_EXCEEDED |
        |  5   | NOT_FOUND         |
        |  13  | INTERNAL          |
        ---
        Troubleshooting
        The request process may not be completed when the response code is NOT `0 (OK)`.

        Here are some common reasons and how to resolve each error.

        | name              | common reason                                                                                   | how to resolve                                                                           |
        | :---------------- | :---------------------------------------------------------------------------------------------- | :--------------------------------------------------------------------------------------- |
        | CANCELLED         | Executed cancel() of rpc from client/server-side or network problems between client and server. | Check the code, especially around timeout and connection management, and fix if needed.  |
        | INVALID_ARGUMENT  | The Requested vector's ID is empty, or some request payload is invalid.                         | Check request payload and fix request payload.                                           |
        | DEADLINE_EXCEEDED | The RPC timeout setting is too short on the client/server side.                                 | Check the gRPC timeout setting on both the client and server sides and fix it if needed. |
        | NOT_FOUND         | Requested ID is NOT inserted.                                                                   | Send a request with an ID that is already inserted.                                      |
        | INTERNAL          | Target Vald cluster or network route has some critical error.                                   | Check target Vald cluster first and check network route including ingress as second.     |
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetObject(self, request, context):
        """Overview
        GetObject RPC is the method to get the metadata of a vector inserted into the `vald-agent`.
        ---
        Status Code
        |  0   | OK                |
        |  1   | CANCELLED         |
        |  3   | INVALID_ARGUMENT  |
        |  4   | DEADLINE_EXCEEDED |
        |  5   | NOT_FOUND         |
        |  13  | INTERNAL          |
        ---
        Troubleshooting
        The request process may not be completed when the response code is NOT `0 (OK)`.

        Here are some common reasons and how to resolve each error.

        | name              | common reason                                                                                   | how to resolve                                                                           |
        | :---------------- | :---------------------------------------------------------------------------------------------- | :--------------------------------------------------------------------------------------- |
        | CANCELLED         | Executed cancel() of rpc from client/server-side or network problems between client and server. | Check the code, especially around timeout and connection management, and fix if needed.  |
        | INVALID_ARGUMENT  | The Requested vector's ID is empty, or some request payload is invalid.                         | Check request payload and fix request payload.                                           |
        | DEADLINE_EXCEEDED | The RPC timeout setting is too short on the client/server side.                                 | Check the gRPC timeout setting on both the client and server sides and fix it if needed. |
        | NOT_FOUND         | Requested ID is NOT inserted.                                                                   | Send a request with an ID that is already inserted.                                      |
        | INTERNAL          | Target Vald cluster or network route has some critical error.                                   | Check target Vald cluster first and check network route including ingress as second.     |
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def StreamGetObject(self, request_iterator, context):
        """Overview
        StreamGetObject RPC is the method to get the metadata of multiple existing vectors using the [bidirectional streaming RPC](https://grpc.io/docs/what-is-grpc/core-concepts/#bidirectional-streaming-rpc).<br>
        Using the bidirectional streaming RPC, the GetObject request can be communicated in any order between client and server.
        Each Upsert request and response are independent.
        ---
        Status Code
        |  0   | OK                |
        |  1   | CANCELLED         |
        |  3   | INVALID_ARGUMENT  |
        |  4   | DEADLINE_EXCEEDED |
        |  5   | NOT_FOUND         |
        |  13  | INTERNAL          |
        ---
        Troubleshooting
        The request process may not be completed when the response code is NOT `0 (OK)`.

        Here are some common reasons and how to resolve each error.

        | name              | common reason                                                                                   | how to resolve                                                                           |
        | :---------------- | :---------------------------------------------------------------------------------------------- | :--------------------------------------------------------------------------------------- |
        | CANCELLED         | Executed cancel() of rpc from client/server-side or network problems between client and server. | Check the code, especially around timeout and connection management, and fix if needed.  |
        | INVALID_ARGUMENT  | The Requested vector's ID is empty, or some request payload is invalid.                         | Check request payload and fix request payload.                                           |
        | DEADLINE_EXCEEDED | The RPC timeout setting is too short on the client/server side.                                 | Check the gRPC timeout setting on both the client and server sides and fix it if needed. |
        | NOT_FOUND         | Requested ID is NOT inserted.                                                                   | Send a request with an ID that is already inserted.                                      |
        | INTERNAL          | Target Vald cluster or network route has some critical error.                                   | Check target Vald cluster first and check network route including ingress as second.     |
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def StreamListObject(self, request, context):
        """Overview
        A method to get all the vectors with server streaming
        ---
        Status Code
        TODO
        ---
        Troubleshooting
        TODO
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetTimestamp(self, request, context):
        """Overview
        Represent the RPC to get the vector metadata. This RPC is mainly used for index correction process
        ---
        Status Code
        TODO
        ---
        Troubleshooting
        TODO
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_ObjectServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Exists': grpc.unary_unary_rpc_method_handler(
                    servicer.Exists,
                    request_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.ID.FromString,
                    response_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.ID.SerializeToString,
            ),
            'GetObject': grpc.unary_unary_rpc_method_handler(
                    servicer.GetObject,
                    request_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.VectorRequest.FromString,
                    response_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.Vector.SerializeToString,
            ),
            'StreamGetObject': grpc.stream_stream_rpc_method_handler(
                    servicer.StreamGetObject,
                    request_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.VectorRequest.FromString,
                    response_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.StreamVector.SerializeToString,
            ),
            'StreamListObject': grpc.unary_stream_rpc_method_handler(
                    servicer.StreamListObject,
                    request_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.List.Request.FromString,
                    response_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.List.Response.SerializeToString,
            ),
            'GetTimestamp': grpc.unary_unary_rpc_method_handler(
                    servicer.GetTimestamp,
                    request_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.TimestampRequest.FromString,
                    response_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.Timestamp.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'vald.v1.Object', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers('vald.v1.Object', rpc_method_handlers)


 # This class is part of an EXPERIMENTAL API.
class Object(object):
    """Overview
    Object Service is responsible for getting inserted vectors and checking whether vectors are inserted into the `vald-agent`.
    """

    @staticmethod
    def Exists(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/vald.v1.Object/Exists',
            vald_dot_v1_dot_payload_dot_payload__pb2.Object.ID.SerializeToString,
            vald_dot_v1_dot_payload_dot_payload__pb2.Object.ID.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetObject(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/vald.v1.Object/GetObject',
            vald_dot_v1_dot_payload_dot_payload__pb2.Object.VectorRequest.SerializeToString,
            vald_dot_v1_dot_payload_dot_payload__pb2.Object.Vector.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def StreamGetObject(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_stream(
            request_iterator,
            target,
            '/vald.v1.Object/StreamGetObject',
            vald_dot_v1_dot_payload_dot_payload__pb2.Object.VectorRequest.SerializeToString,
            vald_dot_v1_dot_payload_dot_payload__pb2.Object.StreamVector.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def StreamListObject(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/vald.v1.Object/StreamListObject',
            vald_dot_v1_dot_payload_dot_payload__pb2.Object.List.Request.SerializeToString,
            vald_dot_v1_dot_payload_dot_payload__pb2.Object.List.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetTimestamp(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/vald.v1.Object/GetTimestamp',
            vald_dot_v1_dot_payload_dot_payload__pb2.Object.TimestampRequest.SerializeToString,
            vald_dot_v1_dot_payload_dot_payload__pb2.Object.Timestamp.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)
