# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from vald.v1.payload import payload_pb2 as vald_dot_v1_dot_payload_dot_payload__pb2


class RemoveStub(object):
    """Overview
    Remove Service is responsible for removing vectors indexed in the `vald-agent`.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Remove = channel.unary_unary(
                '/vald.v1.Remove/Remove',
                request_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Remove.Request.SerializeToString,
                response_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.Location.FromString,
                _registered_method=True)
        self.RemoveByTimestamp = channel.unary_unary(
                '/vald.v1.Remove/RemoveByTimestamp',
                request_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Remove.TimestampRequest.SerializeToString,
                response_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.Locations.FromString,
                _registered_method=True)
        self.StreamRemove = channel.stream_stream(
                '/vald.v1.Remove/StreamRemove',
                request_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Remove.Request.SerializeToString,
                response_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.StreamLocation.FromString,
                _registered_method=True)
        self.MultiRemove = channel.unary_unary(
                '/vald.v1.Remove/MultiRemove',
                request_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Remove.MultiRequest.SerializeToString,
                response_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.Locations.FromString,
                _registered_method=True)


class RemoveServicer(object):
    """Overview
    Remove Service is responsible for removing vectors indexed in the `vald-agent`.
    """

    def Remove(self, request, context):
        """Overview
        Remove RPC is the method to remove a single vector.
        ---
        Status Code
        |  0   | OK                |
        |  1   | CANCELLED         |
        |  3   | INVALID_ARGUMENT  |
        |  4   | DEADLINE_EXCEEDED |
        |  5   | NOT_FOUND         |
        |  10  | ABORTED           |
        |  13  | INTERNAL          |
        ---
        Troubleshooting
        The request process may not be completed when the response code is NOT `0 (OK)`.

        Here are some common reasons and how to resolve each error.

        | name              | common reason                                                                                   | how to resolve                                                                           |
        | :---------------- | :---------------------------------------------------------------------------------------------- | :--------------------------------------------------------------------------------------- |
        | CANCELLED         | Executed cancel() of rpc from client/server-side or network problems between client and server. | Check the code, especially around timeout and connection management, and fix if needed.  |
        | INVALID_ARGUMENT  | The Requested vector's ID is empty, or some request payload is invalid.                         | Check request payload and fix request payload.                                           |
        | DEADLINE_EXCEEDED | The RPC timeout setting is too short on the client/server side.                                 | Check the gRPC timeout setting on both the client and server sides and fix it if needed. |
        | NOT_FOUND         | Requested ID is NOT inserted.                                                                   | Send a request with an ID that is already inserted.                                      |
        | INTERNAL          | Target Vald cluster or network route has some critical error.                                   | Check target Vald cluster first and check network route including ingress as second.     |
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RemoveByTimestamp(self, request, context):
        """Overview
        RemoveByTimestamp RPC is the method to remove vectors based on timestamp.

        <div class="notice">
        In the TimestampRequest message, the 'timestamps' field is repeated, allowing the inclusion of multiple Timestamp.<br>
        When multiple Timestamps are provided, it results in an `AND` condition, enabling the realization of deletions with specified ranges.<br>
        This design allows for versatile deletion operations, facilitating tasks such as removing data within a specific time range.
        </div>
        ---
        Status Code
        |  0   | OK                |
        |  1   | CANCELLED         |
        |  4   | DEADLINE_EXCEEDED |
        |  5   | NOT_FOUND         |
        |  13  | INTERNAL          |
        ---
        Troubleshooting
        The request process may not be completed when the response code is NOT `0 (OK)`.

        Here are some common reasons and how to resolve each error.

        | name              | common reason                                                                                   | how to resolve                                                                                                       |
        | :---------------- | :---------------------------------------------------------------------------------------------- | :------------------------------------------------------------------------------------------------------------------- |
        | CANCELLED         | Executed cancel() of rpc from client/server-side or network problems between client and server. | Check the code, especially around timeout and connection management, and fix if needed.                              |
        | DEADLINE_EXCEEDED | The RPC timeout setting is too short on the client/server side.                                 | Check the gRPC timeout setting on both the client and server sides and fix it if needed.                             |
        | NOT_FOUND         | No vectors in the system match the specified timestamp conditions.                              | Check whether vectors matching the specified timestamp conditions exist in the system, and fix conditions if needed. |
        | INTERNAL          | Target Vald cluster or network route has some critical error.                                   | Check target Vald cluster first and check network route including ingress as second.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def StreamRemove(self, request_iterator, context):
        """Overview
        A method to remove multiple indexed vectors by bidirectional streaming.

        StreamRemove RPC is the method to remove multiple vectors using the [bidirectional streaming RPC](https://grpc.io/docs/what-is-grpc/core-concepts/#bidirectional-streaming-rpc).<br>
        Using the bidirectional streaming RPC, the remove request can be communicated in any order between client and server.
        Each Remove request and response are independent.
        It's the recommended method to remove a large number of vectors.
        ---
        Status Code
        |  0   | OK                |
        |  1   | CANCELLED         |
        |  3   | INVALID_ARGUMENT  |
        |  4   | DEADLINE_EXCEEDED |
        |  5   | NOT_FOUND         |
        |  10  | ABORTED           |
        |  13  | INTERNAL          |
        ---
        Troubleshooting
        The request process may not be completed when the response code is NOT `0 (OK)`.

        Here are some common reasons and how to resolve each error.

        | name              | common reason                                                                                   | how to resolve                                                                           |
        | :---------------- | :---------------------------------------------------------------------------------------------- | :--------------------------------------------------------------------------------------- |
        | CANCELLED         | Executed cancel() of rpc from client/server-side or network problems between client and server. | Check the code, especially around timeout and connection management, and fix if needed.  |
        | INVALID_ARGUMENT  | The Requested vector's ID is empty, or some request payload is invalid.                         | Check request payload and fix request payload.                                           |
        | DEADLINE_EXCEEDED | The RPC timeout setting is too short on the client/server side.                                 | Check the gRPC timeout setting on both the client and server sides and fix it if needed. |
        | NOT_FOUND         | Requested ID is NOT inserted.                                                                   | Send a request with an ID that is already inserted.                                      |
        | INTERNAL          | Target Vald cluster or network route has some critical error.                                   | Check target Vald cluster first and check network route including ingress as second.     |
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def MultiRemove(self, request, context):
        """Overview
        MultiRemove is the method to remove multiple vectors in **1** request.

        <div class="notice">
        gRPC has a message size limitation.<br>
        Please be careful that the size of the request exceeds the limit.
        </div>
        ---
        Status Code
        |  0   | OK                |
        |  1   | CANCELLED         |
        |  3   | INVALID_ARGUMENT  |
        |  4   | DEADLINE_EXCEEDED |
        |  5   | NOT_FOUND         |
        |  10  | ABORTED           |
        |  13  | INTERNAL          |
        ---
        Troubleshooting
        The request process may not be completed when the response code is NOT `0 (OK)`.

        Here are some common reasons and how to resolve each error.

        | name              | common reason                                                                                   | how to resolve                                                                           |
        | :---------------- | :---------------------------------------------------------------------------------------------- | :--------------------------------------------------------------------------------------- |
        | CANCELLED         | Executed cancel() of rpc from client/server-side or network problems between client and server. | Check the code, especially around timeout and connection management, and fix if needed.  |
        | INVALID_ARGUMENT  | The Requested vector's ID is empty, or some request payload is invalid.                         | Check request payload and fix request payload.                                           |
        | DEADLINE_EXCEEDED | The RPC timeout setting is too short on the client/server side.                                 | Check the gRPC timeout setting on both the client and server sides and fix it if needed. |
        | NOT_FOUND         | Requested ID is NOT inserted.                                                                   | Send a request with an ID that is already inserted.                                      |
        | INTERNAL          | Target Vald cluster or network route has some critical error.                                   | Check target Vald cluster first and check network route including ingress as second.     |
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_RemoveServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Remove': grpc.unary_unary_rpc_method_handler(
                    servicer.Remove,
                    request_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Remove.Request.FromString,
                    response_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.Location.SerializeToString,
            ),
            'RemoveByTimestamp': grpc.unary_unary_rpc_method_handler(
                    servicer.RemoveByTimestamp,
                    request_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Remove.TimestampRequest.FromString,
                    response_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.Locations.SerializeToString,
            ),
            'StreamRemove': grpc.stream_stream_rpc_method_handler(
                    servicer.StreamRemove,
                    request_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Remove.Request.FromString,
                    response_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.StreamLocation.SerializeToString,
            ),
            'MultiRemove': grpc.unary_unary_rpc_method_handler(
                    servicer.MultiRemove,
                    request_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Remove.MultiRequest.FromString,
                    response_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.Locations.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'vald.v1.Remove', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers('vald.v1.Remove', rpc_method_handlers)


 # This class is part of an EXPERIMENTAL API.
class Remove(object):
    """Overview
    Remove Service is responsible for removing vectors indexed in the `vald-agent`.
    """

    @staticmethod
    def Remove(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/vald.v1.Remove/Remove',
            vald_dot_v1_dot_payload_dot_payload__pb2.Remove.Request.SerializeToString,
            vald_dot_v1_dot_payload_dot_payload__pb2.Object.Location.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def RemoveByTimestamp(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/vald.v1.Remove/RemoveByTimestamp',
            vald_dot_v1_dot_payload_dot_payload__pb2.Remove.TimestampRequest.SerializeToString,
            vald_dot_v1_dot_payload_dot_payload__pb2.Object.Locations.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def StreamRemove(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_stream(
            request_iterator,
            target,
            '/vald.v1.Remove/StreamRemove',
            vald_dot_v1_dot_payload_dot_payload__pb2.Remove.Request.SerializeToString,
            vald_dot_v1_dot_payload_dot_payload__pb2.Object.StreamLocation.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def MultiRemove(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/vald.v1.Remove/MultiRemove',
            vald_dot_v1_dot_payload_dot_payload__pb2.Remove.MultiRequest.SerializeToString,
            vald_dot_v1_dot_payload_dot_payload__pb2.Object.Locations.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)
