# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from vald.v1.payload import payload_pb2 as vald_dot_v1_dot_payload_dot_payload__pb2


class UpsertStub(object):
    """Overview
    Upsert Service is responsible for updating existing vectors in the `vald-agent` or inserting new vectors into the `vald-agent` if the vector does not exist.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Upsert = channel.unary_unary(
                '/vald.v1.Upsert/Upsert',
                request_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Upsert.Request.SerializeToString,
                response_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.Location.FromString,
                _registered_method=True)
        self.StreamUpsert = channel.stream_stream(
                '/vald.v1.Upsert/StreamUpsert',
                request_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Upsert.Request.SerializeToString,
                response_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.StreamLocation.FromString,
                _registered_method=True)
        self.MultiUpsert = channel.unary_unary(
                '/vald.v1.Upsert/MultiUpsert',
                request_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Upsert.MultiRequest.SerializeToString,
                response_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.Locations.FromString,
                _registered_method=True)


class UpsertServicer(object):
    """Overview
    Upsert Service is responsible for updating existing vectors in the `vald-agent` or inserting new vectors into the `vald-agent` if the vector does not exist.
    """

    def Upsert(self, request, context):
        """Overview
        Upsert RPC is the method to update the inserted vector to a new single vector or add a new single vector if not inserted before.
        ---
        Status Code
        |  0   | OK                |
        |  1   | CANCELLED         |
        |  3   | INVALID_ARGUMENT  |
        |  4   | DEADLINE_EXCEEDED |
        |  5   | NOT_FOUND         |
        |  6   | ALREADY_EXISTS    |
        |  10  | ABORTED           |
        |  13  | INTERNAL          |
        ---
        Troubleshooting
        The request process may not be completed when the response code is NOT `0 (OK)`.

        Here are some common reasons and how to resolve each error.

        | name              | common reason                                                                                                                                       | how to resolve                                                                           |
        | :---------------- | :-------------------------------------------------------------------------------------------------------------------------------------------------- | :--------------------------------------------------------------------------------------- |
        | CANCELLED         | Executed cancel() of rpc from client/server-side or network problems between client and server.                                                     | Check the code, especially around timeout and connection management, and fix if needed.  |
        | INVALID_ARGUMENT  | The Dimension of the request vector is NOT the same as Vald Agent's config, the requested vector's ID is empty, or some request payload is invalid. | Check Agent config, request payload, and fix request payload or Agent config.            |
        | DEADLINE_EXCEEDED | The RPC timeout setting is too short on the client/server side.                                                                                     | Check the gRPC timeout setting on both the client and server sides and fix it if needed. |
        | ALREADY_EXISTS    | Requested pair of ID and vector is already inserted                                                                                                 | Change request payload or nothing to do if update is unnecessary.                        |
        | INTERNAL          | Target Vald cluster or network route has some critical error.                                                                                       | Check target Vald cluster first and check network route including ingress as second.     |
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def StreamUpsert(self, request_iterator, context):
        """Overview
        StreamUpsert RPC is the method to update multiple existing vectors or add new multiple vectors using the [bidirectional streaming RPC](https://grpc.io/docs/what-is-grpc/core-concepts/#bidirectional-streaming-rpc).<br>
        Using the bidirectional streaming RPC, the upsert request can be communicated in any order between the client and server.
        Each Upsert request and response are independent.
        It’s the recommended method to upsert a large number of vectors.
        ---
        Status Code
        |  0   | OK                |
        |  1   | CANCELLED         |
        |  3   | INVALID_ARGUMENT  |
        |  4   | DEADLINE_EXCEEDED |
        |  5   | NOT_FOUND         |
        |  6   | ALREADY_EXISTS    |
        |  10  | ABORTED           |
        |  13  | INTERNAL          |
        ---
        Troubleshooting
        The request process may not be completed when the response code is NOT `0 (OK)`.

        Here are some common reasons and how to resolve each error.

        | name              | common reason                                                                                                                                       | how to resolve                                                                           |
        | :---------------- | :-------------------------------------------------------------------------------------------------------------------------------------------------- | :--------------------------------------------------------------------------------------- |
        | CANCELLED         | Executed cancel() of rpc from client/server-side or network problems between client and server.                                                     | Check the code, especially around timeout and connection management, and fix if needed.  |
        | INVALID_ARGUMENT  | The Dimension of the request vector is NOT the same as Vald Agent's config, the requested vector's ID is empty, or some request payload is invalid. | Check Agent config, request payload, and fix request payload or Agent config.            |
        | DEADLINE_EXCEEDED | The RPC timeout setting is too short on the client/server side.                                                                                     | Check the gRPC timeout setting on both the client and server sides and fix it if needed. |
        | ALREADY_EXISTS    | Requested pair of ID and vector is already inserted                                                                                                 | Change request payload or nothing to do if update is unnecessary.                        |
        | INTERNAL          | Target Vald cluster or network route has some critical error.                                                                                       | Check target Vald cluster first and check network route including ingress as second.     |
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def MultiUpsert(self, request, context):
        """Overview
        MultiUpsert is the method to update existing multiple vectors and add new multiple vectors in **1** request.

        <div class="notice">
        gRPC has a message size limitation.<br>
        Please be careful that the size of the request exceeds the limit.
        </div>
        ---
        Status Code
        |  0   | OK                |
        |  1   | CANCELLED         |
        |  3   | INVALID_ARGUMENT  |
        |  4   | DEADLINE_EXCEEDED |
        |  5   | NOT_FOUND         |
        |  6   | ALREADY_EXISTS    |
        |  10  | ABORTED           |
        |  13  | INTERNAL          |
        ---
        Troubleshooting
        The request process may not be completed when the response code is NOT `0 (OK)`.

        Here are some common reasons and how to resolve each error.

        | name              | common reason                                                                                                                                       | how to resolve                                                                           |
        | :---------------- | :-------------------------------------------------------------------------------------------------------------------------------------------------- | :--------------------------------------------------------------------------------------- |
        | CANCELLED         | Executed cancel() of rpc from client/server-side or network problems between client and server.                                                     | Check the code, especially around timeout and connection management, and fix if needed.  |
        | INVALID_ARGUMENT  | The Dimension of the request vector is NOT the same as Vald Agent's config, the requested vector's ID is empty, or some request payload is invalid. | Check Agent config, request payload, and fix request payload or Agent config.            |
        | DEADLINE_EXCEEDED | The RPC timeout setting is too short on the client/server side.                                                                                     | Check the gRPC timeout setting on both the client and server sides and fix it if needed. |
        | ALREADY_EXISTS    | Requested pair of ID and vector is already inserted                                                                                                 | Change request payload or nothing to do if update is unnecessary.                        |
        | INTERNAL          | Target Vald cluster or network route has some critical error.                                                                                       | Check target Vald cluster first and check network route including ingress as second.     |
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_UpsertServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Upsert': grpc.unary_unary_rpc_method_handler(
                    servicer.Upsert,
                    request_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Upsert.Request.FromString,
                    response_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.Location.SerializeToString,
            ),
            'StreamUpsert': grpc.stream_stream_rpc_method_handler(
                    servicer.StreamUpsert,
                    request_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Upsert.Request.FromString,
                    response_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.StreamLocation.SerializeToString,
            ),
            'MultiUpsert': grpc.unary_unary_rpc_method_handler(
                    servicer.MultiUpsert,
                    request_deserializer=vald_dot_v1_dot_payload_dot_payload__pb2.Upsert.MultiRequest.FromString,
                    response_serializer=vald_dot_v1_dot_payload_dot_payload__pb2.Object.Locations.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'vald.v1.Upsert', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers('vald.v1.Upsert', rpc_method_handlers)


 # This class is part of an EXPERIMENTAL API.
class Upsert(object):
    """Overview
    Upsert Service is responsible for updating existing vectors in the `vald-agent` or inserting new vectors into the `vald-agent` if the vector does not exist.
    """

    @staticmethod
    def Upsert(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/vald.v1.Upsert/Upsert',
            vald_dot_v1_dot_payload_dot_payload__pb2.Upsert.Request.SerializeToString,
            vald_dot_v1_dot_payload_dot_payload__pb2.Object.Location.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def StreamUpsert(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_stream(
            request_iterator,
            target,
            '/vald.v1.Upsert/StreamUpsert',
            vald_dot_v1_dot_payload_dot_payload__pb2.Upsert.Request.SerializeToString,
            vald_dot_v1_dot_payload_dot_payload__pb2.Object.StreamLocation.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def MultiUpsert(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/vald.v1.Upsert/MultiUpsert',
            vald_dot_v1_dot_payload_dot_payload__pb2.Upsert.MultiRequest.SerializeToString,
            vald_dot_v1_dot_payload_dot_payload__pb2.Object.Locations.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)
