# coding: utf-8

"""
    Loci Notes Server

     The [Loci Notes](https://loci-notes.gitlab.io/) server API.  The Loci Notes server is a FastAPI server that provides a RESTful API for interacting with the Loci Notes system. The server is designed to be used by the Loci Notes web UI, VS Code extension, Loci Notes CLI, and any other clients that may be developed in the future.

    The version of the OpenAPI document: 0.20240917.154332
    Contact: thetwitchy@thetwitchy.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from loci_client.models.artifact_note_type_enum import ArtifactNoteTypeEnum
from loci_client.models.artifact_priority_enum import ArtifactPriorityEnum
from loci_client.models.artifact_type_enum import ArtifactTypeEnum
from typing import Optional, Set
from typing_extensions import Self

class ArtifactNoteIn(BaseModel):
    """
    ArtifactNoteIn
    """ # noqa: E501
    artifact_id: Optional[StrictInt] = None
    artifact_descriptor: Optional[StrictStr] = None
    artifact_type: Optional[ArtifactTypeEnum] = None
    artifact_priority: Optional[ArtifactPriorityEnum] = None
    submission_tool: Optional[StrictStr] = None
    type: ArtifactNoteTypeEnum
    contents: StrictStr
    __properties: ClassVar[List[str]] = ["artifact_id", "artifact_descriptor", "artifact_type", "artifact_priority", "submission_tool", "type", "contents"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ArtifactNoteIn from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if artifact_id (nullable) is None
        # and model_fields_set contains the field
        if self.artifact_id is None and "artifact_id" in self.model_fields_set:
            _dict['artifact_id'] = None

        # set to None if artifact_descriptor (nullable) is None
        # and model_fields_set contains the field
        if self.artifact_descriptor is None and "artifact_descriptor" in self.model_fields_set:
            _dict['artifact_descriptor'] = None

        # set to None if artifact_type (nullable) is None
        # and model_fields_set contains the field
        if self.artifact_type is None and "artifact_type" in self.model_fields_set:
            _dict['artifact_type'] = None

        # set to None if artifact_priority (nullable) is None
        # and model_fields_set contains the field
        if self.artifact_priority is None and "artifact_priority" in self.model_fields_set:
            _dict['artifact_priority'] = None

        # set to None if submission_tool (nullable) is None
        # and model_fields_set contains the field
        if self.submission_tool is None and "submission_tool" in self.model_fields_set:
            _dict['submission_tool'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ArtifactNoteIn from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "artifact_id": obj.get("artifact_id"),
            "artifact_descriptor": obj.get("artifact_descriptor"),
            "artifact_type": obj.get("artifact_type"),
            "artifact_priority": obj.get("artifact_priority"),
            "submission_tool": obj.get("submission_tool"),
            "type": obj.get("type"),
            "contents": obj.get("contents")
        })
        return _obj


