# coding: utf-8

"""
    Loci Notes Server

     The [Loci Notes](https://loci-notes.gitlab.io/) server API.  The Loci Notes server is a FastAPI server that provides a RESTful API for interacting with the Loci Notes system. The server is designed to be used by the Loci Notes web UI, VS Code extension, Loci Notes CLI, and any other clients that may be developed in the future.

    The version of the OpenAPI document: 0.20240917.154332
    Contact: thetwitchy@thetwitchy.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from loci_client.models.artifact_export import ArtifactExport
from loci_client.models.project_in import ProjectIn
from loci_client.models.user_out import UserOut
from typing import Optional, Set
from typing_extensions import Self

class ProjectExport(BaseModel):
    """
    ProjectExport
    """ # noqa: E501
    export_version: Optional[StrictStr] = '0.1'
    export_time: datetime
    project: ProjectIn
    users: List[UserOut]
    artifacts: List[ArtifactExport]
    __properties: ClassVar[List[str]] = ["export_version", "export_time", "project", "users", "artifacts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProjectExport from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in users (list)
        _items = []
        if self.users:
            for _item_users in self.users:
                if _item_users:
                    _items.append(_item_users.to_dict())
            _dict['users'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in artifacts (list)
        _items = []
        if self.artifacts:
            for _item_artifacts in self.artifacts:
                if _item_artifacts:
                    _items.append(_item_artifacts.to_dict())
            _dict['artifacts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProjectExport from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "export_version": obj.get("export_version") if obj.get("export_version") is not None else '0.1',
            "export_time": obj.get("export_time"),
            "project": ProjectIn.from_dict(obj["project"]) if obj.get("project") is not None else None,
            "users": [UserOut.from_dict(_item) for _item in obj["users"]] if obj.get("users") is not None else None,
            "artifacts": [ArtifactExport.from_dict(_item) for _item in obj["artifacts"]] if obj.get("artifacts") is not None else None
        })
        return _obj


