# coding: utf-8

"""
    Loci Notes Server

     The [Loci Notes](https://loci-notes.gitlab.io/) server API.  The Loci Notes server is a FastAPI server that provides a RESTful API for interacting with the Loci Notes system. The server is designed to be used by the Loci Notes web UI, VS Code extension, Loci Notes CLI, and any other clients that may be developed in the future.

    The version of the OpenAPI document: 0.20240917.154332
    Contact: thetwitchy@thetwitchy.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from loci_client.models.user_out import UserOut
from typing import Optional, Set
from typing_extensions import Self

class ProjectOut(BaseModel):
    """
    ProjectOut
    """ # noqa: E501
    name: StrictStr
    id: StrictInt
    created_at: datetime
    users: List[UserOut]
    managers: List[UserOut]
    __properties: ClassVar[List[str]] = ["name", "id", "created_at", "users", "managers"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProjectOut from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in users (list)
        _items = []
        if self.users:
            for _item_users in self.users:
                if _item_users:
                    _items.append(_item_users.to_dict())
            _dict['users'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in managers (list)
        _items = []
        if self.managers:
            for _item_managers in self.managers:
                if _item_managers:
                    _items.append(_item_managers.to_dict())
            _dict['managers'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProjectOut from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "id": obj.get("id"),
            "created_at": obj.get("created_at"),
            "users": [UserOut.from_dict(_item) for _item in obj["users"]] if obj.get("users") is not None else None,
            "managers": [UserOut.from_dict(_item) for _item in obj["managers"]] if obj.get("managers") is not None else None
        })
        return _obj


