import { IConstruct } from 'constructs';
import { IManagedPolicy } from './managed-policy';
/**
 * Modify the Permissions Boundaries of Users and Roles in a construct tree.
 *
 * @stability stable
 * @example
 *
 * const policy = ManagedPolicy.fromAwsManagedPolicyName('ReadOnlyAccess');
 * PermissionsBoundary.of(stack).apply(policy);
 */
export declare class PermissionsBoundary {
    private readonly scope;
    /**
     * Access the Permissions Boundaries of a construct tree.
     *
     * @stability stable
     */
    static of(scope: IConstruct): PermissionsBoundary;
    private constructor();
    /**
     * Apply the given policy as Permissions Boundary to all Roles in the scope.
     *
     * Will override any Permissions Boundaries configured previously; in case
     * a Permission Boundary is applied in multiple scopes, the Boundary applied
     * closest to the Role wins.
     *
     * @stability stable
     */
    apply(boundaryPolicy: IManagedPolicy): void;
    /**
     * Remove previously applied Permissions Boundaries.
     *
     * @stability stable
     */
    clear(): void;
}
