# coding: utf-8

"""
    VRt.Account [AC]

    # Description  Veeroute Account Panel.  ## Entity relationship diagram  ![erd](../uml/account.svg) 

    The version of the OpenAPI document: 7.21.2852
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_account.models.audit_action_statistics import AuditActionStatistics
from vrt_lss_account.models.process_type import ProcessType
from vrt_lss_account.models.service import Service
from vrt_lss_account.models.tracedata import Tracedata
from typing import Optional, Set
from typing_extensions import Self

class AuditAction(BaseModel):
    """
    User action.
    """ # noqa: E501
    process_code: StrictStr = Field(description="Unique process identifier. One is created per process, the same for different requests for the same process. ")
    process_type: ProcessType
    username: Annotated[str, Field(min_length=2, strict=True, max_length=256)] = Field(description="Unique username for login.")
    company: Annotated[str, Field(min_length=3, strict=True, max_length=256)] = Field(description="Unique company key.")
    service: Service
    time: datetime = Field(description="The date and time the process was created according to [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format.")
    requests: Annotated[List[Tracedata], Field(min_length=0)] = Field(description="List of requests that relate to one process.")
    statistics: AuditActionStatistics
    input_file_exists: Optional[StrictBool] = Field(default=False, description="Indicates the presence of a saved input file.")
    output_file_exists: Optional[StrictBool] = Field(default=False, description="Indicates the presence of a saved output file.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["process_code", "process_type", "username", "company", "service", "time", "requests", "statistics", "input_file_exists", "output_file_exists"]

    @field_validator('username')
    def username_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"\w+", value):
            raise ValueError(r"must validate the regular expression /\w+/")
        return value

    @field_validator('company')
    def company_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"\w+", value):
            raise ValueError(r"must validate the regular expression /\w+/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AuditAction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in requests (list)
        _items = []
        if self.requests:
            for _item_requests in self.requests:
                if _item_requests:
                    _items.append(_item_requests.to_dict())
            _dict['requests'] = _items
        # override the default output from pydantic by calling `to_dict()` of statistics
        if self.statistics:
            _dict['statistics'] = self.statistics.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AuditAction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "process_code": obj.get("process_code"),
            "process_type": obj.get("process_type"),
            "username": obj.get("username"),
            "company": obj.get("company"),
            "service": obj.get("service"),
            "time": obj.get("time"),
            "requests": [Tracedata.from_dict(_item) for _item in obj["requests"]] if obj.get("requests") is not None else None,
            "statistics": AuditActionStatistics.from_dict(obj["statistics"]) if obj.get("statistics") is not None else None,
            "input_file_exists": obj.get("input_file_exists") if obj.get("input_file_exists") is not None else False,
            "output_file_exists": obj.get("output_file_exists") if obj.get("output_file_exists") is not None else False
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


