import os
from dotenv import load_dotenv
from qdrant_client import QdrantClient
from qdrant_client.models import VectorParams, Distance
from langchain_qdrant import QdrantVectorStore
from langchain_openai import AzureOpenAIEmbeddings
client = QdrantClient(os.getenv("QDRANT_HOST"), port=6333)

load_dotenv()

if not client.collection_exists(os.getenv("MAIN_RAG_COLLECTION_NAME")):
   client.create_collection(
      collection_name= os.getenv("MAIN_RAG_COLLECTION_NAME"),
      vectors_config=VectorParams(size=3072, distance=Distance.COSINE),
   )

if not client.collection_exists(os.getenv("FEEDBACK_COLLECTION_NAME")):
    client.create_collection(
        collection_name= os.getenv("FEEDBACK_COLLECTION_NAME"),
        vectors_config=VectorParams(size=3072, distance=Distance.COSINE)
    )


embeddings = AzureOpenAIEmbeddings(
    model = "text-embedding-3-large",
    api_key = os.getenv("AZURE_OPENAI_API_KEY"),
    azure_endpoint =os.getenv("AZURE_OPENAI_ENDPOINT")
)


rag_vector_store = QdrantVectorStore(
    client= client,
    collection_name= os.getenv("MAIN_RAG_COLLECTION_NAME"),
    embedding=embeddings
)

feedback_vector_store = QdrantVectorStore(
    client= client,
    collection_name= os.getenv("FEEDBACK_COLLECTION_NAME"),
    embedding=embeddings
)
