from typing import List

from fastapi import APIRouter

from src.ragapi.services import RagService
from src.ragapi.dtos import (
    AskRequestDto,
    FeedbackDto,
    FileUploadRequestDto,
    LoadFileRequestDto,
    SuggestionRequestDto
)
router = APIRouter()

@router.post("/send-feedback")
async def sendFeedback(data: FeedbackDto):
    """
    Save user feedback
    :param data:
    :return:
    """
    return await RagService().saveFeedback(data)


@router.post("/suggest-answers")
async def suggestAnswers(data: SuggestionRequestDto):
    """
    Suggest answers similar to the asked question
    :param data:
    :return:
    """
    return await RagService().suggestAnswers(data)

@router.post("/ask")
async def ask(data: AskRequestDto):
    """
    Get Bot responses from based on documents if rag is enabled or not
    :param data:
    :return:
    """
    return await RagService().ask(data)

@router.post("/load")
async def load_files(data: List[LoadFileRequestDto]):
    """
    Load files in the database for providing context to the Bot later on
    :param data:
    :return:
    """
    return await RagService().load_files(data)

@router.post("/upload")
async def upload_file(data: FileUploadRequestDto):
    """
    Upload a file in base64 format in the database
    :param data:
    :return:
    """

    return await RagService().upload_file(data)