from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkFiltersCore

class vtkCriticalTime(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    class ComponentModeType(int): ...
    class ThresholdType(int): ...
    COMPONENT_MODE_USE_ALL:'ComponentModeType'
    COMPONENT_MODE_USE_ANY:'ComponentModeType'
    COMPONENT_MODE_USE_SELECTED:'ComponentModeType'
    THRESHOLD_BETWEEN:'ThresholdType'
    THRESHOLD_LOWER:'ThresholdType'
    THRESHOLD_UPPER:'ThresholdType'
    component_mode:'getset_descriptor'
    lower_threshold:'getset_descriptor'
    selected_component:'getset_descriptor'
    threshold_criterion:'getset_descriptor'
    upper_threshold:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetComponentMode(self) -> int: ...
    def GetComponentModeAsString(self) -> str: ...
    def GetComponentModeMaxValue(self) -> int: ...
    def GetComponentModeMinValue(self) -> int: ...
    def GetLowerThreshold(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSelectedComponent(self) -> int: ...
    def GetSelectedComponentMaxValue(self) -> int: ...
    def GetSelectedComponentMinValue(self) -> int: ...
    def GetThresholdCriterion(self) -> int: ...
    def GetThresholdCriterionMaxValue(self) -> int: ...
    def GetThresholdCriterionMinValue(self) -> int: ...
    def GetThresholdFunctionAsString(self) -> str: ...
    def GetUpperThreshold(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCriticalTime': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCriticalTime': ...
    def SetComponentMode(self, _arg:int) -> None: ...
    def SetComponentModeToUseAll(self) -> None: ...
    def SetComponentModeToUseAny(self) -> None: ...
    def SetComponentModeToUseSelected(self) -> None: ...
    def SetLowerThreshold(self, _arg:float) -> None: ...
    def SetSelectedComponent(self, _arg:int) -> None: ...
    def SetThresholdCriterion(self, _arg:int) -> None: ...
    def SetThresholdCriterionToBetween(self) -> None: ...
    def SetThresholdCriterionToLower(self) -> None: ...
    def SetThresholdCriterionToUpper(self) -> None: ...
    def SetUpperThreshold(self, _arg:float) -> None: ...
    @staticmethod
    def TimeStepsArrayName() -> str: ...

class vtkDataObjectMeshCache(vtkmodules.vtkCommonCore.vtkObject):
    consumer:'getset_descriptor'
    original_data_object:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddOriginalIds(self, attribute:int, name:str) -> None: ...
    def ClearOriginalIds(self) -> None: ...
    def CopyCacheToDataObject(self, output:'vtkDataObject') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InvalidateCache(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsSupportedData(self, dataobject:'vtkDataObject') -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataObjectMeshCache': ...
    def RemoveOriginalIds(self, attribute:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataObjectMeshCache': ...
    def SetConsumer(self, _arg:'vtkAlgorithm') -> None: ...
    def SetOriginalDataObject(self, original:'vtkDataObject') -> None: ...
    def UpdateCache(self, newObject:'vtkDataObject') -> None: ...

class vtkForceStaticMesh(vtkmodules.vtkFiltersCore.vtkPassThrough):
    force_cache_computation:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ForceCacheComputationOff(self) -> None: ...
    def ForceCacheComputationOn(self) -> None: ...
    def GetForceCacheComputation(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkForceStaticMesh': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkForceStaticMesh': ...
    def SetForceCacheComputation(self, _arg:bool) -> None: ...

class vtkTemporalSmoothing(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    temporal_window_half_width:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTemporalWindowHalfWidth(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTemporalSmoothing': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTemporalSmoothing': ...
    def SetTemporalWindowHalfWidth(self, _arg:int) -> None: ...

