from setuptools import setup


setup(
    use_scm_version={
        "write_to": "mc_goods/_version.py",
        "write_to_template": '__version__ = "{version}"',
        "tag_regex": r"^(?P<prefix>v)?(?P<version>[^\+]+)(?P<suffix>.*)?$",
    },
    entry_points={
        'intake.catalogs': [
            'mc_CBOFS_RGRID = mc_goods:cbofs_rgrid',
            'mc_CBOFS = mc_goods:cbofs',
            'mc_CIOFS_RGRID = mc_goods:ciofs_rgrid',
            'mc_CIOFS = mc_goods:ciofs',
            'mc_CREOFS_RGRID = mc_goods:creofs_rgrid',
            'mc_CREOFS = mc_goods:creofs',
            'mc_DBOFS_RGRID = mc_goods:dbofs_rgrid',
            'mc_DBOFS = mc_goods:dbofs',
            'mc_GFS_1_2DEG = mc_goods:gfs_1_2deg',
            'mc_GFS_1_4DEG = mc_goods:gfs_1_4deg',
            'mc_GFS_1DEG = mc_goods:gfs_1deg',
            'mc_GOFS = mc_goods:gofs',
            'mc_GOMOFS_2DS = mc_goods:gomofs_2ds',
            'mc_GOMOFS_RGRID = mc_goods:gomofs_rgrid',
            'mc_GOMOFS = mc_goods:gomofs',
            'mc_LEOFS_RGRID = mc_goods:leofs_rgrid',
            'mc_LEOFS = mc_goods:leofs',
            'mc_LMHOFS_RGRID = mc_goods:lmhofs_rgrid',
            'mc_LMHOFS = mc_goods:lmhofs',
            'mc_LOOFS_FVCOM = mc_goods:loofs_fvcom',
            'mc_LOOFS = mc_goods:loofs',
            'mc_LSOFS_FVCOM = mc_goods:lsofs_fvcom',
            'mc_LSOFS = mc_goods:lsofs',
            'mc_NGOFS2_2DS = mc_goods:ngofs2_2ds',
            'mc_NGOFS2_RGRID = mc_goods:ngofs2_rgrid',
            'mc_NGOFS2 = mc_goods:ngofs2',
            'mc_NYOFS = mc_goods:nyofs',
            'mc_RTOFS_2D = mc_goods:rtofs_2d',
            'mc_RTOFS_AK = mc_goods:rtofs_ak',
            'mc_RTOFS_EAST = mc_goods:rtofs_east',
            'mc_RTOFS_WEST = mc_goods:rtofs_west',
            'mc_RTOFS = mc_goods:rtofs',
            'mc_SFBOFS_RGRID = mc_goods:sfbofs_rgrid',
            'mc_SFBOFS = mc_goods:sfbofs',
            'mc_TBOFS_RGRID = mc_goods:tbofs_rgrid',
            'mc_TBOFS = mc_goods:tbofs',
            'mc_WCOFS_2DS = mc_goods:wcofs_2ds',
            'mc_WCOFS_RGRID = mc_goods:wcofs_rgrid',
            'mc_WCOFS = mc_goods:wcofs',
        ]
    },
)
