# -*- coding: utf-8 -*-
臺灣閩南語羅馬字拼音對照吳守禮方音聲母表 = {
    'p': 'ㄅ', 'ph': 'ㄆ', 'm': 'ㄇ', 'b': 'ㆠ',
    't': 'ㄉ', 'th': 'ㄊ', 'n': 'ㄋ', 'l': 'ㄌ',
    'k': 'ㄍ', 'kh': 'ㄎ', 'ng': 'ㄫ', 'g': 'ㆣ', 'h': 'ㄏ',
    'ts': 'ㄗ', 'tsh': 'ㄘ', 's': 'ㄙ', 'j': 'ㆡ',
    'tsi': 'ㄐ', 'tshi': 'ㄑ', 'si': 'ㄒ', 'ji': 'ㆢ',
    '': '',
}
臺灣閩南語羅馬字拼音對照吳守禮方音韻母表 = {
    'a': 'ㄚ', 'e': 'ㆤ', 'i': 'ㄧ', 'oo': 'ㆦ', 'o': 'ㄜ', 'u': 'ㄨ',
    'ai': 'ㄞ', 'au': 'ㄠ', 'ia': 'ㄧㄚ',
    'io': 'ㄧㄜ', 'iu': 'ㄧㄨ', 'ua': 'ㄨㄚ', 'ue': 'ㄨㆤ', 'ui': 'ㄨㄧ',
    'iau': 'ㄧㄠ', 'uai': 'ㄨㄞ',
    'ann': 'ㆩ', 'enn': 'ㆥ', 'inn': 'ㆪ', 'onn': 'ㆲ',
    'm': 'ㆬ', 'ng': 'ㆭ', 'ainn': 'ㆮ', 'iann': 'ㄧㆩ', 'iaunn': 'ㄧㆯ',
    'iunn': 'ㄧㆫ', 'uann': 'ㄨㆩ', 'uannh': 'ㄨㆩㆷ', 'uainn': 'ㄨㆮ',
    'am': 'ㆰ', 'an': 'ㄢ', 'ang': 'ㄤ',
    'im': 'ㄧㆬ', 'in': 'ㄧㄣ', 'ing': 'ㄧㄥ',
    'om': 'ㆱ', 'ong': 'ㆲ', 'iam': 'ㄧㆰ',
    'ian': 'ㄧㄢ', 'iang': 'ㄧㄤ', 'iong': 'ㄧㆲ',
    'un': 'ㄨㄣ', 'uan': 'ㄨㄢ',
    'ah': 'ㄚㆷ', 'eh': 'ㆤㆷ', 'ih': 'ㄧㆷ', 'oh': 'ㄜㆷ', 'uh': 'ㄨ', 'auh': 'ㄠㆷ', 'iah': 'ㄧㄚㆷ',
    'ioh': 'ㄧㄜㆷ', 'iuh': 'ㄧㄨㆷ', 'iauh': 'ㄧㄠㆷ',
    'uah': 'ㄨㄚㆷ', 'ueh': 'ㄨㆤㆷ', 'ooh': 'ㆦㆷ',
    'annh': 'ㆩㆷ', 'ennh': 'ㆥㆷ', 'innh': 'ㆪㆷ', 'mh': 'ㆬㆷ', 'iannh': 'ㄧㆩㆷ', 'ngh': 'ㆭㆷ',
    'ap': 'ㄚㆴ', 'at': 'ㄚㆵ', 'ak': 'ㄚㆶ', 'op': 'ㆦㆴ', 'ok': 'ㆦㆶ', 'iok': 'ㄧㆦㆶ',
    'ip': 'ㄧㆴ', 'it': 'ㄧㆵ', 'ik': 'ㄧㆶ', 'iap': 'ㄧㄚㆴ', 'iat': 'ㄧㄚㆵ', 'iak': 'ㄧㄚㆶ',
    'ut': 'ㄨㆵ', 'uat': 'ㄨㄚㆵ',
    'ioo': 'ㄧㆦ', 'iooh': 'ㄧㆦㆷ',
    # 泉 豬仔
    'ir': 'ㆨ', 'irh': 'ㆨㆷ', 'irp': 'ㆨㆴ', 'irt': 'ㆨㆵ', 'irk': 'ㆨㆶ',
    'irinn': 'ㆨㆪ', 'irm': 'ㆨㆬ', 'irn': 'ㆨㄣ', 'irng': 'ㆨㄥ',
    'er': 'ㄮ', 'ere': 'ㄮㆤ', 'erh': 'ㄮㆷ', 'ereh': 'ㄮㆤㆷ', 'erm': 'ㄮㆬ',
    'ee': 'ㄝ', 'uee': 'ㄨㄝ', 'eeh': 'ㄝㆷ', 'eng': 'ㄝㄥ',
    # 蚵仔
    'or': 'ㄛ', 'orh': 'ㄛㆷ', 'ior': 'ㄧㄛ', 'iorh': 'ㄧㄛㆷ',
    'ie': 'ㄧㄝ',  # 教育部辭典鹿港腔
    'uinn': 'ㄨㆪ', 'ionn': 'ㄧㆧ', 'uang': 'ㄨㄤ',
    'aih': 'ㄞㆷ', 'ainnh': 'ㆮㆷ', 'aunnh': 'ㆯㆷ', 'uih': 'ㄨㄧㆷ',
    'aunn': 'ㆯ', 'uenn': 'ㄨㆥ', 'uaih': 'ㄨㄞㆷ',
    'iunnh': 'ㄧㆫㆷ', 'iaunnh': 'ㄧㆯㆷ', 'uennh': 'ㄨㆥㆷ', 'uinnh': 'ㄨㆪㆷ', 'uainnh': 'ㄨㆮㆷ',
    'iut': 'ㄧㄨㆵ', 'uak': 'ㄨㄚㆶ', 'onnh': 'ㆧㆷ',
    'oi': 'ㆦㄧ', 'oih': 'ㆦㄧㆷ',
}
臺灣閩南語羅馬字拼音對照吳守禮方音聲調表 = {
    '0': '˙', '1': '', '2': 'ˋ', '3': '˪',
    '4': '', '5': 'ˊ', '6': '˫', '7': '˫',
    '8': '㆐', '9': '^', '10': '㆐'
}


class 臺灣閩南語羅馬字拼音轉方音符號吳守禮改良式模組():
    聲母表 = 臺灣閩南語羅馬字拼音對照吳守禮方音聲母表
    韻母表 = 臺灣閩南語羅馬字拼音對照吳守禮方音韻母表
    聲調符號表 = 臺灣閩南語羅馬字拼音對照吳守禮方音聲調表
    聲 = None
    韻 = None
    調 = None
    音標 = None

    def __init__(self, 聲, 韻, 調, 輕):
        if 聲 is None or 韻 is None or 調 is None or 輕 is None:
            return
        if 韻.startswith('i') and (聲 == 'ts' or 聲 == 'tsh' or 聲 == 's' or 聲 == 'j'):
            聲 += 'i'
        if 輕 == '0':
            調 = '0'
        self.聲 = self.聲母表[聲]
        self.韻 = self.韻母表[韻]
        self.調 = self.聲調符號表[調]
        if 調 == '0':
            self.音標 = self.調 + self.聲 + self.韻
        elif 調 == '8':
            self.音標 = self.聲 + self.韻[:-1] + self.調 + self.韻[-1:]
        else:
            self.音標 = self.聲 + self.韻 + self.調

    def 產生音標組字式(self):
        if self.音標 is None:
            return None
        elif len(self.音標) == 1:
            return '⿿' + self.音標 + '　'
        else:
            return '⿿' * (len(self.音標) - 1) + self.音標
