window.HUDVisualizer=class{constructor(){this.cy=null,this.container=null,this.nodes=new Map,this.isActive=!1,this.librariesLoaded=!1,this.loadingPromise=null,this.pendingEvents=[],this.layoutConfig={name:"dagre",rankDir:"TB",animate:!0,animationDuration:500,fit:!0,padding:30,rankSep:100,nodeSep:80},this.nodeTypes={PM:{color:"#48bb78",shape:"rectangle",width:120,height:40,icon:"👤"},AGENT:{color:"#9f7aea",shape:"ellipse",width:100,height:60,icon:"🤖"},TOOL:{color:"#4299e1",shape:"diamond",width:80,height:50,icon:"🔧"},TODO:{color:"#e53e3e",shape:"triangle",width:70,height:40,icon:"📝"}}}initialize(){return this.container=document.getElementById("hud-cytoscape"),this.container?(this.container.style.pointerEvents="auto",this.container.style.cursor="default",this.container.style.position="relative",this.container.style.zIndex="1",this.setupBasicEventHandlers(),console.log("HUD Visualizer initialized (libraries will load lazily)"),!0):(console.error("HUD container not found"),!1)}async loadLibrariesAndInitialize(){return this.librariesLoaded&&this.cy?Promise.resolve():(this.loadingPromise||(this.loadingPromise=this._performLazyLoading()),this.loadingPromise)}async _performLazyLoading(){try{if(console.log("[HUD-VISUALIZER-DEBUG] _performLazyLoading() called"),console.log("[HUD-VISUALIZER-DEBUG] Loading HUD visualization libraries..."),this.showLoadingIndicator(),!window.HUDLibraryLoader)throw new Error("HUD Library Loader not available");if(console.log("[HUD-VISUALIZER-DEBUG] HUD Library Loader found, loading libraries..."),await window.HUDLibraryLoader.loadHUDLibraries(e=>{console.log("[HUD-VISUALIZER-DEBUG] Loading progress:",e),this.updateLoadingProgress(e)}),console.log("[HUD-VISUALIZER-DEBUG] Verifying libraries are loaded..."),void 0===window.cytoscape)throw new Error("Cytoscape.js not loaded");if(void 0===window.dagre)throw new Error("Dagre not loaded");if(void 0===window.cytoscapeDagre)throw new Error("Cytoscape-dagre not loaded");return console.log("[HUD-VISUALIZER-DEBUG] All HUD libraries loaded successfully"),this.librariesLoaded=!0,console.log("[HUD-VISUALIZER-DEBUG] Initializing Cytoscape..."),this.initializeCytoscape(),console.log("[HUD-VISUALIZER-DEBUG] Setting up Cytoscape event handlers..."),this.setupCytoscapeEventHandlers(),console.log("[HUD-VISUALIZER-DEBUG] Processing pending events..."),this.processPendingEvents(),this.hideLoadingIndicator(),console.log("[HUD-VISUALIZER-DEBUG] HUD Visualizer fully initialized with lazy loading"),!0}catch(e){throw console.error("[HUD-VISUALIZER-DEBUG] Failed to load HUD libraries:",e),console.error("[HUD-VISUALIZER-DEBUG] Error stack:",e.stack),this.showLoadingError(e.message),this.librariesLoaded=!1,this.loadingPromise=null,e}}initializeCytoscape(){this.librariesLoaded&&window.cytoscape?(void 0!==window.cytoscape&&void 0!==window.cytoscapeDagre&&window.cytoscape.use(window.cytoscapeDagre),this.cy=window.cytoscape({container:this.container,elements:[],userZoomingEnabled:!0,userPanningEnabled:!0,boxSelectionEnabled:!1,autoungrabify:!1,autounselectify:!1,style:[{selector:"node",style:{"background-color":"data(color)","border-color":"data(borderColor)","border-width":2,color:"#ffffff",label:"data(label)","text-valign":"center","text-halign":"center","font-size":"12px","font-weight":"bold",width:"data(width)",height:"data(height)",shape:"data(shape)","text-wrap":"wrap","text-max-width":"100px"}},{selector:"edge",style:{width:2,"line-color":"#718096","target-arrow-color":"#718096","target-arrow-shape":"triangle","curve-style":"bezier","arrow-scale":1.2}},{selector:".pm-node",style:{"background-color":"#48bb78","border-color":"#38a169",shape:"rectangle"}},{selector:".agent-node",style:{"background-color":"#9f7aea","border-color":"#805ad5",shape:"ellipse"}},{selector:".tool-node",style:{"background-color":"#4299e1","border-color":"#3182ce",shape:"diamond"}},{selector:".todo-node",style:{"background-color":"#e53e3e","border-color":"#c53030",shape:"triangle"}},{selector:"node:active",style:{"overlay-opacity":.2,"overlay-color":"#000000"}}],layout:this.layoutConfig}),this.setupResizeHandler()):console.error("Cannot initialize Cytoscape: libraries not loaded")}setupBasicEventHandlers(){const e=document.getElementById("hud-reset-layout");e&&e.addEventListener("click",()=>{this.resetLayout()});const t=document.getElementById("hud-center-view");t&&t.addEventListener("click",()=>{this.centerView()})}setupCytoscapeEventHandlers(){this.cy?(console.log("[HUD-VISUALIZER-DEBUG] Setting up Cytoscape event handlers..."),this.cy.on("tap","node",e=>{const t=e.target,o=t.data();console.log("[HUD-VISUALIZER-DEBUG] Node clicked:",o),this.highlightConnectedNodes(t)}),this.cy.on("tap",e=>{e.target===this.cy&&(console.log("[HUD-VISUALIZER-DEBUG] Background clicked - resetting highlights"),this.cy.nodes().style({opacity:1}),this.cy.edges().style({opacity:1}))}),this.cy.on("mouseover","node",e=>{e.target.style("opacity",.8)}),this.cy.on("mouseout","node",e=>{e.target.style("opacity",1)}),console.log("[HUD-VISUALIZER-DEBUG] Cytoscape event handlers set up successfully")):console.warn("[HUD-VISUALIZER-DEBUG] Cannot setup Cytoscape event handlers: no cy instance")}setupResizeHandler(){const e=new ResizeObserver(()=>{this.cy&&this.isActive&&this.ensureContainerResize()});this.container&&e.observe(this.container)}ensureContainerResize(){if(!this.cy||!this.container)return void console.log("[HUD-VISUALIZER-DEBUG] Cannot resize: missing cy or container");this.ensureContainerInteractivity();const e=this.container.getBoundingClientRect();if(console.log("[HUD-VISUALIZER-DEBUG] Container dimensions:",{width:e.width,height:e.height,offsetWidth:this.container.offsetWidth,offsetHeight:this.container.offsetHeight,isVisible:e.width>0&&e.height>0}),e.width>0&&e.height>0){console.log("[HUD-VISUALIZER-DEBUG] Container is visible, resizing Cytoscape...");try{this.cy.resize();const e=this.cy.nodes().length,t=this.cy.edges().length;console.log("[HUD-VISUALIZER-DEBUG] Cytoscape elements after resize:",{nodes:e,edges:t}),e>0?(console.log("[HUD-VISUALIZER-DEBUG] Running fit and layout..."),this.cy.fit(),this.runLayout()):console.log("[HUD-VISUALIZER-DEBUG] No nodes to display")}catch(t){console.error("[HUD-VISUALIZER-DEBUG] Error during resize:",t)}}else console.log("[HUD-VISUALIZER-DEBUG] Container not visible yet, skipping resize")}ensureContainerInteractivity(){if(!this.container)return;this.container.style.pointerEvents="auto",this.container.style.cursor="default",this.container.style.userSelect="none",this.container.style.touchAction="manipulation";const e=this.container.parentElement;e&&(e.style.pointerEvents="auto",e.style.position="relative"),console.log("[HUD-VISUALIZER-DEBUG] Container interactivity ensured")}async activate(){console.log("[HUD-VISUALIZER-DEBUG] activate() called"),this.isActive=!0;try{console.log("[HUD-VISUALIZER-DEBUG] Loading libraries and initializing..."),await this.loadLibrariesAndInitialize(),console.log("[HUD-VISUALIZER-DEBUG] Libraries loaded, cy exists:",!!this.cy),this.cy||(console.log("[HUD-VISUALIZER-DEBUG] Cytoscape instance missing, recreating..."),this.initializeCytoscape(),this.setupCytoscapeEventHandlers()),this.cy&&(console.log("[HUD-VISUALIZER-DEBUG] Triggering resize and fit..."),setTimeout(()=>{console.log("[HUD-VISUALIZER-DEBUG] First resize attempt..."),this.ensureContainerResize()},50),setTimeout(()=>{console.log("[HUD-VISUALIZER-DEBUG] Second resize attempt..."),this.ensureContainerResize()},200),setTimeout(()=>{console.log("[HUD-VISUALIZER-DEBUG] Final resize attempt..."),this.ensureContainerResize()},500)),console.log("[HUD-VISUALIZER-DEBUG] activate() completed successfully")}catch(e){throw console.error("[HUD-VISUALIZER-DEBUG] Failed to activate HUD:",e),console.error("[HUD-VISUALIZER-DEBUG] Error stack:",e.stack),e}}deactivate(){this.isActive=!1}processPendingEvents(){if(this.pendingEvents.length>0){console.log(`Processing ${this.pendingEvents.length} pending events`);for(const e of this.pendingEvents)this._processEventInternal(e);this.pendingEvents=[]}}processExistingEvents(e){if(console.log(`[HUD-VISUALIZER-DEBUG] processExistingEvents called with ${e?e.length:0} events`),!e)return void console.error("[HUD-VISUALIZER-DEBUG] No events provided to processExistingEvents");if(!Array.isArray(e))return void console.error("[HUD-VISUALIZER-DEBUG] Events is not an array:",typeof e);if(console.log(`[HUD-VISUALIZER-DEBUG] Libraries loaded: ${this.librariesLoaded}, Cytoscape available: ${!!this.cy}`),!this.librariesLoaded||!this.cy)return console.warn("[HUD-VISUALIZER-DEBUG] HUD libraries not loaded, cannot process existing events"),console.log(`[HUD-VISUALIZER-DEBUG] Storing ${e.length} events as pending`),void(this.pendingEvents=[...e]);console.log(`[HUD-VISUALIZER-DEBUG] 🏗️ Building HUD tree structure from ${e.length} historical events`),e.length>0&&(console.log("[HUD-VISUALIZER-DEBUG] Sample events:"),e.slice(0,3).forEach((e,t)=>{console.log(`[HUD-VISUALIZER-DEBUG]   Event ${t+1}:`,{timestamp:e.timestamp,hook_event_name:e.hook_event_name,type:e.type,subtype:e.subtype,session_id:e.session_id,data_session_id:e.data?.session_id,data_keys:e.data?Object.keys(e.data):"no data"})})),this.clear();const t=this.groupEventsBySession(e);Object.entries(t).forEach(([e,t])=>{console.log(`  📂 Processing session ${e}: ${t.length} events`),this.buildSessionTree(e,t)}),this.runLayout(),console.log("✅ HUD tree structure built successfully")}groupEventsBySession(e){const t={};return e.forEach(e=>{const o=e.session_id||e.data?.session_id||"unknown";t[o]||(t[o]=[]),t[o].push(e)}),t}buildSessionTree(e,t){console.log(`[HUD-VISUALIZER-DEBUG] Building session tree for ${e} with ${t.length} events`);const o=new Map;let n=null;const s=t.sort((e,t)=>new Date(e.timestamp).getTime()-new Date(t.timestamp).getTime());console.log(`[HUD-VISUALIZER-DEBUG] Sorted ${s.length} events chronologically`),s.forEach((t,s)=>{const i=this.createNodeFromEvent(t,e);i&&(this.addNode(i.id,i.type,i.label,{sessionId:e,timestamp:t.timestamp,eventData:t,isSessionRoot:i.isSessionRoot}),o.set(i.id,{...i,event:t,index:s}),i.isSessionRoot&&!n&&(n=i.id),this.createHierarchicalRelationships(i.id,t,o,n))})}createNodeFromEvent(e,t){const o=e.hook_event_name||e.type||"",n=e.subtype||"",s=new Date(e.timestamp||Date.now());console.log(`[HUD-VISUALIZER-DEBUG] Creating node from event: ${o}/${n} for session ${t}`);let i,r,a,l=!1;const c=s.getTime(),d=Math.random().toString(36).substring(2,7);if("session"===o&&"started"===n)r="PM",a=`Session ${t.substring(0,8)}...`,i=`session-${t.replace(/[^a-zA-Z0-9]/g,"")}`,l=!0;else if("hook"===o&&"user_prompt"===n){r="PM";const t=e.data?.prompt_preview||"User Prompt";a=t.length>20?t.substring(0,20)+"...":t,i=`user-prompt-${c}-${d}`}else if("hook"===o&&"claude_response"===n)r="PM",a="Claude Response",i=`claude-response-${c}-${d}`;else if("hook"===o&&"pre_tool"===n){r="TOOL";const t=e.data?.tool_name||"Unknown Tool",o=t.replace(/[^a-zA-Z0-9]/g,"");a=`${t}`,i=`tool-${o}-${c}-${d}`}else if("agent"===o||e.data?.agent_type){r="AGENT";const t=e.data?.agent_type||e.data?.agent_name||"Agent",o=t.replace(/[^a-zA-Z0-9]/g,"");a=t,i=`agent-${o}-${c}-${d}`}else if("todo"===o||n.includes("todo"))r="TODO",a="Todo Update",i=`todo-${c}-${d}`;else{if("hook"===o&&"notification"===n)return null;if("log"===o){const t=e.data?.level||"info";if(!["error","critical"].includes(t))return null;r="PM",a=`${t.toUpperCase()} Log`,i=`log-${t}-${c}-${d}`}else{r="PM";const e=o.replace(/[^a-zA-Z0-9]/g,"")||"Event";a=o||"Event",i=`generic-${e}-${c}-${d}`}}return{id:i,type:r,label:a,isSessionRoot:l}}createHierarchicalRelationships(e,t,o,n){const s=t.hook_event_name||t.type||"",i=t.subtype||"";let r=null;"session"===s&&"started"===i||(r="hook"===s&&"pre_tool"===i?this.findRecentParentNode(o,["user-prompt","agent"],e):"hook"===s&&"claude_response"===i?this.findRecentParentNode(o,["user-prompt"],e):"agent"===s?this.findRecentParentNode(o,["user-prompt","agent"],e):"todo"===s?this.findRecentParentNode(o,["agent","user-prompt"],e):this.findRecentParentNode(o,["user-prompt","agent","session"],e),!r&&n&&e!==n&&(r=n),r&&r!==e&&this.addEdge(r,e))}findRecentParentNode(e,t,o){const n=Array.from(e.entries()).reverse();for(const[s,i]of n)if(s!==o)for(const e of t)if(s.startsWith(e))return s;return null}processEvent(e){this.isActive&&(this.librariesLoaded&&this.cy?this._processEventInternal(e):this.pendingEvents.push(e))}_processEventInternal(e){const t=e.hook_event_name||e.type||"",o=e.session_id||"unknown",n=new Date(e.timestamp||Date.now());let s=`${t}-${n.getTime()}`,i="PM",r=t;if(t.includes("tool_call")){i="TOOL";const t=e.data?.tool_name||"Unknown Tool";r=t,s=`tool-${t}-${n.getTime()}`}else if(t.includes("agent")){i="AGENT";const t=e.data?.agent_name||"Agent";r=t,s=`agent-${t}-${n.getTime()}`}else t.includes("todo")?(i="TODO",r="Todo List",s=`todo-${n.getTime()}`):(t.includes("user_prompt")||t.includes("claude_response"))&&(i="PM",r=t.includes("user_prompt")?"User Prompt":"Claude Response",s=`pm-${r.replace(" ","")}-${n.getTime()}`);this.addNode(s,i,r,{sessionId:o,timestamp:n.toISOString(),eventData:e}),this.createEventRelationships(s,e)}addNode(e,t,o,n={}){if(console.log(`[HUD-VISUALIZER-DEBUG] Adding node: ${e} (${t}) - ${o}`),this.nodes.has(e))return void console.log(`[HUD-VISUALIZER-DEBUG] Node ${e} already exists, skipping`);const s=this.nodeTypes[t]||this.nodeTypes.PM,i={id:e,label:`${s.icon} ${o}`,type:t,color:s.color,borderColor:this.darkenColor(s.color,20),shape:s.shape,width:s.width,height:s.height,...n};if(this.nodes.set(e,i),this.cy){const e={group:"nodes",data:i,classes:`${t.toLowerCase()}-node`};console.log("[HUD-VISUALIZER-DEBUG] Adding node element to Cytoscape:",e),this.cy.add(e),console.log(`[HUD-VISUALIZER-DEBUG] Node added successfully. Total nodes in cy: ${this.cy.nodes().length}`),this.runLayout()}}addEdge(e,t,o=null,n={}){if(e&&t)if(e!==t){if(o||(o=`edge-${e}-to-${t}`),this.cy){if(this.cy.getElementById(o).length>0)return void console.log(`[HUD-VISUALIZER-DEBUG] Edge ${o} already exists, skipping`);const i=this.cy.getElementById(e),r=this.cy.getElementById(t);if(0===i.length)return void console.warn(`[HUD-VISUALIZER-DEBUG] Source node ${e} does not exist, cannot create edge`);if(0===r.length)return void console.warn(`[HUD-VISUALIZER-DEBUG] Target node ${t} does not exist, cannot create edge`);const a={group:"edges",data:{id:o,source:e,target:t,...n}};console.log("[HUD-VISUALIZER-DEBUG] Adding edge element to Cytoscape:",a);try{this.cy.add(a),console.log(`[HUD-VISUALIZER-DEBUG] Edge added successfully. Total edges in cy: ${this.cy.edges().length}`),this.runLayout()}catch(s){console.error(`[HUD-VISUALIZER-DEBUG] Failed to add edge ${o}:`,s),console.error("[HUD-VISUALIZER-DEBUG] Element details:",a)}}}else console.warn(`[HUD-VISUALIZER-DEBUG] Cannot create self-loop edge from ${e} to itself`);else console.warn(`[HUD-VISUALIZER-DEBUG] Cannot create edge: missing source (${e}) or target (${t})`)}createEventRelationships(e,t){const o=t.hook_event_name||t.type||"",n=t.session_id||"unknown";if(Array.from(this.nodes.entries()),o.includes("tool_call")&&t.data?.tool_name){const t=this.findParentNode(n,["PM","AGENT"]);if(t)return void this.addEdge(t,e)}if(o.includes("agent")||t.data?.agent_name){const t=this.findParentNode(n,["PM"]);if(t)return void this.addEdge(t,e)}if(o.includes("todo")){const t=this.findParentNode(n,["AGENT","PM"]);if(t)return void this.addEdge(t,e)}const s=Array.from(this.nodes.keys()),i=s.indexOf(e);if(i>0){const t=s[i-1];this.addEdge(t,e)}}findParentNode(e,t){const o=Array.from(this.nodes.entries()).reverse();for(const[n,s]of o)if(s.sessionId===e&&t.includes(s.type))return n;return null}highlightConnectedNodes(e){if(!this.cy)return;this.cy.nodes().style({opacity:.3}),this.cy.edges().style({opacity:.2});const t=e.neighborhood();e.style("opacity",1),t.style("opacity",1)}resetLayout(){this.cy&&this.cy.layout(this.layoutConfig).run()}centerView(){this.cy&&(this.cy.fit(),this.cy.center())}runLayout(){if(console.log(`[HUD-VISUALIZER-DEBUG] runLayout called - isActive: ${this.isActive}, cy exists: ${!!this.cy}`),this.cy&&this.isActive){const e=this.cy.nodes().length,t=this.cy.edges().length;if(console.log(`[HUD-VISUALIZER-DEBUG] Running layout with ${e} nodes and ${t} edges`),this.container){const e=this.container.getBoundingClientRect();console.log("[HUD-VISUALIZER-DEBUG] Container dimensions before layout:",{width:e.width,height:e.height,offsetWidth:this.container.offsetWidth,offsetHeight:this.container.offsetHeight})}const o=this.cy.layout(this.layoutConfig);o.on("layoutstop",()=>{console.log("[HUD-VISUALIZER-DEBUG] Layout completed. Final node positions:"),this.cy.nodes().forEach((e,t)=>{const o=e.position(),n=e.data();console.log(`[HUD-VISUALIZER-DEBUG]   Node ${t+1}: ${n.label} at (${o.x.toFixed(1)}, ${o.y.toFixed(1)})`)})}),o.run()}else console.log("[HUD-VISUALIZER-DEBUG] Skipping layout - not active or no Cytoscape instance")}clear(){if(console.log(`[HUD-VISUALIZER-DEBUG] Clearing HUD: ${this.nodes.size} nodes, ${this.pendingEvents.length} pending events`),this.nodes.clear(),this.pendingEvents=[],this.cy){const o=this.cy.elements().length;try{this.cy.elements().remove(),console.log(`[HUD-VISUALIZER-DEBUG] Removed ${o} Cytoscape elements`)}catch(e){console.error("[HUD-VISUALIZER-DEBUG] Error clearing Cytoscape elements:",e);try{this.cy.destroy(),this.cy=null,console.log("[HUD-VISUALIZER-DEBUG] Destroyed Cytoscape instance due to clear error")}catch(t){console.error("[HUD-VISUALIZER-DEBUG] Error destroying Cytoscape:",t)}}}}showLoadingIndicator(){this.container&&(this.container.innerHTML='\n                <div class="hud-loading-container">\n                    <div class="hud-loading-spinner"></div>\n                    <div class="hud-loading-text">Loading HUD visualization libraries...</div>\n                    <div class="hud-loading-progress" id="hud-loading-progress"></div>\n                </div>\n            ')}updateLoadingProgress(e){const t=document.getElementById("hud-loading-progress");t&&(e.error?t.innerHTML=`<span class="hud-error">❌ ${e.message}</span>`:t.innerHTML=`\n                    <div class="hud-progress-bar">\n                        <div class="hud-progress-fill" style="width: ${e.current/e.total*100}%"></div>\n                    </div>\n                    <div class="hud-progress-text">${e.message} (${e.current}/${e.total})</div>\n                `)}hideLoadingIndicator(){this.container&&(this.container.innerHTML="")}showLoadingError(e){this.container&&(this.container.innerHTML=`\n                <div class="hud-error-container">\n                    <div class="hud-error-icon">⚠️</div>\n                    <div class="hud-error-text">Failed to load HUD libraries</div>\n                    <div class="hud-error-message">${e}</div>\n                    <button class="hud-retry-button" onclick="window.hudVisualizer && window.hudVisualizer.retryLoading()">\n                        Retry Loading\n                    </button>\n                </div>\n            `)}retryLoading(){this.librariesLoaded=!1,this.loadingPromise=null,this.activate()}debugTest(){return console.log("[HUD-VISUALIZER-DEBUG] debugTest() called manually"),console.log("[HUD-VISUALIZER-DEBUG] Current state:",{isActive:this.isActive,librariesLoaded:this.librariesLoaded,hasCy:!!this.cy,hasContainer:!!this.container,nodeCount:this.nodes.size,pendingEventCount:this.pendingEvents.length,hasHUDLibraryLoader:!!window.HUDLibraryLoader}),this.container&&console.log("[HUD-VISUALIZER-DEBUG] Container info:",{id:this.container.id,className:this.container.className,offsetWidth:this.container.offsetWidth,offsetHeight:this.container.offsetHeight,innerHTML:this.container.innerHTML?"has content":"empty"}),console.log("[HUD-VISUALIZER-DEBUG] Library availability:",{cytoscape:typeof window.cytoscape,dagre:typeof window.dagre,cytoscapeDagre:typeof window.cytoscapeDagre,HUDLibraryLoader:typeof window.HUDLibraryLoader}),{isActive:this.isActive,librariesLoaded:this.librariesLoaded,hasCy:!!this.cy,containerFound:!!this.container}}debugBlankScreen(){console.log("[HUD-BLANK-SCREEN-DEBUG] ================================="),console.log("[HUD-BLANK-SCREEN-DEBUG] COMPREHENSIVE BLANK SCREEN DEBUG"),console.log("[HUD-BLANK-SCREEN-DEBUG] =================================");const e={isActive:this.isActive,librariesLoaded:this.librariesLoaded,hasCy:!!this.cy,hasContainer:!!this.container,nodeCount:this.nodes.size,cytoscapeElementCount:this.cy?this.cy.elements().length:0};if(console.log("[HUD-BLANK-SCREEN-DEBUG] 1. Basic State:",e),!this.container)return console.error("[HUD-BLANK-SCREEN-DEBUG] 2. Container not found!"),!1;{const e=this.getContainerDebugInfo();console.log("[HUD-BLANK-SCREEN-DEBUG] 2. Container Info:",e),this.debugAddContainerBackground()}if(!this.cy)return console.error("[HUD-BLANK-SCREEN-DEBUG] 3. Cytoscape instance not found!"),!1;{const e=this.getCytoscapeDebugInfo();console.log("[HUD-BLANK-SCREEN-DEBUG] 3. Cytoscape Info:",e)}return this.debugNodePositions(),this.debugManualRenderingTriggers(),this.cy&&0===this.cy.nodes().length&&(console.log("[HUD-BLANK-SCREEN-DEBUG] 6. No nodes found, adding test nodes..."),this.debugAddTestNodes()),this.debugForceZoomFit(),console.log("[HUD-BLANK-SCREEN-DEBUG] Debug complete. Check visual results."),!0}getContainerDebugInfo(){const e=this.container.getBoundingClientRect(),t=window.getComputedStyle(this.container);return{id:this.container.id,className:this.container.className,offsetWidth:this.container.offsetWidth,offsetHeight:this.container.offsetHeight,clientWidth:this.container.clientWidth,clientHeight:this.container.clientHeight,scrollWidth:this.container.scrollWidth,scrollHeight:this.container.scrollHeight,boundingRect:{width:e.width,height:e.height,top:e.top,left:e.left,bottom:e.bottom,right:e.right},computedStyles:{display:t.display,visibility:t.visibility,opacity:t.opacity,position:t.position,overflow:t.overflow,zIndex:t.zIndex,backgroundColor:t.backgroundColor,transform:t.transform},isVisible:e.width>0&&e.height>0&&"none"!==t.display&&"hidden"!==t.visibility,parentElement:this.container.parentElement?{tagName:this.container.parentElement.tagName,className:this.container.parentElement.className,offsetWidth:this.container.parentElement.offsetWidth,offsetHeight:this.container.parentElement.offsetHeight}:null}}getCytoscapeDebugInfo(){const e=this.cy.extent(),t=this.cy.zoom(),o=this.cy.pan(),n=this.cy.viewport();return{nodeCount:this.cy.nodes().length,edgeCount:this.cy.edges().length,elementCount:this.cy.elements().length,zoom:t,pan:o,extent:e,viewport:n,containerWidth:this.cy.width(),containerHeight:this.cy.height(),isInitialized:void 0!==this.cy.scratch("_cytoscape-initialized"),renderer:this.cy.renderer()?{name:this.cy.renderer().name,options:this.cy.renderer().options}:null}}debugNodePositions(){if(!this.cy||0===this.cy.nodes().length)return void console.log("[HUD-BLANK-SCREEN-DEBUG] 4. No nodes to check positions");console.log("[HUD-BLANK-SCREEN-DEBUG] 4. Node Positions:");const e=this.cy.nodes(),t=this.cy.extent(),o=this.cy.viewport();console.log("[HUD-BLANK-SCREEN-DEBUG]   Viewport extent:",t),console.log("[HUD-BLANK-SCREEN-DEBUG]   Current viewport:",o),e.forEach((e,t)=>{const o=e.position(),n=e.data(),s=e.boundingBox();console.log(`[HUD-BLANK-SCREEN-DEBUG]   Node ${t+1}:`,{id:n.id,label:n.label,position:o,boundingBox:s,isVisible:e.visible(),opacity:e.style("opacity"),width:e.style("width"),height:e.style("height")})})}debugAddContainerBackground(){this.container&&(this.container.style.backgroundColor="#ff000020",this.container.style.border="2px solid #ff0000",this.container.style.minHeight="400px",console.log("[HUD-BLANK-SCREEN-DEBUG] Added red background and border to container for visibility test"))}debugManualRenderingTriggers(){if(this.cy){console.log("[HUD-BLANK-SCREEN-DEBUG] 5. Triggering manual rendering operations...");try{console.log("[HUD-BLANK-SCREEN-DEBUG]   - Forcing resize..."),this.cy.resize(),console.log("[HUD-BLANK-SCREEN-DEBUG]   - Forcing redraw..."),this.cy.forceRender(),this.cy.nodes().length>0&&(console.log("[HUD-BLANK-SCREEN-DEBUG]   - Running layout..."),this.cy.layout(this.layoutConfig).run()),console.log("[HUD-BLANK-SCREEN-DEBUG]   - Updating viewport..."),this.cy.viewport({zoom:this.cy.zoom(),pan:this.cy.pan()}),console.log("[HUD-BLANK-SCREEN-DEBUG]   Manual rendering triggers completed")}catch(e){console.error("[HUD-BLANK-SCREEN-DEBUG]   Error during manual rendering:",e)}}else console.log("[HUD-BLANK-SCREEN-DEBUG] 5. No Cytoscape instance for manual rendering")}debugAddTestNodes(){if(this.cy){console.log("[HUD-BLANK-SCREEN-DEBUG]   Adding test nodes...");try{this.cy.elements().remove();const e=[{group:"nodes",data:{id:"test-node-1",label:"🤖 Test Node 1",color:"#48bb78",borderColor:"#38a169",shape:"rectangle",width:120,height:40},classes:"pm-node"},{group:"nodes",data:{id:"test-node-2",label:"🔧 Test Node 2",color:"#4299e1",borderColor:"#3182ce",shape:"diamond",width:80,height:50},classes:"tool-node"},{group:"nodes",data:{id:"test-node-3",label:"📝 Test Node 3",color:"#e53e3e",borderColor:"#c53030",shape:"triangle",width:70,height:40},classes:"todo-node"}],t=[{group:"edges",data:{id:"test-edge-1",source:"test-node-1",target:"test-node-2"}},{group:"edges",data:{id:"test-edge-2",source:"test-node-2",target:"test-node-3"}}];this.cy.add(e),this.cy.add(t),console.log("[HUD-BLANK-SCREEN-DEBUG]   Added 3 test nodes and 2 test edges"),e.forEach(e=>{this.nodes.set(e.data.id,e.data)}),this.runLayout()}catch(e){console.error("[HUD-BLANK-SCREEN-DEBUG]   Error adding test nodes:",e)}}}debugForceZoomFit(){if(!this.cy)return;console.log("[HUD-BLANK-SCREEN-DEBUG] 7. Forcing zoom fit...");const e=e=>{try{console.log(`[HUD-BLANK-SCREEN-DEBUG]   Zoom fit attempt ${e}...`);const t=this.cy.zoom(),o=this.cy.pan(),n=this.cy.elements();if(console.log("[HUD-BLANK-SCREEN-DEBUG]   Before fit:",{zoom:t,pan:o,elementCount:n.length}),n.length>0){this.cy.fit(n,50);const e=this.cy.zoom(),s=this.cy.pan();console.log("[HUD-BLANK-SCREEN-DEBUG]   After fit:",{zoom:e,pan:s,changed:t!==e||o.x!==s.x||o.y!==s.y}),this.cy.center(n)}else console.log("[HUD-BLANK-SCREEN-DEBUG]   No elements to fit")}catch(t){console.error(`[HUD-BLANK-SCREEN-DEBUG]   Zoom fit attempt ${e} failed:`,t)}};e(1),setTimeout(()=>e(2),100),setTimeout(()=>e(3),500),setTimeout(()=>e(4),1e3)}debugDrawSimpleShape(){if(!this.cy)return console.log("[HUD-CANVAS-TEST] No Cytoscape instance"),!1;console.log("[HUD-CANVAS-TEST] Testing Cytoscape canvas rendering...");try{return this.cy.elements().remove(),this.cy.add({group:"nodes",data:{id:"canvas-test",label:"✅ CANVAS TEST",color:"#ff0000",borderColor:"#000000",width:200,height:100,shape:"rectangle"},position:{x:200,y:200}}),this.cy.forceRender(),this.cy.fit(this.cy.$("#canvas-test"),50),console.log("[HUD-CANVAS-TEST] Canvas test node added and positioned"),console.log('[HUD-CANVAS-TEST] If you see a red rectangle with "CANVAS TEST", rendering works!'),!0}catch(e){return console.error("[HUD-CANVAS-TEST] Canvas test failed:",e),!1}}darkenColor(e,t){const o=parseInt(e.replace("#",""),16),n=Math.round(2.55*t),s=(o>>16)-n,i=(o>>8&255)-n,r=(255&o)-n;return"#"+(16777216+65536*(s<255?s<1?0:s:255)+256*(i<255?i<1?0:i:255)+(r<255?r<1?0:r:255)).toString(16).slice(1)}};
//# sourceMappingURL=hud-manager.js.map
