# coding: utf-8

"""
    SnapTrade

    Connect brokerage accounts to your app for live positions and trading

    The version of the OpenAPI document: 1.0.0
    Contact: api@snaptrade.com
    Created by: https://snaptrade.com/
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from snaptrade_client import schemas  # noqa: F401


class CryptoOrderForm(
    schemas.DictSchema
):
    """
    This class is auto generated by Konfig (https://konfigthis.com)
    """


    class MetaOapg:
        required = {
            "amount",
            "side",
            "time_in_force",
            "instrument",
            "type",
        }
        
        class properties:
        
            @staticmethod
            def instrument() -> typing.Type['CryptoTradingInstrument']:
                return CryptoTradingInstrument
        
            @staticmethod
            def side() -> typing.Type['ActionStrict']:
                return ActionStrict
            
            
            class type(
                schemas.EnumBase,
                schemas.StrSchema
            ):
                
                @schemas.classproperty
                def MARKET(cls):
                    return cls("MARKET")
                
                @schemas.classproperty
                def LIMIT(cls):
                    return cls("LIMIT")
                
                @schemas.classproperty
                def STOP_LOSS_MARKET(cls):
                    return cls("STOP_LOSS_MARKET")
                
                @schemas.classproperty
                def STOP_LOSS_LIMIT(cls):
                    return cls("STOP_LOSS_LIMIT")
                
                @schemas.classproperty
                def TAKE_PROFIT_MARKET(cls):
                    return cls("TAKE_PROFIT_MARKET")
                
                @schemas.classproperty
                def TAKE_PROFIT_LIMIT(cls):
                    return cls("TAKE_PROFIT_LIMIT")
            
            
            class time_in_force(
                schemas.EnumBase,
                schemas.StrSchema
            ):
                
                @schemas.classproperty
                def GTC(cls):
                    return cls("GTC")
                
                @schemas.classproperty
                def FOK(cls):
                    return cls("FOK")
                
                @schemas.classproperty
                def IOC(cls):
                    return cls("IOC")
                
                @schemas.classproperty
                def GTD(cls):
                    return cls("GTD")
            amount = schemas.StrSchema
            limit_price = schemas.StrSchema
            stop_price = schemas.StrSchema
            post_only = schemas.BoolSchema
            expiration_date = schemas.DateTimeSchema
            __annotations__ = {
                "instrument": instrument,
                "side": side,
                "type": type,
                "time_in_force": time_in_force,
                "amount": amount,
                "limit_price": limit_price,
                "stop_price": stop_price,
                "post_only": post_only,
                "expiration_date": expiration_date,
            }
    
    amount: MetaOapg.properties.amount
    side: 'ActionStrict'
    time_in_force: MetaOapg.properties.time_in_force
    instrument: 'CryptoTradingInstrument'
    type: MetaOapg.properties.type
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["instrument"]) -> 'CryptoTradingInstrument': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["side"]) -> 'ActionStrict': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["type"]) -> MetaOapg.properties.type: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["time_in_force"]) -> MetaOapg.properties.time_in_force: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["amount"]) -> MetaOapg.properties.amount: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["limit_price"]) -> MetaOapg.properties.limit_price: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["stop_price"]) -> MetaOapg.properties.stop_price: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["post_only"]) -> MetaOapg.properties.post_only: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["expiration_date"]) -> MetaOapg.properties.expiration_date: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["instrument", "side", "type", "time_in_force", "amount", "limit_price", "stop_price", "post_only", "expiration_date", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["instrument"]) -> 'CryptoTradingInstrument': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["side"]) -> 'ActionStrict': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["type"]) -> MetaOapg.properties.type: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["time_in_force"]) -> MetaOapg.properties.time_in_force: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["amount"]) -> MetaOapg.properties.amount: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["limit_price"]) -> typing.Union[MetaOapg.properties.limit_price, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["stop_price"]) -> typing.Union[MetaOapg.properties.stop_price, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["post_only"]) -> typing.Union[MetaOapg.properties.post_only, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["expiration_date"]) -> typing.Union[MetaOapg.properties.expiration_date, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["instrument", "side", "type", "time_in_force", "amount", "limit_price", "stop_price", "post_only", "expiration_date", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        amount: typing.Union[MetaOapg.properties.amount, str, ],
        side: 'ActionStrict',
        time_in_force: typing.Union[MetaOapg.properties.time_in_force, str, ],
        instrument: 'CryptoTradingInstrument',
        type: typing.Union[MetaOapg.properties.type, str, ],
        limit_price: typing.Union[MetaOapg.properties.limit_price, str, schemas.Unset] = schemas.unset,
        stop_price: typing.Union[MetaOapg.properties.stop_price, str, schemas.Unset] = schemas.unset,
        post_only: typing.Union[MetaOapg.properties.post_only, bool, schemas.Unset] = schemas.unset,
        expiration_date: typing.Union[MetaOapg.properties.expiration_date, str, datetime, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'CryptoOrderForm':
        return super().__new__(
            cls,
            *args,
            amount=amount,
            side=side,
            time_in_force=time_in_force,
            instrument=instrument,
            type=type,
            limit_price=limit_price,
            stop_price=stop_price,
            post_only=post_only,
            expiration_date=expiration_date,
            _configuration=_configuration,
            **kwargs,
        )

from snaptrade_client.model.action_strict import ActionStrict
from snaptrade_client.model.crypto_trading_instrument import CryptoTradingInstrument
