# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CiscoBfdFeatureTemplateArgs', 'CiscoBfdFeatureTemplate']

@pulumi.input_type
class CiscoBfdFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 colors: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBfdFeatureTemplateColorArgs']]]] = None,
                 default_dscp: Optional[pulumi.Input[int]] = None,
                 default_dscp_variable: Optional[pulumi.Input[str]] = None,
                 multiplier: Optional[pulumi.Input[int]] = None,
                 multiplier_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 poll_interval: Optional[pulumi.Input[int]] = None,
                 poll_interval_variable: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CiscoBfdFeatureTemplate resource.
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input['CiscoBfdFeatureTemplateColorArgs']]] colors: Set color that identifies the WAN transport tunnel
        :param pulumi.Input[int] default_dscp: Set default DSCP value for BFD packets - Range: `0`-`63` - Default value: `48`
        :param pulumi.Input[str] default_dscp_variable: Variable name
        :param pulumi.Input[int] multiplier: Set the number of polling intervals used to determine tunnel SLA class - Range: `1`-`6` - Default value: `6`
        :param pulumi.Input[str] multiplier_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[int] poll_interval: Set how often BFD polls tunnels to collect packet latency, loss, and statistics - Range: `1`-`4294967295` - Default
               value: `600000`
        :param pulumi.Input[str] poll_interval_variable: Variable name
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if colors is not None:
            pulumi.set(__self__, "colors", colors)
        if default_dscp is not None:
            pulumi.set(__self__, "default_dscp", default_dscp)
        if default_dscp_variable is not None:
            pulumi.set(__self__, "default_dscp_variable", default_dscp_variable)
        if multiplier is not None:
            pulumi.set(__self__, "multiplier", multiplier)
        if multiplier_variable is not None:
            pulumi.set(__self__, "multiplier_variable", multiplier_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if poll_interval is not None:
            pulumi.set(__self__, "poll_interval", poll_interval)
        if poll_interval_variable is not None:
            pulumi.set(__self__, "poll_interval_variable", poll_interval_variable)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter
    def colors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBfdFeatureTemplateColorArgs']]]]:
        """
        Set color that identifies the WAN transport tunnel
        """
        return pulumi.get(self, "colors")

    @colors.setter
    def colors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBfdFeatureTemplateColorArgs']]]]):
        pulumi.set(self, "colors", value)

    @property
    @pulumi.getter(name="defaultDscp")
    def default_dscp(self) -> Optional[pulumi.Input[int]]:
        """
        Set default DSCP value for BFD packets - Range: `0`-`63` - Default value: `48`
        """
        return pulumi.get(self, "default_dscp")

    @default_dscp.setter
    def default_dscp(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_dscp", value)

    @property
    @pulumi.getter(name="defaultDscpVariable")
    def default_dscp_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_dscp_variable")

    @default_dscp_variable.setter
    def default_dscp_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_dscp_variable", value)

    @property
    @pulumi.getter
    def multiplier(self) -> Optional[pulumi.Input[int]]:
        """
        Set the number of polling intervals used to determine tunnel SLA class - Range: `1`-`6` - Default value: `6`
        """
        return pulumi.get(self, "multiplier")

    @multiplier.setter
    def multiplier(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "multiplier", value)

    @property
    @pulumi.getter(name="multiplierVariable")
    def multiplier_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "multiplier_variable")

    @multiplier_variable.setter
    def multiplier_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multiplier_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pollInterval")
    def poll_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Set how often BFD polls tunnels to collect packet latency, loss, and statistics - Range: `1`-`4294967295` - Default
        value: `600000`
        """
        return pulumi.get(self, "poll_interval")

    @poll_interval.setter
    def poll_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "poll_interval", value)

    @property
    @pulumi.getter(name="pollIntervalVariable")
    def poll_interval_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "poll_interval_variable")

    @poll_interval_variable.setter
    def poll_interval_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "poll_interval_variable", value)


@pulumi.input_type
class _CiscoBfdFeatureTemplateState:
    def __init__(__self__, *,
                 colors: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBfdFeatureTemplateColorArgs']]]] = None,
                 default_dscp: Optional[pulumi.Input[int]] = None,
                 default_dscp_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 multiplier: Optional[pulumi.Input[int]] = None,
                 multiplier_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 poll_interval: Optional[pulumi.Input[int]] = None,
                 poll_interval_variable: Optional[pulumi.Input[str]] = None,
                 template_type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering CiscoBfdFeatureTemplate resources.
        :param pulumi.Input[Sequence[pulumi.Input['CiscoBfdFeatureTemplateColorArgs']]] colors: Set color that identifies the WAN transport tunnel
        :param pulumi.Input[int] default_dscp: Set default DSCP value for BFD packets - Range: `0`-`63` - Default value: `48`
        :param pulumi.Input[str] default_dscp_variable: Variable name
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[int] multiplier: Set the number of polling intervals used to determine tunnel SLA class - Range: `1`-`6` - Default value: `6`
        :param pulumi.Input[str] multiplier_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[int] poll_interval: Set how often BFD polls tunnels to collect packet latency, loss, and statistics - Range: `1`-`4294967295` - Default
               value: `600000`
        :param pulumi.Input[str] poll_interval_variable: Variable name
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[int] version: The version of the feature template
        """
        if colors is not None:
            pulumi.set(__self__, "colors", colors)
        if default_dscp is not None:
            pulumi.set(__self__, "default_dscp", default_dscp)
        if default_dscp_variable is not None:
            pulumi.set(__self__, "default_dscp_variable", default_dscp_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if multiplier is not None:
            pulumi.set(__self__, "multiplier", multiplier)
        if multiplier_variable is not None:
            pulumi.set(__self__, "multiplier_variable", multiplier_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if poll_interval is not None:
            pulumi.set(__self__, "poll_interval", poll_interval)
        if poll_interval_variable is not None:
            pulumi.set(__self__, "poll_interval_variable", poll_interval_variable)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def colors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBfdFeatureTemplateColorArgs']]]]:
        """
        Set color that identifies the WAN transport tunnel
        """
        return pulumi.get(self, "colors")

    @colors.setter
    def colors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBfdFeatureTemplateColorArgs']]]]):
        pulumi.set(self, "colors", value)

    @property
    @pulumi.getter(name="defaultDscp")
    def default_dscp(self) -> Optional[pulumi.Input[int]]:
        """
        Set default DSCP value for BFD packets - Range: `0`-`63` - Default value: `48`
        """
        return pulumi.get(self, "default_dscp")

    @default_dscp.setter
    def default_dscp(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_dscp", value)

    @property
    @pulumi.getter(name="defaultDscpVariable")
    def default_dscp_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_dscp_variable")

    @default_dscp_variable.setter
    def default_dscp_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_dscp_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter
    def multiplier(self) -> Optional[pulumi.Input[int]]:
        """
        Set the number of polling intervals used to determine tunnel SLA class - Range: `1`-`6` - Default value: `6`
        """
        return pulumi.get(self, "multiplier")

    @multiplier.setter
    def multiplier(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "multiplier", value)

    @property
    @pulumi.getter(name="multiplierVariable")
    def multiplier_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "multiplier_variable")

    @multiplier_variable.setter
    def multiplier_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multiplier_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pollInterval")
    def poll_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Set how often BFD polls tunnels to collect packet latency, loss, and statistics - Range: `1`-`4294967295` - Default
        value: `600000`
        """
        return pulumi.get(self, "poll_interval")

    @poll_interval.setter
    def poll_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "poll_interval", value)

    @property
    @pulumi.getter(name="pollIntervalVariable")
    def poll_interval_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "poll_interval_variable")

    @poll_interval_variable.setter
    def poll_interval_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "poll_interval_variable", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class CiscoBfdFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 colors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoBfdFeatureTemplateColorArgs', 'CiscoBfdFeatureTemplateColorArgsDict']]]]] = None,
                 default_dscp: Optional[pulumi.Input[int]] = None,
                 default_dscp_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 multiplier: Optional[pulumi.Input[int]] = None,
                 multiplier_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 poll_interval: Optional[pulumi.Input[int]] = None,
                 poll_interval_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a Cisco BFD feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoBfdFeatureTemplate:CiscoBfdFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoBfdFeatureTemplateColorArgs', 'CiscoBfdFeatureTemplateColorArgsDict']]]] colors: Set color that identifies the WAN transport tunnel
        :param pulumi.Input[int] default_dscp: Set default DSCP value for BFD packets - Range: `0`-`63` - Default value: `48`
        :param pulumi.Input[str] default_dscp_variable: Variable name
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[int] multiplier: Set the number of polling intervals used to determine tunnel SLA class - Range: `1`-`6` - Default value: `6`
        :param pulumi.Input[str] multiplier_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[int] poll_interval: Set how often BFD polls tunnels to collect packet latency, loss, and statistics - Range: `1`-`4294967295` - Default
               value: `600000`
        :param pulumi.Input[str] poll_interval_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CiscoBfdFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Cisco BFD feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoBfdFeatureTemplate:CiscoBfdFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CiscoBfdFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CiscoBfdFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 colors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoBfdFeatureTemplateColorArgs', 'CiscoBfdFeatureTemplateColorArgsDict']]]]] = None,
                 default_dscp: Optional[pulumi.Input[int]] = None,
                 default_dscp_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 multiplier: Optional[pulumi.Input[int]] = None,
                 multiplier_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 poll_interval: Optional[pulumi.Input[int]] = None,
                 poll_interval_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CiscoBfdFeatureTemplateArgs.__new__(CiscoBfdFeatureTemplateArgs)

            __props__.__dict__["colors"] = colors
            __props__.__dict__["default_dscp"] = default_dscp
            __props__.__dict__["default_dscp_variable"] = default_dscp_variable
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["multiplier"] = multiplier
            __props__.__dict__["multiplier_variable"] = multiplier_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["poll_interval"] = poll_interval
            __props__.__dict__["poll_interval_variable"] = poll_interval_variable
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CiscoBfdFeatureTemplate, __self__).__init__(
            'sdwan:index/ciscoBfdFeatureTemplate:CiscoBfdFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            colors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoBfdFeatureTemplateColorArgs', 'CiscoBfdFeatureTemplateColorArgsDict']]]]] = None,
            default_dscp: Optional[pulumi.Input[int]] = None,
            default_dscp_variable: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            multiplier: Optional[pulumi.Input[int]] = None,
            multiplier_variable: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            poll_interval: Optional[pulumi.Input[int]] = None,
            poll_interval_variable: Optional[pulumi.Input[str]] = None,
            template_type: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'CiscoBfdFeatureTemplate':
        """
        Get an existing CiscoBfdFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoBfdFeatureTemplateColorArgs', 'CiscoBfdFeatureTemplateColorArgsDict']]]] colors: Set color that identifies the WAN transport tunnel
        :param pulumi.Input[int] default_dscp: Set default DSCP value for BFD packets - Range: `0`-`63` - Default value: `48`
        :param pulumi.Input[str] default_dscp_variable: Variable name
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[int] multiplier: Set the number of polling intervals used to determine tunnel SLA class - Range: `1`-`6` - Default value: `6`
        :param pulumi.Input[str] multiplier_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[int] poll_interval: Set how often BFD polls tunnels to collect packet latency, loss, and statistics - Range: `1`-`4294967295` - Default
               value: `600000`
        :param pulumi.Input[str] poll_interval_variable: Variable name
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CiscoBfdFeatureTemplateState.__new__(_CiscoBfdFeatureTemplateState)

        __props__.__dict__["colors"] = colors
        __props__.__dict__["default_dscp"] = default_dscp
        __props__.__dict__["default_dscp_variable"] = default_dscp_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["multiplier"] = multiplier
        __props__.__dict__["multiplier_variable"] = multiplier_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["poll_interval"] = poll_interval
        __props__.__dict__["poll_interval_variable"] = poll_interval_variable
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["version"] = version
        return CiscoBfdFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def colors(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoBfdFeatureTemplateColor']]]:
        """
        Set color that identifies the WAN transport tunnel
        """
        return pulumi.get(self, "colors")

    @property
    @pulumi.getter(name="defaultDscp")
    def default_dscp(self) -> pulumi.Output[Optional[int]]:
        """
        Set default DSCP value for BFD packets - Range: `0`-`63` - Default value: `48`
        """
        return pulumi.get(self, "default_dscp")

    @property
    @pulumi.getter(name="defaultDscpVariable")
    def default_dscp_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_dscp_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter
    def multiplier(self) -> pulumi.Output[Optional[int]]:
        """
        Set the number of polling intervals used to determine tunnel SLA class - Range: `1`-`6` - Default value: `6`
        """
        return pulumi.get(self, "multiplier")

    @property
    @pulumi.getter(name="multiplierVariable")
    def multiplier_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "multiplier_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pollInterval")
    def poll_interval(self) -> pulumi.Output[Optional[int]]:
        """
        Set how often BFD polls tunnels to collect packet latency, loss, and statistics - Range: `1`-`4294967295` - Default
        value: `600000`
        """
        return pulumi.get(self, "poll_interval")

    @property
    @pulumi.getter(name="pollIntervalVariable")
    def poll_interval_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "poll_interval_variable")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

