# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PolicerPolicyObjectArgs', 'PolicerPolicyObject']

@pulumi.input_type
class PolicerPolicyObjectArgs:
    def __init__(__self__, *,
                 burst: pulumi.Input[int],
                 exceed_action: pulumi.Input[str],
                 rate: pulumi.Input[int],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a PolicerPolicyObject resource.
        :param pulumi.Input[int] burst: Burst in bytes - Range: `15000`-`10000000`
        :param pulumi.Input[str] exceed_action: Exceed action - Choices: `drop`, `remark`
        :param pulumi.Input[int] rate: Rate in bps - Range: `8`-`100000000000`
        :param pulumi.Input[str] name: The name of the policy object
        """
        pulumi.set(__self__, "burst", burst)
        pulumi.set(__self__, "exceed_action", exceed_action)
        pulumi.set(__self__, "rate", rate)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def burst(self) -> pulumi.Input[int]:
        """
        Burst in bytes - Range: `15000`-`10000000`
        """
        return pulumi.get(self, "burst")

    @burst.setter
    def burst(self, value: pulumi.Input[int]):
        pulumi.set(self, "burst", value)

    @property
    @pulumi.getter(name="exceedAction")
    def exceed_action(self) -> pulumi.Input[str]:
        """
        Exceed action - Choices: `drop`, `remark`
        """
        return pulumi.get(self, "exceed_action")

    @exceed_action.setter
    def exceed_action(self, value: pulumi.Input[str]):
        pulumi.set(self, "exceed_action", value)

    @property
    @pulumi.getter
    def rate(self) -> pulumi.Input[int]:
        """
        Rate in bps - Range: `8`-`100000000000`
        """
        return pulumi.get(self, "rate")

    @rate.setter
    def rate(self, value: pulumi.Input[int]):
        pulumi.set(self, "rate", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the policy object
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _PolicerPolicyObjectState:
    def __init__(__self__, *,
                 burst: Optional[pulumi.Input[int]] = None,
                 exceed_action: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rate: Optional[pulumi.Input[int]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering PolicerPolicyObject resources.
        :param pulumi.Input[int] burst: Burst in bytes - Range: `15000`-`10000000`
        :param pulumi.Input[str] exceed_action: Exceed action - Choices: `drop`, `remark`
        :param pulumi.Input[str] name: The name of the policy object
        :param pulumi.Input[int] rate: Rate in bps - Range: `8`-`100000000000`
        :param pulumi.Input[int] version: The version of the object
        """
        if burst is not None:
            pulumi.set(__self__, "burst", burst)
        if exceed_action is not None:
            pulumi.set(__self__, "exceed_action", exceed_action)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rate is not None:
            pulumi.set(__self__, "rate", rate)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def burst(self) -> Optional[pulumi.Input[int]]:
        """
        Burst in bytes - Range: `15000`-`10000000`
        """
        return pulumi.get(self, "burst")

    @burst.setter
    def burst(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "burst", value)

    @property
    @pulumi.getter(name="exceedAction")
    def exceed_action(self) -> Optional[pulumi.Input[str]]:
        """
        Exceed action - Choices: `drop`, `remark`
        """
        return pulumi.get(self, "exceed_action")

    @exceed_action.setter
    def exceed_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exceed_action", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the policy object
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def rate(self) -> Optional[pulumi.Input[int]]:
        """
        Rate in bps - Range: `8`-`100000000000`
        """
        return pulumi.get(self, "rate")

    @rate.setter
    def rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rate", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class PolicerPolicyObject(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 burst: Optional[pulumi.Input[int]] = None,
                 exceed_action: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rate: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        This resource can manage a Policer Policy Object .

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.PolicerPolicyObject("example",
            name="Example",
            burst=100000,
            exceed_action="remark",
            rate=100)
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/policerPolicyObject:PolicerPolicyObject example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] burst: Burst in bytes - Range: `15000`-`10000000`
        :param pulumi.Input[str] exceed_action: Exceed action - Choices: `drop`, `remark`
        :param pulumi.Input[str] name: The name of the policy object
        :param pulumi.Input[int] rate: Rate in bps - Range: `8`-`100000000000`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicerPolicyObjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Policer Policy Object .

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.PolicerPolicyObject("example",
            name="Example",
            burst=100000,
            exceed_action="remark",
            rate=100)
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/policerPolicyObject:PolicerPolicyObject example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param PolicerPolicyObjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicerPolicyObjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 burst: Optional[pulumi.Input[int]] = None,
                 exceed_action: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rate: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicerPolicyObjectArgs.__new__(PolicerPolicyObjectArgs)

            if burst is None and not opts.urn:
                raise TypeError("Missing required property 'burst'")
            __props__.__dict__["burst"] = burst
            if exceed_action is None and not opts.urn:
                raise TypeError("Missing required property 'exceed_action'")
            __props__.__dict__["exceed_action"] = exceed_action
            __props__.__dict__["name"] = name
            if rate is None and not opts.urn:
                raise TypeError("Missing required property 'rate'")
            __props__.__dict__["rate"] = rate
            __props__.__dict__["version"] = None
        super(PolicerPolicyObject, __self__).__init__(
            'sdwan:index/policerPolicyObject:PolicerPolicyObject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            burst: Optional[pulumi.Input[int]] = None,
            exceed_action: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            rate: Optional[pulumi.Input[int]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'PolicerPolicyObject':
        """
        Get an existing PolicerPolicyObject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] burst: Burst in bytes - Range: `15000`-`10000000`
        :param pulumi.Input[str] exceed_action: Exceed action - Choices: `drop`, `remark`
        :param pulumi.Input[str] name: The name of the policy object
        :param pulumi.Input[int] rate: Rate in bps - Range: `8`-`100000000000`
        :param pulumi.Input[int] version: The version of the object
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicerPolicyObjectState.__new__(_PolicerPolicyObjectState)

        __props__.__dict__["burst"] = burst
        __props__.__dict__["exceed_action"] = exceed_action
        __props__.__dict__["name"] = name
        __props__.__dict__["rate"] = rate
        __props__.__dict__["version"] = version
        return PolicerPolicyObject(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def burst(self) -> pulumi.Output[int]:
        """
        Burst in bytes - Range: `15000`-`10000000`
        """
        return pulumi.get(self, "burst")

    @property
    @pulumi.getter(name="exceedAction")
    def exceed_action(self) -> pulumi.Output[str]:
        """
        Exceed action - Choices: `drop`, `remark`
        """
        return pulumi.get(self, "exceed_action")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the policy object
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rate(self) -> pulumi.Output[int]:
        """
        Rate in bps - Range: `8`-`100000000000`
        """
        return pulumi.get(self, "rate")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

