/*
 * Decompiled with CFR 0.152.
 */
package com.github.kittinunf.fuel.toolbox;

import com.github.kittinunf.fuel.core.Body;
import com.github.kittinunf.fuel.core.Client;
import com.github.kittinunf.fuel.core.FuelError;
import com.github.kittinunf.fuel.core.FuelManager;
import com.github.kittinunf.fuel.core.HeaderName;
import com.github.kittinunf.fuel.core.Headers;
import com.github.kittinunf.fuel.core.Method;
import com.github.kittinunf.fuel.core.Request;
import com.github.kittinunf.fuel.core.Response;
import com.github.kittinunf.fuel.core.requests.CancellableRequestKt;
import com.github.kittinunf.fuel.core.requests.DefaultBody;
import com.github.kittinunf.fuel.toolbox.HttpClient$WhenMappings;
import com.github.kittinunf.fuel.toolbox.extensions.ForceMethodKt;
import com.github.kittinunf.fuel.util.DecodeStreamKt;
import com.github.kittinunf.fuel.util.ProgressInputStream;
import com.github.kittinunf.fuel.util.ProgressOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B-\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0019\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010#\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010$\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010%\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'H\u0002R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\r\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006)"}, d2={"Lcom/github/kittinunf/fuel/toolbox/HttpClient;", "Lcom/github/kittinunf/fuel/core/Client;", "proxy", "Ljava/net/Proxy;", "useHttpCache", "", "decodeContent", "hook", "Lcom/github/kittinunf/fuel/core/Client$Hook;", "(Ljava/net/Proxy;ZZLcom/github/kittinunf/fuel/core/Client$Hook;)V", "getDecodeContent", "()Z", "setDecodeContent", "(Z)V", "getHook", "()Lcom/github/kittinunf/fuel/core/Client$Hook;", "setHook", "(Lcom/github/kittinunf/fuel/core/Client$Hook;)V", "getUseHttpCache", "setUseHttpCache", "awaitRequest", "Lcom/github/kittinunf/fuel/core/Response;", "request", "Lcom/github/kittinunf/fuel/core/Request;", "(Lcom/github/kittinunf/fuel/core/Request;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dataStream", "Ljava/io/InputStream;", "connection", "Ljava/net/HttpURLConnection;", "doRequest", "ensureRequestActive", "", "establishConnection", "executeRequest", "retrieveResponse", "sendRequest", "setBodyIfDoOutput", "setDoOutput", "method", "Lcom/github/kittinunf/fuel/core/Method;", "Companion", "fuel"})
public final class HttpClient
implements Client {
    private final Proxy proxy;
    private boolean useHttpCache;
    private boolean decodeContent;
    @NotNull
    private Client.Hook hook;
    private static final List<String> SUPPORTED_DECODING;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Response executeRequest(@NotNull Request request2) {
        Response response2;
        Intrinsics.checkNotNullParameter(request2, "request");
        try {
            response2 = this.doRequest(request2);
        }
        catch (IOException ioe) {
            this.hook.httpExchangeFailed(request2, ioe);
            throw (Throwable)FuelError.Companion.wrap(ioe, new Response(request2.getUrl(), 0, null, null, 0L, null, 62, null));
        }
        catch (InterruptedException interrupted) {
            throw (Throwable)FuelError.Companion.wrap(interrupted, new Response(request2.getUrl(), 0, null, null, 0L, null, 62, null));
        }
        return response2;
    }

    private final void ensureRequestActive(Request request2, HttpURLConnection connection) throws InterruptedException {
        boolean cancelled;
        block2: {
            cancelled = CancellableRequestKt.isCancelled(request2);
            if (!cancelled) {
                Thread thread2 = Thread.currentThread();
                Intrinsics.checkNotNullExpressionValue(thread2, "Thread.currentThread()");
                if (!thread2.isInterrupted()) {
                    return;
                }
            }
            HttpURLConnection httpURLConnection = connection;
            if (httpURLConnection == null) break block2;
            httpURLConnection.disconnect();
        }
        throw (Throwable)new InterruptedException("[HttpClient] could not ensure Request was active: cancelled=" + cancelled);
    }

    @Override
    @Nullable
    public Object awaitRequest(@NotNull Request request2, @NotNull Continuation<? super Response> $completion) {
        boolean bl = false;
        boolean bl2 = false;
        Continuation<? super Response> continuation = $completion;
        boolean bl3 = false;
        SafeContinuation<? super Response> safeContinuation = new SafeContinuation<Response>(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = safeContinuation;
        boolean bl4 = false;
        try {
            Continuation continuation3 = continuation2;
            Response response2 = this.doRequest(request2);
            boolean bl5 = false;
            Result.Companion companion = Result.Companion;
            boolean bl6 = false;
            continuation3.resumeWith(Result.constructor-impl(response2));
        }
        catch (IOException ioe) {
            this.hook.httpExchangeFailed(request2, ioe);
            Continuation continuation4 = continuation2;
            Throwable throwable = FuelError.Companion.wrap(ioe, new Response(request2.getUrl(), 0, null, null, 0L, null, 62, null));
            boolean bl7 = false;
            Result.Companion companion = Result.Companion;
            boolean bl8 = false;
            continuation4.resumeWith(Result.constructor-impl(ResultKt.createFailure(throwable)));
        }
        catch (InterruptedException interrupted) {
            Continuation continuation5 = continuation2;
            Throwable throwable = FuelError.Companion.wrap(interrupted, new Response(request2.getUrl(), 0, null, null, 0L, null, 62, null));
            boolean bl9 = false;
            Result.Companion companion = Result.Companion;
            boolean bl10 = false;
            continuation5.resumeWith(Result.constructor-impl(ResultKt.createFailure(throwable)));
        }
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private final Response doRequest(Request request2) throws IOException, InterruptedException {
        HttpURLConnection connection = this.establishConnection(request2);
        this.sendRequest(request2, connection);
        return this.retrieveResponse(request2, connection);
    }

    private final void sendRequest(Request request2, HttpURLConnection connection) throws IOException, InterruptedException {
        this.ensureRequestActive(request2, connection);
        HttpURLConnection httpURLConnection = connection;
        boolean bl = false;
        boolean bl2 = false;
        HttpURLConnection $this$apply = httpURLConnection;
        boolean bl3 = false;
        int n = request2.getExecutionOptions().getTimeoutInMillisecond();
        int n2 = 0;
        boolean bl4 = false;
        $this$apply.setConnectTimeout(Math.max(n, n2));
        n = request2.getExecutionOptions().getTimeoutReadInMillisecond();
        n2 = 0;
        bl4 = false;
        $this$apply.setReadTimeout(Math.max(n, n2));
        if ($this$apply instanceof HttpsURLConnection) {
            ((HttpsURLConnection)$this$apply).setSSLSocketFactory(request2.getExecutionOptions().getSocketFactory());
            ((HttpsURLConnection)$this$apply).setHostnameVerifier(request2.getExecutionOptions().getHostnameVerifier());
        }
        if (request2.getExecutionOptions().getForceMethods()) {
            ForceMethodKt.forceMethod($this$apply, request2.getMethod());
            if ($this$apply.getRequestMethod() != request2.getMethod().getValue()) {
                $this$apply.setRequestMethod(HttpClient.Companion.coerceMethod(request2.getMethod()).getValue());
                $this$apply.setRequestProperty("X-HTTP-Method-Override", request2.getMethod().getValue());
            }
        } else {
            $this$apply.setRequestMethod(HttpClient.Companion.coerceMethod(request2.getMethod()).getValue());
            if (Intrinsics.areEqual(request2.getMethod().getValue(), "PATCH")) {
                $this$apply.setRequestProperty("X-HTTP-Method-Override", request2.getMethod().getValue());
            }
        }
        $this$apply.setDoInput(true);
        Boolean bl5 = request2.getExecutionOptions().getUseHttpCache();
        $this$apply.setUseCaches(bl5 != null ? bl5 : this.useHttpCache);
        $this$apply.setInstanceFollowRedirects(false);
        request2.getHeaders().transformIterate((Function2<? super String, ? super String, ? extends Object>)new Function2<String, String, Unit>($this$apply){
            final /* synthetic */ HttpURLConnection $this_apply;

            public final void invoke(@NotNull String key, @NotNull String values2) {
                Intrinsics.checkNotNullParameter(key, "key");
                Intrinsics.checkNotNullParameter(values2, "values");
                this.$this_apply.setRequestProperty(key, values2);
            }
            {
                this.$this_apply = httpURLConnection;
                super(2);
            }
        }, (Function2<? super String, ? super String, ? extends Object>)new Function2<String, String, Unit>($this$apply){
            final /* synthetic */ HttpURLConnection $this_apply;

            public final void invoke(@NotNull String key, @NotNull String value2) {
                Intrinsics.checkNotNullParameter(key, "key");
                Intrinsics.checkNotNullParameter(value2, "value");
                this.$this_apply.addRequestProperty(key, value2);
            }
            {
                this.$this_apply = httpURLConnection;
                super(2);
            }
        });
        $this$apply.setRequestProperty("TE", Headers.Companion.collapse(new HeaderName("TE"), (Collection<String>)SUPPORTED_DECODING));
        this.hook.preConnect(connection, request2);
        this.setDoOutput(connection, request2.getMethod());
        this.setBodyIfDoOutput(connection, request2);
        connection.connect();
    }

    /*
     * WARNING - void declaration
     */
    private final Response retrieveResponse(Request request2, HttpURLConnection connection) throws IOException, InterruptedException {
        void contentLength;
        InputStream inputStream;
        boolean bl;
        boolean shouldDecode;
        String contentEncoding;
        List transferEncoding;
        Headers headers;
        block12: {
            Long l;
            boolean bl2;
            CharSequence charSequence;
            String $this$mapTo$iv$iv;
            Object list$iv$iv;
            String it;
            Iterable $this$flatMapTo$iv$iv;
            this.ensureRequestActive(request2, connection);
            this.hook.postConnect(request2);
            Map<String, List<String>> map2 = connection.getHeaderFields();
            Intrinsics.checkNotNullExpressionValue(map2, "connection.headerFields");
            headers = Headers.Companion.from(map2);
            Iterable $this$flatMap$iv = (Iterable)headers.get((Object)"Transfer-Encoding");
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl3 = false;
                list$iv$iv = StringsKt.split$default((CharSequence)it, new char[]{','}, false, 0, 6, null);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map22 = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv = iterator2.next();
                list$iv$iv = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                charSequence = it;
                bl2 = false;
                String string = charSequence;
                if (string == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                collection.add(string2);
            }
            transferEncoding = (List)destination$iv$iv;
            contentEncoding = (String)CollectionsKt.lastOrNull((Iterable)headers.get((Object)"Content-Encoding"));
            Ref.ObjectRef $i$f$map22 = new Ref.ObjectRef();
            String string = (String)CollectionsKt.lastOrNull((Iterable)headers.get((Object)"Content-Length"));
            if (string != null) {
                $this$mapTo$iv$iv = string;
                boolean destination$iv$iv2 = false;
                l = Long.parseLong($this$mapTo$iv$iv);
            } else {
                l = null;
            }
            $i$f$map22.element = l;
            Boolean bl5 = request2.getExecutionOptions().getDecodeContent();
            boolean bl6 = shouldDecode = (bl5 != null ? bl5 : this.decodeContent) && contentEncoding != null && Intrinsics.areEqual(contentEncoding, "identity") ^ true;
            if (shouldDecode) {
                headers.remove((Object)"Content-Encoding");
                headers.remove((Object)"Content-Length");
                contentLength.element = null;
            }
            headers.remove((Object)"Transfer-Encoding");
            Iterable $this$any$iv = transferEncoding;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String encoding = (String)element$iv;
                    boolean bl7 = false;
                    charSequence = encoding;
                    bl2 = false;
                    if (!(!StringsKt.isBlank(charSequence) && Intrinsics.areEqual(encoding, "identity") ^ true)) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        if (bl) {
            headers.remove((Object)"Content-Length");
            contentLength.element = -1L;
        }
        if ((inputStream = this.dataStream(request2, connection)) == null || (inputStream = DecodeStreamKt.decode$default(inputStream, transferEncoding, null, 2, null)) == null) {
            inputStream = new ByteArrayInputStream(new byte[0]);
        }
        InputStream contentStream = inputStream;
        InputStream inputStream2 = shouldDecode && contentEncoding != null ? DecodeStreamKt.decode$default(contentStream, contentEncoding, null, 2, null) : contentStream;
        WeakReference<HttpURLConnection> cancellationConnection = new WeakReference<HttpURLConnection>(connection);
        ProgressInputStream progressStream2 = new ProgressInputStream(inputStream2, (Function1<? super Long, Unit>)new Function1<Long, Unit>(this, request2, (Ref.ObjectRef)contentLength, cancellationConnection){
            final /* synthetic */ HttpClient this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ Ref.ObjectRef $contentLength;
            final /* synthetic */ WeakReference $cancellationConnection;

            public final void invoke(long readBytes) {
                Long l = (Long)this.$contentLength.element;
                this.$request.getExecutionOptions().getResponseProgress().invoke(readBytes, l != null ? l : readBytes);
                HttpClient.access$ensureRequestActive(this.this$0, this.$request, (HttpURLConnection)this.$cancellationConnection.get());
            }
            {
                this.this$0 = httpClient;
                this.$request = request2;
                this.$contentLength = objectRef;
                this.$cancellationConnection = weakReference;
                super(1);
            }
        });
        URL uRL = request2.getUrl();
        Long l = (Long)contentLength.element;
        long l2 = l != null ? l : -1L;
        int n = connection.getResponseCode();
        Object object = connection.getResponseMessage();
        boolean bl8 = false;
        Object object2 = object;
        if (object2 == null) {
            object2 = "";
        }
        object = DefaultBody.Companion.from$default(DefaultBody.Companion, new Function0<InputStream>(progressStream2){
            final /* synthetic */ ProgressInputStream $progressStream;

            @NotNull
            public final InputStream invoke() {
                InputStream inputStream = this.$progressStream;
                int n = FuelManager.Companion.getProgressBufferSize();
                boolean bl = false;
                return inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n);
            }
            {
                this.$progressStream = progressInputStream;
                super(0);
            }
        }, new Function0<Long>((Ref.ObjectRef)contentLength){
            final /* synthetic */ Ref.ObjectRef $contentLength;

            public final long invoke() {
                Long l = (Long)this.$contentLength.element;
                return l != null ? l : -1L;
            }
            {
                this.$contentLength = objectRef;
                super(0);
            }
        }, null, 4, null);
        String string = object2;
        int n2 = n;
        long l3 = l2;
        Headers headers2 = headers;
        return new Response(uRL, n2, string, headers2, l3, (Body)object);
    }

    private final InputStream dataStream(Request request2, HttpURLConnection connection) {
        InputStream inputStream;
        try {
            BufferedInputStream bufferedInputStream;
            InputStream inputStream2 = this.hook.interpretResponseStream(request2, connection.getInputStream());
            if (inputStream2 != null) {
                inputStream = inputStream2;
                int n = 8192;
                boolean bl = false;
                bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n);
            } else {
                bufferedInputStream = null;
            }
            inputStream = bufferedInputStream;
        }
        catch (IOException _) {
            BufferedInputStream bufferedInputStream;
            InputStream inputStream3 = this.hook.interpretResponseStream(request2, connection.getErrorStream());
            if (inputStream3 != null) {
                InputStream inputStream4 = inputStream3;
                int n = 8192;
                boolean bl = false;
                bufferedInputStream = inputStream4 instanceof BufferedInputStream ? (BufferedInputStream)inputStream4 : new BufferedInputStream(inputStream4, n);
            } else {
                bufferedInputStream = null;
            }
            inputStream = bufferedInputStream;
        }
        return inputStream;
    }

    private final HttpURLConnection establishConnection(Request request2) {
        Object connection;
        Object object;
        block5: {
            URL url;
            block4: {
                url = request2.getUrl();
                object = this.proxy;
                if (object == null) break block4;
                Proxy proxy = object;
                boolean bl = false;
                boolean bl2 = false;
                Proxy it = proxy;
                boolean bl3 = false;
                object = url.openConnection(it);
                if (object != null) break block5;
            }
            object = url.openConnection();
        }
        Object object2 = connection = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        return (HttpURLConnection)object2;
    }

    private final void setBodyIfDoOutput(HttpURLConnection connection, Request request2) {
        OutputStream outputStream2;
        OutputStream outputStream3;
        Body body2 = request2.getBody();
        if (!connection.getDoOutput()) {
            return;
        }
        if (body2.isEmpty()) {
            connection.setFixedLengthStreamingMode(0L);
            return;
        }
        Long contentLength = body2.getLength();
        if (contentLength != null && contentLength != -1L) {
            connection.setFixedLengthStreamingMode(contentLength);
        } else {
            connection.setChunkedStreamingMode(4096);
        }
        boolean noProgressHandler = request2.getExecutionOptions().getRequestProgress().isNotSet();
        if (noProgressHandler) {
            outputStream3 = connection.getOutputStream();
        } else {
            Long l;
            Long l2 = contentLength;
            if ((l2 != null ? l2 : -1L) > 0L) {
                Long l3 = contentLength;
                Intrinsics.checkNotNull(l3);
                l = (long)l3;
            } else {
                l = null;
            }
            Long totalBytes = l;
            OutputStream outputStream4 = connection.getOutputStream();
            Intrinsics.checkNotNullExpressionValue(outputStream4, "connection.outputStream");
            OutputStream outputStream5 = new ProgressOutputStream(outputStream4, (Function1<? super Long, Unit>)new Function1<Long, Unit>(this, request2, totalBytes, connection){
                final /* synthetic */ HttpClient this$0;
                final /* synthetic */ Request $request;
                final /* synthetic */ Long $totalBytes;
                final /* synthetic */ HttpURLConnection $connection;

                public final void invoke(long writtenBytes) {
                    Long l = this.$totalBytes;
                    this.$request.getExecutionOptions().getRequestProgress().invoke(writtenBytes, l != null ? l : writtenBytes);
                    HttpClient.access$ensureRequestActive(this.this$0, this.$request, this.$connection);
                }
                {
                    this.this$0 = httpClient;
                    this.$request = request2;
                    this.$totalBytes = l;
                    this.$connection = httpURLConnection;
                    super(1);
                }
            });
            int n = FuelManager.Companion.getProgressBufferSize();
            boolean bl = false;
            outputStream3 = outputStream5 instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream5 : new BufferedOutputStream(outputStream5, n);
        }
        OutputStream outputStream6 = outputStream2 = outputStream3;
        Intrinsics.checkNotNullExpressionValue(outputStream6, "outputStream");
        body2.writeTo(outputStream6);
        connection.getOutputStream().flush();
    }

    private final void setDoOutput(HttpURLConnection connection, Method method) {
        switch (HttpClient$WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                connection.setDoOutput(false);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                connection.setDoOutput(true);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final boolean getUseHttpCache() {
        return this.useHttpCache;
    }

    public final void setUseHttpCache(boolean bl) {
        this.useHttpCache = bl;
    }

    public final boolean getDecodeContent() {
        return this.decodeContent;
    }

    public final void setDecodeContent(boolean bl) {
        this.decodeContent = bl;
    }

    @NotNull
    public final Client.Hook getHook() {
        return this.hook;
    }

    public final void setHook(@NotNull Client.Hook hook2) {
        Intrinsics.checkNotNullParameter(hook2, "<set-?>");
        this.hook = hook2;
    }

    public HttpClient(@Nullable Proxy proxy, boolean useHttpCache, boolean decodeContent, @NotNull Client.Hook hook2) {
        Intrinsics.checkNotNullParameter(hook2, "hook");
        this.proxy = proxy;
        this.useHttpCache = useHttpCache;
        this.decodeContent = decodeContent;
        this.hook = hook2;
    }

    public /* synthetic */ HttpClient(Proxy proxy, boolean bl, boolean bl2, Client.Hook hook2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            proxy = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        this(proxy, bl, bl2, hook2);
    }

    static {
        Companion = new Companion(null);
        SUPPORTED_DECODING = CollectionsKt.listOf("gzip", "deflate; q=0.5");
    }

    public static final /* synthetic */ void access$ensureRequestActive(HttpClient $this, Request request2, HttpURLConnection connection) {
        $this.ensureRequestActive(request2, connection);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/github/kittinunf/fuel/toolbox/HttpClient$Companion;", "", "()V", "SUPPORTED_DECODING", "", "", "coerceMethod", "Lcom/github/kittinunf/fuel/core/Method;", "method", "fuel"})
    public static final class Companion {
        private final Method coerceMethod(Method method) {
            return method == Method.PATCH ? Method.POST : method;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

