/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import solver.SolverConfig;
import solver.SolverInfo;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lsolver/VampireSolverInfo;", "Lsolver/SolverInfo;", "()V", "DEFAULT_VAMPIRE_COMMAND", "", "defaultCommand", "getDefaultCommand", "()Ljava/lang/String;", "commandForStdInMode", "", "clOptions", "getOptionForIncremental", "getOptionForRandomSeed", "randomSeed", "", "getOptionForTimelimit", "timelimit", "Ljava/time/Duration;", "readResolve", "", "supportsLogicFeatures", "", "features", "Lsolver/SolverConfig$LogicFeatures;", "GeneralUtils"})
public final class VampireSolverInfo
extends SolverInfo {
    @NotNull
    public static final VampireSolverInfo INSTANCE = new VampireSolverInfo();
    @NotNull
    private static final String DEFAULT_VAMPIRE_COMMAND = "vprover";

    private VampireSolverInfo() {
        super("Vampire");
    }

    @Override
    @NotNull
    public List<String> getOptionForIncremental() {
        throw new UnsupportedOperationException("incremental mode is not supported by Vampire");
    }

    @Override
    @NotNull
    public List<String> getOptionForTimelimit(@NotNull Duration timelimit) {
        Intrinsics.checkNotNullParameter(timelimit, "timelimit");
        String[] stringArray = new String[]{"--time_limit", String.valueOf(timelimit.toSeconds())};
        return CollectionsKt.listOf(stringArray);
    }

    @Override
    @NotNull
    public List<String> getOptionForRandomSeed(int randomSeed) {
        return CollectionsKt.listOf("--random_seed " + randomSeed);
    }

    @Override
    public boolean supportsLogicFeatures(@NotNull SolverConfig.LogicFeatures features) {
        Intrinsics.checkNotNullParameter(features, "features");
        return true;
    }

    @Override
    @NotNull
    public List<String> commandForStdInMode(@NotNull List<String> clOptions) {
        Intrinsics.checkNotNullParameter(clOptions, "clOptions");
        String[] stringArray = new String[]{DEFAULT_VAMPIRE_COMMAND, "--input_syntax", "smtlib2", "--mode", "portfolio", "--schedule", "smtcomp", "--cores", "1", "--output_mode", "smtcomp"};
        return CollectionsKt.plus((Collection)CollectionsKt.listOf(stringArray), (Iterable)clOptions);
    }

    @Override
    @NotNull
    public String getDefaultCommand() {
        return DEFAULT_VAMPIRE_COMMAND;
    }

    private final Object readResolve() {
        return INSTANCE;
    }
}

