from __future__ import unicode_literals

from reviewboard.hostingsvcs.tests.testcases import ServiceTests


class GitoriousTests(ServiceTests):
    """Unit tests for the Gitorious hosting service."""

    service_name = 'gitorious'

    def test_service_support(self):
        """Testing the Gitorious service support capabilities"""
        self.assertFalse(self.service_class.supports_bug_trackers)
        self.assertTrue(self.service_class.supports_repositories)
        self.assertTrue(self.service_class.self_hosted)

    def test_repo_field_values(self):
        """Testing the Gitorious repository field values"""
        fields = self._get_repository_fields('Git', fields={
            'gitorious_project_name': 'myproj',
            'gitorious_repo_name': 'myrepo',
        })
        self.assertEqual(fields['path'],
                         'git://example.com/myproj/myrepo.git')
        self.assertEqual(fields['mirror_path'],
                         'https://example.com/myproj/myrepo.git')
        self.assertEqual(fields['raw_file_url'],
                         'https://example.com/myproj/myrepo/blobs/raw/'
                         '<revision>')
