(function(){suite("rb/collections/FilteredCollection",function(){var mainCollection,filteredCollection;beforeEach(function(){mainCollection=new Backbone.Collection([{id:1,label:"One",bool:true},{id:2,label:"Two",bool:false},{id:3,label:"Three",bool:true}])});describe("Initialization",function(){it("Defaults to full contents",function(){filteredCollection=new RB.FilteredCollection(null,{collection:mainCollection});expect(filteredCollection.length).toBe(mainCollection.length)});it("Respects provided filter",function(){filteredCollection=new RB.FilteredCollection(null,{collection:mainCollection,filters:{label:"T"}});expect(filteredCollection.length).toBe(2);expect(filteredCollection.at(0).id).toBe(2);expect(filteredCollection.at(1).id).toBe(3)})});describe("Methods",function(){beforeEach(function(){filteredCollection=new RB.FilteredCollection(null,{collection:mainCollection,filters:{label:"T"}});expect(filteredCollection.length).toBe(2)});describe("setFilters",function(){it("With new filter",function(){filteredCollection.setFilters({label:"O"});expect(filteredCollection.length).toBe(1);expect(filteredCollection.at(0).id).toBe(1)});it("With multiple filters",function(){filteredCollection.setFilters({label:"T",bool:false});expect(filteredCollection.length).toBe(1);expect(filteredCollection.at(0).id).toBe(2)});it("{}",function(){filteredCollection.setFilters({});expect(filteredCollection.length).toBe(3)});it("null",function(){filteredCollection.setFilters(null);expect(filteredCollection.length).toBe(3)});it("undefined",function(){filteredCollection.setFilters();expect(filteredCollection.length).toBe(3)})})});describe("Main collection events",function(){describe("With filters",function(){beforeEach(function(){filteredCollection=new RB.FilteredCollection(null,{collection:mainCollection,filters:{label:"T"}});expect(filteredCollection.length).toBe(2)});it("reset",function(){mainCollection.reset([{id:10,label:"Monday"},{id:11,label:"Tuesday"}]);expect(filteredCollection.length).toBe(1);expect(filteredCollection.at(0).id).toBe(11)});describe("add",function(){it("Matching filter",function(){mainCollection.add({id:4,label:"Test"});expect(filteredCollection.length).toBe(3);expect(filteredCollection.at(2).id).toBe(4)});it("Not matching filter",function(){mainCollection.add({id:4,label:"Four"});expect(filteredCollection.length).toBe(2)})});describe("remove",function(){it("Matching filter",function(){mainCollection.remove(mainCollection.get(2));expect(filteredCollection.length).toBe(1)});it("Not matching filter",function(){mainCollection.remove(mainCollection.get(0));expect(filteredCollection.length).toBe(2)})})});describe("Without filters",function(){beforeEach(function(){filteredCollection=new RB.FilteredCollection(null,{collection:mainCollection});expect(filteredCollection.length).toBe(3)});it("reset",function(){mainCollection.reset([{id:10,label:"Monday"},{id:11,label:"Tuesday"}]);expect(filteredCollection.length).toBe(2)});it("add",function(){mainCollection.add({id:4,label:"Four"});expect(filteredCollection.length).toBe(4);expect(filteredCollection.at(3).id).toBe(4)});it("remove",function(){mainCollection.remove(mainCollection.get(1));expect(filteredCollection.length).toBe(2)})})})});suite("rb/configForms/models/ResourceListItem",function(){var TestListItem,resource,listItem;TestListItem=RB.Config.ResourceListItem.extend({syncAttrs:["name","fileRegex"],createResource:function(attrs){return new RB.DefaultReviewer(attrs)}});beforeEach(function(){resource=new RB.DefaultReviewer({name:"my-name",fileRegex:".*"})});describe("Synchronizing attributes",function(){it("On resource attribute change",function(){listItem=new TestListItem({resource:resource});resource.set("name","foo");expect(listItem.get("name")).toBe("foo")});describe("On creation",function(){it("With existing resource",function(){listItem=new TestListItem({resource:resource,name:"dummy",fileRegex:"/foo/.*"});expect(listItem.get("name")).toBe("my-name");expect(listItem.get("fileRegex")).toBe(".*")});it("With created resource",function(){listItem=new TestListItem({id:123,name:"new-name",fileRegex:"/foo/.*"});expect(listItem.get("name")).toBe("new-name");expect(listItem.get("fileRegex")).toBe("/foo/.*");resource=listItem.get("resource");expect(resource.id).toBe(123);expect(resource.get("name")).toBe("new-name");expect(resource.get("fileRegex")).toBe("/foo/.*")})})});describe("Event mirroring",function(){beforeEach(function(){listItem=new TestListItem({resource:resource});spyOn(listItem,"trigger")});it("destroy",function(){resource.trigger("destroy");expect(listItem.trigger).toHaveBeenCalledWith("destroy",listItem,undefined,{})});it("request",function(){resource.trigger("request");expect(listItem.trigger).toHaveBeenCalledWith("request")});it("sync",function(){resource.trigger("sync");expect(listItem.trigger).toHaveBeenCalledWith("sync")})})});"use strict";suite("rb/diffviewer/collections/DiffReviewableCollection",function(){describe("Construction",function(){it("Sets reviewRequest",function(){var reviewRequest=new RB.ReviewRequest;var collection=new RB.DiffReviewableCollection([],{reviewRequest:reviewRequest});expect(collection.reviewRequest).toBe(reviewRequest)})});describe("watchFiles",function(){var collection=void 0;var files=void 0;beforeEach(function(){collection=new RB.DiffReviewableCollection([],{reviewRequest:new RB.ReviewRequest});files=new RB.DiffFileCollection});it("Initially populates",function(){spyOn(collection,"_populateFromFiles");collection.watchFiles(files);expect(collection._populateFromFiles).toHaveBeenCalled()});it("Populates on files.reset",function(){spyOn(collection,"trigger");spyOn(collection,"reset");collection.watchFiles(files);files.reset([new RB.DiffFile({filediff:{id:300,revision:1},index:1,id:100}),new RB.DiffFile({filediff:{id:301,revision:1},interfilediff:{id:400,revision:2},index:2,id:101,commentCounts:[1]}),new RB.DiffFile({filediff:{id:302,revision:2},forceInterdiff:true,forceInterdiffRevision:1,index:3,id:102})]);expect(collection.reset).toHaveBeenCalled();expect(collection.trigger).toHaveBeenCalledWith("populating");expect(collection.trigger).toHaveBeenCalledWith("populated");expect(collection.length).toBe(3);var diffReviewable=collection.at(0);expect(diffReviewable.get("file").id).toBe(100);expect(diffReviewable.get("reviewRequest")).toBe(collection.reviewRequest);expect(diffReviewable.get("fileDiffID")).toBe(300);expect(diffReviewable.get("interFileDiffID")).toBe(null);expect(diffReviewable.get("revision")).toBe(1);expect(diffReviewable.get("interdiffRevision")).toBe(null);diffReviewable=collection.at(1);expect(diffReviewable.get("file").id).toBe(101);expect(diffReviewable.get("reviewRequest")).toBe(collection.reviewRequest);expect(diffReviewable.get("fileDiffID")).toBe(301);expect(diffReviewable.get("interFileDiffID")).toBe(400);expect(diffReviewable.get("revision")).toBe(1);expect(diffReviewable.get("interdiffRevision")).toBe(2);expect(diffReviewable.get("serializedCommentBlocks")).toEqual([1]);diffReviewable=collection.at(2);expect(diffReviewable.get("file").id).toBe(102);expect(diffReviewable.get("reviewRequest")).toBe(collection.reviewRequest);expect(diffReviewable.get("fileDiffID")).toBe(302);expect(diffReviewable.get("interFileDiffID")).toBe(null);expect(diffReviewable.get("revision")).toBe(2);expect(diffReviewable.get("interdiffRevision")).toBe(1)})})});suite("rb/diffviewer/models/DiffFile",function(){var model;beforeEach(function(){model=new RB.DiffFile});describe("parse",function(){it("API payloads",function(){var data=model.parse({binary:false,comment_counts:[1],deleted:true,depot_filename:"foo",dest_filename:"bar",filediff:{id:38,revision:2},id:28,index:3,interfilediff:{id:23,revision:4},newfile:true,revision:3});expect(data).not.toBe(undefined);expect(data.binary).toBe(false);expect(data.commentCounts).toEqual([1]);expect(data.deleted).toBe(true);expect(data.depotFilename).toBe("foo");expect(data.destFilename).toBe("bar");expect(data.filediff).not.toBe(undefined);expect(data.filediff.id).toBe(38);expect(data.filediff.revision).toBe(2);expect(data.id).toBe(28);expect(data.index).toBe(3);expect(data.interfilediff).not.toBe(undefined);expect(data.interfilediff.id).toBe(23);expect(data.interfilediff.revision).toBe(4);expect(data.newfile).toBe(true);expect(data.revision).toBe(3)})})});suite("rb/diffviewer/models/DiffReviewable",function(){var callbacks,reviewRequest;beforeEach(function(){callbacks={success:function(){},error:function(){},complete:function(){}};reviewRequest=new RB.ReviewRequest({reviewURL:"/r/1/"});spyOn(callbacks,"success");spyOn(callbacks,"error");spyOn(callbacks,"complete")});describe("getRenderedDiff",function(){it("Without interdiffs",function(){var diffReviewable=new RB.DiffReviewable({reviewRequest:reviewRequest,fileDiffID:3,revision:2,file:new RB.DiffFile({index:4})});spyOn($,"ajax").and.callFake(function(request){expect(request.type).toBe("GET");expect(request.url).toBe("/r/1/diff/2/fragment/3/?index=4&"+TEMPLATE_SERIAL);request.success("abc");request.complete("abc","success")});diffReviewable.getRenderedDiff(callbacks);expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith("abc");expect(callbacks.complete).toHaveBeenCalledWith("abc","success");expect(callbacks.error).not.toHaveBeenCalled()});it("With interdiffs",function(){var diffReviewable=new RB.DiffReviewable({reviewRequest:reviewRequest,fileDiffID:3,revision:2,interdiffRevision:3,file:new RB.DiffFile({index:4})});spyOn($,"ajax").and.callFake(function(request){expect(request.type).toBe("GET");expect(request.url).toBe("/r/1/diff/2-3/fragment/3/?index=4&"+TEMPLATE_SERIAL);request.success("abc");request.complete("abc","success")});diffReviewable.getRenderedDiff(callbacks);expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith("abc");expect(callbacks.complete).toHaveBeenCalledWith("abc","success");expect(callbacks.error).not.toHaveBeenCalled()})});describe("getRenderedDiffFragment",function(){it("Without interdiffs",function(){var diffReviewable=new RB.DiffReviewable({reviewRequest:reviewRequest,fileDiffID:3,revision:2,file:new RB.DiffFile({index:5})});spyOn($,"ajax").and.callFake(function(request){expect(request.type).toBe("GET");expect(request.url).toBe("/r/1/diff/2/fragment/3/chunk/4/");expect(request.data.index).toBe(5);expect(request.data["lines-of-context"]).toBe(6);request.success("abc");request.complete("abc","success")});diffReviewable.getRenderedDiffFragment({chunkIndex:4,linesOfContext:6},callbacks);expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith("abc");expect(callbacks.complete).toHaveBeenCalledWith("abc","success");expect(callbacks.error).not.toHaveBeenCalled()});it("With interdiffs",function(){var diffReviewable=new RB.DiffReviewable({reviewRequest:reviewRequest,fileDiffID:3,revision:2,interdiffRevision:3,interFileDiffID:4,file:new RB.DiffFile({index:5})});spyOn($,"ajax").and.callFake(function(request){expect(request.type).toBe("GET");expect(request.url).toBe("/r/1/diff/2-3/fragment/3-4/chunk/4/");expect(request.data.index).toBe(5);expect(request.data["lines-of-context"]).toBe(6);request.success("abc");request.complete("abc","success")});diffReviewable.getRenderedDiffFragment({chunkIndex:4,linesOfContext:6},callbacks);expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith("abc");expect(callbacks.complete).toHaveBeenCalledWith("abc","success");expect(callbacks.error).not.toHaveBeenCalled()})})});suite("rb/diffviewer/models/DiffRevision",function(){var model;beforeEach(function(){model=new RB.DiffRevision});describe("parse",function(){it("API payloads",function(){var data=model.parse({revision:2,latest_revision:3,interdiff_revision:4,is_interdiff:true,is_draft_diff:true});expect(data).not.toBe(undefined);expect(data.revision).toBe(2);expect(data.latestRevision).toBe(3);expect(data.interdiffRevision).toBe(4);expect(data.isInterdiff).toBe(true);expect(data.isDraftDiff).toBe(true)})})});suite("rb/diffviewer/models/Pagination",function(){var model;beforeEach(function(){model=new RB.Pagination});describe("parse",function(){it("API payloads",function(){var data=model.parse({is_paginated:true,pages:4,has_previous:true,has_next:true,page_numbers:[1,2,3,4],previous_page:1,next_page:3,current_page:2});expect(data).not.toBe(undefined);expect(data.isPaginated).toBe(true);expect(data.pages).toBe(4);expect(data.pageNumbers).toEqual([1,2,3,4]);expect(data.hasPrevious).toBe(true);expect(data.hasNext).toBe(true);expect(data.previousPage).toBe(1);expect(data.nextPage).toBe(3);expect(data.currentPage).toBe(2)})})});suite("rb/diffviewer/views/DiffReviewableView",function(){var diffTableTemplate=_.template(['<table class="sidebyside">'," <thead>","  <tr>",'   <th colspan="2">','    <a name="1" class="file-anchor"></a> my-file.txt',"   </th>","  </tr>","  <tr>",'   <th class="rev">Revision 1</th>','   <th class="rev">Revision 2</th>',"  </tr>"," </thead>"," <% _.each(chunks, function(chunk, index) { %>",'  <% if (chunk.type === "collapsed") { %>','   <tbody class="diff-header">',"    <tr>","     <th>",'      <a href="#" class="diff-expand-btn tests-expand-above"','         data-chunk-index="<%= index %>"','         data-lines-of-context="20,0"><img /></a>',"     </th>",'     <th colspan="3">','      <a href="#" class="diff-expand-btn tests-expand-chunk"','         data-chunk-index="<%= index %>"><img /> Expand</a>',"     </th>","    </tr>","    <tr>","     <th>",'      <a href="#" class="diff-expand-btn tests-expand-below"','         data-chunk-index="<%= index %>"','         data-lines-of-context="0,20"><img /></a>',"     </th>",'     <th colspan="3">','      <a href="#" class="diff-expand-btn tests-expand-header"','         data-chunk-index="<%= index %>"','         data-lines-of-context="0,<%= chunk.expandHeaderLines %>">',"       <img /> <code>Some Function</code>","      </a>","     </th>","    </tr>","   </tbody>","  <% } else { %>",'   <tbody class="<%= chunk.type %>',"                 <% if (chunk.expanded) { %>loaded<% } %>",'                 <%= chunk.extraClass || "" %>"','          id="chunk0.<%= index %>">',"    <% for (var i = 0; i < chunk.numRows; i++) { %>",'     <tr line="<%= i + chunk.startRow %>">',"      <th></th>","      <td>","       <% if (chunk.expanded && i === 0) { %>",'        <div class="collapse-floater">','         <img class="diff-collapse-btn"','              data-chunk-index="<%= index %>"','              data-lines-of-context="0" />',"        </div>","       <% } %>","      </td>","      <th></th>","      <td></td>","     </tr>","    <% } %>","   </tbody>","  <% } %>"," <% }); %>","</table>"].join("")),reviewRequest,$container,view;beforeEach(function(){$container=$("<div/>").appendTo($testsScratch);reviewRequest=new RB.ReviewRequest});afterEach(function(){view.remove()});describe("CommentRowSelector",function(){var selector,$rows;beforeEach(function(){view=new RB.DiffReviewableView({model:new RB.DiffReviewable({reviewRequest:reviewRequest}),el:$(diffTableTemplate({chunks:[{type:"equal",startRow:1,numRows:5},{type:"delete",startRow:6,numRows:10}]}))});view.render().$el.appendTo($container);selector=view._selector;$rows=view.$el.find("tbody tr")});describe("Selecting range",function(){var $startRow,startCell;beforeEach(function(){$startRow=$($rows[4]);startCell=$startRow[0].cells[0]});it("Beginning selection",function(){selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});expect($startRow.hasClass("selected")).toBe(true);expect(selector._$begin[0]).toBe($startRow[0]);expect(selector._$end[0]).toBe($startRow[0]);expect(selector._beginLineNum).toBe(5);expect(selector._endLineNum).toBe(5);expect(selector._lastSeenIndex).toBe($startRow[0].rowIndex)});describe("Adding rows to selection",function(){it("Above",function(){var $prevRow=$($rows[3]);selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});selector._onMouseOver({target:$prevRow[0].cells[0]});expect($startRow.hasClass("selected")).toBe(true);expect($prevRow.hasClass("selected")).toBe(true);expect(selector._$begin[0]).toBe($prevRow[0]);expect(selector._$end[0]).toBe($startRow[0]);expect(selector._beginLineNum).toBe(4);expect(selector._endLineNum).toBe(5);expect(selector._lastSeenIndex).toBe($prevRow[0].rowIndex)});it("Below",function(){var $nextRow=$($rows[5]);selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});selector._onMouseOver({target:$nextRow[0].cells[0]});expect($startRow.hasClass("selected")).toBe(true);expect($nextRow.hasClass("selected")).toBe(true);expect(selector._$begin[0]).toBe($startRow[0]);expect(selector._$end[0]).toBe($nextRow[0]);expect(selector._beginLineNum).toBe(5);expect(selector._endLineNum).toBe(6);expect(selector._lastSeenIndex).toBe($nextRow[0].rowIndex)});it("Rows inbetween two events",function(){var $laterRow=$($rows[7]);selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});selector._onMouseOver({target:$laterRow[0].cells[0]});expect($($rows[4]).hasClass("selected")).toBe(true);expect($($rows[5]).hasClass("selected")).toBe(true);expect($($rows[6]).hasClass("selected")).toBe(true);expect($($rows[7]).hasClass("selected")).toBe(true);expect(selector._$begin[0]).toBe($startRow[0]);expect(selector._$end[0]).toBe($laterRow[0]);expect(selector._beginLineNum).toBe(5);expect(selector._endLineNum).toBe(8);expect(selector._lastSeenIndex).toBe($laterRow[0].rowIndex)})});describe("Removing rows from selection",function(){it("Above",function(){var $prevRow=$($rows[3]),prevCell=$prevRow[0].cells[0];selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});selector._onMouseOver({target:prevCell});selector._onMouseOut({relatedTarget:startCell,target:prevCell});selector._onMouseOver({target:startCell});expect($startRow.hasClass("selected")).toBe(true);expect($prevRow.hasClass("selected")).toBe(false);expect(selector._$begin[0]).toBe($startRow[0]);expect(selector._$end[0]).toBe($startRow[0]);expect(selector._beginLineNum).toBe(5);expect(selector._endLineNum).toBe(5);expect(selector._lastSeenIndex).toBe($startRow[0].rowIndex)});it("Below",function(){var $nextRow=$($rows[5]),nextCell=$nextRow[0].cells[0];selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});selector._onMouseOver({target:nextCell});selector._onMouseOut({relatedTarget:startCell,target:nextCell});selector._onMouseOver({target:startCell});expect($startRow.hasClass("selected")).toBe(true);expect($nextRow.hasClass("selected")).toBe(false);expect(selector._$begin[0]).toBe($startRow[0]);expect(selector._$end[0]).toBe($startRow[0]);expect(selector._beginLineNum).toBe(5);expect(selector._endLineNum).toBe(5);expect(selector._lastSeenIndex).toBe($startRow[0].rowIndex)})});describe("Finishing selection",function(){beforeEach(function(){spyOn(view,"createAndEditCommentBlock")});describe("With single line",function(){var $row,cell;beforeEach(function(){$row=$($rows[4]);cell=$row[0].cells[0]});it("And existing comment",function(){var onClick=jasmine.createSpy("onClick");$('<a class="commentflag" />').click(onClick).appendTo(cell);selector._onMouseOver({target:cell});selector._onMouseDown({target:cell});selector._onMouseUp({target:cell,stopImmediatePropagation:function(){},preventDefault:function(){}});expect(view.createAndEditCommentBlock).not.toHaveBeenCalled();expect(onClick).toHaveBeenCalled();expect($row.hasClass("selected")).toBe(false);expect(selector._$begin).toBe(null);expect(selector._$end).toBe(null);expect(selector._beginLineNum).toBe(0);expect(selector._endLineNum).toBe(0);expect(selector._lastSeenIndex).toBe(0)});it("And no existing comment",function(){selector._onMouseOver({target:cell});selector._onMouseDown({target:cell});selector._onMouseUp({target:cell,stopImmediatePropagation:function(){},preventDefault:function(){}});expect(view.createAndEditCommentBlock).toHaveBeenCalledWith({$beginRow:$row,$endRow:$row,beginLineNum:5,endLineNum:5});expect($row.hasClass("selected")).toBe(false);expect(selector._$begin).toBe(null);expect(selector._$end).toBe(null);expect(selector._beginLineNum).toBe(0);expect(selector._endLineNum).toBe(0);expect(selector._lastSeenIndex).toBe(0)})});describe("With multiple lines",function(){var $startRow,$endRow,startCell,endCell;beforeEach(function(){$startRow=$($rows[4]);$endRow=$($rows[5]);startCell=$startRow[0].cells[0];endCell=$endRow[0].cells[0]});xit("And existing comment",function(){var onClick=jasmine.createSpy("onClick");$('<a class="commentflag" />').click(onClick).appendTo(startCell);selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});selector._onMouseOver({target:endCell});expect(selector._$begin[0]).toBe($startRow[0]);expect(selector._$end[0]).toBe($endRow[0]);$startRow=selector._$begin;$endRow=selector._$end;selector._onMouseUp({target:endCell,stopImmediatePropagation:function(){},preventDefault:function(){}});expect(view.createAndEditCommentBlock).toHaveBeenCalledWith({$beginRow:$startRow,$endRow:$endRow,beginLineNum:5,endLineNum:6});expect(onClick).not.toHaveBeenCalled();expect($startRow.hasClass("selected")).toBe(false);expect($endRow.hasClass("selected")).toBe(false);expect(selector._$begin).toBe(null);expect(selector._$end).toBe(null);expect(selector._beginLineNum).toBe(0);expect(selector._endLineNum).toBe(0);expect(selector._lastSeenIndex).toBe(0)});it("And no existing comment",function(){selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});selector._onMouseOver({target:endCell});expect(selector._$begin[0]).toBe($startRow[0]);expect(selector._$end[0]).toBe($endRow[0]);$startRow=selector._$begin;$endRow=selector._$end;selector._onMouseUp({target:endCell,stopImmediatePropagation:function(){},preventDefault:function(){}});expect(view.createAndEditCommentBlock).toHaveBeenCalledWith({$beginRow:$startRow,$endRow:$endRow,beginLineNum:5,endLineNum:6});expect($startRow.hasClass("selected")).toBe(false);expect($endRow.hasClass("selected")).toBe(false);expect(selector._$begin).toBe(null);expect(selector._$end).toBe(null);expect(selector._beginLineNum).toBe(0);expect(selector._endLineNum).toBe(0);expect(selector._lastSeenIndex).toBe(0)})})})});describe("Hovering",function(){describe("Over line",function(){var $row,cell;beforeEach(function(){$row=$($rows[4])});it("Contents cell",function(){cell=$row[0].cells[1];selector._onMouseOver({target:cell});expect($row.hasClass("selected")).toBe(false);expect(selector._$ghostCommentFlag.css("display")).toBe("none")});describe("Line number cell",function(){beforeEach(function(){cell=$row[0].cells[0]});it("With existing comment on row",function(){$(cell).append('<a class="commentflag" />');selector._onMouseOver({target:cell});expect($row.hasClass("selected")).toBe(true);expect(selector._$ghostCommentFlag.css("display")).toBe("none")});it("With no column flag",function(){selector._onMouseOver({target:cell});expect($row.hasClass("selected")).toBe(true);expect(selector._$ghostCommentFlag.css("display")).not.toBe("none")})})});describe("Out of line",function(){it("Contents cell",function(){var $row=$($rows[0]);selector._onMouseOver({target:$row[0].cells[0]});expect(selector._$ghostCommentFlag.css("display")).not.toBe("none");selector._onMouseOut({target:$row[0].cells[0]});expect(selector._$ghostCommentFlag.css("display")).toBe("none")});it("Line number cell",function(){var $row=$($rows[0]);selector._onMouseOver({target:$row[0].cells[0]});expect(selector._$ghostCommentFlag.css("display")).not.toBe("none");expect($row.hasClass("selected")).toBe(true);selector._onMouseOut({target:$row[0].cells[0]});expect(selector._$ghostCommentFlag.css("display")).toBe("none");expect($row.hasClass("selected")).toBe(false)})})})});describe("Incremental expansion",function(){var model;beforeEach(function(){model=new RB.DiffReviewable({reviewRequest:reviewRequest,fileDiffID:10,revision:1,file:new RB.DiffFile({index:1})})});describe("Expanding",function(){beforeEach(function(){view=new RB.DiffReviewableView({model:model,el:$(diffTableTemplate({chunks:[{type:"equal",startRow:1,numRows:5},{type:"collapsed",expandHeaderLines:7},{type:"delete",startRow:10,numRows:5}]}))});view.render().$el.appendTo($container)});describe("Fetching fragment",function(){beforeEach(function(){spyOn(model,"getRenderedDiffFragment")});it("Full chunk",function(){var options;view.$(".tests-expand-chunk").click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();options=model.getRenderedDiffFragment.calls.argsFor(0)[0];expect(options.chunkIndex).toBe(1);expect(options.linesOfContext).toBe(undefined)});it("+20 above",function(){var options;view.$(".tests-expand-above").click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();options=model.getRenderedDiffFragment.calls.argsFor(0)[0];expect(options.chunkIndex).toBe(1);expect(options.linesOfContext).toBe("20,0")});it("+20 below",function(){var options;view.$(".tests-expand-below").click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();options=model.getRenderedDiffFragment.calls.argsFor(0)[0];expect(options.chunkIndex).toBe(1);expect(options.linesOfContext).toBe("0,20")});it("Function/class",function(){var options;view.$(".tests-expand-header").click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();options=model.getRenderedDiffFragment.calls.argsFor(0)[0];expect(options.chunkIndex).toBe(1);expect(options.linesOfContext).toBe("0,7")})});describe("Injecting HTML",function(){it("Whole chunk",function(){var $tbodies;spyOn(model,"getRenderedDiffFragment").and.callFake(function(options,callbacks,context){callbacks.success.call(context,['<tbody class="equal tests-new-chunk">',' <tr line="6">',"  <th></th>","  <td>",'   <div class="collapse-floater">','    <img class="diff-collapse-btn"','         data-chunk-index="1"','         data-lines-of-context="0" />',"   </div>","  </td>","  <th></th>","  <td></td>"," </tr>","</tbody>"].join(""))});spyOn(view,"trigger").and.callThrough();view.$(".tests-expand-chunk").click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();$tbodies=view.$("tbody");expect($tbodies.length).toBe(3);expect($($tbodies[0]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("tests-new-chunk")).toBe(true);expect($($tbodies[2]).hasClass("delete")).toBe(true);expect(view._centered._elements.size).toBe(1);expect(view.trigger).toHaveBeenCalledWith("chunkExpansionChanged")});it("Merging adjacent expanded chunks",function(){var $tbodies;spyOn(model,"getRenderedDiffFragment").and.callFake(function(options,callbacks,context){callbacks.success.call(context,['<tbody class="equal tests-new-chunk">',' <tr line="6">',"  <th></th>","  <td>",'   <div class="collapse-floater">','    <img class="diff-collapse-btn"','         data-chunk-index="1"','         data-lines-of-context="0" />',"   </div>","  </td>","  <th></th>","  <td></td>"," </tr>","</tbody>"].join(""))});spyOn(view,"trigger").and.callThrough();$('<tbody class="equal loaded"/>').append($('<img class="diff-collapse-btn" />')).insertAfter(view.$("tbody")[1]).clone().insertBefore(view.$("tbody")[1]);expect(view.$("tbody").length).toBe(5);view.$(".tests-expand-chunk").click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();$tbodies=view.$("tbody");expect($tbodies.length).toBe(3);expect($($tbodies[0]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("tests-new-chunk")).toBe(true);expect($($tbodies[2]).hasClass("delete")).toBe(true);expect(view._centered._elements.size).toBe(1);expect(view.trigger).toHaveBeenCalledWith("chunkExpansionChanged")})})});describe("Collapsing",function(){var $collapseButton;beforeEach(function(){view=new RB.DiffReviewableView({model:model,el:$(diffTableTemplate({chunks:[{type:"equal",startRow:1,numRows:5},{type:"equal",expanded:true,startRow:6,numRows:2},{type:"delete",startRow:10,numRows:5}]}))});view.render().$el.appendTo($container);$collapseButton=view.$(".diff-collapse-btn")});it("Fetching fragment",function(){var options;spyOn(model,"getRenderedDiffFragment");$collapseButton.click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();options=model.getRenderedDiffFragment.calls.argsFor(0)[0];expect(options.chunkIndex).toBe(1);expect(options.linesOfContext).toBe(0)});describe("Injecting HTML",function(){it("Single expanded chunk",function(){var $tbodies;spyOn(model,"getRenderedDiffFragment").and.callFake(function(options,callbacks,context){callbacks.success.call(context,['<tbody class="equal tests-new-chunk">',' <tr line="6">',"  <th></th>","  <td></td>","  <th></th>","  <td></td>"," </tr>","</tbody>"].join(""))});spyOn(view,"trigger").and.callThrough();$collapseButton.click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();$tbodies=view.$("tbody");expect($tbodies.length).toBe(3);expect($($tbodies[0]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("tests-new-chunk")).toBe(true);expect($($tbodies[2]).hasClass("delete")).toBe(true);expect(view._centered._elements.size).toBe(0);expect(view.trigger).toHaveBeenCalledWith("chunkExpansionChanged")});it("Merging adjacent expanded chunks",function(){var $tbodies;spyOn(model,"getRenderedDiffFragment").and.callFake(function(options,callbacks,context){callbacks.success.call(context,['<tbody class="equal tests-new-chunk">',' <tr line="6">',"  <th></th>","  <td></td>","  <th></th>","  <td></td>"," </tr>","</tbody>"].join(""))});spyOn(view,"trigger").and.callThrough();$('<tbody class="equal loaded"/>').append($('<img class="diff-collapse-btn" />')).insertAfter(view.$("tbody")[1]).clone().insertBefore(view.$("tbody")[1]);$collapseButton.click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();$tbodies=view.$("tbody");expect($tbodies.length).toBe(3);expect($($tbodies[0]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("tests-new-chunk")).toBe(true);expect($($tbodies[2]).hasClass("delete")).toBe(true);expect(view._centered._elements.size).toBe(0);expect(view.trigger).toHaveBeenCalledWith("chunkExpansionChanged")})})})});describe("Comment flags",function(){describe("Placing visible comments",function(){var expandedDiffFragmentHTML=['<tbody class="equal tests-new-chunk">',' <tr line="11">',"  <th></th>","  <td>",'   <div class="collapse-floater">','    <img class="diff-collapse-btn"','         data-chunk-index="1"','         data-lines-of-context="0" />',"   </div>","  </td>","  <th></th>","  <td></td>"," </tr>","</tbody>"].join(""),$commentFlags,$rows,diffFragmentHTML;beforeEach(function(){view=new RB.DiffReviewableView({model:new RB.DiffReviewable({reviewRequest:reviewRequest,serializedCommentBlocks:[{linenum:2,num_lines:2,comments:[{issue_opened:false,review_id:1,localdraft:false,text:"Comment 1",comment_id:1,user:{name:"testuser"},line:2}]},{linenum:4,num_lines:1,comments:[{issue_opened:false,review_id:1,localdraft:false,text:"Comment 2",comment_id:1,user:{name:"testuser"},line:4},{issue_opened:false,review_id:1,localdraft:false,text:"Comment 3",comment_id:1,user:{name:"testuser"},line:4}]},{linenum:11,num_lines:1,comments:[{issue_opened:false,review_id:1,localdraft:false,text:"Comment 4",comment_id:1,user:{name:"testuser"},line:12}]}]}),el:$(diffTableTemplate({chunks:[{type:"insert",startRow:1,numRows:10},{type:"collapsed",expandHeaderLines:7}]}))});view.render().$el.appendTo($container);diffFragmentHTML=expandedDiffFragmentHTML;spyOn(view.model,"getRenderedDiffFragment").and.callFake(function(options,callbacks,context){callbacks.success.call(context,diffFragmentHTML)});$commentFlags=view.$(".commentflag");$rows=view.$el.find("tbody tr")});it("On initial render",function(){var $commentFlag;expect($commentFlags.length).toBe(2);expect($($commentFlags[0]).find(".commentflag-count").text()).toBe("1");expect($($commentFlags[1]).find(".commentflag-count").text()).toBe("2");
$commentFlag=$($rows[1]).find(".commentflag");expect($commentFlag.length).toBe(1);expect($commentFlag[0]).toBe($commentFlags[0]);expect($commentFlag.parents("tr").attr("line")).toBe("2");$commentFlag=$($rows[3]).find(".commentflag");expect($commentFlag.length).toBe(1);expect($commentFlag[0]).toBe($commentFlags[1]);expect($commentFlag.parents("tr").attr("line")).toBe("4")});it("On chunk expand",function(){expect($commentFlags.length).toBe(2);view.$(".tests-expand-chunk").click();$commentFlags=view.$(".commentflag");$rows=view.$el.find("tbody tr");expect($commentFlags.length).toBe(3);expect($($commentFlags[2]).find(".commentflag-count").text()).toBe("1");$commentFlag=$($rows[10]).find(".commentflag");expect($commentFlag.length).toBe(1);expect($commentFlag[0]).toBe($commentFlags[2]);expect($commentFlag.parents("tr").attr("line")).toBe("11")});it("On chunk re-expand (after collapsing)",function(){var collapsedDiffFragmentHTML=['<tbody class="diff-header">',$(view.$("tbody")[1]).html(),"</tbody>"].join("");expect($commentFlags.length).toBe(2);view.$(".tests-expand-chunk").click();expect(view.$(".commentflag").length).toBe(3);diffFragmentHTML=collapsedDiffFragmentHTML;view.$(".diff-collapse-btn").click();expect(view.$(".commentflag").length).toBe(2);diffFragmentHTML=expandedDiffFragmentHTML;view.$(".tests-expand-chunk").click();expect(view.$(".commentflag").length).toBe(3);$commentFlags=view.$(".commentflag");$rows=view.$el.find("tbody tr");expect($commentFlags.length).toBe(3);expect($($commentFlags[2]).find(".commentflag-count").text()).toBe("1");$commentFlag=$($rows[10]).find(".commentflag");expect($commentFlag.length).toBe(1);expect($commentFlag[0]).toBe($commentFlags[2]);expect($commentFlag.parents("tr").attr("line")).toBe("11")})})});describe("Methods",function(){describe("toggleWhitespaceOnlyChunks",function(){beforeEach(function(){view=new RB.DiffReviewableView({model:new RB.DiffReviewable({reviewRequest:reviewRequest}),el:$(diffTableTemplate({chunks:[{type:"replace",startRow:1,numRows:5,extraClass:"whitespace-chunk"}]}))});view.render().$el.appendTo($container)});describe("Toggle on",function(){it("Chunk classes",function(){var $tbodies,$tbody,$children;view.toggleWhitespaceOnlyChunks();$tbodies=view.$("tbody");$tbody=$($tbodies[0]);$children=$tbody.children();expect($tbody.hasClass("replace")).toBe(false);expect($($children[0]).hasClass("first")).toBe(true);expect($($children[$children.length-1]).hasClass("last")).toBe(true)});it("chunkDimmed event triggered",function(){spyOn(view,"trigger");view.toggleWhitespaceOnlyChunks();expect(view.trigger).toHaveBeenCalledWith("chunkDimmed","0.0")});it("Whitespace-only file classes",function(){var $tbodies=view.$el.children("tbody"),$whitespaceChunk=$("<tbody/>").addClass("whitespace-file").hide().html("<tr><td></td></tr>").appendTo(view.$el);expect($whitespaceChunk.is(":visible")).toBe(false);expect($tbodies.is(":visible")).toBe(true);view.toggleWhitespaceOnlyChunks();expect($whitespaceChunk.is(":visible")).toBe(true);expect($tbodies.is(":visible")).toBe(false)})});describe("Toggle off",function(){it("Chunk classes",function(){var $tbodies,$tbody,$children;view.toggleWhitespaceOnlyChunks();view.toggleWhitespaceOnlyChunks();$tbodies=view.$("tbody");$tbody=$($tbodies[0]);$children=$tbody.children();expect($tbody.hasClass("replace")).toBe(true);expect($($children[0]).hasClass("first")).toBe(false);expect($($children[$children.length-1]).hasClass("last")).toBe(false)});it("chunkDimmed event triggered",function(){view.toggleWhitespaceOnlyChunks();spyOn(view,"trigger");view.toggleWhitespaceOnlyChunks();expect(view.trigger).toHaveBeenCalledWith("chunkUndimmed","0.0")});it("Whitespace-only file classes",function(){var $tbodies=view.$el.children("tbody"),$whitespaceChunk=$("<tbody/>").addClass("whitespace-file").html("<tr><td></td></tr>").hide().appendTo(view.$el);expect($whitespaceChunk.is(":visible")).toBe(false);expect($tbodies.is(":visible")).toBe(true);view.toggleWhitespaceOnlyChunks();view.toggleWhitespaceOnlyChunks();expect($whitespaceChunk.is(":visible")).toBe(false);expect($tbodies.is(":visible")).toBe(true)})})})})});suite("rb/models/CommentEditor",function(){var editor,reviewRequest,comment;function createComment(){return new RB.BaseComment({parentObject:new RB.BaseResource({"public":true})})}beforeEach(function(){reviewRequest=new RB.ReviewRequest;editor=new RB.CommentEditor({canEdit:true,reviewRequest:reviewRequest})});describe("Attribute defaults",function(){describe("canEdit",function(){it("When logged in and hasDraft=false",function(){RB.UserSession.instance.set("authenticated",true);editor=new RB.CommentEditor({reviewRequest:reviewRequest});expect(editor.get("canEdit")).toBe(true)});it("When logged in and hasDraft=true",function(){RB.UserSession.instance.set("authenticated",true);reviewRequest.set("hasDraft",true);editor=new RB.CommentEditor({reviewRequest:reviewRequest});expect(editor.get("canEdit")).toBe(false)});it("When logged out",function(){RB.UserSession.instance.set("authenticated",false);editor=new RB.CommentEditor({reviewRequest:reviewRequest});expect(editor.get("canEdit")).toBe(false)});it("With explicitly set value",function(){RB.UserSession.instance.set("authenticated",false);editor=new RB.CommentEditor({canEdit:true,reviewRequest:reviewRequest});expect(editor.get("canEdit")).toBe(true)})});describe("openIssue",function(){it("When user preference is true",function(){RB.UserSession.instance.set("commentsOpenAnIssue",true);editor=new RB.CommentEditor({reviewRequest:reviewRequest});expect(editor.get("openIssue")).toBe(true)});it("When user preference is false",function(){RB.UserSession.instance.set("commentsOpenAnIssue",false);editor=new RB.CommentEditor({reviewRequest:reviewRequest});expect(editor.get("openIssue")).toBe(false)});it("With explicitly set value",function(){RB.UserSession.instance.set("commentsOpenAnIssue",false);editor=new RB.CommentEditor({openIssue:true,reviewRequest:reviewRequest});expect(editor.get("openIssue")).toBe(true)});it("When reloading the page with explicitly set value",function(){RB.UserSession.instance.set("commentsOpenAnIssue",true);comment=createComment();comment.set({loaded:false,issueOpened:false});editor=new RB.CommentEditor({comment:comment,reviewRequest:reviewRequest});expect(editor.get("openIssue")).toBe(false)})});describe("richText",function(){it("When user preference is true",function(){RB.UserSession.instance.set("defaultUseRichText",true);editor=new RB.CommentEditor({reviewRequest:reviewRequest});expect(editor.get("richText")).toBe(true)});it("When user preference is false",function(){RB.UserSession.instance.set("defaultUseRichText",false);editor=new RB.CommentEditor({reviewRequest:reviewRequest});expect(editor.get("richText")).toBe(false)});it("With explicitly set value",function(){RB.UserSession.instance.set("defaultUseRichText",false);editor=new RB.CommentEditor({richText:true,reviewRequest:reviewRequest});expect(editor.get("richText")).toBe(true)})})});describe("Loading comment",function(){describe("With comment richText=true",function(){var comment;beforeEach(function(){comment=createComment();comment.set({id:123,loaded:true,richText:true,text:"<p>this _is_ a <em>test</em></p>",rawTextFields:{text:"this \\_is\\_ a _test_"},markdownTextFields:{text:"this \\_is\\_ a _test_"}})});it("When defaultUseRichText=true",function(){RB.UserSession.instance.set("defaultUseRichText",true);editor.set("comment",comment);editor.beginEdit();expect(editor.get("dirty")).toBe(false);expect(editor.get("richText")).toBe(true);expect(editor.get("text")).toBe("this \\_is\\_ a _test_")});it("When defaultUseRichText=false",function(){RB.UserSession.instance.set("defaultUseRichText",false);editor.set("comment",comment);editor.beginEdit();expect(editor.get("dirty")).toBe(false);expect(editor.get("richText")).toBe(true);expect(editor.get("text")).toBe("this \\_is\\_ a _test_")})});describe("With comment richText=false",function(){var comment;beforeEach(function(){comment=createComment();comment.set({id:123,loaded:true,richText:false,text:"<p>this _is_ a test</p>",rawTextFields:{text:"this _is_ a _test_"},markdownTextFields:{text:"this \\_is\\_ a \\_test\\_"}})});it("When defaultUseRichText=true",function(){RB.UserSession.instance.set("defaultUseRichText",true);editor.set("comment",comment);editor.beginEdit();expect(editor.get("dirty")).toBe(false);expect(editor.get("richText")).toBe(true);expect(editor.get("text")).toBe("this \\_is\\_ a \\_test\\_")});it("When defaultUseRichText=false",function(){RB.UserSession.instance.set("defaultUseRichText",false);editor.set("comment",comment);editor.beginEdit();expect(editor.get("dirty")).toBe(false);expect(editor.get("richText")).toBe(false);expect(editor.get("text")).toBe("this _is_ a _test_")})})});describe("Capability states",function(){describe("canDelete",function(){it("When not editing",function(){expect(editor.get("editing")).toBe(false);expect(editor.get("canDelete")).toBe(false)});it("When editing new comment",function(){editor.set("comment",createComment());editor.beginEdit();expect(editor.get("canDelete")).toBe(false)});it("When editing existing comment",function(){var comment=createComment();comment.set({id:123,loaded:true});editor.set("comment",comment);editor.beginEdit();expect(editor.get("canDelete")).toBe(true)});it("When editing existing comment with canEdit=false",function(){var comment=createComment();comment.set({id:123,loaded:true});editor.set({canEdit:false,comment:comment});expect(function(){editor.beginEdit()}).toThrow();expect(console.assert).toHaveBeenCalled();expect(editor.get("canDelete")).toBe(false)})});describe("canSave",function(){it("When not editing",function(){expect(editor.get("editing")).toBe(false);expect(editor.get("canSave")).toBe(false)});it("When editing comment with text",function(){var comment=createComment();editor.set("comment",comment);editor.beginEdit();editor.set("text","Foo");expect(editor.get("canSave")).toBe(true)});it("When editing comment with initial state",function(){var comment=createComment();editor.set("comment",comment);editor.beginEdit();expect(editor.get("canSave")).toBe(false)});it("When editing comment without text",function(){var comment=createComment();editor.set("comment",comment);editor.beginEdit();editor.set("text","");expect(editor.get("canSave")).toBe(false)})})});describe("States",function(){describe("dirty",function(){it("Initial state",function(){expect(editor.get("dirty")).toBe(false)});it("After new comment",function(){var comment=createComment();editor.set("dirty",true);editor.set("comment",comment);expect(editor.get("dirty")).toBe(false)});it("After text change",function(){editor.set("comment",createComment());editor.beginEdit();editor.set("text","abc");expect(editor.get("dirty")).toBe(true)});it("After toggling Open Issue",function(){editor.set("comment",createComment());editor.beginEdit();editor.set("openIssue","true");expect(editor.get("dirty")).toBe(true)});it("After saving",function(){var comment=createComment();editor.set("comment",comment);editor.beginEdit();editor.set("text","abc");expect(editor.get("dirty")).toBe(true);spyOn(comment,"save").and.callFake(function(callbacks,context){callbacks.success.call(context)});editor.save();expect(editor.get("dirty")).toBe(false)});it("After deleting",function(){var comment=createComment();comment.set({id:123,loaded:true});editor.set("comment",comment);editor.beginEdit();editor.set("text","abc");expect(editor.get("dirty")).toBe(true);spyOn(comment,"destroy").and.callFake(function(callbacks,context){if(callbacks&&callbacks.success){callbacks.success.call(context)}});editor.deleteComment();expect(editor.get("dirty")).toBe(false)})})});describe("Operations",function(){it("setExtraData",function(){editor.setExtraData("key1","strvalue");editor.setExtraData("key2",42);expect(editor.get("extraData")).toEqual({key1:"strvalue",key2:42})});it("getExtraData",function(){editor.set("extraData",{mykey:"value"});expect(editor.getExtraData("mykey")).toBe("value")});describe("beginEdit",function(){it("With canEdit=true",function(){editor.set({comment:createComment(),canEdit:true});editor.beginEdit();expect(console.assert.calls.argsFor(0)[0]).toBeTruthy()});it("With canEdit=false",function(){editor.set({comment:createComment(),canEdit:false});expect(function(){editor.beginEdit()}).toThrow();expect(console.assert.calls.argsFor(0)[0]).toBeFalsy()});it("With no comment",function(){expect(function(){editor.beginEdit()}).toThrow();expect(console.assert.calls.argsFor(0)[0]).toBeTruthy();expect(console.assert.calls.argsFor(1)[0]).toBeFalsy()})});describe("cancel",function(){beforeEach(function(){spyOn(editor,"close");spyOn(editor,"trigger")});it("With comment",function(){var comment=createComment();spyOn(comment,"destroyIfEmpty");editor.set("comment",comment);editor.cancel();expect(comment.destroyIfEmpty).toHaveBeenCalled();expect(editor.trigger).toHaveBeenCalledWith("canceled");expect(editor.close).toHaveBeenCalled()});it("Without comment",function(){editor.cancel();expect(editor.trigger).not.toHaveBeenCalledWith("canceled");expect(editor.close).toHaveBeenCalled()})});describe("destroy",function(){var comment;beforeEach(function(){comment=createComment();spyOn(comment,"destroy").and.callFake(function(callbacks,context){if(callbacks&&callbacks.success){callbacks.success.call(context)}});spyOn(editor,"close");spyOn(editor,"trigger")});it("With canDelete=false",function(){editor.set("comment",comment);editor.set("canDelete",false);expect(function(){editor.deleteComment()}).toThrow();expect(console.assert.calls.argsFor(0)[0]).toBeFalsy();expect(comment.destroy).not.toHaveBeenCalled();expect(editor.trigger).not.toHaveBeenCalledWith("deleted");expect(editor.close).not.toHaveBeenCalled()});it("With canDelete=true",function(){editor.set("comment",comment);editor.set("canDelete",true);editor.deleteComment();expect(console.assert.calls.argsFor(0)[0]).toBeTruthy();expect(comment.destroy).toHaveBeenCalled();expect(editor.trigger).toHaveBeenCalledWith("deleted");expect(editor.close).toHaveBeenCalled()})});describe("save",function(){var comment;beforeEach(function(){comment=createComment();spyOn(comment,"save").and.callFake(function(options){if(options&&options.success){options.success()}});spyOn(editor,"trigger")});it("With canSave=false",function(){editor.set("comment",comment);editor.set("canSave",false);expect(function(){editor.save()}).toThrow();expect(console.assert.calls.argsFor(0)[0]).toBeFalsy();expect(comment.save).not.toHaveBeenCalled();expect(editor.trigger).not.toHaveBeenCalledWith("saved")});it("With canSave=true",function(){var text="My text",issue_opened=true;comment.set("issueOpened",false);editor.set("comment",comment);editor.set({text:text,issue_opened:issue_opened,canSave:true,richText:true});editor.setExtraData("mykey","myvalue");editor.save();expect(console.assert.calls.argsFor(0)[0]).toBeTruthy();expect(comment.save).toHaveBeenCalled();expect(comment.get("text")).toBe(text);expect(comment.get("issueOpened")).toBe(issue_opened);expect(comment.get("richText")).toBe(true);expect(comment.get("extraData")).toEqual({mykey:"myvalue",require_verification:false});expect(editor.get("dirty")).toBe(false);expect(editor.trigger).toHaveBeenCalledWith("saved")})})})});suite("rb/models/ExtraData",function(){var model;beforeEach(function(){var Resource=Backbone.Model.extend(_.defaults({defaults:function(){return{extraData:{}}},initialize:function(){this._setupExtraData()}},RB.ExtraDataMixin));model=new Resource});it("change events fired",function(){var callbacks={change:function(){},"change:extraData":function(){}};spyOn(callbacks,"change");spyOn(callbacks,"change:extraData");model.on("change",callbacks.change);model.on("change:extraData",callbacks["change:extraData"]);model.setExtraData("foo",1);expect(callbacks.change).toHaveBeenCalled();expect(callbacks["change:extraData"]).toHaveBeenCalled()});it("attributes updated",function(){var oldExtraData=model.attributes.extraData;expect(model.extraData.attributes).toBe(oldExtraData);model.set({extraData:{foo:1}});expect(model.attributes.extraData).toEqual({foo:1});expect(model.extraData.attributes).toEqual({foo:1});expect(model.extraData.attributes).not.toBe(oldExtraData);expect(model.attributes.extraData).not.toBe(oldExtraData);expect(model.extraData.attributes).toBe(model.attributes.extraData)})});suite("rb/models/ReviewRequestEditor",function(){var reviewRequest,editor;beforeEach(function(){reviewRequest=new RB.ReviewRequest({id:1});editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest})});describe("Methods",function(){describe("createFileAttachment",function(){it("With new FileAttachment",function(){var fileAttachments=editor.get("fileAttachments"),fileAttachment;expect(fileAttachments.length).toBe(0);fileAttachment=editor.createFileAttachment();expect(fileAttachments.length).toBe(1);expect(fileAttachments.at(0)).toBe(fileAttachment)})});describe("decr",function(){it("With integer attribute",function(){editor.set("myint",1);editor.decr("myint");expect(editor.get("myint")).toBe(0)});it("With non-integer attribute",function(){editor.set("foo","abc");expect(function(){editor.decr("foo")}).toThrow();expect(console.assert).toHaveBeenCalled();expect(console.assert.calls.mostRecent().args[0]).toBe(false);expect(editor.get("foo")).toBe("abc")});describe("editCount",function(){it("When > 0",function(){editor.set("editCount",1);editor.decr("editCount");expect(editor.get("editCount")).toBe(0);expect(editor.validationError).toBe(null)});it("When 0",function(){editor.set("editCount",0);editor.decr("editCount");expect(editor.get("editCount")).toBe(0);expect(editor.validationError).toBe(RB.ReviewRequestEditor.strings.UNBALANCED_EDIT_COUNT)})})});describe("incr",function(){it("With integer attribute",function(){editor.set("myint",0);editor.incr("myint");expect(editor.get("myint")).toBe(1)});it("With non-integer attribute",function(){editor.set("foo","abc");expect(function(){editor.incr("foo")}).toThrow();expect(console.assert).toHaveBeenCalled();expect(console.assert.calls.mostRecent().args[0]).toBe(false);expect(editor.get("foo")).toBe("abc")})});describe("getDraftField",function(){var value;it("For closeDescription",function(){reviewRequest.set("closeDescription","Test");value=editor.getDraftField("closeDescription");expect(value).toBe("Test")});it("For closeDescriptionRichText",function(){reviewRequest.set("closeDescriptionRichText",true);value=editor.getDraftField("closeDescriptionRichText");expect(value).toBe(true)});it("For draft fields",function(){reviewRequest.draft.set("description","Test");value=editor.getDraftField("description");expect(value).toBe("Test")});it("For custom fields",function(){var extraData=reviewRequest.draft.get("extraData");extraData.foo="**Test**";extraData.fooRichText=true;value=editor.getDraftField("foo",{useExtraData:true});expect(value).toBe("**Test**");value=editor.getDraftField("fooRichText",{useExtraData:true});expect(value).toBe(true)})});describe("setDraftField",function(){var callbacks,draft;beforeEach(function(){callbacks={error:function(){},success:function(){}};spyOn(callbacks,"error");spyOn(callbacks,"success");draft=editor.get("reviewRequest").draft});describe("When publishing",function(){beforeEach(function(){spyOn(editor,"publishDraft");editor.set({publishing:true,pendingSaveCount:1})});it("Successful saves",function(){spyOn(draft,"save").and.callFake(function(options,context){options.success.call(context)});editor.setDraftField("summary","My Summary",callbacks);expect(callbacks.success).toHaveBeenCalled();expect(editor.get("publishing")).toBe(false);expect(editor.get("pendingSaveCount")).toBe(0);expect(editor.publishDraft).toHaveBeenCalled()});it("Field set errors",function(){spyOn(draft,"save").and.callFake(function(options,context){options.error.call(context,draft,{errorPayload:{fields:{summary:["Something went wrong"]}}})});editor.setDraftField("summary","My Summary",_.defaults({jsonFieldName:"summary"},callbacks));expect(callbacks.error).toHaveBeenCalled();expect(editor.get("publishing")).toBe(false);expect(editor.get("pendingSaveCount")).toBe(1);expect(editor.publishDraft).not.toHaveBeenCalled()})});describe("Rich text fields",function(){describe("changeDescription",function(){describe("Draft description",function(){function testDraftDescription(richText,textType){spyOn(reviewRequest,"close");spyOn(reviewRequest.draft,"save");editor.setDraftField("changeDescription","My description",{allowMarkdown:true,fieldID:"changedescription",richText:richText,jsonFieldName:"changedescription",jsonTextTypeFieldName:"changedescription_text_type"});expect(reviewRequest.close).not.toHaveBeenCalled();expect(reviewRequest.draft.save).toHaveBeenCalled();expect(reviewRequest.draft.save.calls.argsFor(0)[0].data).toEqual({changedescription_text_type:textType,changedescription:"My description",force_text_type:"html",include_text_types:"raw"})}it("For Markdown",function(){testDraftDescription(true,"markdown")});it("For plain text",function(){testDraftDescription(false,"plain")})})})});describe("Special list fields",function(){describe("targetGroups",function(){it("Empty",function(){spyOn(draft,"save").and.callFake(function(options,context){options.success.call(context)});editor.setDraftField("targetGroups","",callbacks);expect(callbacks.success).toHaveBeenCalled()});it("With values",function(){spyOn(draft,"save").and.callFake(function(options,context){options.success.call(context)});editor.setDraftField("targetGroups","group1, group2",callbacks);expect(callbacks.success).toHaveBeenCalled()});it("With invalid groups",function(){spyOn(draft,"save").and.callFake(function(options,context){options.error.call(context,draft,{errorPayload:{fields:{target_groups:["group1","group2"]}}})});editor.setDraftField("targetGroups","group1, group2",_.defaults({jsonFieldName:"target_groups"},callbacks));expect(callbacks.error).toHaveBeenCalledWith({errorText:'Groups "group1" and "group2" do '+"not exist."})})});describe("targetPeople",function(){it("Empty",function(){spyOn(draft,"save").and.callFake(function(options,context){options.success.call(context)});editor.setDraftField("targetPeople","",_.defaults({jsonFieldName:"target_people"},callbacks));expect(callbacks.success).toHaveBeenCalled()});it("With values",function(){spyOn(draft,"save").and.callFake(function(options,context){options.success.call(context)});editor.setDraftField("targetPeople","user1, user2",_.defaults({jsonFieldName:"target_people"},callbacks));expect(callbacks.success).toHaveBeenCalled()});it("With invalid users",function(){spyOn(draft,"save").and.callFake(function(options,context){options.error.call(context,draft,{errorPayload:{fields:{target_people:["user1","user2"]}}})});editor.setDraftField("targetPeople","user1, user2",_.defaults({jsonFieldName:"target_people"},callbacks));expect(callbacks.error).toHaveBeenCalledWith({errorText:'Users "user1" and "user2" do not exist.'})})});describe("submitter",function(){it("Empty",function(){spyOn(draft,"save").and.callFake(function(options,context){options.success.call(context)});editor.setDraftField("submitter","",_.defaults({jsonFieldName:"submitter"},callbacks));expect(callbacks.success).toHaveBeenCalled()});it("With value",function(){spyOn(draft,"save").and.callFake(function(options,context){options.success.call(context)});editor.setDraftField("submitter","user1",_.defaults({jsonFieldName:"submitter"},callbacks));expect(callbacks.success).toHaveBeenCalled()});it("With invalid user",function(){spyOn(draft,"save").and.callFake(function(options,context){options.error.call(context,draft,{errorPayload:{fields:{submitter:["user1"]}}})});editor.setDraftField("submitter","user1",_.defaults({jsonFieldName:"submitter"},callbacks));expect(callbacks.error).toHaveBeenCalledWith({errorText:'User "user1" does not exist.'})})})});describe("Custom fields",function(){describe("Rich text fields",function(){function testFields(richText,textType){spyOn(reviewRequest.draft,"save");editor.setDraftField("myField","Test text.",{allowMarkdown:true,useExtraData:true,fieldID:"myfield",richText:richText,jsonFieldName:"myfield",jsonTextTypeFieldName:"myfield_text_type"});expect(reviewRequest.draft.save).toHaveBeenCalled();expect(reviewRequest.draft.save.calls.argsFor(0)[0].data).toEqual({"extra_data.myfield_text_type":textType,"extra_data.myfield":"Test text.",force_text_type:"html",include_text_types:"raw"})}it("For Markdown",function(){testFields(true,"markdown")});it("For plain text",function(){testFields(false,"plain")})})})})});describe("Reviewed objects",function(){describe("File attachments",function(){it("Removed when destroyed",function(){var fileAttachments=editor.get("fileAttachments"),fileAttachment=editor.createFileAttachment(),draft=editor.get("reviewRequest").draft;spyOn(draft,"ensureCreated").and.callFake(function(options,context){options.success.call(context)});expect(fileAttachments.at(0)).toBe(fileAttachment);fileAttachment.destroy();expect(fileAttachments.length).toBe(0)})});describe("Screenshots",function(){it("Removed when destroyed",function(){var screenshots=editor.get("screenshots"),screenshot=reviewRequest.createScreenshot();screenshots.add(screenshot);expect(screenshots.at(0)).toBe(screenshot);screenshot.destroy();expect(screenshots.length).toBe(0)})})});describe("Events",function(){describe("saved",function(){it("When new file attachment saved",function(){var fileAttachment=editor.createFileAttachment();spyOn(editor,"trigger");fileAttachment.trigger("saved");expect(editor.trigger).toHaveBeenCalledWith("saved")});it("When new file attachment destroyed",function(){var fileAttachment=editor.createFileAttachment(),draft=editor.get("reviewRequest").draft;spyOn(draft,"ensureCreated").and.callFake(function(options,context){options.success.call(context)});spyOn(editor,"trigger");fileAttachment.destroy();expect(editor.trigger).toHaveBeenCalledWith("saved")});it("When existing file attachment saved",function(){var fileAttachment=reviewRequest.draft.createFileAttachment();editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest,fileAttachments:new Backbone.Collection([fileAttachment])});spyOn(editor,"trigger");fileAttachment.trigger("saved");expect(editor.trigger).toHaveBeenCalledWith("saved")});it("When existing file attachment destroyed",function(){var fileAttachment=reviewRequest.draft.createFileAttachment();editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest,fileAttachments:new Backbone.Collection([fileAttachment])});spyOn(reviewRequest.draft,"ensureCreated").and.callFake(function(options,context){options.success.call(context)});spyOn(editor,"trigger");fileAttachment.destroy();expect(editor.trigger).toHaveBeenCalledWith("saved")});it("When existing screenshot saved",function(){var screenshot=reviewRequest.createScreenshot();editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest,screenshots:new Backbone.Collection([screenshot])});spyOn(editor,"trigger");screenshot.trigger("saved");expect(editor.trigger).toHaveBeenCalledWith("saved")});it("When existing screenshot destroyed",function(){var screenshot=reviewRequest.createScreenshot();editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest,screenshots:new Backbone.Collection([screenshot])});spyOn(reviewRequest.draft,"ensureCreated").and.callFake(function(options,context){options.success.call(context)});spyOn(editor,"trigger");screenshot.destroy();expect(editor.trigger).toHaveBeenCalledWith("saved")})});describe("saving",function(){it("When new file attachment saving",function(){var fileAttachment=editor.createFileAttachment();spyOn(editor,"trigger");fileAttachment.trigger("saving");expect(editor.trigger).toHaveBeenCalledWith("saving")});it("When existing file attachment saving",function(){var fileAttachment=reviewRequest.draft.createFileAttachment();editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest,fileAttachments:new Backbone.Collection([fileAttachment])});spyOn(editor,"trigger");fileAttachment.trigger("saving");expect(editor.trigger).toHaveBeenCalledWith("saving")});it("When screenshot saving",function(){var screenshot=reviewRequest.createScreenshot();editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest,screenshots:new Backbone.Collection([screenshot])});spyOn(editor,"trigger");screenshot.trigger("saving");expect(editor.trigger).toHaveBeenCalledWith("saving")})})})});suite("rb/models/uploadDiffModel",function(){var reviewRequest,updateDiffView;beforeEach(function(){reviewRequest=new RB.ReviewRequest({id:123});updateDiffView=new RB.UpdateDiffView({model:new RB.UploadDiffModel({changeNumber:reviewRequest.get("commitID"),repository:reviewRequest.get("repository"),reviewRequest:reviewRequest}),el:$("#scratch")})});describe("Updating Review Requests",function(){it('"Start Over" doesn\'t change reviewRequest attribute',function(){spyOn(updateDiffView.model,"startOver").and.callThrough();updateDiffView.model.startOver();expect(updateDiffView.model.attributes.reviewRequest).toBe(reviewRequest)})})});suite("rb/models/UserSession",function(){describe("create",function(){it("Instance is set",function(){var session;RB.UserSession.instance=null;session=RB.UserSession.create({username:"testuser"});expect(session).toBe(RB.UserSession.instance)});it("Second attempt fails",function(){RB.UserSession.instance=null;RB.UserSession.create({username:"testuser"});expect(console.assert).toHaveBeenCalled();expect(console.assert.calls.argsFor(0)[0]).toBeTruthy();expect(function(){RB.UserSession.create({username:"foo"})}).toThrow();expect(console.assert).toHaveBeenCalled();expect(console.assert.calls.argsFor(1)[0]).toBeFalsy()})});describe("Attributes",function(){var session;beforeEach(function(){session=RB.UserSession.instance});describe("diffsShowExtraWhitespace",function(){describe("Loads from cookie",function(){it('When "true"',function(){spyOn($,"cookie").and.returnValue("true");RB.UserSession.instance=null;session=RB.UserSession.create({username:"testuser"});expect($.cookie).toHaveBeenCalledWith("show_ew");expect(session.get("diffsShowExtraWhitespace")).toBe(true)});it('When "false"',function(){spyOn($,"cookie").and.returnValue("false");RB.UserSession.instance=null;session=RB.UserSession.create({username:"testuser"});expect($.cookie).toHaveBeenCalledWith("show_ew");expect(session.get("diffsShowExtraWhitespace")).toBe(false)})});describe("Sets cookie",function(){beforeEach(function(){spyOn($,"cookie")});it("When true",function(){session.attributes.diffsShowExtraWhitespace=false;session.set("diffsShowExtraWhitespace",true);expect($.cookie).toHaveBeenCalledWith("show_ew","true",{path:SITE_ROOT})});it("When false",function(){session.attributes.diffsShowExtraWhitespace=true;session.set("diffsShowExtraWhitespace",false);expect($.cookie).toHaveBeenCalledWith("show_ew","false",{path:SITE_ROOT})})})})})});suite("rb/newReviewRequest/views/BranchesView",function(){var collection,view;beforeEach(function(){collection=new RB.RepositoryBranches([{name:"master",commit:"8088295174d8d46af7700ddf4522e3a703724106",isDefault:true},{name:"release-1.7.x",commit:"5e6707050f7cb29ed50fafd3b92bffb1e15df19f",isDefault:false},{name:"release-1.6.x",commit:"a15d0e635064a2e1929ce1bf3bc8d4aa65738b64",isDefault:false}]);view=new RB.BranchesView({collection:collection})});describe("Rendering",function(){it("With items",function(){view.render();expect(view.$el.html()).toBe('<option selected="selected">master</option>'+"<option>release-1.7.x</option>"+"<option>release-1.6.x</option>")})});describe("Selected event",function(){it("When clicked",function(){var children;view.render();view.on("selected",function(branch){expect(branch.get("name")).toBe("release-1.7.x")});children=view.$el.children();$(children[0]).attr("selected",false);$(children[1]).attr("selected",true);view.$el.change();expect(view.$el.html()).toBe("<option>master</option>"+'<option selected="selected">release-1.7.x</option>'+"<option>release-1.6.x</option>")})})});suite("rb/newReviewRequest/views/PostCommitView",function(){var repository,commits,model,view;
beforeEach(function(){repository=new RB.Repository({name:"Repo",supportsPostCommit:true});spyOn(repository.branches,"sync").and.callFake(function(method,collection,options){options.success({stat:"ok",branches:[{name:"master",commit:"859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817","default":true},{name:"release-1.7.x",commit:"92463764015ef463b4b6d1a1825fee7aeec8cb15","default":false},{name:"release-1.6.x",commit:"a15d0e635064a2e1929ce1bf3bc8d4aa65738b64","default":false}]})});spyOn(repository,"getCommits").and.callFake(function(options){commits=new RB.RepositoryCommits([],{urlBase:_.result(this,"url")+"commits/",start:options.start,branch:options.branch});spyOn(commits,"sync").and.callFake(function(method,collection,options){options.success({stat:"ok",commits:[{authorName:"Author 1",date:"2013-07-22T03:51:50Z",id:"3",message:"Summary 1\n\nMessage 1"},{authorName:"Author 2",date:"2013-07-22T03:50:46Z",id:"2",message:"Summary 2\n\nMessage 2"},{authorName:"Author 3",date:"2013-07-21T08:05:45Z",id:"1",message:"Summary 3\n\nMessage 3"}]})});return commits});model=new RB.PostCommitModel({repository:repository});view=new RB.PostCommitView({model:model});spyOn(RB.PostCommitView.prototype,"_onCreateReviewRequest").and.callThrough();expect(repository.branches.sync).toHaveBeenCalled()});it("Render",function(){view.render();expect(commits.sync).toHaveBeenCalled();expect(view._branchesView.$el.children().length).toBe(3);expect(view._commitsView.$el.children().length).toBe(3)});it("Create",function(){var commit,call;view.render();spyOn(RB.ReviewRequest.prototype,"save").and.returnValue();commit=commits.models[1];commit.trigger("create",commit);expect(RB.PostCommitView.prototype._onCreateReviewRequest).toHaveBeenCalled();expect(RB.ReviewRequest.prototype.save).toHaveBeenCalled();expect(RB.ReviewRequest.prototype.save.calls.count()).toBe(1);call=RB.ReviewRequest.prototype.save.calls.mostRecent();expect(call.object.get("commitID")).toBe(commit.get("id"))});describe("Error handling",function(){describe("Branches",function(){var xhr={errorText:"Oh no"},returnError;beforeEach(function(){spyOn(repository.branches,"fetch").and.callFake(function(options,context){if(returnError){options.error.call(context,repository.branches,xhr)}else{options.success.call(context)}});returnError=true;spyOn(RB.PostCommitView.prototype,"_showLoadError").and.callThrough();view._loadBranches()});it("UI state",function(){expect(repository.branches.fetch).toHaveBeenCalled();expect(view._showLoadError).toHaveBeenCalledWith("branches",xhr);expect(view._branchesView.$el.css("display")).toBe("none");expect(view._$error).toBeTruthy();expect(view._$error.length).toBe(1);expect(view._commitsView).toBeFalsy();expect(view._$error.find(".error-text").text().strip()).toBe("Oh no");expect(view._$error.find("a")[0].id).toBe("reload_branches")});it("Reloading",function(){var $reload;spyOn(view,"_loadBranches").and.callThrough();view.delegateEvents();returnError=false;expect(view._$error).toBeTruthy();$reload=view._$error.find("#reload_branches");expect($reload.length).toBe(1);$reload.click();expect(view._loadBranches).toHaveBeenCalled();expect(view._$error).toBe(null);expect(view._branchesView.$el.css("display")).not.toBe("none")})});describe("Commits",function(){var xhr={errorText:"Oh no"},returnError;beforeEach(function(){view.render();spyOn(RB.RepositoryCommits.prototype,"fetch").and.callFake(function(options,context){if(returnError){options.error.call(context,repository.commits,xhr)}else{options.success.call(context)}});returnError=true;spyOn(RB.PostCommitView.prototype,"_showLoadError").and.callThrough();view._loadCommits()});it("UI state",function(){expect(view._commitsCollection.fetch).toHaveBeenCalled();expect(view._showLoadError).toHaveBeenCalledWith("commits",xhr);expect(view._commitsView.$el.css("display")).toBe("none");expect(view._$error).toBeTruthy();expect(view._$error.length).toBe(1);expect(view._commitsView).toBeTruthy();expect(view._commitsView.$el.css("display")).toBe("none");expect(view._$error.find(".error-text").text().strip()).toBe("Oh no");expect(view._$error.find("a")[0].id).toBe("reload_commits")});it("Reloading",function(){var $reload;spyOn(view,"_loadCommits").and.callThrough();view.delegateEvents();returnError=false;expect(view._$error).toBeTruthy();$reload=view._$error.find("#reload_commits");expect($reload.length).toBe(1);$reload.click();expect(view._loadCommits).toHaveBeenCalled();expect(view._$error).toBe(null);expect(view._commitsView.$el.css("display")).toBe("block")})})})});suite("rb/newReviewRequest/views/RepositorySelectionView",function(){var collection,view;beforeEach(function(){collection=new Backbone.Collection([{name:"Repo 1"},{name:"Repo 2"},{name:"Repo 3"}],{model:RB.Repository});view=new RB.RepositorySelectionView({collection:collection})});describe("Rendering",function(){it("With items",function(){var children,i,count,name;view.render();children=view.$el.children(".repository");count=children.length;expect(count).toBe(collection.models.length);for(i=0;i<count;i++){name=collection.models[i].get("name");expect($(children[i]).text()).toBe(name)}})});describe("Selected event",function(){it("When clicked",function(){var children;view.render();view.on("selected",function(repository){expect(repository.get("name")).toBe("Repo 2")});children=view.$el.children(".repository");$(children[1]).click()})})});"use strict";suite("rb/pages/models/DiffViewerPage",function(){describe("parse",function(){it("{}",function(){var page=new RB.DiffViewerPage({},{parse:true});expect(page.get("reviewRequest")).toBeTruthy();expect(page.get("pendingReview")).toBeTruthy();expect(page.get("lastActivityTimestamp")).toBe(null);expect(page.get("checkForUpdates")).toBe(false);expect(page.get("checkUpdatesType")).toBe(null);expect(page.get("numDiffs")).toBe(0);expect(page.commentsHint).not.toBe(null);expect(page.files).not.toBe(null);expect(page.pagination).not.toBe(null);expect(page.revision).not.toBe(null);expect(page.get("editorData")).toBe(undefined);expect(page.get("reviewRequestData")).toBe(undefined)});it("reviewRequestData",function(){var page=new RB.DiffViewerPage({reviewRequestData:{bugTrackerURL:"http://bugs.example.com/--bug_id--/",id:123,localSitePrefix:"s/foo/",branch:"my-branch",bugsClosed:[101,102,103],closeDescription:"This is closed",closeDescriptionRichText:true,description:"This is a description",descriptionRichText:true,hasDraft:true,lastUpdatedTimestamp:"2017-08-23T15:10:20Z","public":true,repository:{id:200,name:"My repo",requiresBasedir:true,requiresChangeNumber:true,scmtoolName:"My Tool",supportsPostCommit:true},reviewURL:"/s/foo/r/123/",state:"CLOSE_SUBMITTED",summary:"This is a summary",targetGroups:[{name:"Some group",url:"/s/foo/groups/some-group/"}],targetPeople:[{username:"some-user",url:"/s/foo/users/some-user/"}],testingDone:"This is testing done",testingDoneRichText:true,visibility:"ARCHIVED"}},{parse:true});expect(page.get("pendingReview")).toBeTruthy();expect(page.get("checkForUpdates")).toBe(false);expect(page.get("reviewRequestData")).toBe(undefined);var reviewRequest=page.get("reviewRequest");expect(reviewRequest).toBeTruthy();expect(reviewRequest.id).toBe(123);expect(reviewRequest.url()).toBe("/s/foo/api/review-requests/123/");expect(reviewRequest.get("bugTrackerURL")).toBe("http://bugs.example.com/--bug_id--/");expect(reviewRequest.get("localSitePrefix")).toBe("s/foo/");expect(reviewRequest.get("branch")).toBe("my-branch");expect(reviewRequest.get("bugsClosed")).toEqual([101,102,103]);expect(reviewRequest.get("closeDescription")).toBe("This is closed");expect(reviewRequest.get("closeDescriptionRichText")).toBe(true);expect(reviewRequest.get("description")).toBe("This is a description");expect(reviewRequest.get("descriptionRichText")).toBe(true);expect(reviewRequest.get("hasDraft")).toBe(true);expect(reviewRequest.get("lastUpdatedTimestamp")).toBe("2017-08-23T15:10:20Z");expect(reviewRequest.get("public")).toBe(true);expect(reviewRequest.get("reviewURL")).toBe("/s/foo/r/123/");expect(reviewRequest.get("state")).toBe(RB.ReviewRequest.CLOSE_SUBMITTED);expect(reviewRequest.get("summary")).toBe("This is a summary");expect(reviewRequest.get("targetGroups")).toEqual([{name:"Some group",url:"/s/foo/groups/some-group/"}]);expect(reviewRequest.get("targetPeople")).toEqual([{username:"some-user",url:"/s/foo/users/some-user/"}]);expect(reviewRequest.get("testingDone")).toBe("This is testing done");expect(reviewRequest.get("testingDoneRichText")).toBe(true);expect(reviewRequest.get("visibility")).toBe(RB.ReviewRequest.VISIBILITY_ARCHIVED);var repository=reviewRequest.get("repository");expect(repository.id).toBe(200);expect(repository.get("name")).toBe("My repo");expect(repository.get("requiresBasedir")).toBe(true);expect(repository.get("requiresChangeNumber")).toBe(true);expect(repository.get("scmtoolName")).toBe("My Tool");expect(repository.get("supportsPostCommit")).toBe(true)});it("extraReviewRequestDraftData",function(){var page=new RB.DiffViewerPage({extraReviewRequestDraftData:{changeDescription:"Draft change description",changeDescriptionRichText:true,interdiffLink:"/s/foo/r/123/diff/1-2/"}},{parse:true});expect(page.get("pendingReview")).toBeTruthy();expect(page.get("checkForUpdates")).toBe(false);expect(page.get("reviewRequestData")).toBe(undefined);var draft=page.get("reviewRequest").draft;expect(draft.get("changeDescription")).toBe("Draft change description");expect(draft.get("changeDescriptionRichText")).toBe(true);expect(draft.get("interdiffLink")).toBe("/s/foo/r/123/diff/1-2/")});it("editorData",function(){var page=new RB.DiffViewerPage({editorData:{changeDescriptionRenderedText:"Change description",closeDescriptionRenderedText:"This is closed",hasDraft:true,mutableByUser:true,showSendEmail:true,statusMutableByUser:true}},{parse:true});expect(page.get("pendingReview")).toBeTruthy();expect(page.get("checkForUpdates")).toBe(false);expect(page.get("editorData")).toBe(undefined);var editor=page.reviewRequestEditor;expect(editor.get("changeDescriptionRenderedText")).toBe("Change description");expect(editor.get("closeDescriptionRenderedText")).toBe("This is closed");expect(editor.get("hasDraft")).toBe(true);expect(editor.get("mutableByUser")).toBe(true);expect(editor.get("showSendEmail")).toBe(true);expect(editor.get("statusMutableByUser")).toBe(true)});it("lastActivityTimestamp",function(){var page=new RB.DiffViewerPage({lastActivityTimestamp:"2017-08-22T18:20:30Z",checkUpdatesType:"diff"},{parse:true});expect(page.get("lastActivityTimestamp")).toBe("2017-08-22T18:20:30Z")});it("checkUpdatesType",function(){var page=new RB.DiffViewerPage({checkUpdatesType:"diff"},{parse:true});expect(page.get("pendingReview")).toBeTruthy();expect(page.get("checkUpdatesType")).toBe("diff")});it("comments_hint",function(){var page=new RB.DiffViewerPage({comments_hint:{diffsets_with_comments:[{revision:1,is_current:false}],has_other_comments:true,interdiffs_with_comments:[{old_revision:1,new_revision:2,is_current:true}]}},{parse:true});var commentsHint=page.commentsHint;expect(commentsHint.get("hasOtherComments")).toBe(true);expect(commentsHint.get("diffsetsWithComments")).toEqual([{revision:1,isCurrent:false}]);expect(commentsHint.get("interdiffsWithComments")).toEqual([{oldRevision:1,newRevision:2,isCurrent:true}])})});describe("loadDiffRevision",function(){var page=void 0;beforeEach(function(){page=new RB.DiffViewerPage({reviewRequestData:{id:123}},{parse:true});spyOn($,"ajax").and.callFake(function(url){var query={};var queryParams=url.split("?")[1].split("&");for(var i=0;i<queryParams.length;i++){var pair=queryParams[i].split("=");query[decodeURIComponent(pair[0])]=decodeURIComponent(pair[1])}return{done:function done(cb){return cb({diff_context:{revision:{revision:query.revision,interdiff_revision:query["interdiff-revision"]||null}}})}}})});describe("Generates URL for",function(){it("First page, normal diffs",function(){page.loadDiffRevision({page:1,revision:1});expect($.ajax).toHaveBeenCalledWith("/api/review-requests/123/diff-context/?revision=1")});it("Other page, normal diffs",function(){page.loadDiffRevision({page:2,revision:1});expect($.ajax).toHaveBeenCalledWith("/api/review-requests/123/diff-context/"+"?revision=1&page=2")});it("First page, interdiffs",function(){page.loadDiffRevision({page:1,revision:1,interdiffRevision:2});expect($.ajax).toHaveBeenCalledWith("/api/review-requests/123/diff-context/"+"?revision=1&interdiff-revision=2")});it("Other page, interdiffs",function(){page.loadDiffRevision({page:2,revision:1,interdiffRevision:2});expect($.ajax).toHaveBeenCalledWith("/api/review-requests/123/diff-context/"+"?revision=1&interdiff-revision=2&page=2")});it("Filename patterns",function(){page.loadDiffRevision({page:2,revision:1,filenamePatterns:"*.txt,src/*"});expect($.ajax).toHaveBeenCalledWith("/api/review-requests/123/diff-context/"+"?revision=1&page=2&filenames=*.txt%2Csrc%2F*")})});describe("Sets canDownloadDiff to",function(){it("true for normal diffs",function(){page.loadDiffRevision({revision:1});expect(page.get("canDownloadDiff")).toBe(true)});it("false for interdiffs",function(){page.loadDiffRevision({revision:1,interdiffRevision:2});expect(page.get("canDownloadDiff")).toBe(false)})})})});suite("rb/pages/models/PageManager",function(){var pageManager,page;beforeEach(function(){pageManager=new RB.PageManager;page=new Backbone.View;spyOn(page,"render")});describe("Instance",function(){var callbacks,expectedRender;beforeEach(function(){expectedRender=false;callbacks={cb:function(_page){expect(_page).toBe(page);expect(pageManager.get("rendered")).toBe(expectedRender)}};spyOn(callbacks,"cb")});describe("Methods",function(){describe("beforeReady",function(){it("Without page set",function(){pageManager.beforeRender(callbacks.cb);expect(callbacks.cb).not.toHaveBeenCalled();pageManager.set("page",page);expect(callbacks.cb).toHaveBeenCalled()});it("With page set, not rendered",function(){pageManager.set("page",page);pageManager.set("rendered",false);pageManager.beforeRender(callbacks.cb);expect(callbacks.cb).toHaveBeenCalled()});it("With page set, rendered",function(){pageManager.set({page:page,rendered:true});expect(function(){pageManager.beforeRender(callbacks.cb)}).toThrow();expect(callbacks.cb).not.toHaveBeenCalled()})});describe("ready",function(){it("Without page set",function(){pageManager.ready(callbacks.cb);expect(callbacks.cb).not.toHaveBeenCalled();pageManager.set("page",page);expect(pageManager.get("rendered")).toBe(true);expect(page.render).toHaveBeenCalled();expect(callbacks.cb).toHaveBeenCalled()});it("With page set, not rendered",function(){spyOn(pageManager,"_renderPage");pageManager.set("page",page);expect(pageManager.get("rendered")).toBe(false);expect(page.render).not.toHaveBeenCalled();pageManager.ready(callbacks.cb);expect(callbacks.cb).not.toHaveBeenCalled()});it("With page set, rendered",function(){pageManager.set("page",page);expect(pageManager.get("rendered")).toBe(true);expect(page.render).toHaveBeenCalled();pageManager.ready(callbacks.cb);expect(callbacks.cb).toHaveBeenCalled()})})})});describe("Class methods",function(){var oldInstance;beforeEach(function(){oldInstance=RB.PageManager.instance;RB.PageManager.instance=pageManager});afterEach(function(){RB.PageManager.instance=oldInstance});it("beforeRender",function(){spyOn(RB.PageManager.instance,"beforeRender");RB.PageManager.beforeRender(1,2);expect(RB.PageManager.instance.beforeRender).toHaveBeenCalledWith(1,2)});it("ready",function(){spyOn(RB.PageManager.instance,"ready");RB.PageManager.ready(1,2);expect(RB.PageManager.instance.ready).toHaveBeenCalledWith(1,2)});it("setPage",function(){var page=new Backbone.View;RB.PageManager.setPage(page);expect(pageManager.get("page")).toBe(page)});it("getPage",function(){var page=new Backbone.View;pageManager.set("page",page);expect(RB.PageManager.getPage()).toBe(page)})})});"use strict";suite("rb/pages/models/ReviewablePage",function(){describe("Construction",function(){it("Child objects created",function(){var reviewRequest=new RB.ReviewRequest;var page=new RB.ReviewablePage({reviewRequest:reviewRequest,pendingReview:new RB.Review,editorData:{showSendEmail:false,hasDraft:true}});expect(page.commentIssueManager).toBeTruthy();expect(page.commentIssueManager.get("reviewRequest")).toBe(reviewRequest);expect(page.reviewRequestEditor.get("commentIssueManager")).toBe(page.commentIssueManager);expect(page.reviewRequestEditor.get("reviewRequest")).toBe(reviewRequest);expect(page.reviewRequestEditor.get("showSendEmail")).toBe(false);expect(page.reviewRequestEditor.get("hasDraft")).toBe(true)})});describe("parse",function(){it("{}",function(){var page=new RB.ReviewablePage({},{parse:true});expect(page.get("reviewRequest")).toBeTruthy();expect(page.get("pendingReview")).toBeTruthy();expect(page.get("lastActivityTimestamp")).toBe(null);expect(page.get("checkForUpdates")).toBe(false);expect(page.get("checkUpdatesType")).toBe(null);expect(page.get("editorData")).toBe(undefined);expect(page.get("reviewRequestData")).toBe(undefined)});it("reviewRequestData",function(){var page=new RB.ReviewablePage({reviewRequestData:{bugTrackerURL:"http://bugs.example.com/--bug_id--/",id:123,localSitePrefix:"s/foo/",branch:"my-branch",bugsClosed:[101,102,103],closeDescription:"This is closed",closeDescriptionRichText:true,description:"This is a description",descriptionRichText:true,hasDraft:true,lastUpdatedTimestamp:"2017-08-23T15:10:20Z","public":true,repository:{id:200,name:"My repo",requiresBasedir:true,requiresChangeNumber:true,scmtoolName:"My Tool",supportsPostCommit:true},reviewURL:"/s/foo/r/123/",state:"CLOSE_SUBMITTED",summary:"This is a summary",targetGroups:[{name:"Some group",url:"/s/foo/groups/some-group/"}],targetPeople:[{username:"some-user",url:"/s/foo/users/some-user/"}],testingDone:"This is testing done",testingDoneRichText:true,visibility:"ARCHIVED"}},{parse:true});expect(page.get("pendingReview")).toBeTruthy();expect(page.get("checkForUpdates")).toBe(false);expect(page.get("reviewRequestData")).toBe(undefined);var reviewRequest=page.get("reviewRequest");expect(reviewRequest).toBeTruthy();expect(reviewRequest.id).toBe(123);expect(reviewRequest.url()).toBe("/s/foo/api/review-requests/123/");expect(reviewRequest.get("bugTrackerURL")).toBe("http://bugs.example.com/--bug_id--/");expect(reviewRequest.get("localSitePrefix")).toBe("s/foo/");expect(reviewRequest.get("branch")).toBe("my-branch");expect(reviewRequest.get("bugsClosed")).toEqual([101,102,103]);expect(reviewRequest.get("closeDescription")).toBe("This is closed");expect(reviewRequest.get("closeDescriptionRichText")).toBe(true);expect(reviewRequest.get("description")).toBe("This is a description");expect(reviewRequest.get("descriptionRichText")).toBe(true);expect(reviewRequest.get("hasDraft")).toBe(true);expect(reviewRequest.get("lastUpdatedTimestamp")).toBe("2017-08-23T15:10:20Z");expect(reviewRequest.get("public")).toBe(true);expect(reviewRequest.get("reviewURL")).toBe("/s/foo/r/123/");expect(reviewRequest.get("state")).toBe(RB.ReviewRequest.CLOSE_SUBMITTED);expect(reviewRequest.get("summary")).toBe("This is a summary");expect(reviewRequest.get("targetGroups")).toEqual([{name:"Some group",url:"/s/foo/groups/some-group/"}]);expect(reviewRequest.get("targetPeople")).toEqual([{username:"some-user",url:"/s/foo/users/some-user/"}]);expect(reviewRequest.get("testingDone")).toBe("This is testing done");expect(reviewRequest.get("testingDoneRichText")).toBe(true);expect(reviewRequest.get("visibility")).toBe(RB.ReviewRequest.VISIBILITY_ARCHIVED);var repository=reviewRequest.get("repository");expect(repository.id).toBe(200);expect(repository.get("name")).toBe("My repo");expect(repository.get("requiresBasedir")).toBe(true);expect(repository.get("requiresChangeNumber")).toBe(true);expect(repository.get("scmtoolName")).toBe("My Tool");expect(repository.get("supportsPostCommit")).toBe(true)});it("extraReviewRequestDraftData",function(){var page=new RB.ReviewablePage({extraReviewRequestDraftData:{changeDescription:"Draft change description",changeDescriptionRichText:true,interdiffLink:"/s/foo/r/123/diff/1-2/"}},{parse:true});expect(page.get("pendingReview")).toBeTruthy();expect(page.get("checkForUpdates")).toBe(false);expect(page.get("reviewRequestData")).toBe(undefined);var draft=page.get("reviewRequest").draft;expect(draft.get("changeDescription")).toBe("Draft change description");expect(draft.get("changeDescriptionRichText")).toBe(true);expect(draft.get("interdiffLink")).toBe("/s/foo/r/123/diff/1-2/")});it("editorData",function(){var page=new RB.ReviewablePage({editorData:{changeDescriptionRenderedText:"Change description",closeDescriptionRenderedText:"This is closed",hasDraft:true,mutableByUser:true,showSendEmail:true,statusMutableByUser:true}},{parse:true});expect(page.get("pendingReview")).toBeTruthy();expect(page.get("checkForUpdates")).toBe(false);expect(page.get("editorData")).toBe(undefined);var editor=page.reviewRequestEditor;expect(editor.get("changeDescriptionRenderedText")).toBe("Change description");expect(editor.get("closeDescriptionRenderedText")).toBe("This is closed");expect(editor.get("hasDraft")).toBe(true);expect(editor.get("mutableByUser")).toBe(true);expect(editor.get("showSendEmail")).toBe(true);expect(editor.get("statusMutableByUser")).toBe(true)});it("lastActivityTimestamp",function(){var page=new RB.ReviewablePage({lastActivityTimestamp:"2017-08-22T18:20:30Z",checkUpdatesType:"diff"},{parse:true});expect(page.get("lastActivityTimestamp")).toBe("2017-08-22T18:20:30Z")});it("checkUpdatesType",function(){var page=new RB.ReviewablePage({checkUpdatesType:"diff"},{parse:true});expect(page.get("pendingReview")).toBeTruthy();expect(page.get("checkUpdatesType")).toBe("diff")})});describe("Actions",function(){it("markShipIt",function(){var page=new RB.ReviewablePage({},{parse:true});var pendingReview=page.get("pendingReview");spyOn(pendingReview,"ready").and.callFake(function(callbacks){return callbacks.ready()});spyOn(pendingReview,"publish");page.markShipIt();expect(pendingReview.publish).toHaveBeenCalled();expect(pendingReview.get("shipIt")).toBe(true);expect(pendingReview.get("bodyTop")).toBe("Ship It!")})})});"use strict";suite("rb/pages/views/DiffViewerPageView",function(){var tableTemplate=_.template('<div class="diff-container">\n <table class="sidebyside">\n  <thead>\n   <tr class="filename-row">\n    <th colspan="4">\n     <a name="<%- fileID %>" class="file-anchor"></a>\n    </th>\n   </tr>\n  </thead>\n  <% _.each(chunks, function(chunk) { %>\n   <tbody class="<%- chunk.type %>">\n    <% _.each(chunk.lines, function(line, i) { %>\n     <tr line="<%- line.vNumber %>">\n      <th>\n       <% if (i === 0 && chunk.type !== "equal") { %>\n        <a name="<%- chunk.id %>" class="chunk-anchor"></a>\n       <% } %>\n       <%- line.leftNumber || "" %>\n      </th>\n      <td class="l"></td>\n      <th><%- line.rightNumber || "" %></th>\n      <td class="r"></td>\n     </tr>\n    <% }); %>\n   </tbody>\n  <% }); %>\n </table>\n</div>');var pageTemplate='<div>\n <div id="review-banner"></div>\n <div id="diffs"></div>\n</div>';var page=void 0;var pageView=void 0;var $diffs=void 0;beforeEach(function(){spyOn(Backbone.history,"start");page=new RB.DiffViewerPage({checkForUpdates:false,pagination:{current_page:1},reviewRequestData:{id:123,loaded:true,state:RB.ReviewRequest.PENDING},revision:{revision:1,interdiff_revision:null,is_interdiff:false},editorData:{mutableByUser:true,statusMutableByUser:true}},{parse:true});pageView=new RB.DiffViewerPageView({el:$(pageTemplate).appendTo($testsScratch),model:page});$diffs=pageView.$el.children("#diffs");spyOn(page.get("reviewRequest"),"ready").and.callFake(function(options,context){return options.ready.call(context)})});afterEach(function(){RB.DnDUploader.instance=null});describe("Anchors",function(){it("Tracks all types",function(){$diffs.html(tableTemplate({fileID:"file1",chunks:[{id:"1.1",lines:[{type:"insert",vNumber:100,leftNumber:100,rightNumber:101}]},{id:"1.2",lines:[{type:"equal",vNumber:101,leftNumber:101,rightNumber:101}]},{id:"1.3",lines:[{type:"delete",vNumber:102,leftNumber:102,rightNumber:101}]}]}));pageView.render();pageView._updateAnchors(pageView.$el.find("table").eq(0));expect(pageView._$anchors.length).toBe(4);expect(pageView._$anchors[0].name).toBe("file1");expect(pageView._$anchors[1].name).toBe("1.1");expect(pageView._$anchors[2].name).toBe("1.2");expect(pageView._$anchors[3].name).toBe("1.3");expect(pageView._selectedAnchorIndex).toBe(0)});describe("Navigation",function(){beforeEach(function(){$diffs.html([tableTemplate({fileID:"file1",chunks:[{id:"1.1",lines:[{type:"insert",vNumber:100,leftNumber:100,rightNumber:101}]},{id:"1.2",lines:[{type:"equal",vNumber:101,leftNumber:101,rightNumber:101}]}]}),tableTemplate({fileID:"file2",chunks:[]}),tableTemplate({fileID:"file3",chunks:[{id:"2.1",lines:[{type:"insert",vNumber:100,leftNumber:100,rightNumber:101}]},{id:"2.2",lines:[{type:"equal",vNumber:101,leftNumber:101,rightNumber:101}]}]})]);pageView.render();pageView.$el.find("table").each(function(){pageView._updateAnchors($(this))})});describe("Previous file",function(){it("From file",function(){pageView.selectAnchorByName("file2");expect(pageView._selectedAnchorIndex).toBe(3);pageView._selectPreviousFile();expect(pageView._selectedAnchorIndex).toBe(0)});it("From chunk",function(){pageView.selectAnchorByName("2.2");expect(pageView._selectedAnchorIndex).toBe(6);pageView._selectPreviousFile();expect(pageView._selectedAnchorIndex).toBe(4)});it("On first file",function(){pageView.selectAnchorByName("file1");expect(pageView._selectedAnchorIndex).toBe(0);pageView._selectPreviousFile();expect(pageView._selectedAnchorIndex).toBe(0)})});describe("Next file",function(){it("From file",function(){pageView.selectAnchorByName("file1");expect(pageView._selectedAnchorIndex).toBe(0);pageView._selectNextFile();expect(pageView._selectedAnchorIndex).toBe(3)});it("From chunk",function(){pageView.selectAnchorByName("1.1");expect(pageView._selectedAnchorIndex).toBe(1);pageView._selectNextFile();expect(pageView._selectedAnchorIndex).toBe(3)});it("On last file",function(){pageView.selectAnchorByName("file3");expect(pageView._selectedAnchorIndex).toBe(4);pageView._selectNextFile();expect(pageView._selectedAnchorIndex).toBe(4)})});describe("Previous anchor",function(){it("From file to file",function(){pageView.selectAnchorByName("file3");expect(pageView._selectedAnchorIndex).toBe(4);pageView._selectPreviousDiff();expect(pageView._selectedAnchorIndex).toBe(3)});it("From file to chunk",function(){pageView.selectAnchorByName("file2");expect(pageView._selectedAnchorIndex).toBe(3);pageView._selectPreviousDiff();expect(pageView._selectedAnchorIndex).toBe(2)});it("From chunk to file",function(){pageView.selectAnchorByName("2.1");expect(pageView._selectedAnchorIndex).toBe(5);pageView._selectPreviousDiff();expect(pageView._selectedAnchorIndex).toBe(4)});it("From chunk to chunk",function(){pageView.selectAnchorByName("2.2");expect(pageView._selectedAnchorIndex).toBe(6);pageView._selectPreviousDiff();expect(pageView._selectedAnchorIndex).toBe(5)});it("On first file",function(){pageView.selectAnchorByName("file1");expect(pageView._selectedAnchorIndex).toBe(0);pageView._selectPreviousDiff();expect(pageView._selectedAnchorIndex).toBe(0)})});describe("Next anchor",function(){it("From file to file",function(){pageView.selectAnchorByName("file2");expect(pageView._selectedAnchorIndex).toBe(3);pageView._selectNextDiff();expect(pageView._selectedAnchorIndex).toBe(4)});it("From file to chunk",function(){pageView.selectAnchorByName("file1");expect(pageView._selectedAnchorIndex).toBe(0);pageView._selectNextDiff();expect(pageView._selectedAnchorIndex).toBe(1)});it("From chunk to file",function(){pageView.selectAnchorByName("1.2");expect(pageView._selectedAnchorIndex).toBe(2);pageView._selectNextDiff();expect(pageView._selectedAnchorIndex).toBe(3)});it("From chunk to chunk",function(){pageView.selectAnchorByName("2.1");expect(pageView._selectedAnchorIndex).toBe(5);pageView._selectNextDiff();expect(pageView._selectedAnchorIndex).toBe(6)});it("On last chunk",function(){pageView.selectAnchorByName("2.2");expect(pageView._selectedAnchorIndex).toBe(6);pageView._selectNextDiff();expect(pageView._selectedAnchorIndex).toBe(6)})})})});describe("Key bindings",function(){function triggerKeyPress(c){var evt=$.Event("keypress");evt.which=c.charCodeAt(0);pageView.$el.trigger(evt)}function testKeys(description,funcName,keyList){describe(description,function(){keyList.forEach(function(key){var label=void 0;var c=void 0;if(key.length===2){label=key[0];c=key[1]}else{label="'"+key+"'";c=key}it(label,function(){pageView.render();spyOn(pageView,funcName);triggerKeyPress(c);expect(pageView[funcName]).toHaveBeenCalled()})})})}testKeys("Previous file","_selectPreviousFile",["a","A","K","P","<","m"]);testKeys("Next file","_selectNextFile",["f","F","J","N",">"]);testKeys("Previous anchor","_selectPreviousDiff",["s","S","k","p",","]);testKeys("Next anchor","_selectNextDiff",["d","D","j","n","."]);testKeys("Previous comment","_selectPreviousComment",["[","x"]);testKeys("Next comment","_selectNextComment",["]","c"]);testKeys("Recenter selected","_recenterSelected",[["Enter","\r"]]);testKeys("Create comment","_createComment",["r","R"])});describe("Reviewable Management",function(){beforeEach(function(){spyOn(pageView,"queueLoadDiff");pageView.render()});it("File added",function(){expect($diffs.find(".diff-container").length).toBe(0);expect(pageView.queueLoadDiff.calls.count()).toBe(0);page.files.reset([new RB.DiffFile({id:100,filediff:{id:200,revision:1}})]);expect($diffs.find(".diff-container").length).toBe(1);expect(pageView.queueLoadDiff.calls.count()).toBe(1)});it("Files reset",function(){expect($diffs.find(".diff-container").length).toBe(0);expect(pageView.queueLoadDiff.calls.count()).toBe(0);page.files.reset([new RB.DiffFile({id:100,filediff:{id:200,revision:1}})]);expect($diffs.find(".diff-container").length).toBe(1);expect(pageView.queueLoadDiff.calls.count()).toBe(1);page.files.reset([new RB.DiffFile({id:101,filediff:{id:201,revision:2}})]);var $containers=$diffs.find(".diff-container");expect($containers.length).toBe(1);expect($containers.find(".sidebyside")[0].id).toBe("file_container_101");expect(pageView.queueLoadDiff.calls.count()).toBe(2)})});describe("Page view/URL state",function(){var router=void 0;beforeEach(function(){router=pageView.router;spyOn(page,"loadDiffRevision");spyOn(router,"navigate").and.callFake(function(url,options){if(!options||options.trigger!==false){Backbone.history.loadUrl(url)}})});describe("Initial URL",function(){it("Initial default load",function(){pageView._setInitialURL("","index_header");expect(router.navigate).toHaveBeenCalledWith("1/#index_header",{replace:true,trigger:false});expect(page.loadDiffRevision).not.toHaveBeenCalled()});it("Initial load of first page explicit",function(){pageView._setInitialURL("?page=1","index_header");expect(router.navigate).toHaveBeenCalledWith("1/?page=1#index_header",{replace:true,trigger:false});expect(page.loadDiffRevision).not.toHaveBeenCalled()});it("Initial load of page > 1",function(){pageView._setInitialURL("?page=2","index_header");expect(router.navigate).toHaveBeenCalledWith("1/?page=2#index_header",{replace:true,trigger:false});expect(page.loadDiffRevision).not.toHaveBeenCalled()});it("Initial load of interdiff",function(){page.revision.set("revision",2);page.revision.set("interdiffRevision",3);pageView._setInitialURL("?page=2","index_header");expect(router.navigate).toHaveBeenCalledWith("2-3/?page=2#index_header",{replace:true,trigger:false});expect(page.loadDiffRevision).not.toHaveBeenCalled()});it("Initial load with filename patterns",function(){pageView._setInitialURL("?filenames=*.js,src/*","index_header");expect(router.navigate).toHaveBeenCalledWith("1/?filenames=*.js,src/*#index_header",{replace:true,trigger:false});expect(page.loadDiffRevision).not.toHaveBeenCalled()
})});describe("_navigate",function(){beforeEach(function(){page.set("filenamePatterns","*.js,src/*")});it("With page == 1",function(){pageView._navigate({page:1});expect(router.navigate).toHaveBeenCalledWith("1/?filenames=*.js%2Csrc%2F*",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({page:1,revision:1,interdiffRevision:null,filenamePatterns:"*.js,src/*"})});it("With page > 1",function(){pageView._navigate({page:2});expect(router.navigate).toHaveBeenCalledWith("1/?page=2&filenames=*.js%2Csrc%2F*",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({page:2,revision:1,interdiffRevision:null,filenamePatterns:"*.js,src/*"})});it("New revision on page > 1",function(){page.pagination.set("currentPage",2);pageView._onRevisionSelected([0,2]);expect(router.navigate).toHaveBeenCalledWith("2/?filenames=*.js%2Csrc%2F*",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({page:1,revision:2,interdiffRevision:null,filenamePatterns:"*.js,src/*"})});it("Same revision on page > 1",function(){page.pagination.set("currentPage",2);pageView._navigate({revision:1});expect(router.navigate).toHaveBeenCalledWith("1/?page=2&filenames=*.js%2Csrc%2F*",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({page:2,revision:1,interdiffRevision:null,filenamePatterns:"*.js,src/*"})});it("With updateURLOnly",function(){page.pagination.set("currentPage",2);pageView._navigate({revision:2,interdiffRevision:3,updateURLOnly:true});expect(router.navigate).toHaveBeenCalledWith("2-3/?filenames=*.js%2Csrc%2F*",{replace:true,trigger:false});expect(page.loadDiffRevision).not.toHaveBeenCalled()});it("With anchor",function(){pageView._navigate({anchor:"test"});expect(router.navigate).toHaveBeenCalledWith("1/?filenames=*.js%2Csrc%2F*#test",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({page:1,revision:1,interdiffRevision:null,filenamePatterns:"*.js,src/*"})})});describe("Revision selector",function(){describe("New diff revision selected",function(){it("From single revision",function(){pageView._onRevisionSelected([0,2]);expect(router.navigate).toHaveBeenCalledWith("2/",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({page:1,revision:2,interdiffRevision:null,filenamePatterns:null})});it("From interdiff revision",function(){page.revision.set("interdiffRevision",2);pageView._onRevisionSelected([0,2]);expect(router.navigate).toHaveBeenCalledWith("2/",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({page:1,revision:2,interdiffRevision:null,filenamePatterns:null})})});it("New interdiff revision selected",function(){pageView._onRevisionSelected([2,5]);expect(router.navigate).toHaveBeenCalledWith("2-5/",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({page:1,revision:2,interdiffRevision:5,filenamePatterns:null})})});describe("Page selector",function(){it("With page == 1",function(){pageView._onPageSelected(true,1);expect(router.navigate).toHaveBeenCalledWith("1/",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({page:1,revision:1,interdiffRevision:null,filenamePatterns:null})});it("With page > 1",function(){pageView._onPageSelected(true,2);expect(router.navigate).toHaveBeenCalledWith("1/?page=2",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({page:2,revision:1,interdiffRevision:null,filenamePatterns:null})})});it("Anchor selection",function(){var $anchor=$('<a name="test"/>');pageView.render();pageView.selectAnchor($anchor);expect(router.navigate).toHaveBeenCalledWith("1/#test",{replace:true,trigger:false});expect(page.loadDiffRevision).not.toHaveBeenCalled()})})});"use strict";suite("rb/pages/views/ReviewablePageView",function(){var pageTemplate='<div id="review-banner"></div>\n<a href="#" id="review-action">Edit Review</a>\n<a href="#" id="ship-it-action">Ship It</a>';var $editReview=void 0;var $shipIt=void 0;var page=void 0;var pageView=void 0;beforeEach(function(){var $container=$("<div/>").html(pageTemplate).appendTo($testsScratch);RB.DnDUploader.instance=null;$editReview=$container.find("#review-action");$shipIt=$container.find("#ship-it-action");page=new RB.ReviewablePage({checkForUpdates:false,reviewRequestData:{id:123,loaded:true,state:RB.ReviewRequest.PENDING},editorData:{mutableByUser:true,statusMutableByUser:true}},{parse:true});pageView=new RB.ReviewablePageView({el:$container,model:page});var reviewRequest=page.get("reviewRequest");spyOn(reviewRequest,"ready").and.callFake(function(options,context){return options.ready.call(context)});pageView.render()});afterEach(function(){RB.DnDUploader.instance=null;pageView.remove()});describe("Public objects",function(){it("reviewRequest",function(){expect(page.get("reviewRequest")).not.toBe(undefined)});it("pendingReview",function(){var pendingReview=page.get("pendingReview");expect(pendingReview).not.toBe(undefined);expect(pendingReview.get("parentObject")).toBe(page.get("reviewRequest"))});it("commentIssueManager",function(){expect(page.commentIssueManager).not.toBe(undefined);expect(page.commentIssueManager.get("reviewRequest")).toBe(page.get("reviewRequest"))});it("reviewRequestEditor",function(){var reviewRequestEditor=page.reviewRequestEditor;expect(reviewRequestEditor).not.toBe(undefined);expect(reviewRequestEditor.get("reviewRequest")).toBe(page.get("reviewRequest"));expect(reviewRequestEditor.get("commentIssueManager")).toBe(page.commentIssueManager);expect(reviewRequestEditor.get("editable")).toBe(true)});it("reviewRequestEditorView",function(){expect(pageView.reviewRequestEditorView).not.toBe(undefined);expect(pageView.reviewRequestEditorView.model).toBe(page.reviewRequestEditor)})});describe("Actions",function(){it("Edit Review",function(){spyOn(RB.ReviewDialogView,"create");$editReview.click();expect(RB.ReviewDialogView.create).toHaveBeenCalled();var options=RB.ReviewDialogView.create.calls.argsFor(0)[0];expect(options.review).toBe(page.get("pendingReview"));expect(options.reviewRequestEditor).toBe(page.reviewRequestEditor)});describe("Ship It",function(){var pendingReview=void 0;beforeEach(function(){pendingReview=page.get("pendingReview")});it("Confirmed",function(){spyOn(window,"confirm").and.returnValue(true);spyOn(pendingReview,"ready").and.callFake(function(options,context){return options.ready.call(context)});spyOn(pendingReview,"save").and.callFake(function(options,context){return options.success.call(context)});spyOn(pendingReview,"publish").and.callThrough();spyOn(pageView.draftReviewBanner,"hideAndReload");$shipIt.click();expect(window.confirm).toHaveBeenCalled();expect(pendingReview.ready).toHaveBeenCalled();expect(pendingReview.publish).toHaveBeenCalled();expect(pendingReview.save).toHaveBeenCalled();expect(pageView.draftReviewBanner.hideAndReload).toHaveBeenCalled();expect(pendingReview.get("shipIt")).toBe(true);expect(pendingReview.get("bodyTop")).toBe("Ship It!")});it("Canceled",function(){spyOn(window,"confirm").and.returnValue(false);spyOn(pendingReview,"ready");$shipIt.click();expect(window.confirm).toHaveBeenCalled();expect(pendingReview.ready).not.toHaveBeenCalled()})})});describe("Update bubble",function(){var summary="My summary";var user={url:"/users/foo/",fullname:"Mr. User",username:"user"};var $bubble=void 0;var bubbleView=void 0;beforeEach(function(){page.get("reviewRequest").trigger("updated",{summary:summary,user:user});$bubble=$("#updates-bubble");bubbleView=pageView._updatesBubble});it("Displays",function(){expect($bubble.length).toBe(1);expect(bubbleView.$el[0]).toBe($bubble[0]);expect($bubble.is(":visible")).toBe(true);expect($bubble.find("#updates-bubble-summary").text()).toBe(summary);expect($bubble.find("#updates-bubble-user").text()).toBe(user.fullname);expect($bubble.find("#updates-bubble-user").attr("href")).toBe(user.url)});describe("Actions",function(){it("Ignore",function(){spyOn(bubbleView,"close").and.callThrough();spyOn(bubbleView,"trigger").and.callThrough();spyOn(bubbleView,"remove").and.callThrough();$bubble.find(".ignore").click();expect(bubbleView.close).toHaveBeenCalled();expect(bubbleView.remove).toHaveBeenCalled();expect(bubbleView.trigger).toHaveBeenCalledWith("closed")});it("Update Page displays Updates Bubble",function(){spyOn(bubbleView,"trigger");$bubble.find(".update-page").click();expect(bubbleView.trigger).toHaveBeenCalledWith("updatePage")});it("Update Page calls notify if shouldNotify",function(){var info={user:{fullname:"Hello"}};RB.NotificationManager.instance._canNotify=true;spyOn(RB.NotificationManager.instance,"notify");spyOn(RB.NotificationManager.instance,"_haveNotificationPermissions").and.returnValue(true);spyOn(pageView,"_showUpdatesBubble");pageView._onReviewRequestUpdated(info);expect(RB.NotificationManager.instance.notify).toHaveBeenCalled();expect(pageView._showUpdatesBubble).toHaveBeenCalled()})})})});suite("rb/resources/collections/RepositoryBranches",function(){var collection;beforeEach(function(){collection=new RB.RepositoryBranches;collection.url="/api/repositories/123/branches/"});describe("Methods",function(){it("fetch",function(){spyOn($,"ajax").and.callFake(function(request){expect(request.url).toBe("/api/repositories/123/branches/");expect(request.type).toBe("GET");request.success({stat:"ok",branches:[{name:"master",commit:"859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817","default":true},{name:"release-1.7.x",commit:"92463764015ef463b4b6d1a1825fee7aeec8cb15","default":false},{name:"release-1.6.x",commit:"a15d0e635064a2e1929ce1bf3bc8d4aa65738b64","default":false}]})});collection.fetch();expect($.ajax).toHaveBeenCalled();expect(collection.length).toBe(3);expect(collection.at(0).get("name")).toBe("master");expect(collection.at(1).get("commit")).toBe("92463764015ef463b4b6d1a1825fee7aeec8cb15");expect(collection.at(2).get("isDefault")).toBe(false);expect(collection.reduce(function(memo,item){return memo+item.get("isDefault")?1:0},0)).toBe(1)})})});suite("rb/resources/collections/RepositoryCommits",function(){var collection,url="/api/repositories/123/commits/",start="859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817";beforeEach(function(){collection=new RB.RepositoryCommits([],{urlBase:url,start:start})});describe("Methods",function(){it("fetch",function(){spyOn($,"ajax").and.callFake(function(request){expect(request.url).toBe(url+"?start="+start);expect(request.type).toBe("GET");request.success({stat:"ok",commits:[{author_name:"Christian Hammond",date:"2013-06-25T23:31:22Z",id:"859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817",message:"Merge branch 'release-1.7.x'",parent:"84c730c7823b653a5bbcc007188d5c85a7c4ac58",review_request_url:""},{author_name:"Christian Hammond",date:"2013-06-25T23:30:59Z",id:"92463764015ef463b4b6d1a1825fee7aeec8cb15",message:"Fixed the bug number for the "+"blacktriangledown bug.",parent:"f5a35f1d8a8dcefb336a8e3211334f1f50ea7792",review_request_url:"http://example.com/r/18274/"},{author_name:"Christian Hammond",date:"2013-06-25T22:53:32Z",id:"84c730c7823b653a5bbcc007188d5c85a7c4ac58",message:["Don't expose child resources in ","ValidateDiffResource.\n\nFor convenience, ","ValidateDiffResource inherited from ","DiffResource.\nThis brought along the child ","resources, which weren't valid to have.\n","That ended up breaking docs, which tried ","to traverse them."].join(""),parent:"4150004c2f332747d92769d8133571dfac8c2803",review_request_url:""}]})});collection.fetch();expect($.ajax).toHaveBeenCalled();expect(collection.length).toBe(3);expect(collection.at(0).get("authorName")).toBe("Christian Hammond");expect(collection.at(1).get("date").getUTCHours()).toBe(23);expect(collection.at(2).get("summary")).toBe("Don't expose child resources in ValidateDiffResource.");expect(collection.at(1).get("reviewRequestURL")).toBe("http://example.com/r/18274/")});it("url",function(){expect(_.result(collection,"url")).toBe(url+"?start="+start)})})});suite("rb/resources/collections/ResourceCollection",function(){var collection,reviewRequest;beforeEach(function(){reviewRequest=new RB.ReviewRequest({id:123,loaded:true,links:{reviews:{href:"/api/review-requests/123/reviews/"}}});spyOn(reviewRequest,"ready").and.callFake(function(options,context){options.ready.call(context)});collection=new RB.ResourceCollection([],{model:RB.Review,parentResource:reviewRequest})});describe("Methods",function(){describe("fetch",function(){it("Populates collection",function(){spyOn($,"ajax").and.callFake(function(request){expect(request.url).toBe("/api/review-requests/123/reviews/");expect(request.type).toBe("GET");request.success({stat:"ok",total_results:2,links:{self:{method:"GET",href:"/api/review-requests/123/reviews/"},next:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=25"}},reviews:[{id:1,links:{}},{id:2,links:{}}]})});collection.fetch();expect($.ajax).toHaveBeenCalled();expect(collection.length).toBe(2);expect(collection.at(0).id).toBe(1);expect(collection.at(1).id).toBe(2);expect(collection.hasPrev).toBe(false);expect(collection.hasNext).toBe(true)});it("With start=",function(){spyOn($,"ajax").and.callFake(function(request){expect(request.url).toBe("/api/review-requests/123/reviews/");expect(request.data).not.toBe(undefined);expect(request.data.start).toBe(100)});collection.fetch({start:100});expect($.ajax).toHaveBeenCalled()});describe("With parentResource",function(){it("Calls parentResource.ready",function(){spyOn(RB.BaseCollection.prototype,"fetch");collection.fetch();expect(reviewRequest.ready).toHaveBeenCalled();expect(RB.BaseCollection.prototype.fetch).toHaveBeenCalled()})})});describe("fetchAll",function(){it("Spanning pages",function(){var numFetches=0,result;spyOn($,"ajax").and.callFake(function(request){console.assert(numFetches<2);expect(request.type).toBe("GET");numFetches++;if(numFetches===1){expect(request.url).toBe("/api/review-requests/123/reviews/");request.success({stat:"ok",total_results:4,links:{self:{method:"GET",href:"/api/review-requests/123/reviews/"},next:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=25"}},reviews:[{id:1,links:{}},{id:2,links:{}}]})}else if(numFetches===2){expect(request.url).toBe("/api/review-requests/123/reviews/?start=25");request.success({stat:"ok",total_results:4,links:{self:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=25"},prev:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=0"}},reviews:[{id:3,links:{}},{id:4,links:{}}]})}});result=collection.fetchAll();expect(result).toBe(true);expect($.ajax).toHaveBeenCalled();expect(numFetches).toBe(2);expect(collection.hasPrev).toBe(false);expect(collection.hasNext).toBe(false);expect(collection.totalResults).toBe(4);expect(collection.currentPage).toBe(0);expect(collection.length).toBe(4);expect(collection.at(0).id).toBe(1);expect(collection.at(1).id).toBe(2);expect(collection.at(2).id).toBe(3);expect(collection.at(3).id).toBe(4)})});describe("fetchNext",function(){it("With hasNext == false",function(){var result;collection.hasNext=false;spyOn(collection,"fetch");result=collection.fetchNext();expect(result).toBe(false);expect(collection.fetch).not.toHaveBeenCalled()});it("With hasNext == true",function(){var result;spyOn($,"ajax").and.callFake(function(request){expect(request.url).toBe("/api/review-requests/123/reviews/?start=25");expect(request.type).toBe("GET");request.success({stat:"ok",total_results:2,links:{self:{method:"GET",href:"/api/review-requests/123/reviews/"},prev:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=0"},next:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=50"}},reviews:[{id:1,links:{}},{id:2,links:{}}]})});collection.hasNext=true;collection.currentPage=2;collection._links={next:{method:"GET",href:"/api/review-requests/123/reviews/?start=25"}};spyOn(collection,"fetch").and.callThrough();result=collection.fetchNext();expect(result).toBe(true);expect(collection.fetch).toHaveBeenCalled();expect(collection.hasPrev).toBe(true);expect(collection.hasNext).toBe(true);expect(collection.currentPage).toBe(3);expect(collection.models.length).toBe(2)})});describe("fetchPrev",function(){it("With hasPrev == false",function(){var result;collection.hasPrev=false;spyOn(collection,"fetch");result=collection.fetchPrev();expect(result).toBe(false);expect(collection.fetch).not.toHaveBeenCalled()});it("With hasPrev == true",function(){var result;spyOn($,"ajax").and.callFake(function(request){expect(request.url).toBe("/api/review-requests/123/reviews/?start=25");expect(request.type).toBe("GET");request.success({stat:"ok",total_results:2,links:{self:{method:"GET",href:"/api/review-requests/123/reviews/"},prev:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=0"},next:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=25"}},reviews:[{id:1,links:{}},{id:2,links:{}}]})});collection.hasPrev=true;collection.currentPage=2;collection._links={prev:{method:"GET",href:"/api/review-requests/123/reviews/?start=25"}};spyOn(collection,"fetch").and.callThrough();result=collection.fetchPrev();expect(result).toBe(true);expect(collection.fetch).toHaveBeenCalled();expect(collection.hasPrev).toBe(true);expect(collection.hasNext).toBe(true);expect(collection.currentPage).toBe(1);expect(collection.models.length).toBe(2)})});describe("parse",function(){var payload;beforeEach(function(){payload={links:{},total_results:5,reviews:[]}});it("Resources returned",function(){var results;payload.reviews=[{id:1},{id:2},{id:3}];results=collection.parse(payload);expect(results.length).toBe(3);expect(results[0].id).toBe(1);expect(results[1].id).toBe(2);expect(results[2].id).toBe(3)});it("totalResults set",function(){collection.parse(payload);expect(collection.totalResults).toBe(5)});describe("With fetchingAll",function(){var options={fetchingAll:true};it("currentPage = 0",function(){collection.parse(payload,options);expect(collection.currentPage).toBe(0)});it("hasPrev disabled",function(){collection.parse(payload,options);expect(collection.hasPrev).toBe(false)});it("hasNext disabled",function(){collection.parse(payload,options);expect(collection.hasNext).toBe(false)})});describe("Without fetchingAll",function(){describe("currentPage",function(){it("undefined when not options.page",function(){collection.parse(payload);expect(collection.currentPage).toBe(undefined)});it("Set when options.page",function(){collection.parse(payload,{page:4});expect(collection.currentPage).toBe(4)})});describe("hasPrev",function(){it("true with rsp.links.prev",function(){payload.links={prev:{href:"blah"}};collection.parse(payload);expect(collection.hasPrev).toBe(true)});it("false without rsp.links.prev",function(){collection.parse(payload);expect(collection.hasPrev).toBe(false)})});describe("hasNext",function(){it("true with rsp.links.next",function(){payload.links={next:{href:"blah"}};collection.parse(payload);expect(collection.hasNext).toBe(true)});it("false without rsp.links.next",function(){collection.parse(payload);expect(collection.hasNext).toBe(false)})})})});describe("url",function(){it("With parentResource",function(){expect(collection.url()).toBe("/api/review-requests/123/reviews/")});it("With _fetchURL",function(){collection._fetchURL="/api/foo/";expect(collection.url()).toBe("/api/foo/")});it("Without _fetchURL or parentResource",function(){collection.parentResource=null;expect(collection.url()).toBe(null)})})})});suite("rb/resources/models/BaseComment",function(){var strings=RB.BaseComment.strings,parentObject,model;beforeEach(function(){parentObject=new RB.BaseResource({"public":true});model=new RB.BaseComment({parentObject:parentObject});expect(model.validate(model.attributes)).toBe(undefined)});describe("State values",function(){it("STATE_DROPPED",function(){expect(RB.BaseComment.STATE_DROPPED).toBe("dropped")});it("STATE_OPEN",function(){expect(RB.BaseComment.STATE_OPEN).toBe("open")});it("STATE_RESOLVED",function(){expect(RB.BaseComment.STATE_RESOLVED).toBe("resolved")})});describe("destroyIfEmpty",function(){beforeEach(function(){spyOn(model,"destroy")});it("Destroying when text is empty",function(){model.set("text","");model.destroyIfEmpty();expect(model.destroy).toHaveBeenCalled()});it("Not destroying when text is not empty",function(){model.set("text","foo");model.destroyIfEmpty();expect(model.destroy).not.toHaveBeenCalled()})});describe("parse",function(){beforeEach(function(){model.rspNamespace="my_comment"});it("API payloads",function(){var data=model.parse({stat:"ok",my_comment:{id:42,issue_opened:true,issue_status:"resolved",text:"foo"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.issueOpened).toBe(true);expect(data.issueStatus).toBe(RB.BaseComment.STATE_RESOLVED);expect(data.text).toBe("foo")})});describe("toJSON",function(){describe("force_text_type field",function(){it("With value",function(){var data;model.set("forceTextType","html");data=model.toJSON();expect(data.force_text_type).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.force_text_type).toBe(undefined)})});describe("include_text_types field",function(){it("With value",function(){var data;model.set("includeTextTypes","html");data=model.toJSON();expect(data.include_text_types).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.include_text_types).toBe(undefined)})});describe("issue_opened field",function(){it("Default",function(){var data=model.toJSON();expect(data.issue_opened).toBe(null)});it("With value",function(){var data;model.set("issueOpened",false);data=model.toJSON();expect(data.issue_opened).toBe(false);model.set("issueOpened",true);data=model.toJSON();expect(data.issue_opened).toBe(true)})});describe("issue_status field",function(){it("When not loaded",function(){var data;model.set("issueStatus",RB.BaseComment.STATE_DROPPED);data=model.toJSON();expect(data.issue_status).toBe(undefined)});it("When loaded and parent is not public",function(){var data;parentObject.set("public",false);model.set({loaded:true,issueStatus:RB.BaseComment.STATE_DROPPED,parentObject:parentObject});data=model.toJSON();expect(data.issue_status).toBe(undefined)});it("When loaded and parent is public",function(){var data;parentObject.set("public",true);model.set({loaded:true,issueStatus:RB.BaseComment.STATE_DROPPED,parentObject:parentObject});data=model.toJSON();expect(data.issue_status).toBe(RB.BaseComment.STATE_DROPPED)})});describe("richText field",function(){it("With true",function(){var data;model.set("richText",true);data=model.toJSON();expect(data.text_type).toBe("markdown")});it("With false",function(){var data;model.set("richText",false);data=model.toJSON();expect(data.text_type).toBe("plain")})});describe("text field",function(){it("With value",function(){var data;model.set("text","foo");data=model.toJSON();expect(data.text).toBe("foo")})})});describe("validate",function(){describe("issueState",function(){it("STATE_DROPPED",function(){expect(model.validate({issueStatus:RB.BaseComment.STATE_DROPPED})).toBe(undefined)});it("STATE_OPEN",function(){expect(model.validate({issueStatus:RB.BaseComment.STATE_OPEN})).toBe(undefined)});it("STATE_RESOLVED",function(){expect(model.validate({issueStatus:RB.BaseComment.STATE_RESOLVED})).toBe(undefined)});it("Unset",function(){expect(model.validate({issueStatus:""})).toBe(undefined);expect(model.validate({issueStatus:undefined})).toBe(undefined);expect(model.validate({issueStatus:null})).toBe(undefined)});it("Invalid values",function(){expect(model.validate({issueStatus:"foobar"})).toBe(strings.INVALID_ISSUE_STATUS)})});describe("parentObject",function(){it("With value",function(){expect(model.validate({parentObject:parentObject})).toBe(undefined)});it("Unset",function(){expect(model.validate({parentObject:null})).toBe(RB.BaseResource.strings.UNSET_PARENT_OBJECT)})})})});suite("rb/resources/models/BaseCommentReply",function(){var parentObject,model;beforeEach(function(){parentObject=new RB.BaseResource({"public":true});model=new RB.BaseCommentReply({parentObject:parentObject});expect(model.validate(model.attributes)).toBe(undefined)});describe("destroyIfEmpty",function(){beforeEach(function(){spyOn(model,"destroy")});it("Destroying when text is empty",function(){model.set("text","");model.destroyIfEmpty();expect(model.destroy).toHaveBeenCalled()});it("Not destroying when text is not empty",function(){model.set("text","foo");model.destroyIfEmpty();expect(model.destroy).not.toHaveBeenCalled()})});describe("parse",function(){beforeEach(function(){model.rspNamespace="my_comment"});it("API payloads",function(){var data=model.parse({stat:"ok",my_comment:{id:42,text:"foo",text_type:"markdown"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.text).toBe("foo");expect(data.richText).toBe(true)})});describe("toJSON",function(){describe("force_text_type field",function(){it("With value",function(){var data;model.set("forceTextType","html");data=model.toJSON();expect(data.force_text_type).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.force_text_type).toBe(undefined)})});describe("include_text_types field",function(){it("With value",function(){var data;model.set("includeTextTypes","html");data=model.toJSON();expect(data.include_text_types).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.include_text_types).toBe(undefined)})});describe("reply_to_id field",function(){it("When loaded",function(){var data;model.set({replyToID:10,loaded:true});data=model.toJSON();expect(data.reply_to_id).toBe(undefined)});it("When not loaded",function(){var data;model.set({replyToID:10,loaded:false});data=model.toJSON();expect(data.reply_to_id).toBe(10)})});describe("richText field",function(){it("With true",function(){var data;model.set("richText",true);data=model.toJSON();expect(data.text_type).toBe("markdown")});it("With false",function(){var data;model.set("richText",false);data=model.toJSON();expect(data.text_type).toBe("plain")})});describe("text field",function(){it("With value",function(){var data;model.set("text","foo");data=model.toJSON();expect(data.text).toBe("foo")})})});describe("validate",function(){describe("parentObject",function(){it("With value",function(){expect(model.validate({parentObject:parentObject})).toBe(undefined)});it("Unset",function(){expect(model.validate({parentObject:null})).toBe(RB.BaseResource.strings.UNSET_PARENT_OBJECT)})})})});suite("rb/resources/models/BaseResource",function(){var model,parentObject;beforeEach(function(){model=new RB.BaseResource;model.rspNamespace="foo";parentObject=new RB.BaseResource({links:{foos:{href:"/api/foos/"}}})});describe("ensureCreated",function(){var callbacks;describe("Callback handling",function(){beforeEach(function(){callbacks={success:function(){},error:function(){}};spyOn(model,"save").and.callFake(function(options){if(options&&_.isFunction(options.success)){options.success()}});spyOn(model,"fetch").and.callFake(function(options,context){options.success.call(context)});spyOn(model,"ready").and.callThrough();spyOn(callbacks,"success");spyOn(callbacks,"error")});describe("With loaded=true",function(){beforeEach(function(){model.set("loaded",true)});it("With callbacks",function(){model.ensureCreated(callbacks);expect(model.ready).toHaveBeenCalled();expect(model.fetch).not.toHaveBeenCalled();expect(model.save).not.toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled()});it("Without callbacks",function(){model.ensureCreated();expect(model.ready).toHaveBeenCalled();expect(model.fetch).not.toHaveBeenCalled();expect(model.save).not.toHaveBeenCalled()})});describe("With loaded=false, isNew=true",function(){beforeEach(function(){model.set("loaded",false)});it("With callbacks",function(){model.ensureCreated(callbacks);expect(model.ready).toHaveBeenCalled();expect(model.fetch).not.toHaveBeenCalled();expect(model.save).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled()});it("Without callbacks",function(){model.ensureCreated();expect(model.ready).toHaveBeenCalled();expect(model.fetch).not.toHaveBeenCalled();expect(model.save).toHaveBeenCalled()})});describe("With loaded=false, isNew=false",function(){beforeEach(function(){model.set({loaded:false,id:1})});it("With callbacks",function(){model.ensureCreated(callbacks);expect(model.ready).toHaveBeenCalled();expect(model.fetch).toHaveBeenCalled();expect(model.save).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled()});it("Without callbacks",function(){model.ensureCreated();expect(model.ready).toHaveBeenCalled();expect(model.fetch).toHaveBeenCalled();expect(model.save).toHaveBeenCalled()})})})});describe("fetch",function(){var callbacks;describe("Callback handling",function(){beforeEach(function(){callbacks={success:function(){},error:function(){}};spyOn(Backbone.Model.prototype,"fetch").and.callFake(function(options){if(options&&_.isFunction(options.success)){options.success()}});spyOn(callbacks,"success");spyOn(callbacks,"error")});describe("With isNew=true",function(){beforeEach(function(){expect(model.isNew()).toBe(true)});it("With callbacks",function(){model.fetch(callbacks);expect(Backbone.Model.prototype.fetch).not.toHaveBeenCalled();expect(callbacks.success).not.toHaveBeenCalled();expect(callbacks.error).toHaveBeenCalled()});it("Without callbacks",function(){model.fetch();expect(Backbone.Model.prototype.fetch).not.toHaveBeenCalled()})});describe("With isNew=false and no parentObject",function(){beforeEach(function(){model.set("id",123)});it("With callbacks",function(){model.fetch(callbacks);expect(Backbone.Model.prototype.fetch).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("Without callbacks",function(){model.fetch();expect(Backbone.Model.prototype.fetch).toHaveBeenCalled()})});describe("With isNew=false and parentObject",function(){beforeEach(function(){model.set({parentObject:parentObject,id:123});spyOn(parentObject,"ready").and.callFake(function(options,context){options.ready.call(context)})});it("With callbacks",function(){model.fetch(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("Without callbacks",function(){model.fetch();expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).toHaveBeenCalled()})});describe("With isNew=false and parentObject with error",function(){beforeEach(function(){model.set({parentObject:parentObject,id:123});spyOn(parentObject,"ready").and.callFake(function(options,context){if(options&&_.isFunction(options.error)){options.error.call(context,"Oh nosers.")}})});it("With callbacks",function(){model.fetch(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).not.toHaveBeenCalled();expect(callbacks.success).not.toHaveBeenCalled();expect(callbacks.error).toHaveBeenCalled()});it("Without callbacks",function(){model.fetch();expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).not.toHaveBeenCalled()})})});describe("Response handling",function(){beforeEach(function(){model.set({id:123,links:{self:{href:"/api/foo/"}}})});it("Custom response parsing",function(){spyOn(model,"parse").and.callFake(function(rsp){return{a:rsp.a+1,b:rsp.b,c:true}});spyOn($,"ajax").and.callFake(function(request){request.success({a:10,b:20,d:30})});model.fetch();expect(model.get("a")).toBe(11);expect(model.get("b")).toBe(20);expect(model.get("c")).toBe(true);expect(model.get("d")).toBe(undefined)});it("Default response parsing",function(){spyOn(model,"parse").and.callThrough();spyOn($,"ajax").and.callFake(function(request){request.success({stat:"ok",foo:{id:42,links:{foo:{href:"bar"}},a:20}})});model.fetch();expect(model.get("a")).toBe(undefined);expect(model.id).toBe(42);expect(model.get("links").foo).not.toBe(undefined);expect(model.get("loaded")).toBe(true)})});describe("Request payload",function(){beforeEach(function(){model.set({id:123,links:{self:{href:"/api/foo/"}}})
});describe("GET",function(){it("No contentType sent",function(){spyOn(Backbone,"sync").and.callFake(function(method,model,options){expect(options.contentType).toBe(undefined)});model.fetch();expect(Backbone.sync).toHaveBeenCalled()});it("No model data sent",function(){spyOn(Backbone,"sync").and.callFake(function(method,model,options){expect(_.isEmpty(options.data)).toBe(true)});model.toJSON=function(){return{a:1,b:2}};model.fetch();expect(Backbone.sync).toHaveBeenCalled()});it("Query attributes sent",function(){spyOn(Backbone,"sync").and.callFake(function(method,model,options){expect(_.isEmpty(options.data)).toBe(false);expect(options.data.foo).toBe("bar")});model.toJSON=function(){return{a:1,b:2}};model.fetch({data:{foo:"bar"}});expect(Backbone.sync).toHaveBeenCalled()})})})});describe("ready",function(){var callbacks;beforeEach(function(){callbacks={ready:function(){},error:function(){}};spyOn(model,"fetch").and.callFake(function(options){options.success()});spyOn(callbacks,"ready");spyOn(callbacks,"error")});it("With loaded=true",function(){model.set("loaded",true);model.ready(callbacks);expect(model.fetch).not.toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("With loaded=false and isNew=true",function(){model.set("loaded",false);expect(model.isNew()).toBe(true);model.ready(callbacks);expect(model.fetch).not.toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("With loaded=false and isNew=false",function(){model.set({loaded:false,id:123});expect(model.isNew()).toBe(false);model.ready(callbacks);expect(model.fetch).toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()})});describe("save",function(){var callbacks;describe("Callback handling",function(){beforeEach(function(){callbacks={success:function(){},error:function(){}};spyOn(Backbone.Model.prototype,"fetch").and.callFake(function(options){if(options&&_.isFunction(options.success)){options.success()}});spyOn(callbacks,"success");spyOn(callbacks,"error");spyOn(model,"trigger")});describe("With isNew=true and parentObject",function(){var responseData={foo:{},stat:"ok"};beforeEach(function(){spyOn(parentObject,"ensureCreated").and.callFake(function(options){if(options&&_.isFunction(options.success)){options.success()}});spyOn(parentObject,"ready").and.callFake(function(options,context){options.ready.call(context)});spyOn(Backbone.Model.prototype,"save").and.callThrough();model.set("parentObject",parentObject);spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax").and.callFake(function(request){expect(request.type).toBe("POST");request.success(responseData)})});it("With callbacks",function(){var args;model.save(callbacks);expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(parentObject.ensureCreated).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();args=callbacks.success.calls.argsFor(0);expect(args[0]).toBe(model);expect(args[1]).toBe(responseData);expect(callbacks.error).not.toHaveBeenCalled();expect(model.trigger).toHaveBeenCalledWith("saved",callbacks)});it("Without callbacks",function(){model.save();expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(parentObject.ensureCreated).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(model.trigger).toHaveBeenCalledWith("saved",{})})});describe("With isNew=true and no parentObject",function(){beforeEach(function(){spyOn(Backbone.Model.prototype,"save").and.callThrough();spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax").and.callFake(function(){})});it("With callbacks",function(){model.save(callbacks);expect(Backbone.Model.prototype.save).not.toHaveBeenCalled();expect(RB.apiCall).not.toHaveBeenCalled();expect($.ajax).not.toHaveBeenCalled();expect(callbacks.success).not.toHaveBeenCalled();expect(callbacks.error).toHaveBeenCalled();expect(model.trigger).not.toHaveBeenCalledWith("saved",callbacks)});it("Without callbacks",function(){model.save();expect(Backbone.Model.prototype.save).not.toHaveBeenCalled();expect(RB.apiCall).not.toHaveBeenCalled();expect($.ajax).not.toHaveBeenCalled();expect(model.trigger).not.toHaveBeenCalledWith("saved")})});describe("With isNew=false and no parentObject",function(){beforeEach(function(){model.set("id",123);model.url="/api/foos/1/";spyOn(Backbone.Model.prototype,"save").and.callFake(function(attrs,options){if(options&&_.isFunction(options.success)){options.success()}})});it("With callbacks",function(){model.save(callbacks);expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled();expect(model.trigger).toHaveBeenCalledWith("saved",callbacks)});it("Without callbacks",function(){model.save();expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(model.trigger).toHaveBeenCalledWith("saved",{})})});describe("With isNew=false and parentObject",function(){beforeEach(function(){spyOn(parentObject,"ensureCreated").and.callFake(function(options){if(options&&_.isFunction(options.success)){options.success()}});spyOn(Backbone.Model.prototype,"save").and.callThrough();model.set({parentObject:parentObject,id:123});spyOn(parentObject,"ready").and.callFake(function(options,context){options.ready.call(context)});spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax").and.callFake(function(request){expect(request.type).toBe("PUT");request.success({foo:{},stat:"ok"})})});it("With callbacks",function(){model.save(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled();expect(model.trigger).toHaveBeenCalledWith("saved",callbacks)});it("Without callbacks",function(){model.save();expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(model.trigger).toHaveBeenCalledWith("saved",{})})});describe("With isNew=false and parentObject with error",function(){beforeEach(function(){model.set({parentObject:parentObject,id:123});spyOn(parentObject,"ready").and.callFake(function(options,context){if(options&&_.isFunction(options.error)){options.error.call(context,"Oh nosers.")}});spyOn(Backbone.Model.prototype,"save").and.callFake(function(attrs,options){if(options&&_.isFunction(options.success)){options.success()}})});it("With callbacks",function(){model.save(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.save).not.toHaveBeenCalled();expect(callbacks.success).not.toHaveBeenCalled();expect(callbacks.error).toHaveBeenCalled();expect(model.trigger).not.toHaveBeenCalledWith("saved")});it("Without callbacks",function(){model.save();expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.save).not.toHaveBeenCalled();expect(model.trigger).not.toHaveBeenCalledWith("saved")})})});describe("Request payload",function(){it("Saved data",function(){model.set("id",1);model.url="/api/foos/";expect(model.isNew()).toBe(false);spyOn(model,"toJSON").and.callFake(function(){return{a:10,b:20,c:30}});spyOn(model,"ready").and.callFake(function(options,context){options.ready.call(context)});spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax").and.callFake(function(request){expect(request.url).toBe(model.url);expect(request.contentType).toBe("application/x-www-form-urlencoded");expect(request.processData).toBe(true);expect(request.data.a).toBe(10);expect(request.data.b).toBe(20);expect(request.data.c).toBe(30);request.success({stat:"ok",foo:{id:1,a:10,b:20,c:30,links:{}}})});model.save();expect(model.toJSON).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled()})});describe("With file upload support",function(){beforeEach(function(){model.payloadFileKeys=["file"];model.url="/api/foos/";model.toJSON=function(){return{file:this.get("file"),myfield:"myvalue"}};spyOn(Backbone.Model.prototype,"save").and.callThrough();spyOn(RB,"apiCall").and.callThrough()});it("With file",function(done){var boundary="-----multipartformboundary",blob=new Blob(["Hello world!"],{type:"text/plain"});blob.name="myfile";spyOn($,"ajax").and.callFake(function(request){var fileReader=new FileReader;expect(request.type).toBe("POST");expect(request.processData).toBe(false);expect(request.contentType.indexOf("multipart/form-data; boundary=")).toBe(0);fileReader.onload=function(){var array=new Uint8Array(this.result),data=[],i;for(i=0;i<array.length;i++){data.push(String.fromCharCode(array[i]))}expect(data.join("")).toBe("--"+boundary+"\r\n"+'Content-Disposition: form-data; name="file"'+'; filename="myfile"\r\n'+"Content-Type: text/plain\r\n\r\n"+"Hello world!"+"\r\n"+"--"+boundary+"\r\n"+"Content-Disposition: form-data; "+'name="myfield"\r\n\r\n'+"myvalue\r\n"+"--"+boundary+"--\r\n\r\n");request.success({stat:"ok",foo:{id:42}})};fileReader.readAsArrayBuffer(request.data)});model.set("file",blob);model.save({success:function(){expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();done()},boundary:boundary})});it("With multiple files",function(done){var blob1=new Blob(["Hello world!"],{type:"text/plain"}),blob2=new Blob(["Goodbye world!"],{type:"text/plain"}),boundary="-----multipartformboundary";blob1.name="myfile1";blob2.name="myfile2";model.payloadFileKeys=["file1","file2"];model.toJSON=function(){return{file1:this.get("file1"),file2:this.get("file2"),myfield:"myvalue"}};spyOn($,"ajax").and.callFake(function(request){var fileReader=new FileReader;expect(request.type).toBe("POST");expect(request.processData).toBe(false);expect(request.contentType.indexOf("multipart/form-data; boundary=")).toBe(0);fileReader.onload=function(){var array=new Uint8Array(this.result),data=[],i;for(i=0;i<array.length;i++){data.push(String.fromCharCode(array[i]))}expect(data.join("")).toBe("--"+boundary+"\r\n"+'Content-Disposition: form-data; name="file1"'+'; filename="myfile1"\r\n'+"Content-Type: text/plain\r\n\r\n"+"Hello world!"+"\r\n"+"--"+boundary+"\r\n"+'Content-Disposition: form-data; name="file2"'+'; filename="myfile2"\r\n'+"Content-Type: text/plain\r\n\r\n"+"Goodbye world!"+"\r\n"+"--"+boundary+"\r\n"+"Content-Disposition: form-data; "+'name="myfield"\r\n\r\n'+"myvalue\r\n"+"--"+boundary+"--\r\n\r\n");request.success({stat:"ok",foo:{id:42}})};fileReader.readAsArrayBuffer(request.data)});model.set("file1",blob1);model.set("file2",blob2);model.save({success:function(){expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();done()},boundary:boundary})});it("Without file",function(done){spyOn($,"ajax").and.callFake(function(request){expect(request.type).toBe("POST");expect(request.processData).toBe(true);expect(request.contentType).toBe("application/x-www-form-urlencoded");request.success({stat:"ok",foo:{id:42}})});model.save({success:function(){expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();done()}})})});describe("With form upload support",function(){beforeEach(function(){model.url="/api/foos/"});it("Overriding toJSON attributes",function(){var form=$("<form/>").append($('<input name="foo"/>'));model.toJSON=function(){return{myfield:"myvalue"}};spyOn(Backbone,"sync").and.callThrough();spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax");spyOn(form,"ajaxSubmit");model.save({form:form});expect(RB.apiCall).toHaveBeenCalled();expect(form.ajaxSubmit).toHaveBeenCalled();expect($.ajax).not.toHaveBeenCalled();expect(Backbone.sync.calls.argsFor(0)[2].data).toBe(null);expect(RB.apiCall.calls.argsFor(0)[0].data).toBe(null)});it("Overriding file attributes",function(){var form=$("<form/>").append($('<input name="foo"/>'));model.payloadFileKey="file";model.toJSON=function(){return{file:this.get("file")}};spyOn(model,"_saveWithFiles").and.callThrough();spyOn(Backbone,"sync").and.callThrough();spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax");spyOn(form,"ajaxSubmit");model.save({form:form});expect(model._saveWithFiles).not.toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect(form.ajaxSubmit).toHaveBeenCalled();expect($.ajax).not.toHaveBeenCalled();expect(Backbone.sync.calls.argsFor(0)[2].data).toBe(null);expect(RB.apiCall.calls.argsFor(0)[0].data).toBe(null)})})});describe("url",function(){it("With self link",function(){var url="/api/base-resource/";model.set("links",{self:{href:url}});expect(model.url()).toBe(url)});it("With parentObject and model ID",function(){model.set({parentObject:parentObject,id:123});expect(model.url()).toBe("/api/foos/123/")});it("With parentObject, no links",function(){model.set("parentObject",parentObject);expect(model.url()).toBe("/api/foos/")});it("With no parentObject, no links",function(){expect(model.url()).toBe(null)})})});suite("rb/resources/models/DefaultReviewer",function(){var model;beforeEach(function(){model=new RB.DefaultReviewer});describe("parse",function(){it("API payloads",function(){var data=model.parse({stat:"ok",default_reviewer:{id:42,name:"my-default-reviewer",file_regex:"/foo/.*"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.name).toBe("my-default-reviewer");expect(data.fileRegex).toBe("/foo/.*")})});describe("toJSON",function(){describe("name field",function(){it("With value",function(){var data;model.set("name","foo");data=model.toJSON();expect(data.name).toBe("foo")})});describe("fileRegex field",function(){it("With value",function(){var data;model.set("fileRegex","/foo/.*");data=model.toJSON();expect(data.file_regex).toBe("/foo/.*")})})})});suite("rb/resources/models/DiffComment",function(){var model;beforeEach(function(){model=new RB.DiffComment({fileDiffID:16,parentObject:new RB.BaseResource({"public":true})})});it("getNumLines",function(){model.set({beginLineNum:5,endLineNum:10});expect(model.getNumLines()).toBe(6)});describe("parse",function(){it("API payloads",function(){var data=model.parse({stat:"ok",diff_comment:{id:42,issue_opened:true,issue_status:"resolved",text_type:"markdown",text:"foo",first_line:10,num_lines:5,filediff:{id:1,source_file:"my-file"},interfilediff:{id:2,source_file:"my-file"}}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.issueOpened).toBe(true);expect(data.issueStatus).toBe(RB.BaseComment.STATE_RESOLVED);expect(data.richText).toBe(true);expect(data.text).toBe("foo");expect(data.beginLineNum).toBe(10);expect(data.endLineNum).toBe(14);expect(data.fileDiff).not.toBe(undefined);expect(data.fileDiff.id).toBe(1);expect(data.fileDiff.get("sourceFilename")).toBe("my-file");expect(data.interFileDiff).not.toBe(undefined);expect(data.interFileDiff.id).toBe(2);expect(data.interFileDiff.get("sourceFilename")).toBe("my-file")})});describe("toJSON",function(){it("BaseComment.toJSON called",function(){spyOn(RB.BaseComment.prototype,"toJSON").and.callThrough();model.toJSON();expect(RB.BaseComment.prototype.toJSON).toHaveBeenCalled()});it("first_line field",function(){var data;model.set({beginLineNum:100,endLineNum:100});data=model.toJSON();expect(data.first_line).toBe(100)});it("num_lines field",function(){var data;model.set({beginLineNum:100,endLineNum:105});data=model.toJSON();expect(data.num_lines).toBe(6)});describe("force_text_type field",function(){it("With value",function(){var data;model.set("forceTextType","html");data=model.toJSON();expect(data.force_text_type).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.force_text_type).toBe(undefined)})});describe("include_text_types field",function(){it("With value",function(){var data;model.set("includeTextTypes","html");data=model.toJSON();expect(data.include_text_types).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.include_text_types).toBe(undefined)})});describe("filediff_id field",function(){it("When loaded",function(){var data;model.set("loaded",true);data=model.toJSON();expect(data.filediff_id).toBe(undefined)});it("When not loaded",function(){var data=model.toJSON();expect(data.filediff_id).toBe(16)})});describe("interfilediff_id field",function(){it("When loaded",function(){var data;model.set("loaded",true);data=model.toJSON();expect(data.interfilediff_id).toBe(undefined)});it("When not loaded",function(){var data;model.set("interFileDiffID",50);data=model.toJSON();expect(data.interfilediff_id).toBe(50)});it("When not loaded and unset",function(){var data;data=model.toJSON();expect(data.interfilediff_id).toBe(undefined)})})});describe("validate",function(){it("Inherited behavior",function(){spyOn(RB.BaseComment.prototype,"validate");model.validate({});expect(RB.BaseComment.prototype.validate).toHaveBeenCalled()});describe("beginLineNum/endLineNum",function(){describe("Valid values",function(){it("beginLineNum == 0, endLineNum == 0",function(){expect(model.validate({beginLineNum:0,endLineNum:0})).toBe(undefined)});it("beginLineNum > 0, endLineNum == beginLineNum",function(){expect(model.validate({beginLineNum:10,endLineNum:10})).toBe(undefined)});it("beginLineNum > 0, endLineNum > 0",function(){expect(model.validate({beginLineNum:10,endLineNum:11})).toBe(undefined)})});describe("Invalid values",function(){it("beginLineNum < 0",function(){expect(model.validate({beginLineNum:-1})).toBe(RB.DiffComment.strings.BEGINLINENUM_GTE_0)});it("endLineNum < 0",function(){expect(model.validate({endLineNum:-1})).toBe(RB.DiffComment.strings.ENDLINENUM_GTE_0)});it("endLineNum < beginLineNum",function(){expect(model.validate({beginLineNum:20,endLineNum:10})).toBe(RB.DiffComment.strings.BEGINLINENUM_LTE_ENDLINENUM)})})});describe("fileDiffID",function(){it("With value",function(){expect(model.validate({fileDiffID:42})).toBe(undefined)});it("Unset",function(){expect(model.validate({fileDiffID:null})).toBe(RB.DiffComment.strings.INVALID_FILEDIFF_ID)})})})});suite("rb/resources/models/DraftReview",function(){var model,parentObject;beforeEach(function(){parentObject=new RB.BaseResource({links:{reviews:{href:"/api/foos/"}}});model=new RB.DraftReview({parentObject:parentObject});model.rspNamespace="foo"});describe("Methods",function(){var callbacks;beforeEach(function(){callbacks={ready:function(){},success:function(){},error:function(){}};spyOn(callbacks,"ready");spyOn(callbacks,"success");spyOn(callbacks,"error")});describe("ready",function(){beforeEach(function(){spyOn(Backbone.Model.prototype,"fetch").and.callFake(function(options){if(options&&_.isFunction(options.success)){options.success()}});spyOn(parentObject,"ready").and.callFake(function(options,context){if(options&&_.isFunction(options.ready)){options.ready.call(context)}});spyOn(model,"_retrieveDraft").and.callFake(function(options,context){if(options&&_.isFunction(options.ready)){options.ready.call(context)}})});describe("With isNew=true",function(){beforeEach(function(){expect(model.isNew()).toBe(true);expect(model.get("loaded")).toBe(false)});it("With callbacks",function(){model.ready(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(model._retrieveDraft).toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled()})});describe("With isNew=false",function(){beforeEach(function(){model.set({id:123})});it("With callbacks",function(){model.ready(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(model._retrieveDraft).not.toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled()})})});describe("publish",function(){beforeEach(function(){spyOn(model,"save").and.callFake(function(options,context){options.success.call(context)})});it('Triggers "publishing" event before publish',function(){spyOn(model,"trigger");spyOn(model,"ready");model.publish();expect(model.trigger).toHaveBeenCalledWith("publishing")});it('Triggers "published" event after publish',function(){spyOn(model,"trigger");spyOn(model,"ready").and.callFake(function(options,context){options.ready.call(context)});model.publish(callbacks);expect(callbacks.success).toHaveBeenCalled();expect(model.trigger).toHaveBeenCalledWith("published")});it('Sets "public" to true',function(){spyOn(model,"ready").and.callFake(function(options,context){options.ready.call(context)});expect(model.get("public")).toBe(false);model.publish(callbacks);expect(callbacks.success).toHaveBeenCalled();expect(model.get("public")).toBe(true)})})})});suite("rb/resources/models/DraftReviewRequest",function(){var draft,callbacks;beforeEach(function(){var reviewRequest=new RB.ReviewRequest({id:1,links:{draft:{href:"/api/review-requests/123/draft/"}}});draft=reviewRequest.draft;callbacks={success:function(){},error:function(){}};spyOn(callbacks,"success");spyOn(callbacks,"error");spyOn(reviewRequest,"ready").and.callFake(function(options,context){options.ready.call(context)});spyOn(reviewRequest,"ensureCreated").and.callFake(function(options,context){options.success.call(context)});spyOn(draft,"ready").and.callFake(function(options,context){options.ready.call(context)})});it("url",function(){expect(draft.url()).toBe("/api/review-requests/123/draft/")});it("publish",function(){spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax").and.callFake(function(request){expect(request.data.public).toBe(1);request.success({stat:"ok",draft:{id:1,links:{}}})});draft.set({targetGroups:[{name:"mygroup",url:"/groups/mygroup"}],summary:"My summary",description:"My description"});draft.publish({success:callbacks.success,error:callbacks.error});expect(callbacks.error).not.toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled()});it("parse",function(){var data=draft.parse({stat:"ok",draft:{id:1,branch:"branch",bugs_closed:"bugsClosed",changedescription:"changeDescription",changedescription_text_type:"markdown",description:"description","public":"public",description_text_type:"markdown",summary:"summary",target_groups:"targetGroups",target_people:"targetPeople",testing_done:"testingDone",testing_done_text_type:"plain",links:{submitter:"submitter"}}});expect(data).not.toBe(undefined);expect(data.id).toBe(1);expect(data.branch).toBe("branch");expect(data.bugsClosed).toBe("bugsClosed");expect(data.changeDescription).toBe("changeDescription");expect(data.changeDescriptionRichText).toBe(true);expect(data.description).toBe("description");expect(data.descriptionRichText).toBe(true);expect(data.public).toBe("public");expect(data.summary).toBe("summary");expect(data.submitter).toBe("submitter");expect(data.targetGroups).toBe("targetGroups");expect(data.targetPeople).toBe("targetPeople");expect(data.testingDone).toBe("testingDone");expect(data.testingDoneRichText).toBe(false)})});suite("rb/resources/models/FileAttachment",function(){beforeEach(function(){parentObject=new RB.BaseResource({"public":true});model=new RB.FileAttachment({parentObject:parentObject})});describe("toJSON",function(){describe("caption field",function(){it("With value",function(){var data;model.set("caption","foo");data=model.toJSON();expect(data.caption).toBe("foo")})});describe("file field",function(){it("With new file attachment",function(){var data;expect(model.isNew()).toBe(true);model.set("file","abc");data=model.toJSON();expect(data.path).toBe("abc")});it("With existing file attachment",function(){var data;model.id=123;expect(model.isNew()).toBe(false);model.set("file","abc");data=model.toJSON();expect(data.path).toBe(undefined)})})});describe("parse",function(){it("API payloads",function(){var data=model.parse({stat:"ok",file_attachment:{id:42,caption:"caption",url:"downloadURL",filename:"filename",review_url:"reviewURL",revision:123,thumbnail:"thumbnailHTML"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.caption).toBe("caption");expect(data.downloadURL).toBe("downloadURL");expect(data.filename).toBe("filename");expect(data.reviewURL).toBe("reviewURL");expect(data.revision).toBe(123);expect(data.thumbnailHTML).toBe("thumbnailHTML")})})});suite("rb/resources/models/FileAttachmentComment",function(){var baseStrings=RB.BaseResource.strings,model;beforeEach(function(){model=new RB.FileAttachmentComment({fileAttachmentID:16,parentObject:new RB.BaseResource({"public":true})})});describe("parse",function(){it("API payloads",function(){var data=model.parse({stat:"ok",file_attachment_comment:{id:42,issue_opened:true,issue_status:"resolved",text_type:"markdown",text:"foo",extra_data:{my_int:123,my_bool:true,my_str:"strvalue",my_null:null},link_text:"my-link-text",thumbnail_html:"<blink>Boo</blink>",review_url:"/review-ui/",file_attachment:{id:10,filename:"file.txt"}}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.issueOpened).toBe(true);expect(data.issueStatus).toBe(RB.BaseComment.STATE_RESOLVED);expect(data.richText).toBe(true);expect(data.text).toBe("foo");expect(data.extraData).not.toBe(undefined);expect(data.extraData.my_int).toBe(123);expect(data.extraData.my_bool).toBe(true);expect(data.extraData.my_str).toBe("strvalue");expect(data.extraData.my_null).toBe(null);expect(data.linkText).toBe("my-link-text");expect(data.thumbnailHTML).toBe("<blink>Boo</blink>");expect(data.reviewURL).toBe("/review-ui/");expect(data.fileAttachment).not.toBe(undefined);expect(data.fileAttachment.id).toBe(10);expect(data.fileAttachment.get("filename")).toBe("file.txt");expect(data.fileAttachmentID).toBe(10)})});describe("toJSON",function(){it("BaseComment.toJSON called",function(){spyOn(RB.BaseComment.prototype,"toJSON").and.callThrough();model.toJSON();expect(RB.BaseComment.prototype.toJSON).toHaveBeenCalled()});describe("diff_against_file_attachment_id field",function(){it("When loaded",function(){var data;model.set({loaded:true,diffAgainstFileAttachmentID:123});data=model.toJSON();expect(data.diff_against_file_attachment_id).toBe(undefined)});describe("When not loaded",function(){it("With value",function(){var data;model.set("diffAgainstFileAttachmentID",123);data=model.toJSON();expect(data.diff_against_file_attachment_id).toBe(123)});it("Without value",function(){var data;data=model.toJSON();expect(data.diff_against_file_attachment_id).toBe(undefined)})})});describe("file_attachment_id field",function(){it("When loaded",function(){var data;model.set({loaded:true,fileAttachmentID:123});data=model.toJSON();expect(data.file_attachment_id).toBe(undefined)});it("When not loaded",function(){var data;model.set("fileAttachmentID",123);data=model.toJSON();expect(data.file_attachment_id).toBe(123)})});describe("force_text_type field",function(){it("With value",function(){var data;model.set("forceTextType","html");data=model.toJSON();expect(data.force_text_type).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.force_text_type).toBe(undefined)})});describe("include_text_types field",function(){it("With value",function(){var data;model.set("includeTextTypes","html");data=model.toJSON();expect(data.include_text_types).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.include_text_types).toBe(undefined)})});it("extra_data field",function(){var data;model.set({extraData:{my_int:123,my_bool:true,my_str:"strvalue",my_null:null}});data=model.toJSON();expect(data["extra_data.my_int"]).toBe(123);expect(data["extra_data.my_bool"]).toBe(true);expect(data["extra_data.my_str"]).toBe("strvalue");expect(data["extra_data.my_null"]).toBe(null)})});describe("validate",function(){it("Inherited behavior",function(){spyOn(RB.BaseComment.prototype,"validate");model.validate({});expect(RB.BaseComment.prototype.validate).toHaveBeenCalled()});describe("extraData",function(){describe("Valid values",function(){it("Empty object",function(){expect(model.validate({extraData:{}})).toBe(undefined)});it("Populated object",function(){expect(model.validate({extraData:{a:42}})).toBe(undefined)});it("Undefined",function(){expect(model.validate({extraData:undefined})).toBe(undefined)})});describe("Invalid values",function(){var errStr=baseStrings.INVALID_EXTRADATA_TYPE;it("Array",function(){expect(model.validate({extraData:""})).toBe(errStr)});it("Boolean",function(){expect(model.validate({extraData:false})).toBe(errStr)});it("Integer",function(){expect(model.validate({extraData:0})).toBe(errStr)});it("Null",function(){expect(model.validate({extraData:null})).toBe(errStr)});it("String",function(){expect(model.validate({extraData:""})).toBe(errStr)})})});describe("extraData entries",function(){describe("Valid values",function(){it("Booleans",function(){expect(model.validate({extraData:{value:true}})).toBe(undefined)});it("Integers",function(){expect(model.validate({extraData:{value:42}})).toBe(undefined)});it("Null",function(){expect(model.validate({extraData:{value:null}})).toBe(undefined)});it("Strings",function(){expect(model.validate({extraData:{value:"foo"}})).toBe(undefined)})});describe("Invalid values",function(){var errStr=baseStrings.INVALID_EXTRADATA_VALUE_TYPE.replace("{key}","value");it("Arrays",function(){expect(model.validate({extraData:{value:[1,2,3]}})).toBe(errStr)});it("NaN",function(){expect(model.validate({extraData:{value:NaN}})).toBe(errStr)});it("Objects",function(){expect(model.validate({extraData:{value:{a:1}}})).toBe(errStr)});it("Undefined",function(){expect(model.validate({extraData:{value:undefined}})).toBe(errStr)})})})})});suite("rb/resources/models/FileDiff",function(){var model;beforeEach(function(){model=new RB.FileDiff({destFilename:"dest-file",sourceFilename:"source-file",sourceRevision:"source-revision"})});describe("parse",function(){it("API payloads",function(){var data=model.parse({stat:"ok",filediff:{id:42,dest_file:"my-dest-file",source_file:"my-source-file",source_revision:"my-source-revision"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.destFilename).toBe("my-dest-file");expect(data.sourceFilename).toBe("my-source-file");expect(data.sourceRevision).toBe("my-source-revision")})})});suite("rb/resources/models/GeneralComment",function(){var model;beforeEach(function(){model=new RB.GeneralComment({parentObject:new RB.BaseResource({"public":true})})});describe("parse",function(){it("API payloads",function(){var data=model.parse({stat:"ok",general_comment:{id:42,issue_opened:true,issue_status:"resolved",text_type:"markdown",text:"foo"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.issueOpened).toBe(true);expect(data.issueStatus).toBe(RB.BaseComment.STATE_RESOLVED);expect(data.richText).toBe(true);expect(data.text).toBe("foo")})});describe("toJSON",function(){it("BaseComment.toJSON called",function(){spyOn(RB.BaseComment.prototype,"toJSON").and.callThrough();model.toJSON();expect(RB.BaseComment.prototype.toJSON).toHaveBeenCalled()})});describe("validate",function(){it("Inherited behavior",function(){spyOn(RB.BaseComment.prototype,"validate");model.validate({});expect(RB.BaseComment.prototype.validate).toHaveBeenCalled()})})});suite("rb/resources/models/Screenshot",function(){var parentObject,model;beforeEach(function(){parentObject=new RB.BaseResource({"public":true});model=new RB.Screenshot({parentObject:parentObject})});describe("getDisplayName",function(){it("With caption",function(){model.set("caption","My Caption");expect(model.getDisplayName()).toBe("My Caption")});it("With filename",function(){model.set("filename","myfile.png");expect(model.getDisplayName()).toBe("myfile.png")});it("With caption and filename",function(){model.set({caption:"My Caption",filename:"myfile.png"});expect(model.getDisplayName()).toBe("My Caption")})});describe("parse",function(){it("API payloads",function(){var data=model.parse({stat:"ok",screenshot:{id:42,caption:"my-caption",filename:"my-filename",review_url:"/review-ui/"}});
expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.caption).toBe("my-caption");expect(data.filename).toBe("my-filename");expect(data.reviewURL).toBe("/review-ui/")})});describe("toJSON",function(){describe("caption field",function(){it("With value",function(){var data;model.set("caption","foo");data=model.toJSON();expect(data.caption).toBe("foo")})})})});suite("rb/resources/models/ScreenshotComment",function(){var strings=RB.ScreenshotComment.strings,model;beforeEach(function(){model=new RB.ScreenshotComment({screenshotID:16,parentObject:new RB.BaseResource({"public":true}),x:0,y:0,width:1,height:1})});describe("parse",function(){it("API payloads",function(){var data=model.parse({stat:"ok",screenshot_comment:{id:42,issue_opened:true,issue_status:"resolved",text_type:"markdown",text:"foo",x:10,y:20,w:30,h:40,thumbnail_url:"/thumbnail.png",screenshot:{id:10,filename:"image.png"}}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.issueOpened).toBe(true);expect(data.issueStatus).toBe(RB.BaseComment.STATE_RESOLVED);expect(data.richText).toBe(true);expect(data.text).toBe("foo");expect(data.x).toBe(10);expect(data.y).toBe(20);expect(data.width).toBe(30);expect(data.height).toBe(40);expect(data.thumbnailURL).toBe("/thumbnail.png");expect(data.screenshot).not.toBe(undefined);expect(data.screenshot.id).toBe(10);expect(data.screenshot.get("filename")).toBe("image.png");expect(data.screenshotID).toBe(10)})});describe("toJSON",function(){it("BaseComment.toJSON called",function(){spyOn(RB.BaseComment.prototype,"toJSON").and.callThrough();model.toJSON();expect(RB.BaseComment.prototype.toJSON).toHaveBeenCalled()});it("x field",function(){var data;model.set("x",10);data=model.toJSON();expect(data.x).toBe(10)});it("y field",function(){var data;model.set("y",10);data=model.toJSON();expect(data.y).toBe(10)});it("w field",function(){var data;model.set("width",10);data=model.toJSON();expect(data.w).toBe(10)});it("h field",function(){var data;model.set("height",10);data=model.toJSON();expect(data.h).toBe(10)});describe("force_text_type field",function(){it("With value",function(){var data;model.set("forceTextType","html");data=model.toJSON();expect(data.force_text_type).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.force_text_type).toBe(undefined)})});describe("include_text_types field",function(){it("With value",function(){var data;model.set("includeTextTypes","html");data=model.toJSON();expect(data.include_text_types).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.include_text_types).toBe(undefined)})})});describe("validate",function(){it("Inherited behavior",function(){spyOn(RB.BaseComment.prototype,"validate");model.validate({});expect(RB.BaseComment.prototype.validate).toHaveBeenCalled()});describe("x",function(){describe("Valid values",function(){it("0",function(){expect(model.validate({x:0})).toBe(undefined)});it("> 0",function(){expect(model.validate({x:10})).toBe(undefined)})});describe("Invalid values",function(){it("< 0",function(){expect(model.validate({x:-1})).toBe(strings.INVALID_X)})})});describe("y",function(){describe("Valid values",function(){it("0",function(){expect(model.validate({y:0})).toBe(undefined)});it("> 0",function(){expect(model.validate({y:10})).toBe(undefined)})});describe("Invalid values",function(){it("< 0",function(){expect(model.validate({y:-1})).toBe(strings.INVALID_Y)})})});describe("width",function(){describe("Valid values",function(){it("> 0",function(){expect(model.validate({width:10})).toBe(undefined)})});describe("Invalid values",function(){it("0",function(){expect(model.validate({width:0})).toBe(strings.INVALID_WIDTH)});it("< 0",function(){expect(model.validate({width:-1})).toBe(strings.INVALID_WIDTH)})})});describe("height",function(){describe("Valid values",function(){it("> 0",function(){expect(model.validate({height:10})).toBe(undefined)})});describe("Invalid values",function(){it("0",function(){expect(model.validate({height:0})).toBe(strings.INVALID_HEIGHT)});it("< 0",function(){expect(model.validate({height:-1})).toBe(strings.INVALID_HEIGHT)})})})})});suite("rb/resources/models/RepositoryBranch",function(){var model;beforeEach(function(){model=new RB.RepositoryBranch});describe("parse",function(){it("API payloads",function(){var data=model.parse({name:"master",commit:"c8ffef025488802a77f499d7f0d24579d858b07e","default":true});expect(data).not.toBe(undefined);expect(data.name).toBe("master");expect(data.commit).toBe("c8ffef025488802a77f499d7f0d24579d858b07e");expect(data.isDefault).toBe(true)})})});suite("rb/resources/models/RepositoryCommit",function(){var model;beforeEach(function(){model=new RB.RepositoryCommit});describe("parse",function(){it("API payloads",function(){var data=model.parse({author_name:"Sneezy",date:"2013-06-25T23:31:22Z",id:"859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817",message:"Here's a commit message\n\nWith a description",review_request_url:"http://example.com/r/12/"});expect(data).not.toBe(undefined);expect(data.authorName).toBe("Sneezy");expect(data.id).toBe("859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817");expect(data.date.getUTCFullYear()).toBe(2013);expect(data.date.getUTCDate()).toBe(25);expect(data.message).toBe("Here's a commit message\n\nWith a description");expect(data.summary).toBe("Here's a commit message");expect(data.reviewRequestURL).toBe("http://example.com/r/12/")})})});suite("rb/resources/models/ReviewGroup",function(){describe("setStarred",function(){var url="/api/users/testuser/watched/groups/",callbacks,session,group;beforeEach(function(){RB.UserSession.instance=null;session=RB.UserSession.create({username:"testuser",watchedReviewGroupsURL:url});group=new RB.ReviewGroup({id:1});callbacks={success:function(){},error:function(){}};spyOn(session.watchedGroups,"addImmediately").and.callThrough();spyOn(session.watchedGroups,"removeImmediately").and.callThrough();spyOn(RB,"apiCall").and.callThrough();spyOn(callbacks,"success");spyOn(callbacks,"error")});it("true",function(){spyOn($,"ajax").and.callFake(function(request){expect(request.type).toBe("POST");expect(request.url).toBe(url);request.success({stat:"ok"})});group.setStarred(true,callbacks);expect(session.watchedGroups.addImmediately).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("false",function(){spyOn($,"ajax").and.callFake(function(request){expect(request.type).toBe("DELETE");expect(request.url).toBe(url+"1/");request.success({stat:"ok"})});group.setStarred(false,callbacks);expect(session.watchedGroups.removeImmediately).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()})});describe("addUser",function(){var callbacks,group;beforeEach(function(){group=new RB.ReviewGroup({id:1,name:"test-group"});callbacks={success:function(){},error:function(){}};spyOn(RB,"apiCall").and.callThrough();spyOn(callbacks,"success");spyOn(callbacks,"error")});it("Loaded group",function(){spyOn($,"ajax").and.callFake(function(request){expect(request.type).toBe("POST");expect(request.data.username).toBe("my-user");request.success({stat:"ok"})});group.addUser("my-user",callbacks);expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled()});it("Unloaded group",function(){spyOn($,"ajax");group.set("id",null);expect(group.isNew()).toBe(true);group.addUser("my-user",callbacks);expect(RB.apiCall).not.toHaveBeenCalled();expect($.ajax).not.toHaveBeenCalled();expect(callbacks.error).toHaveBeenCalled()})});describe("removeUser",function(){var callbacks,group;beforeEach(function(){group=new RB.ReviewGroup({id:1,name:"test-group"});callbacks={success:function(){},error:function(){}};spyOn(RB,"apiCall").and.callThrough();spyOn(callbacks,"success");spyOn(callbacks,"error")});it("Loaded group",function(){spyOn($,"ajax").and.callFake(function(request){expect(request.type).toBe("DELETE");request.success()});group.removeUser("my-user",callbacks);expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled()});it("Unloaded group",function(){spyOn($,"ajax");group.set("id",null);expect(group.isNew()).toBe(true);group.removeUser("my-user",callbacks);expect(RB.apiCall).not.toHaveBeenCalled();expect($.ajax).not.toHaveBeenCalled();expect(callbacks.error).toHaveBeenCalled()})})});suite("rb/resources/models/Review",function(){var model;beforeEach(function(){model=new RB.Review({parentObject:new RB.ReviewRequest})});describe("createReply",function(){it("Returns cached draft reply",function(){var reviewReply,reviewReply2;expect(model.get("draftReply")).toBe(null);reviewReply=model.createReply();expect(model.get("draftReply")).toBe(reviewReply);reviewReply2=model.createReply();expect(reviewReply).toBe(reviewReply2)});it("Cached draft reply resets on publish",function(){var reviewReply;reviewReply=model.createReply();expect(model.get("draftReply")).toBe(reviewReply);reviewReply.trigger("published");expect(model.get("draftReply")).toBe(null)})});describe("parse",function(){beforeEach(function(){model.rspNamespace="my_review"});it("Common API payloads",function(){var data=model.parse({stat:"ok",my_review:{id:42,body_top:"my body top",body_bottom:"my body bottom","public":false,body_top_text_type:"markdown",body_bottom_text_type:"plain",ship_it:false}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.bodyTop).toBe("my body top");expect(data.bodyBottom).toBe("my body bottom");expect(data.public).toBe(false);expect(data.bodyTopRichText).toBe(true);expect(data.bodyBottomRichText).toBe(false);expect(data.shipIt).toBe(false)});it("With raw_text_fields",function(){var data=model.parse({stat:"ok",my_review:{body_top:"my body top",body_bottom:"my body bottom",body_top_text_type:"markdown",body_bottom_text_type:"plain",raw_text_fields:{body_top:"raw body top",body_top_text_type:"raw",body_bottom:"raw body bottom",body_bottom_text_type:"raw"}}});expect(data).not.toBe(undefined);expect(data.bodyTop).toBe("my body top");expect(data.bodyBottom).toBe("my body bottom");expect(data.bodyTopRichText).toBe(false);expect(data.bodyBottomRichText).toBe(false);expect(data.rawTextFields).toBeTruthy();expect(data.rawTextFields.bodyTop).toBe("raw body top");expect(data.rawTextFields.bodyBottom).toBe("raw body bottom")});it("With markdown_text_fields",function(){var data=model.parse({stat:"ok",my_review:{body_top:"my body top",body_bottom:"my body bottom",body_top_text_type:"markdown",body_bottom_text_type:"plain",markdown_text_fields:{body_top:"Markdown body top",body_top_text_type:"markdown",body_bottom:"Markdown body bottom",body_bottom_text_type:"markdown"}}});expect(data).not.toBe(undefined);expect(data.bodyTop).toBe("my body top");expect(data.bodyBottom).toBe("my body bottom");expect(data.bodyTopRichText).toBe(true);expect(data.bodyBottomRichText).toBe(false);expect(data.markdownTextFields).toBeTruthy();expect(data.markdownTextFields.bodyTop).toBe("Markdown body top");expect(data.markdownTextFields.bodyBottom).toBe("Markdown body bottom")});it("With html_text_fields",function(){var data=model.parse({stat:"ok",my_review:{body_top:"my body top",body_bottom:"my body bottom",body_top_text_type:"markdown",body_bottom_text_type:"plain",html_text_fields:{body_top:"HTML body top",body_top_text_type:"html",body_bottom:"HTML body bottom",body_bottom_text_type:"html"}}});expect(data).not.toBe(undefined);expect(data.bodyTop).toBe("my body top");expect(data.bodyBottom).toBe("my body bottom");expect(data.bodyTopRichText).toBe(true);expect(data.bodyBottomRichText).toBe(false);expect(data.htmlTextFields).toBeTruthy();expect(data.htmlTextFields.bodyTop).toBe("HTML body top");expect(data.htmlTextFields.bodyBottom).toBe("HTML body bottom")})});describe("toJSON",function(){describe("bodyTop field",function(){it("With value",function(){var data;model.set("bodyTop","foo");data=model.toJSON();expect(data.body_top).toBe("foo")})});describe("bodyBottom field",function(){it("With value",function(){var data;model.set("bodyBottom","foo");data=model.toJSON();expect(data.body_bottom).toBe("foo")})});describe("force_text_type field",function(){it("With value",function(){var data;model.set("forceTextType","html");data=model.toJSON();expect(data.force_text_type).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.force_text_type).toBe(undefined)})});describe("include_text_types field",function(){it("With value",function(){var data;model.set("includeTextTypes","html");data=model.toJSON();expect(data.include_text_types).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.include_text_types).toBe(undefined)})});describe("public field",function(){it("With value",function(){var data;model.set("public",true);data=model.toJSON();expect(data.public).toBe(1)});it("Without value",function(){var data=model.toJSON();expect(data.public).toBe(undefined)})});describe("bodyTopRichText field",function(){it("With true",function(){var data;model.set("bodyTopRichText",true);data=model.toJSON();expect(data.body_top_text_type).toBe("markdown")});it("With false",function(){var data;model.set("bodyTopRichText",false);data=model.toJSON();expect(data.body_top_text_type).toBe("plain")})});describe("bodyBottomRichText field",function(){it("With true",function(){var data;model.set("bodyBottomRichText",true);data=model.toJSON();expect(data.body_bottom_text_type).toBe("markdown")});it("With false",function(){var data;model.set("bodyBottomRichText",false);data=model.toJSON();expect(data.body_bottom_text_type).toBe("plain")})});describe("shipIt field",function(){it("With value",function(){var data;model.set("shipIt",true);data=model.toJSON();expect(data.ship_it).toBe(true)})})})});suite("rb/resources/models/ReviewReply",function(){var parentObject,model;beforeEach(function(){parentObject=new RB.BaseResource({"public":true,links:{replies:{href:"/api/foos/replies/"}}});model=new RB.ReviewReply({parentObject:parentObject})});describe("destroy",function(){var callbacks;beforeEach(function(){callbacks={ready:function(){},error:function(){}};spyOn(Backbone.Model.prototype,"destroy").and.callFake(function(options){if(options&&_.isFunction(options.success)){options.success()}});spyOn(model,"_retrieveDraft").and.callThrough();spyOn(parentObject,"ready").and.callFake(function(options,context){if(options&&_.isFunction(options.ready)){options.ready.call(context)}});spyOn(callbacks,"ready");spyOn(callbacks,"error")});describe("With isNew=true",function(){beforeEach(function(){expect(model.isNew()).toBe(true);expect(model.get("loaded")).toBe(false);spyOn(Backbone.Model.prototype,"fetch").and.callFake(function(options){if(options&&_.isFunction(options.success)){options.error(model,{status:404})}})});it("With callbacks",function(){model.destroy(callbacks);expect(model.isNew()).toBe(true);expect(model.get("loaded")).toBe(false);expect(parentObject.ready).toHaveBeenCalled();expect(model._retrieveDraft).toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).toHaveBeenCalled();expect(Backbone.Model.prototype.destroy).toHaveBeenCalled()})});describe("With isNew=false",function(){beforeEach(function(){model.set({id:123,loaded:true});spyOn(Backbone.Model.prototype,"fetch")});it("With callbacks",function(){model.destroy(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(model._retrieveDraft).not.toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).not.toHaveBeenCalled();expect(Backbone.Model.prototype.destroy).toHaveBeenCalled()})})});describe("discardIfEmpty",function(){var callbacks;beforeEach(function(){callbacks={success:function(){},error:function(){}};spyOn(model,"destroy").and.callFake(function(options){if(options&&_.isFunction(options.success)){options.success()}});spyOn(parentObject,"ready").and.callFake(function(options,context){if(options&&_.isFunction(options.ready)){options.ready.call(context)}});spyOn(model,"ready").and.callFake(function(options,context){if(options&&_.isFunction(options.ready)){options.ready.call(context)}});spyOn(callbacks,"success");spyOn(callbacks,"error")});it("With isNew=true",function(){expect(model.isNew()).toBe(true);expect(model.get("loaded")).toBe(false);model.discardIfEmpty(callbacks);expect(model.destroy).not.toHaveBeenCalled()});describe("With isNew=false",function(){var commentsData={};beforeEach(function(){model.set({id:123,loaded:true,links:{self:{href:"/api/foos/replies/123/"},diff_comments:{href:"/api/diff-comments/"},screenshot_comments:{href:"/api/screenshot-comments/"},file_attachment_comments:{href:"/api/file-attachment-comments/"},general_comments:{href:"/api/general-comments/"}}});spyOn(RB,"apiCall").and.callFake(function(options){var links=model.get("links"),data={},key=_.find(RB.ReviewReply.prototype.COMMENT_LINK_NAMES,function(name){return options.url===links[name].href});if(key){data[key]=commentsData[key]||[];options.success(data)}else{options.error({status:404})}});spyOn(Backbone.Model.prototype,"fetch").and.callFake(function(options){if(options&&_.isFunction(options.success)){options.success()}})});it("With no comments or body replies",function(){model.discardIfEmpty(callbacks);expect(model.destroy).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith(true)});it("With bodyTop",function(){model.set({bodyTop:"hi"});model.discardIfEmpty(callbacks);expect(model.destroy).not.toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith(false)});it("With bodyBottom",function(){model.set({bodyBottom:"hi"});model.discardIfEmpty(callbacks);expect(model.destroy).not.toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith(false)});it("With diff comment",function(){commentsData.diff_comments=[{id:1}];model.discardIfEmpty(callbacks);expect(model.destroy).not.toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith(false)});it("With screenshot comment",function(){commentsData.screenshot_comments=[{id:1}];model.discardIfEmpty(callbacks);expect(model.destroy).not.toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith(false)});it("With file attachment comment",function(){commentsData.file_attachment_comments=[{id:1}];model.discardIfEmpty(callbacks);expect(model.destroy).not.toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith(false)});it("With general comment",function(){commentsData.general_comments=[{id:1}];model.discardIfEmpty(callbacks);expect(model.destroy).not.toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith(false)})})});describe("ready",function(){var callbacks;beforeEach(function(){callbacks={ready:function(){},error:function(){}};spyOn(parentObject,"ready").and.callFake(function(options,context){if(options&&_.isFunction(options.ready)){options.ready.call(context)}});spyOn(callbacks,"ready");spyOn(callbacks,"error")});describe("With isNew=true",function(){beforeEach(function(){expect(model.isNew()).toBe(true);expect(model.get("loaded")).toBe(false);spyOn(Backbone.Model.prototype,"fetch").and.callFake(function(options){if(options&&_.isFunction(options.success)){options.success()}});spyOn(model,"_retrieveDraft").and.callFake(function(options,context){if(options&&_.isFunction(options.ready)){options.ready.call(context)}})});it("With callbacks",function(){model.ready(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(model._retrieveDraft).toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled()})});describe("With isNew=false",function(){beforeEach(function(){model.set({id:123});spyOn(Backbone.Model.prototype,"fetch").and.callFake(function(options){if(options&&_.isFunction(options.success)){options.success()}});spyOn(model,"_retrieveDraft").and.callFake(function(options,context){if(options&&_.isFunction(options.ready)){options.ready.call(context)}})});it("With callbacks",function(){model.ready(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(model._retrieveDraft).not.toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled()})});it("After destruction",function(){spyOn(model,"_retrieveDraft").and.callThrough();spyOn(Backbone.Model.prototype,"fetch").and.callFake(function(options){model.set({id:123,links:{self:{href:"/api/foos/replies/123/"}},loaded:true});options.success()});spyOn(Backbone.Model.prototype,"destroy").and.callFake(function(options){options.success()});expect(model.isNew()).toBe(true);expect(model.get("loaded")).toBe(false);expect(model._needDraft).toBe(undefined);model.ready(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(model._retrieveDraft).toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled();expect(model.isNew()).toBe(false);expect(model.get("loaded")).toBe(true);expect(model._needDraft).toBe(false);model.destroy(callbacks);expect(model.isNew()).toBe(true);expect(model.get("loaded")).toBe(false);expect(model._needDraft).toBe(true);parentObject.ready.calls.reset();model._retrieveDraft.calls.reset();callbacks.ready.calls.reset();model.ready(callbacks);expect(model._retrieveDraft).toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled();expect(model._needDraft).toBe(false)})});describe("parse",function(){beforeEach(function(){model.rspNamespace="my_reply"});it("API payloads",function(){var data=model.parse({stat:"ok",my_reply:{id:42,body_top:"foo",body_bottom:"bar","public":false,body_top_text_type:"markdown",body_bottom_text_type:"plain"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.bodyTop).toBe("foo");expect(data.bodyBottom).toBe("bar");expect(data.public).toBe(false);expect(data.bodyTopRichText).toBe(true);expect(data.bodyBottomRichText).toBe(false)})});describe("toJSON",function(){describe("bodyTop field",function(){it("With value",function(){var data;model.set("bodyTop","foo");data=model.toJSON();expect(data.body_top).toBe("foo")})});describe("bodyBottom field",function(){it("With value",function(){var data;model.set("bodyBottom","foo");data=model.toJSON();expect(data.body_bottom).toBe("foo")})});describe("bodyTopRichText field",function(){it("With true",function(){var data;model.set("bodyTopRichText",true);data=model.toJSON();expect(data.body_top_text_type).toBe("markdown")});it("With false",function(){var data;model.set("bodyTopRichText",false);data=model.toJSON();expect(data.body_top_text_type).toBe("plain")})});describe("bodyBottomRichText field",function(){it("With true",function(){var data;model.set("bodyBottomRichText",true);data=model.toJSON();expect(data.body_bottom_text_type).toBe("markdown")});it("With false",function(){var data;model.set("bodyBottomRichText",false);data=model.toJSON();expect(data.body_bottom_text_type).toBe("plain")})});describe("force_text_type field",function(){it("With value",function(){var data;model.set("forceTextType","html");data=model.toJSON();expect(data.force_text_type).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.force_text_type).toBe(undefined)})});describe("include_text_types field",function(){it("With value",function(){var data;model.set("includeTextTypes","html");data=model.toJSON();expect(data.include_text_types).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.include_text_types).toBe(undefined)})});describe("public field",function(){it("With value",function(){var data;model.set("public",true);data=model.toJSON();expect(data.public).toBe(true)})})})});suite("rb/resources/models/ReviewRequest",function(){var reviewRequest,callbacks;beforeEach(function(){reviewRequest=new RB.ReviewRequest({id:1});callbacks={success:function(){},error:function(){}};spyOn(callbacks,"success");spyOn(callbacks,"error");spyOn(reviewRequest,"ready").and.callFake(function(options,context){options.ready.call(context)})});it("createDiff",function(){var diff=reviewRequest.createDiff();expect(diff.get("parentObject")).toBe(reviewRequest)});it("createScreenshot",function(){var screenshot=reviewRequest.createScreenshot(42);expect(screenshot.get("parentObject")).toBe(reviewRequest);expect(screenshot.id).toBe(42)});it("createFileAttachment",function(){var fileAttachment=reviewRequest.createFileAttachment({id:42});expect(fileAttachment.get("parentObject")).toBe(reviewRequest);expect(fileAttachment.id).toBe(42)});it("parse",function(){var data=reviewRequest.parse({stat:"ok",review_request:{id:1,branch:"branch",bugs_closed:"bugsClosed",close_description:"closeDescription",close_description_text_type:"markdown",description:"description",description_text_type:"markdown",last_updated:"lastUpdated","public":"public",summary:"summary",target_groups:"targetGroups",target_people:"targetPeople",testing_done:"testingDone",testing_done_text_type:"plain"}});expect(data).not.toBe(undefined);expect(data.id).toBe(1);expect(data.branch).toBe("branch");expect(data.bugsClosed).toBe("bugsClosed");expect(data.closeDescription).toBe("closeDescription");expect(data.closeDescriptionRichText).toBe(true);expect(data.description).toBe("description");expect(data.descriptionRichText).toBe(true);expect(data.lastUpdated).toBe("lastUpdated");expect(data.public).toBe("public");expect(data.summary).toBe("summary");expect(data.targetGroups).toBe("targetGroups");expect(data.targetPeople).toBe("targetPeople");expect(data.testingDone).toBe("testingDone");expect(data.testingDoneRichText).toBe(false)});it("reopen",function(){spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax").and.callFake(function(request){expect(request.type).toBe("PUT");expect(request.data.status).toBe("pending");request.success({stat:"ok",review_request:{id:1,links:{}}})});reviewRequest.reopen({success:callbacks.success,error:callbacks.error});expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});describe("createReview",function(){it("With review ID",function(){var review=reviewRequest.createReview(42);expect(review.get("parentObject")).toBe(reviewRequest);expect(review.get("id")).toBe(42);expect(reviewRequest.get("draftReview")).toBe(null);expect(reviewRequest.reviews.length).toBe(1);expect(reviewRequest.reviews.get(42)).toBe(review)});it("Without review ID",function(){var review1=reviewRequest.createReview(),review2=reviewRequest.createReview();expect(review1.get("parentObject")).toBe(reviewRequest);expect(review1.id).toBeFalsy();expect(reviewRequest.get("draftReview")).toBe(review1);expect(review1).toBe(review2);expect(reviewRequest.reviews.length).toBe(0)})});describe("setStarred",function(){var url="/api/users/testuser/watched/review-requests/",session;beforeEach(function(){RB.UserSession.instance=null;session=RB.UserSession.create({username:"testuser",watchedReviewRequestsURL:url});spyOn(session.watchedReviewRequests,"addImmediately").and.callThrough();spyOn(session.watchedReviewRequests,"removeImmediately").and.callThrough();spyOn(RB,"apiCall").and.callThrough()});it("true",function(){spyOn($,"ajax").and.callFake(function(request){expect(request.type).toBe("POST");expect(request.url).toBe(url);request.success({stat:"ok"})});reviewRequest.setStarred(true,callbacks);expect(session.watchedReviewRequests.addImmediately).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("false",function(){spyOn($,"ajax").and.callFake(function(request){expect(request.type).toBe("DELETE");expect(request.url).toBe(url+"1/");request.success({stat:"ok"})});reviewRequest.setStarred(false,callbacks);expect(session.watchedReviewRequests.removeImmediately).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()})});describe("close",function(){it("With type=CLOSE_DISCARDED",function(){spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax").and.callFake(function(request){expect(request.type).toBe("PUT");expect(request.data.status).toBe("discarded");expect(request.data.description).toBe(undefined);request.success({stat:"ok",review_request:{id:1,links:{}}})});reviewRequest.close({type:RB.ReviewRequest.CLOSE_DISCARDED,success:callbacks.success,error:callbacks.error});expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("With type=CLOSE_SUBMITTED",function(){spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax").and.callFake(function(request){expect(request.type).toBe("PUT");expect(request.data.status).toBe("submitted");expect(request.data.description).toBe(undefined);request.success({stat:"ok",review_request:{id:1,links:{}}})});reviewRequest.close({type:RB.ReviewRequest.CLOSE_SUBMITTED,success:callbacks.success,error:callbacks.error});expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("With invalid type",function(){spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax");reviewRequest.close({type:"foo",success:callbacks.success,error:callbacks.error});expect(RB.apiCall).not.toHaveBeenCalled();expect($.ajax).not.toHaveBeenCalled();expect(callbacks.success).not.toHaveBeenCalled();expect(callbacks.error).toHaveBeenCalled()});it("With description",function(){spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax").and.callFake(function(request){expect(request.type).toBe("PUT");expect(request.data.status).toBe("submitted");expect(request.data.close_description).toBe("test");request.success({stat:"ok",review_request:{id:1,links:{}}})});reviewRequest.close({type:RB.ReviewRequest.CLOSE_SUBMITTED,description:"test",success:callbacks.success,error:callbacks.error});expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()})})});suite("rb/resources/models/UserFileAttachment",function(){beforeEach(function(){model=new RB.UserFileAttachment});describe("toJSON",function(){describe("caption field",function(){it("With value",function(){var data;model.set("caption","foo");data=model.toJSON();expect(data.caption).toBe("foo")})});describe("file field",function(){it("With no file attachment",function(){var data;model.id=123;expect(model.isNew()).toBe(false);data=model.toJSON();expect(data.path).toBe(undefined)});it("With file attachment",function(){var data;model.id=123;expect(model.isNew()).toBe(false);model.set("file","abc");data=model.toJSON();expect(data.path).toBe("abc")})})});describe("parse",function(){it("API payloads",function(){var data=model.parse({stat:"ok",user_file_attachment:{id:42,caption:"caption",absolute_url:"downloadURL",filename:"filename"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.caption).toBe("caption");expect(data.downloadURL).toBe("downloadURL");expect(data.filename).toBe("filename")})})});suite("rb/resources/models/ValidateDiffModel",function(){var model;beforeEach(function(){model=new RB.ValidateDiffModel});describe("methods",function(){describe("url",function(){it("Without local site",function(){expect(_.result(model,"url")).toBe("/api/validation/diffs/")});it("With local site",function(){model.set("localSitePrefix","s/test-site/");expect(_.result(model,"url")).toBe("/s/test-site/api/validation/diffs/")})})});describe("toJSON",function(){it("repository field",function(){var data;model.set("repository",123);data=model.toJSON();expect(data.repository).toBe(123)})})});"use strict";suite("rb/reviewRequestPage/models/ChangeEntry",function(){it("parse",function(){var diffCommentsData=[["1","100"],["2","100-101"]];
var reviewRequestEditor=new RB.ReviewRequestEditor({reviewRequest:new RB.ReviewRequest});var entry=new RB.ReviewRequestPage.ChangeEntry({diffCommentsData:diffCommentsData,id:"100",typeID:"changedesc",addedTimestamp:"2017-08-18T13:40:25Z",updatedTimestamp:"2017-08-18T16:20:00Z",pendingStatusUpdates:true,reviewsData:[{id:123,bodyTop:"My body top",bodyBottom:"My body bottom","public":true,shipIt:false}],reviewRequestEditor:reviewRequestEditor,ignoredAttr:"ignored"},{parse:true});expect(entry.id).toBe("100");expect(entry.get("diffCommentsData")).toBe(diffCommentsData);expect(entry.get("reviewRequestEditor")).toBe(reviewRequestEditor);expect(entry.get("typeID")).toBe("changedesc");expect(entry.get("addedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,13,40,25)));expect(entry.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,16,20,0)));expect(entry.get("pendingStatusUpdates")).toBe(true);expect(entry.get("ignoredAttr")).toBe(undefined);var reviews=entry.get("reviews");expect(reviews.length).toBe(1);var review=reviews[0];expect(review.get("id")).toBe(123);expect(review.get("bodyTop")).toBe("My body top");expect(review.get("bodyBottom")).toBe("My body bottom");expect(review.get("public")).toBe(true);expect(review.get("shipIt")).toBe(false)})});"use strict";suite("rb/reviewRequestPage/models/Entry",function(){it("parse",function(){var reviewRequestEditor=new RB.ReviewRequestEditor({reviewRequest:new RB.ReviewRequest});var entry=new RB.ReviewRequestPage.Entry({reviewRequestEditor:reviewRequestEditor,id:"123",typeID:"some_type",addedTimestamp:"2017-08-18T13:40:25Z",updatedTimestamp:"2017-08-18T16:20:00Z",ignoredAttr:"ignored"},{parse:true});expect(entry.id).toBe("123");expect(entry.get("reviewRequestEditor")).toBe(reviewRequestEditor);expect(entry.get("addedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,13,40,25)));expect(entry.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,16,20,0)));expect(entry.get("typeID")).toBe("some_type")})});"use strict";suite("rb/reviewRequestPage/models/ReviewEntry",function(){it("parse",function(){var diffCommentsData=[["1","100"],["2","100-101"]];var reviewRequestEditor=new RB.ReviewRequestEditor({reviewRequest:new RB.ReviewRequest});var entry=new RB.ReviewRequestPage.ReviewEntry({diffCommentsData:diffCommentsData,id:"100",typeID:"review",addedTimestamp:"2017-08-18T13:40:25Z",updatedTimestamp:"2017-08-18T16:20:00Z",reviewData:{id:123,bodyTop:"My body top",bodyBottom:"My body bottom","public":true,shipIt:false},reviewRequestEditor:reviewRequestEditor,ignoredAttr:"ignored"},{parse:true});expect(entry.id).toBe("100");expect(entry.get("diffCommentsData")).toBe(diffCommentsData);expect(entry.get("reviewRequestEditor")).toBe(reviewRequestEditor);expect(entry.get("typeID")).toBe("review");expect(entry.get("addedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,13,40,25)));expect(entry.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,16,20,0)));expect(entry.get("ignoredAttr")).toBe(undefined);var review=entry.get("review");expect(review).toBeTruthy();expect(review.get("id")).toBe(123);expect(review.get("bodyTop")).toBe("My body top");expect(review.get("bodyBottom")).toBe("My body bottom");expect(review.get("public")).toBe(true);expect(review.get("shipIt")).toBe(false)})});suite("rb/reviewRequestPage/models/ReviewReplyEditor",function(){var reviewReply,review,editor;beforeEach(function(){review=new RB.Review({loaded:true,links:{replies:{href:"/api/review/123/replies/"}}});reviewReply=review.createReply();spyOn(review,"ready").and.callFake(function(options,context){options.ready.call(context)});spyOn(reviewReply,"ensureCreated").and.callFake(function(options,context){options.success.call(context)});spyOn(reviewReply,"ready").and.callFake(function(options,context){options.ready.call(context)})});describe("Event handling",function(){describe("reviewReply changes",function(){beforeEach(function(){editor=new RB.ReviewRequestPage.ReviewReplyEditor({contextType:"body_top",review:review,reviewReply:reviewReply,text:"My Text"})});it("Sets up events on new reviewReply",function(){var reviewReply=new RB.ReviewReply;spyOn(reviewReply,"on");editor.set("reviewReply",reviewReply);expect(reviewReply.on.calls.count()).toBe(2);expect(reviewReply.on.calls.argsFor(0)[0]).toBe("destroyed");expect(reviewReply.on.calls.argsFor(1)[0]).toBe("published")});it("Removes events from old reviewReply",function(){spyOn(reviewReply,"off");editor.set("reviewReply",new RB.ReviewReply);expect(reviewReply.off).toHaveBeenCalledWith(null,null,editor)})})});describe("Methods",function(){describe("save",function(){function testBodySave(options){editor=new RB.ReviewRequestPage.ReviewReplyEditor({contextType:options.contextType,review:review,reviewReply:reviewReply,richText:options.richText,text:"My Text"});spyOn(editor,"trigger");spyOn(reviewReply,"save").and.callFake(function(options,context){options.success.call(context)});editor.save();expect(editor.get("replyObject")).toBe(reviewReply);expect(editor.get("hasDraft")).toBe(true);expect(editor.get("text")).toBe("My Text");expect(editor.get("richText")).toBe(true);expect(reviewReply.get(options.textAttr)).toBe("My Text");expect(reviewReply.get(options.richTextAttr)).toBe(options.richText);expect(reviewReply.ready).toHaveBeenCalled();expect(reviewReply.save).toHaveBeenCalled();expect(editor.trigger).toHaveBeenCalledWith("saving");expect(editor.trigger).toHaveBeenCalledWith("saved")}function testCommentSave(options){var replyObject;editor=new RB.ReviewRequestPage.ReviewReplyEditor({contextType:options.contextType,hasDraft:false,review:review,reviewReply:reviewReply,richText:options.richText,text:"My Text"});spyOn(editor,"trigger");spyOn(options.model.prototype,"ready").and.callFake(function(options,context){options.ready.call(context)});spyOn(options.model.prototype,"save").and.callFake(function(options,context){options.success.call(context)});editor.save();replyObject=editor.get("replyObject");expect(editor.get("hasDraft")).toBe(true);expect(editor.get("text")).toBe("My Text");expect(editor.get("richText")).toBe(true);expect(replyObject instanceof options.model).toBe(true);expect(replyObject.get("text")).toBe("My Text");expect(replyObject.get("richText")).toBe(options.richText);expect(options.model.prototype.ready).toHaveBeenCalled();expect(options.model.prototype.save).toHaveBeenCalled();expect(editor.trigger).toHaveBeenCalledWith("saving");expect(editor.trigger).toHaveBeenCalledWith("saved")}it("With existing reply object",function(){var replyObject=new RB.DiffCommentReply;editor=new RB.ReviewRequestPage.ReviewReplyEditor({contextType:"diff_comments",hasDraft:false,replyObject:replyObject,review:review,reviewReply:reviewReply,text:"My Text"});spyOn(editor,"trigger");spyOn(replyObject,"ready").and.callFake(function(options,context){options.ready.call(context)});spyOn(replyObject,"save").and.callFake(function(options,context){options.success.call(context)});editor.save();expect(editor.get("hasDraft")).toBe(true);expect(editor.get("replyObject")).toBe(replyObject);expect(replyObject.get("text")).toBe("My Text");expect(replyObject.ready).toHaveBeenCalled();expect(replyObject.save).toHaveBeenCalled();expect(editor.trigger).toHaveBeenCalledWith("saving");expect(editor.trigger).toHaveBeenCalledWith("saved")});it("With empty text",function(){var replyObject=new RB.DiffCommentReply({text:"Orig Text"});editor=new RB.ReviewRequestPage.ReviewReplyEditor({contextType:"diff_comments",review:review,reviewReply:reviewReply});spyOn(editor,"trigger");spyOn(editor,"resetStateIfEmpty");spyOn(replyObject,"ready").and.callFake(function(options,context){options.ready.call(context)});spyOn(replyObject,"save");editor.set({hasDraft:false,replyObject:replyObject,text:""});editor.save();expect(editor.get("hasDraft")).toBe(false);expect(editor.get("replyObject")).toBe(replyObject);expect(replyObject.get("text")).toBe("Orig Text");expect(replyObject.ready).toHaveBeenCalled();expect(replyObject.save).not.toHaveBeenCalled();expect(editor.resetStateIfEmpty).toHaveBeenCalled();expect(editor.trigger).toHaveBeenCalledWith("saving")});describe("With body_top",function(){function testSave(richText){testBodySave({contextType:"body_top",textAttr:"bodyTop",richTextAttr:"bodyTopRichText",richText:richText})}it("richText=true",function(){testSave(true)});it("richText=false",function(){testSave(false)})});describe("With body_bottom",function(){function testSave(richText){testBodySave({contextType:"body_bottom",textAttr:"bodyBottom",richTextAttr:"bodyBottomRichText",richText:richText})}it("richText=true",function(){testSave(true)});it("richText=false",function(){testSave(false)})});describe("With diff comments",function(){function testSave(richText){testCommentSave({contextType:"diff_comments",model:RB.DiffCommentReply,richText:richText})}it("richText=true",function(){testSave(true)});it("richText=false",function(){testSave(false)})});describe("With file attachment comments",function(){function testSave(richText){testCommentSave({contextType:"file_attachment_comments",model:RB.FileAttachmentCommentReply,richText:richText})}it("richText=true",function(){testSave(true)});it("richText=false",function(){testSave(false)})});describe("With general comments",function(){function testSave(richText){testCommentSave({contextType:"general_comments",model:RB.GeneralCommentReply,richText:richText})}it("richText=true",function(){testSave(true)});it("richText=false",function(){testSave(false)})});describe("With screenshot comments",function(){function testSave(richText){testCommentSave({contextType:"screenshot_comments",model:RB.ScreenshotCommentReply,richText:richText})}it("richText=true",function(){testSave(true)});it("richText=false",function(){testSave(false)})})});describe("resetStateIfEmpty",function(){var replyObject;beforeEach(function(){replyObject=new RB.DiffCommentReply;editor=new RB.ReviewRequestPage.ReviewReplyEditor({contextType:"diff_comments",hasDraft:true,replyObject:replyObject,review:review,reviewReply:reviewReply});spyOn(editor,"trigger");spyOn(replyObject,"destroy").and.callFake(function(options,context){options.success.call(context)})});it("Without empty text",function(){editor.set("text","My Text");editor.resetStateIfEmpty();expect(replyObject.destroy).not.toHaveBeenCalled();expect(editor.get("hasDraft")).toBe(true);expect(editor.trigger).not.toHaveBeenCalledWith("resetState")});describe("With empty text",function(){it("With no reply object",function(){editor.set("replyObject",null);editor.resetStateIfEmpty();expect(replyObject.destroy).not.toHaveBeenCalled();expect(editor.get("hasDraft")).toBe(false);expect(editor.trigger).toHaveBeenCalledWith("resetState")});it("With new reply object",function(){replyObject.id=null;editor.resetStateIfEmpty();expect(replyObject.destroy).not.toHaveBeenCalled();expect(editor.get("hasDraft")).toBe(false);expect(editor.trigger).toHaveBeenCalledWith("resetState")});it("With existing reply object",function(){replyObject.id=123;editor.resetStateIfEmpty();expect(replyObject.destroy).toHaveBeenCalled();expect(editor.get("hasDraft")).toBe(false);expect(editor.trigger).toHaveBeenCalledWith("resetState")})})})})});"use strict";suite("rb/reviewRequestPage/models/ReviewRequestPage",function(){var page=void 0;beforeEach(function(){page=new RB.ReviewRequestPage.ReviewRequestPage({updatesURL:"/r/123/_updates/",checkForUpdates:false,reviewRequestData:{},editorData:{fileAttachments:[],mutableByUser:true,showSendEmail:false}},{parse:true})});describe("Methods",function(){it("addEntry",function(){var entry=new RB.ReviewRequestPage.Entry;page.addEntry(entry);expect(entry.get("page")).toBe(page);expect(page.entries.at(0)).toBe(entry)});describe("parse",function(){it("Parent called",function(){var attrs=page.parse({reviewRequestData:{summary:"Test summary"}});expect(attrs.reviewRequest).toBeTruthy();expect(attrs.reviewRequest.get("summary")).toBe("Test summary")});it("updatesURL",function(){var attrs=page.parse({updatesURL:"https://example.com/"});expect(attrs.updatesURL).toBe("https://example.com/")})});describe("watchEntryUpdates",function(){var entry=void 0;beforeEach(function(){spyOn(page,"_scheduleCheckUpdates");entry=new RB.ReviewRequestPage.Entry({id:"my-entry"})});it("First call",function(){page.watchEntryUpdates(entry,1e3);expect(page._watchedUpdatesPeriodMS).toBe(1e3);expect(page._watchedEntries[entry.id]).toEqual({entry:entry,periodMS:1e3});expect(page._scheduleCheckUpdates).toHaveBeenCalled()});it("Shorter watch periods take precedent",function(){page._watchedUpdatesPeriodMS=5e3;page.watchEntryUpdates(entry,1e3);expect(page._watchedUpdatesPeriodMS).toBe(1e3);expect(page._watchedEntries[entry.id]).toEqual({entry:entry,periodMS:1e3});expect(page._scheduleCheckUpdates).toHaveBeenCalled()});it("Subsequent call with longer watch period",function(){page._watchedUpdatesPeriodMS=1e3;page.watchEntryUpdates(entry,5e3);expect(page._watchedUpdatesPeriodMS).toBe(1e3);expect(page._watchedEntries[entry.id]).toEqual({entry:entry,periodMS:5e3});expect(page._scheduleCheckUpdates).toHaveBeenCalled()})});describe("stopWatchingEntryUpdates",function(){beforeEach(function(){spyOn(page,"_scheduleCheckUpdates")});it("Switches to next-shortest update period",function(){var entry1=new RB.ReviewRequestPage.Entry({id:"1"});var entry2=new RB.ReviewRequestPage.Entry({id:"2"});page.watchEntryUpdates(entry1,2e3);page.watchEntryUpdates(entry2,1e3);expect(page._watchedUpdatesPeriodMS).toBe(1e3);page.stopWatchingEntryUpdates(entry2);expect(page._watchedUpdatesPeriodMS).toBe(2e3)});it("Last entry being watched",function(){var entry=new RB.ReviewRequestPage.Entry({id:"1"});page.watchEntryUpdates(entry,1e3);page.stopWatchingEntryUpdates(entry);expect(_.isEmpty(page._watchedEntries)).toBe(true);expect(page._watchedUpdatesTimeout).toBe(null);expect(page._watchedUpdatesPeriodMS).toBe(null);expect(page._watchedUpdatesLastScheduleTime).toBe(null)})})});describe("Dynamic updating",function(){it("Scheduled check for update",function(){var scheduledCallback=null;spyOn(page,"_scheduleCheckUpdates").and.callThrough();spyOn(window,"setTimeout").and.callFake(function(cb,ms){scheduledCallback=cb;return"dummy value"});spyOn(page,"_loadUpdates").and.callThrough();spyOn(Backbone,"sync");var entry1=new RB.ReviewRequestPage.Entry({typeID:"my-entry",id:"100"});var entry2=new RB.ReviewRequestPage.Entry({typeID:"my-entry",id:"200"});var entry3=new RB.ReviewRequestPage.Entry({typeID:"another-entry",id:"foo"});page.watchEntryUpdates(entry1,2e3);page.watchEntryUpdates(entry2,1e3);page.watchEntryUpdates(entry3,2e3);expect(scheduledCallback).not.toBe(null);expect(page._scheduleCheckUpdates).toHaveBeenCalled();expect(page._watchedUpdatesLastScheduleTime).not.toBe(null);expect(page._watchedUpdatesTimeout).not.toBe(null);scheduledCallback();expect(page._watchedUpdatesLastScheduleTime).not.toBe(null);expect(page._watchedUpdatesTimeout).toBe(null);expect(page._loadUpdates.calls.count()).toBe(1);expect(page._loadUpdates.calls.mostRecent().args[0].entries).toEqual([entry1,entry2,entry3]);expect(Backbone.sync.calls.count()).toBe(1);var callOptions=Backbone.sync.calls.mostRecent().args[2];expect(callOptions.url).toBe("/r/123/_updates/?entries=my-entry:100,200"+";another-entry:foo");expect(callOptions.noActivityIndicator).toBe(true);expect(callOptions.dataType).toBe("arraybuffer")});describe("Response parsing",function(){var TestEntry=RB.ReviewRequestPage.Entry.extend({parse:function parse(rsp){return _.extend({myAttr:rsp.myAttr},RB.ReviewRequestPage.Entry.prototype.parse.call(this,rsp))}});var entry1=void 0;var entry2=void 0;beforeEach(function(){spyOn(page,"trigger").and.callThrough();entry1=new TestEntry({typeID:"my-entry",id:"1",addedTimestamp:new Date(2017,7,1,0,0,0),updatedTimestamp:new Date(2017,7,1,12,0,0)});entry2=new TestEntry({typeID:"my-entry",id:"2",addedTimestamp:new Date(2017,7,1,0,0,0),updatedTimestamp:new Date(2017,7,1,12,0,0)});page.addEntry(entry1);page.addEntry(entry2)});it("Updates to outdated entries",function(done){spyOn(entry1,"beforeApplyUpdate");spyOn(entry1,"afterApplyUpdate");spyOn(entry2,"beforeApplyUpdate");spyOn(entry2,"afterApplyUpdate");spyOn($,"ajax").and.callFake(function(options){expect(options.dataType).toBe("arraybuffer");expect(options.url).toBe("/r/123/_updates/");var metadata1=new Blob(['{"type": "entry", ','"entryType": "my-entry", ','"entryID": "1", ','"addedTimestamp": "2017-07-01T00:00:00", ','"updatedTimestamp": "2017-09-04T14:30:20", ','"modelData": {"myAttr": "value1"}}']);var metadata2=new Blob(['{"type": "entry", ','"entryType": "my-entry", ','"entryID": "2", ','"addedTimestamp": "2017-07-01T00:00:00", ','"updatedTimestamp": "2017-09-03T14:30:20", ','"modelData": {"myAttr": "value2"}}']);var html1=new Blob(["<p>My HTML!</p>"]);var html2=new Blob(["<p>Oh hi!</p>"]);var blob=RB.DataUtils.buildBlob([[{type:"uint32",values:[177]}],metadata1,[{type:"uint32",values:[15]}],html1,[{type:"uint32",values:[177]}],metadata2,[{type:"uint32",values:[13]}],html2]);RB.DataUtils.readBlobAsArrayBuffer(blob,options.success)});page._loadUpdates({onDone:function onDone(){var metadata1={type:"entry",entryType:"my-entry",entryID:"1",addedTimestamp:"2017-07-01T00:00:00",updatedTimestamp:"2017-09-04T14:30:20",modelData:{myAttr:"value1"}};var html1="<p>My HTML!</p>";expect(entry1.get("myAttr")).toBe("value1");expect(entry1.beforeApplyUpdate).toHaveBeenCalledWith(metadata1);expect(entry1.afterApplyUpdate).toHaveBeenCalledWith(metadata1);expect(page.trigger).toHaveBeenCalledWith("applyingUpdate:entry",metadata1,html1);expect(page.trigger).toHaveBeenCalledWith("applyingUpdate:entry:1",metadata1,html1);expect(page.trigger).toHaveBeenCalledWith("appliedModelUpdate:entry:1",metadata1,html1);expect(page.trigger).toHaveBeenCalledWith("appliedUpdate:entry:1",metadata1,html1);expect(page.trigger).toHaveBeenCalledWith("appliedUpdate:entry",metadata1,html1);var metadata2={type:"entry",entryType:"my-entry",entryID:"2",addedTimestamp:"2017-07-01T00:00:00",updatedTimestamp:"2017-09-03T14:30:20",modelData:{myAttr:"value2"}};var html2="<p>Oh hi!</p>";expect(entry2.get("myAttr")).toBe("value2");expect(entry2.beforeApplyUpdate).toHaveBeenCalledWith(metadata2);expect(entry2.afterApplyUpdate).toHaveBeenCalledWith(metadata2);expect(page.trigger).toHaveBeenCalledWith("applyingUpdate:entry",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("applyingUpdate:entry:2",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("appliedModelUpdate:entry:2",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("appliedUpdate:entry:2",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("appliedUpdate:entry",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("updatesProcessed");done()}})});it("Updates to up-to-date entries",function(done){entry1.set("myAttr","existing-value");spyOn(entry1,"beforeApplyUpdate");spyOn(entry1,"afterApplyUpdate");spyOn($,"ajax").and.callFake(function(options){expect(options.dataType).toBe("arraybuffer");expect(options.url).toBe("/r/123/_updates/");var metadata=new Blob(['{"type": "entry", ','"entryType": "my-entry", ','"entryID": "1", ','"addedTimestamp": "2016-09-04T14:30:20", ','"updatedTimestamp": "2016-12-10T12:24:14", ','"modelData": {"myAttr": "value1"}}']);var html=new Blob(["<p>My HTML!</p>"]);var blob=RB.DataUtils.buildBlob([[{type:"uint32",values:[metadata.size]}],metadata,[{type:"uint32",values:[html.size]}],html]);RB.DataUtils.readBlobAsArrayBuffer(blob,options.success)});page._loadUpdates({onDone:function onDone(){var metadata1={type:"entry",entryType:"my-entry",entryID:"1",addedTimestamp:"2016-09-04T14:30:20",updatedTimestamp:"2016-09-04T14:30:20",modelData:{myAttr:"value1"}};var html1="<p>My HTML!</p>";expect(entry1.get("myAttr")).toBe("existing-value");expect(entry1.beforeApplyUpdate).not.toHaveBeenCalled();expect(entry1.afterApplyUpdate).not.toHaveBeenCalled();expect(page.trigger).not.toHaveBeenCalledWith("applyingUpdate:entry",metadata1,html1);expect(page.trigger).not.toHaveBeenCalledWith("applyingUpdate:entry:1",metadata1,html1);expect(page.trigger).not.toHaveBeenCalledWith("appliedModelUpdate:entry:1",metadata1,html1);expect(page.trigger).not.toHaveBeenCalledWith("appliedUpdate:entry:1",metadata1,html1);expect(page.trigger).not.toHaveBeenCalledWith("appliedUpdate:entry",metadata1,html1);expect(page.trigger).toHaveBeenCalledWith("updatesProcessed");done()}})});it("Updates to non-entries",function(done){spyOn($,"ajax").and.callFake(function(options){expect(options.dataType).toBe("arraybuffer");expect(options.url).toBe("/r/123/_updates/");var metadata=new Blob(['{"type": "something", "foo": "bar"}']);var html=new Blob(["<div>Something</div>"]);var blob=RB.DataUtils.buildBlob([[{type:"uint32",values:[metadata.size]}],metadata,[{type:"uint32",values:[html.size]}],html]);RB.DataUtils.readBlobAsArrayBuffer(blob,options.success)});page._loadUpdates({onDone:function onDone(){var metadata={type:"something",foo:"bar"};var html="<div>Something</div>";expect(page.trigger).toHaveBeenCalledWith("applyingUpdate:something",metadata,html);expect(page.trigger).toHaveBeenCalledWith("appliedUpdate:something",metadata,html);expect(page.trigger).toHaveBeenCalledWith("updatesProcessed");done()}})});it("Updates containing Unicode in HTML",function(done){spyOn(entry1,"beforeApplyUpdate");spyOn(entry1,"afterApplyUpdate");spyOn(entry2,"beforeApplyUpdate");spyOn(entry2,"afterApplyUpdate");spyOn($,"ajax").and.callFake(function(options){expect(options.dataType).toBe("arraybuffer");expect(options.url).toBe("/r/123/_updates/");var metadata1=new Blob(['{"type": "entry", ','"entryType": "my-entry", ','"entryID": "1", ','"addedTimestamp": "2017-07-01T00:00:00", ','"updatedTimestamp": "2017-09-04T14:30:20", ','"modelData": {"myAttr": "value1"}}']);var metadata2=new Blob(['{"type": "entry", ','"entryType": "my-entry", ','"entryID": "2", ','"addedTimestamp": "2017-07-01T00:00:00", ','"updatedTimestamp": "2017-09-03T14:30:20", ','"modelData": {"myAttr": "value2"}}']);var html1=[60,115,112,97,110,62,195,161,195,169,195,173,195,179,195,186,32,240,159,148,165,60,47,115,112,97,110,62];var html2=[60,115,112,97,110,62,195,132,195,139,195,143,195,150,195,156,197,184,32,240,159,152,177,60,47,115,112,97,110,62];expect(html1.length).toBe(28);expect(html2.length).toBe(30);var blob=RB.DataUtils.buildBlob([[{type:"uint32",values:[metadata1.size]}],metadata1,[{type:"uint32",values:[html1.length]},{type:"uint8",values:html1},{type:"uint32",values:[metadata2.size]}],metadata2,[{type:"uint32",values:[html2.length]},{type:"uint8",values:html2}]]);RB.DataUtils.readBlobAsArrayBuffer(blob,options.success)});page._loadUpdates({onDone:function onDone(){var metadata1={type:"entry",entryType:"my-entry",entryID:"1",addedTimestamp:"2017-07-01T00:00:00",updatedTimestamp:"2017-09-04T14:30:20",modelData:{myAttr:"value1"}};var html1="<span>áéíóú 🔥</span>";expect(entry1.get("myAttr")).toBe("value1");expect(entry1.beforeApplyUpdate).toHaveBeenCalledWith(metadata1);expect(entry1.afterApplyUpdate).toHaveBeenCalledWith(metadata1);expect(page.trigger).toHaveBeenCalledWith("applyingUpdate:entry",metadata1,html1);expect(page.trigger).toHaveBeenCalledWith("applyingUpdate:entry:1",metadata1,html1);expect(page.trigger).toHaveBeenCalledWith("appliedModelUpdate:entry:1",metadata1,html1);expect(page.trigger).toHaveBeenCalledWith("appliedUpdate:entry:1",metadata1,html1);expect(page.trigger).toHaveBeenCalledWith("appliedUpdate:entry",metadata1,html1);var metadata2={type:"entry",entryType:"my-entry",entryID:"2",addedTimestamp:"2017-07-01T00:00:00",updatedTimestamp:"2017-09-03T14:30:20",modelData:{myAttr:"value2"}};var html2="<span>ÄËÏÖÜŸ 😱</span>";expect(entry2.get("myAttr")).toBe("value2");expect(entry2.beforeApplyUpdate).toHaveBeenCalledWith(metadata2);expect(entry2.afterApplyUpdate).toHaveBeenCalledWith(metadata2);expect(page.trigger).toHaveBeenCalledWith("applyingUpdate:entry",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("applyingUpdate:entry:2",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("appliedModelUpdate:entry:2",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("appliedUpdate:entry:2",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("appliedUpdate:entry",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("updatesProcessed");done()}})})})})});"use strict";suite("rb/reviewRequestPage/models/StatusUpdatesEntry",function(){it("parse",function(){var diffCommentsData=[["1","100"],["2","100-101"]];var reviewRequestEditor=new RB.ReviewRequestEditor({reviewRequest:new RB.ReviewRequest});var entry=new RB.ReviewRequestPage.StatusUpdatesEntry({diffCommentsData:diffCommentsData,id:"0",typeID:"initial_status_updates",addedTimestamp:"2017-08-18T13:40:25Z",updatedTimestamp:"2017-08-18T16:20:00Z",pendingStatusUpdates:true,reviewsData:[{id:123,bodyTop:"My body top",bodyBottom:"My body bottom","public":true,shipIt:false}],reviewRequestEditor:reviewRequestEditor,ignoredAttr:"ignored"},{parse:true});expect(entry.id).toBe("0");expect(entry.get("diffCommentsData")).toBe(diffCommentsData);expect(entry.get("reviewRequestEditor")).toBe(reviewRequestEditor);expect(entry.get("typeID")).toBe("initial_status_updates");expect(entry.get("addedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,13,40,25)));expect(entry.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,16,20,0)));expect(entry.get("pendingStatusUpdates")).toBe(true);expect(entry.get("ignoredAttr")).toBe(undefined);var reviews=entry.get("reviews");expect(reviews.length).toBe(1);var review=reviews[0];expect(review.get("id")).toBe(123);expect(review.get("bodyTop")).toBe("My body top");expect(review.get("bodyBottom")).toBe("My body bottom");expect(review.get("public")).toBe(true);expect(review.get("shipIt")).toBe(false)})});"use strict";suite("rb/reviewRequestPage/views/BaseStatusUpdatesEntryView",function(){var TestPage=Backbone.View.extend({stopWatchingEntryUpdates:function stopWatchingEntryUpdates(){},watchEntryUpdates:function watchEntryUpdates(){},queueLoadDiff:function queueLoadDiff(){}});var entryView=void 0;var page=void 0;var entry=void 0;beforeEach(function(){var reviewRequest=new RB.ReviewRequest;var editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest});entry=new RB.ReviewRequestPage.StatusUpdatesEntry({reviews:[reviewRequest.createReview(100,{loaded:true,links:{replies:{href:"/api/review/100/replies/"}}}),reviewRequest.createReview(101,{loaded:true,links:{replies:{href:"/api/review/101/replies/"}}})],reviewRequest:reviewRequest,reviewRequestEditor:editor,id:"0",typeID:"initial_status_updates",addedTimestamp:new Date(Date.UTC(2017,7,18,13,40,25)),updatedTimestamp:new Date(Date.UTC(2017,7,18,16,20,0)),pendingStatusUpdates:true,diffCommentsData:[["1","100"],["2","100-101"]]});entryView=new RB.ReviewRequestPage.BaseStatusUpdatesEntryView({model:entry});page=new TestPage;page.diffFragmentQueue=new RB.DiffFragmentQueueView({containerPrefix:"comment"});entry.set("page",page);RB.PageManager.setPage(page)});afterEach(function(){RB.PageManager.setPage(null)});describe("Dynamic Updating",function(){describe("Update checking",function(){it("Enabled when pendingStatusUpdates=true",function(){spyOn(entry,"watchUpdates");entry.set("pendingStatusUpdates",true);entryView.render();expect(entry.watchUpdates).toHaveBeenCalled()});it("Disabled when pendingStatusUpdates=false",function(){spyOn(entry,"watchUpdates");entry.set("pendingStatusUpdates",false);entryView.render();expect(entry.watchUpdates).not.toHaveBeenCalled()})});it("Saves fragments on beforeApplyUpdate",function(){spyOn(page.diffFragmentQueue,"saveFragment");spyOn(page,"stopWatchingEntryUpdates");entryView.beforeApplyUpdate();expect(page.diffFragmentQueue.saveFragment.calls.count()).toBe(2);expect(page.diffFragmentQueue.saveFragment.calls.argsFor(0)).toEqual(["1"]);expect(page.diffFragmentQueue.saveFragment.calls.argsFor(1)).toEqual(["2"]);expect(page.stopWatchingEntryUpdates).toHaveBeenCalled()})});describe("render",function(){it("Creates ReviewViews",function(){entryView.render();expect(entryView._reviewViews.length).toBe(2)})})});"use strict";suite("rb/reviewRequestPage/views/IssueSummaryTable",function(){var issueSummaryTableTemplate=_.template('<div id="issue-summary">\n <div class="issue-summary-filters">\n  <select id="issue-reviewer-filter">\n   <option value="all"></option>\n  </select>\n </div>\n <ul>\n  <li class="issue-summary-tab active" data-issue-state="open">\n   <span id="open-counter">2</span>\n  </li>\n  <li class="issue-summary-tab" data-issue-state="resolved">\n   <span id="resolved-counter">3</span>\n  </li>\n  <li class="issue-summary-tab" data-issue-state="dropped">\n   <span id="dropped-counter">1</span>\n  </li>\n  <li class="issue-summary-tab" data-issue-state="all">\n   <span id="total-counter">6</span>\n  </li>\n </ul>\n <table id="issue-summary-table">\n  <thead>\n   <tr>\n    <th class="description-header"></th>\n    <th class="from-header"></th>\n    <th class="last-updated-header"></th>\n   </tr>\n  </thead>\n  <tbody>\n   <tr id="summary-table-entry-1"\n       class="issue resolved hidden"\n       data-issue-id="1"\n       data-reviewer="user1"\n       data-comment-type="diff"\n       data-comment-href="#comment1">\n    <td>\n     <span class="issue-icon rb-icon-issue-resolved"></span>\n     Resolved comment 1\n    </td>\n    <td>user1</td>\n    <td class="last-updated">\n     <time class="timesince" datetime="2017-02-01T20:30:00-07:00">\n      February 1, 2017, 8:30 p.m.\n     </time>\n    </td>\n   </tr>\n   <tr id="summary-table-entry-2"\n       class="issue resolved hidden"\n       data-issue-id="2"\n       data-reviewer="user2"\n       data-comment-type="diff"\n       data-comment-href="#comment2">\n    <td>\n     <span class="issue-icon rb-icon-issue-resolved"></span>\n     Resolved comment 2\n    </td>\n    <td>user2</td>\n    <td class="last-updated">\n     <time class="timesince" datetime="2017-02-02T20:30:00-07:00">\n      February 2, 2017, 8:30 p.m.\n     </time>\n    </td>\n   </tr>\n   <tr id="summary-table-entry-3"\n       class="issue resolved hidden"\n       data-issue-id="3"\n       data-reviewer="user3"\n       data-comment-type="diff"\n       data-comment-href="#comment3">\n    <td>\n     <span class="issue-icon rb-icon-issue-resolved"></span>\n     Resolved comment 3\n    </td>\n    <td>user3</td>\n    <td class="last-updated">\n     <time class="timesince" datetime="2017-02-03T20:30:00-07:00">\n      February 3, 2017, 8:30 p.m.\n     </time>\n    </td>\n   </tr>\n   <tr id="summary-table-entry-4"\n       class="issue open"\n       data-issue-id="4"\n       data-reviewer="user1"\n       data-comment-type="diff"\n       data-comment-href="#comment4">\n    <td>\n     <span class="issue-icon rb-icon-issue-open"></span>\n     Open comment 4\n    </td>\n    <td>user1</td>\n    <td class="last-updated">\n     <time class="timesince" datetime="2017-02-01T20:30:00-07:00">\n      February 1, 2017, 8:30 p.m.\n     </time>\n    </td>\n   </tr>\n   <tr id="summary-table-entry-5"\n       class="issue open"\n       data-issue-id="5"\n       data-reviewer="user2"\n       data-comment-type="diff"\n       data-comment-href="#comment5">\n    <td>\n     <span class="issue-icon rb-icon-issue-open"></span>\n     Open comment 5\n    </td>\n    <td>user2</td>\n    <td class="last-updated">\n     <time class="timesince" datetime="2017-02-02T20:30:00-07:00">\n      February 2, 2017, 8:30 p.m.\n     </time>\n    </td>\n   </tr>\n   <tr id="summary-table-entry-6"\n       class="issue dropped hidden"\n       data-issue-id="6"\n       data-reviewer="user1"\n       data-comment-type="diff"\n       data-comment-href="#comment6">\n    <td>\n     <span class="issue-icon rb-icon-issue-dropped"></span>\n     Dropped comment 6\n    </td>\n    <td>user1</td>\n    <td class="last-updated">\n     <time class="timesince" datetime="2017-02-01T20:30:00-07:00">\n      February 1, 2017, 8:30 p.m.\n     </time>\n    </td>\n   </tr>\n  </tbody>\n </table>\n</div>');
var view=void 0;function getTab(state){return view.$('.issue-summary-tab[data-issue-state="'+state+'"]')}beforeEach(function(){view=new RB.ReviewRequestPage.IssueSummaryTableView({el:$(issueSummaryTableTemplate()),model:new RB.CommentIssueManager});view.$el.appendTo($testsScratch)});describe("render",function(){it("Initial state",function(){view.render();expect(view.statusFilterState).toBe("open");expect(view.reviewerFilterState).toBe("all");expect(view.reviewerToSelectorMap).toEqual({all:"",user1:'[data-reviewer="user1"]',user2:'[data-reviewer="user2"]',user3:'[data-reviewer="user3"]'});var $reviewers=view._$reviewerFilter.children();expect($reviewers.length).toBe(4);expect($reviewers.eq(0).val()).toBe("all");expect($reviewers.eq(1).val()).toBe("user1");expect($reviewers.eq(2).val()).toBe("user2");expect($reviewers.eq(3).val()).toBe("user3")})});describe("Filters",function(){describe("Reviewer filter",function(){describe("To all",function(){it("With issues",function(){view.render();view._$reviewerFilter.val("user1");view._$reviewerFilter.trigger("change");view._$reviewerFilter.val("all");view._$reviewerFilter.trigger("change");var $issues=view.$el.find(".issue").not(".hidden");expect($issues.length).toBe(2);expect($issues.eq(0).data("issue-id")).toBe(4);expect($issues.eq(1).data("issue-id")).toBe(5)});it("Without issues",function(){view.$el.find(".issue").remove();view.render();view._$reviewerFilter.val("user1");view._$reviewerFilter.trigger("change");view._$reviewerFilter.val("all");view._$reviewerFilter.trigger("change");expect(view.$el.find(".issue").not(".hidden").length).toBe(0);var $noIssues=view.$(".no-issues");expect($noIssues.length).toBe(1)})});describe("To user",function(){it("With issues",function(){view.render();view._$reviewerFilter.val("user1");view._$reviewerFilter.trigger("change");var $issues=view.$el.find(".issue").not(".hidden");expect($issues.length).toBe(1);expect($issues.eq(0).data("issue-id")).toBe(4)});describe("Without issues",function(){function testByUserWithoutIssues(state){it("And filtered by "+state+" issues",function(){view.$el.find(".issue."+state+'[data-reviewer="user1"]').remove();view.render();view._$reviewerFilter.val("user1");view._$reviewerFilter.trigger("change");var $tab=getTab(state);$tab.click();expect(view.$el.find(".issue").not(".hidden").length).toBe(0);var $noIssues=view.$(".no-issues");expect($noIssues.length).toBe(1);expect($noIssues.text().strip()).toBe("There are no "+state+" issues from user1")})}testByUserWithoutIssues("open");testByUserWithoutIssues("resolved");testByUserWithoutIssues("dropped")})})});describe("Status filters",function(){function testStatusFilters(options){var state=options.state;describe(options.description,function(){it("With issues",function(){var expectedIDs=options.expectedIDs;view.render();var $tab=getTab(state);$tab.click();expect($tab.hasClass("active")).toBe(true);var $allIssues=view.$el.find(".issue");var $issues=$allIssues.not(".hidden");expect(view.$el.find(".issue.hidden").length).toBe($allIssues.length-expectedIDs.length);expect($issues.length).toBe(expectedIDs.length);expect(view.$(".no-issues").length).toBe(0);for(var i=0;i<expectedIDs.length;i++){expect($issues.eq(i).data("issue-id")).toBe(expectedIDs[i])}});it("Without issues",function(){var stateSel=view.stateToSelectorMap[state];view.$el.find(".issue"+stateSel).remove();view.render();var $tab=getTab(state);$tab.click();expect($tab.hasClass("active")).toBe(true);expect(view.$el.find(".issue").not(".hidden").length).toBe(0);var $noIssues=view.$(".no-issues");expect($noIssues.length).toBe(1);expect($noIssues.text().strip()).toBe(options.noIssuesText)})})}testStatusFilters({description:"All",state:"all",expectedIDs:[1,2,3,4,5,6],noIssuesText:""});testStatusFilters({description:"Open",state:"open",expectedIDs:[4,5],noIssuesText:"There are no open issues"});testStatusFilters({description:"Resolved",state:"resolved",expectedIDs:[1,2,3],noIssuesText:"There are no resolved issues"});testStatusFilters({description:"Dropped",state:"dropped",expectedIDs:[6],noIssuesText:"There are no dropped issues"})})});describe("Events",function(){it("Issue clicked",function(){var cb=jasmine.createSpy();view.render();view.on("issueClicked",cb);view.$('.issue[data-issue-id="4"]').click();expect(cb).toHaveBeenCalledWith({commentType:"diff",commentID:4,commentURL:"#comment4"})});describe("Issue status updated",function(){var date=new Date(2017,7,6,1,4,30);var $issue=void 0;var $icon=void 0;var comment=void 0;beforeEach(function(){comment=new RB.DiffComment({id:4});view.render();expect(view.$("#resolved-counter").text()).toBe("3");expect(view.$("#open-counter").text()).toBe("2");expect(view.$("#dropped-counter").text()).toBe("1");expect(view.$("#total-counter").text()).toBe("6");$issue=view.$('.issue[data-issue-id="4"]');$icon=$issue.find(".issue-icon")});it("To dropped",function(){comment.set("issueStatus","dropped");view.model.trigger("issueStatusUpdated",comment,"open",date);expect(view.$("#open-counter").text()).toBe("1");expect(view.$("#dropped-counter").text()).toBe("2");expect(view.$("#total-counter").text()).toBe("6");expect($icon.hasClass("rb-icon-issue-open")).toBe(false);expect($icon.hasClass("rb-icon-issue-dropped")).toBe(true)});it("To resolved",function(){comment.set("issueStatus","resolved");view.model.trigger("issueStatusUpdated",comment,"open",date);expect(view.$("#resolved-counter").text()).toBe("4");expect(view.$("#open-counter").text()).toBe("1");expect(view.$("#total-counter").text()).toBe("6");expect($icon.hasClass("rb-icon-issue-open")).toBe(false);expect($icon.hasClass("rb-icon-issue-resolved")).toBe(true)});it("To open",function(){comment.set({issueStatus:"open",id:1});view.model.trigger("issueStatusUpdated",comment,"resolved",date);$issue=view.$('.issue[data-issue-id="1"]');$icon=$issue.find(".issue-icon");expect(view.$("#resolved-counter").text()).toBe("2");expect(view.$("#open-counter").text()).toBe("3");expect(view.$("#total-counter").text()).toBe("6");expect($icon.hasClass("rb-icon-issue-resolved")).toBe(false);expect($icon.hasClass("rb-icon-issue-open")).toBe(true)});it("After re-renders",function(){view.render();view.render();comment.set("issueStatus","resolved");view.model.trigger("issueStatusUpdated",comment,"open",date);expect(view.$("#resolved-counter").text()).toBe("4");expect(view.$("#open-counter").text()).toBe("1");expect(view.$("#total-counter").text()).toBe("6");expect($icon.hasClass("rb-icon-issue-open")).toBe(false);expect($icon.hasClass("rb-icon-issue-resolved")).toBe(true)});afterEach(function(){expect($issue.find(".last-updated time").attr("datetime")).toBe(date.toISOString())})});describe("Header clicked",function(){function testHeaderSorting(options){it(options.description,function(){view.render();var event=$.Event("click");event.shiftKey=!!options.shiftKey;view.$(options.headerSel).trigger(event);var $issues=view.$(".issue");expect($issues.length).toBe(6);var expectedIDs=options.expectedIDs;for(var i=0;i<expectedIDs.length;i++){expect($issues.eq(i).data("issue-id")).toBe(expectedIDs[i])}})}describe("Ascending",function(){testHeaderSorting({description:"Description",headerSel:".description-header",expectedIDs:[6,4,5,1,2,3]});testHeaderSorting({description:"From",headerSel:".from-header",expectedIDs:[1,4,6,2,5,3]});testHeaderSorting({description:"Last Updated",headerSel:".last-updated-header",expectedIDs:[3,2,5,1,4,6]})});describe("Descending",function(){testHeaderSorting({description:"Description",headerSel:".description-header",expectedIDs:[3,2,1,5,4,6],shiftKey:true});testHeaderSorting({description:"From",headerSel:".from-header",expectedIDs:[3,2,5,1,4,6],shiftKey:true});testHeaderSorting({description:"Last Updated",headerSel:".last-updated-header",expectedIDs:[1,4,6,2,5,3],shiftKey:true})})})})});suite("rb/reviewRequestPage/views/ReviewEntryView",function(){var view,reviewView,reviewReply,template=_.template(['<div class="review review-request-page-entry">',' <div class="review-request-page-entry-contents">','  <div class="collapse-button"></div>','  <div class="banners">','   <input type="button" value="Publish" />','   <input type="button" value="Discard" />',"  </div>",'  <div class="comment-section" data-context-type="body_top">','   <a class="add_comment_link"></a>','   <ul class="reply-comments">','    <li class="draft" data-comment-id="456">','     <pre class="reviewtext"></pre>',"    </li>","   </ul>","  </div>",'  <div class="comment-section" data-context-id="123" ','       data-context-type="diff_comments">','   <a class="add_comment_link"></a>','   <ul class="reply-comments"></ul>',"  </div>",'  <div class="comment-section" data-context-type="body_bottom">','   <a class="add_comment_link"></a>','   <ul class="reply-comments"></ul>',"  </div>"," </div>","</div>"].join(""));beforeEach(function(){var reviewRequest=new RB.ReviewRequest,editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest}),review=reviewRequest.createReview({loaded:true,links:{replies:{href:"/api/review/123/replies/"}}}),model=new RB.ReviewRequestPage.ReviewEntry({review:review,reviewRequest:reviewRequest,reviewRequestEditor:editor}),$el=$(template()).appendTo($testsScratch);reviewReply=review.createReply();view=new RB.ReviewRequestPage.ReviewEntryView({el:$el,model:model});view.render();reviewView=view._reviewView;spyOn(reviewView,"_showReplyDraftBanner");spyOn(reviewView,"trigger").and.callThrough();reviewView._setupNewReply(reviewReply)});describe("Actions",function(){it("Toggle collapse",function(){var $box=view.$(".review-request-page-entry-contents"),$collapseButton=view.$(".collapse-button");$collapseButton.click();expect($box.hasClass("collapsed")).toBe(true);$collapseButton.click();expect($box.hasClass("collapsed")).toBe(false)})});describe("Draft banner",function(){describe("Visibility",function(){it("Shown on hasDraft",function(){var editor=reviewView._replyEditorViews[1].model;reviewView._showReplyDraftBanner.calls.reset();expect(editor.get("hasDraft")).toBe(false);expect(reviewView._showReplyDraftBanner).not.toHaveBeenCalled();editor.set("hasDraft",true);expect(reviewView._showReplyDraftBanner).toHaveBeenCalled()})})});describe("Methods",function(){it("collapse",function(){view.collapse();expect(view.$(".review-request-page-entry-contents").hasClass("collapsed")).toBe(true)});it("expand",function(){var $box=view.$(".review-request-page-entry-contents");$box.addClass("collapsed");view.expand();expect($box.hasClass("collapsed")).toBe(false)});describe("getReviewReplyEditorView",function(){it("With body_top",function(){var editorView=view.getReviewReplyEditorView("body_top");expect(editorView).not.toBe(undefined);expect(editorView).toBe(reviewView._replyEditorViews[0])});it("With body_bottom",function(){var editorView=view.getReviewReplyEditorView("body_bottom");expect(editorView).not.toBe(undefined);expect(editorView).toBe(reviewView._replyEditorViews[2])});it("With comments",function(){var editorView=view.getReviewReplyEditorView("diff_comments",123);expect(editorView).not.toBe(undefined);expect(editorView).toBe(reviewView._replyEditorViews[1])})})})});suite("rb/reviewRequestPage/views/ReviewReplyDraftBannerView",function(){var reviewReply,view;beforeEach(function(){reviewReply=new RB.ReviewReply;view=new RB.ReviewRequestPage.ReviewReplyDraftBannerView({model:reviewReply,$floatContainer:$testsScratch,reviewRequestEditor:new RB.ReviewRequestEditor({reviewRequest:new RB.ReviewRequest})});view.render().$el.appendTo($testsScratch)});describe("Actions",function(){it("Discard",function(){spyOn(reviewReply,"destroy");view.$(".discard-button").click();expect(reviewReply.destroy).toHaveBeenCalled()});it("Publish",function(){spyOn(reviewReply,"publish");view.$(".publish-button").click();expect(reviewReply.publish).toHaveBeenCalled()})});describe("Event Handling",function(){describe("Buttons",function(){var $buttons;beforeEach(function(){$buttons=view.$("input")});describe("Disabled",function(){it("When saving",function(){expect($buttons.prop("disabled")).toBe(false);reviewReply.trigger("saving");expect($buttons.prop("disabled")).toBe(true)});it("When destroying",function(){expect($buttons.prop("disabled")).toBe(false);reviewReply.trigger("destroying");expect($buttons.prop("disabled")).toBe(true)})});describe("Enabled",function(){it("When saved",function(){$buttons.prop("disabled",true);reviewReply.trigger("saved");expect($buttons.prop("disabled")).toBe(false)})})})});describe("Publish",function(){beforeEach(function(){spyOn(reviewReply,"ensureCreated").and.callFake(function(options,context){options.success.call(context)});spyOn(reviewReply,"publish")});describe("With Send E-Mail shown",function(){beforeEach(function(){view.remove();view=new RB.ReviewRequestPage.ReviewReplyDraftBannerView({model:reviewReply,$floatContainer:$testsScratch,reviewRequestEditor:new RB.ReviewRequestEditor({reviewRequest:new RB.ReviewRequest,showSendEmail:true})});view.render().$el.appendTo($testsScratch)});it("Send E-Mail true",function(){$(".send-email").prop("checked",true);$(".publish-button").click();expect(reviewReply.publish).toHaveBeenCalled();expect(reviewReply.publish.calls.argsFor(0)[0].trivial).toBe(false)});it("Send E-Mail false",function(){$(".send-email").prop("checked",false);$(".publish-button").click();expect(reviewReply.publish).toHaveBeenCalled();expect(reviewReply.publish.calls.argsFor(0)[0].trivial).toBe(true)})});it("Without Send E-Mail shown",function(){$(".publish-button").click();expect($(".send-email").length).toEqual(0);expect(reviewReply.publish).toHaveBeenCalled();expect(reviewReply.publish.calls.argsFor(0)[0].trivial).toBe(false)})})});suite("rb/reviewRequestPage/views/ReviewReplyEditorView",function(){var reviewReply,editor,view;beforeEach(function(){var $container=$("<div/>").appendTo($testsScratch);reviewReply=new RB.ReviewReply;spyOn(reviewReply,"discardIfEmpty").and.callFake(function(options,context){options.success.call(context)});editor=new RB.ReviewRequestPage.ReviewReplyEditor({review:new RB.Review({id:42,parentObject:new RB.ReviewRequest}),reviewReply:reviewReply,contextType:"rcbt",contextID:"100"});view=new RB.ReviewRequestPage.ReviewReplyEditorView({model:editor,el:$testsScratch});view._$commentsList=$('<ul class="reply-comments"/>');$container.append(view._$commentsList).append($('<a href="#" class="add_comment_link">New Comment</a>'))});describe("Construction",function(){it("Populate from draft comment",function(){var commentText="Test comment",now=moment(),$el=view._makeCommentElement({commentID:16,now:now,text:commentText});view.render();expect(editor.get("commentID")).toBe(16);expect(editor.get("text")).toBe(commentText);expect(editor.get("hasDraft")).toBe(true);expect(editor.get("timestamp").valueOf()).toBe(now.milliseconds(0).valueOf());expect(view._$draftComment[0]).toBe($el[0]);expect(view._$addCommentLink.is(":visible")).toBe(false)})});describe("Actions",function(){it("Add comment link",function(){view.render();expect(view._$addCommentLink.is(":visible")).toBe(true);view._$addCommentLink.click();expect(view._$addCommentLink.is(":visible")).toBe(false);expect(view._$draftComment).not.toBe(null);expect(view._$draftComment.hasClass("draft")).toBe(true)})});describe("Event handling",function(){it("Comment discarded",function(){var $el;view._makeCommentElement({text:"Test comment"});view.render();$el=view.$(".reply-comments li");expect($el.length).toBe(1);reviewReply.trigger("destroyed");$el=view.$(".reply-comments li");expect($el.length).toBe(0);expect(view._$draftComment).toBe(null)});it("Comment published",function(){var $draftEl=view._makeCommentElement({commentID:16}),$el;spyOn($.fn,"user_infobox").and.callThrough();spyOn($.fn,"timesince").and.callThrough();view.render();editor.set("text","Test **comment**");reviewReply.trigger("published");$el=view.$(".reply-comments li");expect($el.length).toBe(1);expect($draftEl).not.toBe($el);expect($el.hasClass("draft")).toBe(false);expect($el.data("comment-id")).toBe(16);expect(view._$draftComment).toBe(null);expect($.fn.user_infobox).toHaveBeenCalled();expect($.fn.timesince).toHaveBeenCalled()})});describe("Methods",function(){it("openCommentEditor",function(){view.render();expect(view._$addCommentLink.is(":visible")).toBe(true);expect(view._$draftComment).toBe(null);view.openCommentEditor();expect(view._$addCommentLink.is(":visible")).toBe(false);expect(view._$draftComment).not.toBe(null);expect(view._$draftComment.hasClass("draft")).toBe(true)})});describe("Text rendering",function(){function testRendering(richText,expectedHTML){var $comment,$reviewText;view.render();$comment=view._makeCommentElement({text:"<p><strong>Test</strong> &amp;lt;</p>",richText:richText});$reviewText=$comment.find(".reviewtext");expect($reviewText.length).toBe(1);expect($reviewText.hasClass("rich-text")).toBe(richText);expect($reviewText.html()).toBe(expectedHTML)}it("richText=true",function(){testRendering(true,"<p><strong>Test</strong> &amp;lt;</p>")});it("richText=false",function(){testRendering(false,"&lt;p&gt;&lt;strong&gt;Test&lt;/strong&gt; "+"&amp;amp;lt;&lt;/p&gt;")})})});"use strict";suite("rb/reviewRequestPage/views/ReviewRequestPageView",function(){var template='<div id="review-banner"></div>\n<a id="collapse-all"></a>\n<a id="expand-all"></a>\n<div>\n <div class="review review-request-page-entry" id="review123">\n  <div class="review-request-page-entry-contents">\n   <div class="body">\n    <pre class="body_top">Body Top</pre>\n    <div class="comment-section" data-context-type="body_top">\n    </div>\n    <div class="comment-section" data-context-id="123"\n         data-context-type="diff_comments">\n    </div>\n    <pre class="body_bottom">Body Bottom</pre>\n    <div class="comment-section" data-context-type="body_bottom">\n    </div>\n   </div>\n </div>\n <div class="review review-request-page-entry" id="review124">\n  <div class="review-request-page-entry-contents">\n   <div class="body">\n    <pre class="body_top">Body Top</pre>\n    <div class="comment-section" data-context-type="body_top">\n    </div>\n    <pre class="body_bottom">Body Bottom</pre>\n    <div class="comment-section" data-context-type="body_bottom">\n    </div>\n   </div>\n  </div>\n </div>\n</div>';var page=void 0;var pageView=void 0;var entry1=void 0;var entry2=void 0;beforeEach(function(){var $el=$("<div/>").html(template).appendTo($testsScratch);RB.DnDUploader.instance=null;page=new RB.ReviewRequestPage.ReviewRequestPage({checkForUpdates:false,reviewRequestData:{},editorData:{fileAttachments:[],mutableByUser:true,showSendEmail:false}},{parse:true});pageView=new RB.ReviewRequestPage.ReviewRequestPageView({el:$el,model:page});spyOn(RB.ReviewRequestPage.IssueSummaryTableView.prototype,"render");var reviewRequest=page.get("reviewRequest");pageView.addEntryView(new RB.ReviewRequestPage.ReviewEntryView({model:new RB.ReviewRequestPage.ReviewEntry({review:reviewRequest.createReview(123,{shipIt:true,"public":true,bodyTop:"Body Top",bodyBottom:"Body Bottom"}),reviewRequestEditor:pageView.reviewRequestEditor}),el:$el.find("#review123")}));pageView.addEntryView(new RB.ReviewRequestPage.ReviewEntryView({model:new RB.ReviewRequestPage.ReviewEntry({review:reviewRequest.createReview(124,{shipIt:false,"public":true,bodyTop:"Body Top",bodyBottom:"Body Bottom"}),reviewRequestEditor:pageView.reviewRequestEditor}),el:$el.find("#review124")}));pageView.render();expect(pageView._entryViews.length).toBe(2);entry1=pageView._entryViews[0];entry2=pageView._entryViews[1]});afterEach(function(){RB.DnDUploader.instance=null});describe("Actions",function(){it("Collapse all",function(){var $el1=entry1.$el.find(".review-request-page-entry-contents");var $el2=entry2.$el.find(".review-request-page-entry-contents");expect($el1.hasClass("collapsed")).toBe(false);expect($el2.hasClass("collapsed")).toBe(false);pageView.$("#collapse-all").click();expect($el1.hasClass("collapsed")).toBe(true);expect($el2.hasClass("collapsed")).toBe(true)});it("Expand all",function(){var $el1=entry1.$el.find(".review-request-page-entry-contents");var $el2=entry2.$el.find(".review-request-page-entry-contents");$el1.addClass("collapsed");$el2.addClass("collapsed");pageView.$("#expand-all").click();expect($el1.hasClass("collapsed")).toBe(false);expect($el2.hasClass("collapsed")).toBe(false)})});describe("Methods",function(){describe("openCommentEditor",function(){beforeEach(function(){spyOn(RB.ReviewRequestPage.ReviewReplyEditorView.prototype,"openCommentEditor");spyOn(entry1,"getReviewReplyEditorView").and.callThrough();spyOn(entry2,"getReviewReplyEditorView").and.callThrough()});it("With body_top",function(){pageView.openCommentEditor("body_top");expect(entry1.getReviewReplyEditorView).toHaveBeenCalled();expect(RB.ReviewRequestPage.ReviewReplyEditorView.prototype.openCommentEditor).toHaveBeenCalled();expect(entry2.getReviewReplyEditorView).not.toHaveBeenCalled()});it("With body_bottom",function(){pageView.openCommentEditor("body_bottom");expect(entry1.getReviewReplyEditorView).toHaveBeenCalled();expect(RB.ReviewRequestPage.ReviewReplyEditorView.prototype.openCommentEditor).toHaveBeenCalled();expect(entry2.getReviewReplyEditorView).not.toHaveBeenCalled()});it("With comments",function(){pageView.openCommentEditor("diff_comments",123);expect(entry1.getReviewReplyEditorView).toHaveBeenCalled();expect(RB.ReviewRequestPage.ReviewReplyEditorView.prototype.openCommentEditor).toHaveBeenCalled();expect(entry2.getReviewReplyEditorView).not.toHaveBeenCalled()})})})});"use strict";suite("rb/views/ReviewView",function(){var template=_.template('<div class="review review-request-page-entry">\n <div class="review-request-page-entry-contents">\n  <div class="collapse-button"></div>\n  <div class="banners">\n   <input type="button" value="Publish" />\n   <input type="button" value="Discard" />\n  </div>\n  <div class="body">\n   <ol class="review-comments">\n    <li>\n     <div class="review-comment-thread">\n      <div class="review-comment">\n       <pre class="reviewtext body_top"></pre>\n      </div>\n      <div class="comment-section" data-context-type="body_top">\n       <a class="add_comment_link"></a>\n       <ul class="reply-comments">\n        <li class="draft" data-comment-id="456">\n         <pre class="reviewtext"></pre>\n        </li>\n       </ul>\n      </div>\n     </div>\n    </li>\n    <li>\n     <div class="review-comment-thread">\n      <div class="comment-section" data-context-id="123"\n           data-context-type="diff_comments">\n       <a class="add_comment_link"></a>\n       <ul class="reply-comments"></ul>\n      </div>\n     </div>\n    </li>\n    <li>\n     <div class="review-comment-thread">\n      <div class="review-comment">\n       <pre class="reviewtext body_bottom"></pre>\n      </div>\n      <div class="comment-section" data-context-type="body_bottom">\n       <a class="add_comment_link"></a>\n       <ul class="reply-comments"></ul>\n      </div>\n     </div>\n    </div>\n   </li>\n  </ol>\n </div>\n</div>');var view=void 0;var review=void 0;var reviewReply=void 0;beforeEach(function(){var reviewRequest=new RB.ReviewRequest;var editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest});review=reviewRequest.createReview({loaded:true,links:{replies:{href:"/api/review/123/replies/"}}});var $el=$(template()).appendTo($testsScratch);reviewReply=review.createReply();view=new RB.ReviewRequestPage.ReviewView({el:$el,model:review,entryModel:new RB.ReviewRequestPage.ReviewEntry({review:review,reviewRequest:reviewRequest,reviewRequestEditor:editor})});view._setupNewReply(reviewReply);spyOn(view,"trigger").and.callThrough();view.render()});describe("Model events",function(){it("bodyTop changed",function(){review.set({bodyTop:"new **body** top",htmlTextFields:{bodyTop:"<p>new <strong>body</strong> top</p>"}});expect(view._$bodyTop.html()).toBe("<p>new <strong>body</strong> top</p>")});it("bodyBottom changed",function(){review.set({bodyBottom:"new **body** bottom",htmlTextFields:{bodyBottom:"<p>new <strong>body</strong> bottom</p>"}});expect(view._$bodyBottom.html()).toBe("<p>new <strong>body</strong> bottom</p>")});describe("bodyTopRichText changed",function(){it("To true",function(){expect(view._$bodyTop.hasClass("rich-text")).toBe(false);review.set("bodyTopRichText",true);expect(view._$bodyTop.hasClass("rich-text")).toBe(true)});it("To false",function(){review.attributes.bodyTopRichText=true;view._$bodyTop.addClass("rich-text");review.set("bodyTopRichText",false);expect(view._$bodyTop.hasClass("rich-text")).toBe(false)})});describe("bodyBottomRichText changed",function(){it("To true",function(){expect(view._$bodyBottom.hasClass("rich-text")).toBe(false);review.set("bodyBottomRichText",true);expect(view._$bodyBottom.hasClass("rich-text")).toBe(true)});it("To false",function(){review.attributes.bodyBottomRichText=true;view._$bodyBottom.addClass("rich-text");review.set("bodyBottomRichText",false);expect(view._$bodyBottom.hasClass("rich-text")).toBe(false)})})});describe("Reply editors",function(){it("Views created",function(){expect(view._replyEditorViews.length).toBe(3)});it("Initial state populated",function(){var model=view._replyEditorViews[0].model;expect(model.get("contextID")).toBe(null);expect(model.get("contextType")).toBe("body_top");expect(model.get("hasDraft")).toBe(true);model=view._replyEditorViews[1].model;expect(model.get("contextID")).toBe(123);expect(model.get("contextType")).toBe("diff_comments");expect(model.get("hasDraft")).toBe(false);model=view._replyEditorViews[2].model;expect(model.get("contextID")).toBe(null);expect(model.get("contextType")).toBe("body_bottom");expect(model.get("hasDraft")).toBe(false);expect(view._replyDraftsCount).toBe(1)});it("Draft banner when draft comment exists",function(){expect(view.trigger).toHaveBeenCalledWith("hasDraftChanged",true)});describe("reviewReply changes on",function(){it("Discard",function(){spyOn(view,"_setupNewReply");spyOn(reviewReply,"discardIfEmpty").and.callFake(function(options,context){return options.success.call(context)});reviewReply.trigger("destroyed");expect(view._setupNewReply).toHaveBeenCalled()});it("Publish",function(){spyOn(view,"_setupNewReply");view._replyEditors.forEach(function(editor){return spyOn(editor,"_resetState")});reviewReply.trigger("published");expect(view._setupNewReply).toHaveBeenCalled()})});describe("When draft deleted",function(){describe("With last one",function(){it("Draft banner hidden",function(){var editor=view._replyEditors[0];expect(editor.get("hasDraft")).toBe(true);expect(view._replyDraftsCount).toBe(1);expect(view._draftBannerShown).toBe(true);editor.set("hasDraft",false);expect(view._replyDraftsCount).toBe(0);expect(view._draftBannerShown).toBe(false)})});describe("With more remaining",function(){it("Draft banner stays visible",function(){view._replyEditors[1].set("hasDraft",true);var editor=view._replyEditors[0];expect(editor.get("hasDraft")).toBe(true);expect(view._replyDraftsCount).toBe(2);expect(view._draftBannerShown).toBe(true);editor.set("hasDraft",false);expect(view._replyDraftsCount).toBe(1);expect(view._draftBannerShown).toBe(true)})})});describe("When reviewReply changes",function(){it("Signals connected",function(){spyOn(view,"listenTo").and.callThrough();view._setupNewReply(new RB.ReviewReply);expect(view.listenTo.calls.argsFor(0)[1]).toBe("destroyed published")});it("Signals disconnected from old reviewReply",function(){spyOn(view,"stopListening").and.callThrough();view._setupNewReply();expect(view.stopListening).toHaveBeenCalledWith(reviewReply)});it("Hide draft banner signal emitted",function(){view._setupNewReply();expect(view.trigger).toHaveBeenCalledWith("hasDraftChanged",false)});it("Editors updated",function(){view._setupNewReply();view._replyEditors.forEach(function(editor){return expect(editor.get("reviewReply")).toBe(view._reviewReply)})})})})});suite("rb/ui/views/DialogView",function(){describe("Buttons",function(){describe("Settings",function(){it("Default",function(){var dialogView=new RB.DialogView({buttons:[{label:"Test"}]}),buttons=dialogView._getButtons();expect(buttons.length).toBe(1);expect(buttons[0].val()).toBe("Test");expect(buttons[0].hasClass("primary")).toBe(false);expect(buttons[0].hasClass("danger")).toBe(false)});it("Primary",function(){var dialogView=new RB.DialogView({buttons:[{label:"Test",primary:true}]}),buttons=dialogView._getButtons();expect(buttons.length).toBe(1);expect(buttons[0].val()).toBe("Test");expect(buttons[0].hasClass("primary")).toBe(true);expect(buttons[0].hasClass("danger")).toBe(false)});it("Danger",function(){var dialogView=new RB.DialogView({buttons:[{label:"Test",danger:true}]}),buttons=dialogView._getButtons();expect(buttons.length).toBe(1);expect(buttons[0].val()).toBe("Test");expect(buttons[0].hasClass("primary")).toBe(false);expect(buttons[0].hasClass("danger")).toBe(true)})});describe("Events",function(){describe("Click",function(){it("When function",function(){var myFunc=jasmine.createSpy("cb"),dialogView=new RB.DialogView({buttons:[{label:"Test",onClick:myFunc}]}),buttons=dialogView._getButtons();expect(buttons.length).toBe(1);expect(buttons[0].val()).toBe("Test");buttons[0].click();expect(myFunc).toHaveBeenCalled()});it("When string on subclass",function(){var MyDialogView=RB.DialogView.extend({buttons:[{label:"Test",onClick:"_onClicked"}],_onClicked:jasmine.createSpy("cb")}),dialogView=new MyDialogView,buttons=dialogView._getButtons();expect(buttons.length).toBe(1);expect(buttons[0].val()).toBe("Test");buttons[0].click();expect(dialogView._onClicked).toHaveBeenCalled()})})})})});"use strict";suite("rb/ui/views/InfoboxManagerView",function(){var DummyInfoboxView=RB.BaseInfoboxView.extend({infoboxID:"dummy-infobox"});var infoboxManagerView=void 0;beforeEach(function(){infoboxManagerView=RB.InfoboxManagerView.getInstance();spyOn(infoboxManagerView,"_fetchInfoboxContents").and.callFake(function(url,onDone){expect(url).toBe("/foo/infobox/");onDone("<strong>Hi!</strong>")})});afterEach(function(){infoboxManagerView.remove();RB.InfoboxManagerView._instance=null});describe("addTargets",function(){var $el1=void 0;var $el2=void 0;var $els=void 0;beforeEach(function(){$el1=$("<div/>");$el2=$("<div/>");$els=$([$el1[0],$el2[0]])});it("Registers new targets",function(){infoboxManagerView.addTargets(DummyInfoboxView,$els);expect($el1.data("has-infobox")).toBe(true);expect($el2.data("has-infobox")).toBe(true)});it("Registers event handlers",function(){spyOn(infoboxManagerView,"_onTargetMouseEnter");spyOn(infoboxManagerView,"_onMouseLeave");infoboxManagerView.addTargets(DummyInfoboxView,$els);$el1.triggerHandler("mouseenter");expect(infoboxManagerView._onTargetMouseEnter).toHaveBeenCalled();$el1.triggerHandler("mouseleave");expect(infoboxManagerView._onMouseLeave).toHaveBeenCalled()});it("Skips already-registered targets",function(){spyOn(infoboxManagerView,"_onTargetMouseEnter");infoboxManagerView.addTargets(DummyInfoboxView,$els);infoboxManagerView.addTargets(DummyInfoboxView,$els);$el1.triggerHandler("mouseenter");expect(infoboxManagerView._onTargetMouseEnter.calls.count()).toBe(1)})});describe("getOrCreateInfobox",function(){it("Caches infobox views",function(){var infoboxView1=infoboxManagerView.getOrCreateInfobox(DummyInfoboxView);var infoboxView2=infoboxManagerView.getOrCreateInfobox(DummyInfoboxView);expect(infoboxView1.cid).toBe(infoboxView2.cid)});it("Starts infobox hidden",function(){var infoboxView=infoboxManagerView.getOrCreateInfobox(DummyInfoboxView);expect(infoboxView.$el.is(":visible")).toBe(false)});it("Registers events",function(){spyOn(infoboxManagerView,"_onInfoboxMouseEnter");spyOn(infoboxManagerView,"_onMouseLeave");var infoboxView=infoboxManagerView.getOrCreateInfobox(DummyInfoboxView);infoboxView.$el.triggerHandler("mouseenter");expect(infoboxManagerView._onInfoboxMouseEnter).toHaveBeenCalled();infoboxView.$el.triggerHandler("mouseleave");expect(infoboxManagerView._onMouseLeave).toHaveBeenCalled()})});describe("setPositioning",function(){it("Overrides default position",function(){infoboxManagerView.setPositioning(DummyInfoboxView,{side:"b",foo:"bar"});
var infoboxView=infoboxManagerView.getOrCreateInfobox(DummyInfoboxView);expect(infoboxView.positioning).toEqual({side:"b",foo:"bar"})})});describe("Target Events",function(){var $el=void 0;beforeEach(function(){spyOn(window,"setTimeout").and.callFake(function(cb){return cb()});$el=$('<a href="/foo/" />');infoboxManagerView.addTargets(DummyInfoboxView,$el)});describe("mouseenter",function(){it("First time for target",function(){$el.triggerHandler("mouseenter");var infoboxView=infoboxManagerView.getOrCreateInfobox(DummyInfoboxView);expect(infoboxView.$el.html()).toBe("<strong>Hi!</strong>");expect(infoboxView.$el.is(":visible")).toBe(true)});it("Subsequent time for target (cached data)",function(){var infoboxView=infoboxManagerView.getOrCreateInfobox(DummyInfoboxView);spyOn(infoboxView,"setContents").and.callThrough();spyOn(infoboxManagerView,"_showInfobox").and.callThrough();infoboxManagerView._cache["/foo/infobox/"]="Old HTML";$el.triggerHandler("mouseenter");expect(infoboxView.$el.html()).toBe("<strong>Hi!</strong>");expect(infoboxView.$el.is(":visible")).toBe(true);expect(infoboxManagerView._showInfobox.calls.count()).toBe(1);expect(infoboxView.setContents.calls.count()).toBe(2)})});describe("mouseleave",function(){beforeEach(function(){$el.triggerHandler("mouseenter")});it("Cancels showing infobox",function(){infoboxManagerView._showTimeout=123;$el.triggerHandler("mouseleave");expect(infoboxManagerView._showTimeout).toBe(null)});it("Hides infobox",function(){var infoboxView=infoboxManagerView.getOrCreateInfobox(DummyInfoboxView);infoboxManagerView._showTimeout=123;expect(infoboxView.$el.is(":visible")).toBe(true);expect(infoboxManagerView._activeInfoboxView).not.toBe(null);$el.triggerHandler("mouseleave");expect(infoboxView.$el.is(":visible")).toBe(false);expect(infoboxManagerView._activeInfoboxView).toBe(null);expect(infoboxManagerView._showTimeout).toBe(null)})})});describe("Infobox Events",function(){var $el=void 0;beforeEach(function(){spyOn(window,"setTimeout").and.callFake(function(cb){return cb()});$el=$('<a href="/foo/" />');infoboxManagerView.addTargets(DummyInfoboxView,$el)});describe("mouseenter",function(){it("Preserves infobox after leaving target",function(){var infoboxView=infoboxManagerView.getOrCreateInfobox(DummyInfoboxView);$el.triggerHandler("mouseenter");expect(infoboxManagerView._activeInfoboxView).toBe(infoboxView);window.setTimeout.and.callThrough();$el.triggerHandler("mouseleave");expect(infoboxManagerView._hideTimeout).not.toBe(null);expect(infoboxManagerView._showTimeout).toBe(null);infoboxView.$el.triggerHandler("mouseenter");expect(infoboxView.$el.is(":visible")).toBe(true);expect(infoboxManagerView._showTimeout).toBe(null);expect(infoboxManagerView._hideTimeout).toBe(null)})});describe("mouseleave",function(){it("Hides infobox",function(){var infoboxView=infoboxManagerView.getOrCreateInfobox(DummyInfoboxView);infoboxManagerView._showInfobox(infoboxView,$el);expect(infoboxView.$el.is(":visible")).toBe(true);expect(infoboxManagerView._activeInfoboxView).toBe(infoboxView);infoboxView.$el.triggerHandler("mouseleave");expect(infoboxView.$el.is(":visible")).toBe(false);expect(infoboxManagerView._activeInfoboxView).toBe(null);expect(infoboxManagerView._showTimeout).toBe(null)})})})});"use strict";suite("rb/ui/managers/NotificationManagerModel",function(){var instance=RB.NotificationManager.instance;var origNotification=void 0;var Notification=function Notification(title,options){this.title=title;this.options=options;this.close=function(){}};Notification.requestPermission=function(){Notification.permission="granted"};beforeEach(function(){origNotification=RB.NotificationManager.Notification;RB.NotificationManager.Notification=Notification;RB.UserSession.instance.set("enableDesktopNotifications",true);instance.setup();expect(Notification.permission).toBe("granted")});afterEach(function(){RB.NotificationManager.Notification=origNotification});describe("Notification Manager",function(){it("Calls external API",function(){instance.notify({title:"Test",body:"This is a test"});var notification=instance._notification;expect(notification).not.toBe(null);expect(notification.title).toBe("Test");expect(notification.options.body).toBe("This is a test")});it("Should notify",function(){instance._canNotify=true;spyOn(instance,"_haveNotificationPermissions").and.returnValue(true);expect(instance.shouldNotify()).toBe(true)});it("Should not notify due to user permissions",function(){instance._canNotify=false;spyOn(instance,"_haveNotificationPermissions").and.returnValue(true);expect(instance.shouldNotify()).toBe(false)});it("Should not notify due to browser permissions",function(){instance._canNotify=true;spyOn(instance,"_haveNotificationPermissions").and.returnValue(false);expect(instance.shouldNotify()).toBe(false)})})});"use strict";suite("rb/ui/views/ScrollManagerView",function(){function makeElement(){var dimensions=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};var scratchOffset=$testsScratch.offset();return $("<div/>").css({position:"absolute",left:-scratchOffset.left+(dimensions.left||0),top:-scratchOffset.top+(dimensions.top||0),width:dimensions.width||20,height:dimensions.height||20}).appendTo($testsScratch)}var scrollManager=void 0;beforeEach(function(){scrollManager=new RB.ScrollManagerView;scrollManager.window={pageXOffset:0,pageYOffset:0,scrollTo:function scrollTo(x,y){this.pageXOffset=x;this.pageYOffset=y},requestAnimationFrame:function requestAnimationFrame(cb){cb()}}});describe("scrollToPosition",function(){it("Without scroll offset",function(){scrollManager.scrollToPosition(100);expect(scrollManager.window.pageYOffset).toBe(100)});it("With scroll offset",function(){scrollManager.scrollYOffset=40;scrollManager.scrollToPosition(100);expect(scrollManager.window.pageYOffset).toBe(60)})});describe("scrollToElement",function(){var $el=void 0;beforeEach(function(){$el=makeElement({top:50})});it("Without scroll offset",function(){scrollManager.scrollToElement($el);expect(scrollManager.window.pageYOffset).toBe(50)});it("With scroll offset",function(){scrollManager.scrollYOffset=40;scrollManager.scrollToElement($el);expect(scrollManager.window.pageYOffset).toBe(10)})});describe("markUpdated",function(){var $el=void 0;beforeEach(function(){$el=makeElement({top:50})});it("First in a batch",function(){scrollManager.window.pageYOffset=100;expect(scrollManager._oldScrollY).toBe(null);scrollManager.markForUpdate($el);expect(scrollManager._pendingElements.get($el[0])).toEqual({oldHeight:20,oldOffset:{top:50,left:0}});expect(scrollManager._oldScrollY).toBe(100)});it("Subsequent entries",function(){scrollManager._oldScrollY=100;scrollManager.window.pageYOffset=200;scrollManager.markForUpdate($el);expect(scrollManager._pendingElements.get($el[0])).toEqual({oldHeight:20,oldOffset:{top:50,left:0}});expect(scrollManager._oldScrollY).toBe(100)})});describe("markUpdated",function(){var $el=void 0;beforeEach(function(){$el=makeElement({top:50})});it("Stores correct state",function(){spyOn(scrollManager.window,"requestAnimationFrame");scrollManager.markForUpdate($el);$el.height(40);$el.css("top",parseInt($el.css("top"),10)-10);scrollManager.markUpdated($el);var el=$el[0];expect(scrollManager._pendingElements.get(el)).toBe(undefined);expect(scrollManager._elements.get(el)).toEqual({oldHeight:20,oldOffset:{top:50,left:0},newHeight:40,newOffset:{top:40,left:0}});expect(scrollManager.window.requestAnimationFrame).toHaveBeenCalled()})});describe("Scroll updates",function(){beforeEach(function(){spyOn(scrollManager.window,"requestAnimationFrame");scrollManager.window.pageYOffset=200});it("Includes updates before scroll position",function(){var $el1=makeElement({top:10});var $el2=makeElement({top:60});var $el3=makeElement({top:70});scrollManager.markForUpdate($el1);$el1.height(70);scrollManager.markUpdated($el1);scrollManager.markForUpdate($el2);$el2.height(10);scrollManager.markUpdated($el2);scrollManager.markForUpdate($el3);$el3.css("top",parseInt($el3.css("top"),10)-5);scrollManager.markUpdated($el3);scrollManager._updateScrollPos();expect(scrollManager.window.pageYOffset).toBe(235)});it("Ignores updates after scroll position",function(){var $el1=makeElement({top:10});var $el2=makeElement({top:scrollManager.window.pageYOffset});var $el3=makeElement({top:500});scrollManager.markForUpdate($el1);$el1.height(30);scrollManager.markUpdated($el1);scrollManager.markForUpdate($el2);$el2.height(90);scrollManager.markUpdated($el2);scrollManager.markForUpdate($el3);$el3.height(1e3);scrollManager.markUpdated($el3);scrollManager._updateScrollPos();expect(scrollManager.window.pageYOffset).toBe(210)})})});suite("rb/ui/views/TextEditorView",function(){var view,file;beforeEach(function(){RB.DnDUploader.create()});afterEach(function(){RB.DnDUploader.instance=null});describe("Construction",function(){it("Initial text",function(){view=new RB.TextEditorView({text:"Test"});view.render();expect(view.getText()).toBe("Test")});describe("Text field wrapper",function(){it("If plain text",function(){view=new RB.TextEditorView({richText:false});view.render();view.show();expect(view.richText).toBe(false);expect(view.$el.children("textarea").length).toBe(1);expect(view.$el.children(".CodeMirror").length).toBe(0)});it("If Markdown",function(){view=new RB.TextEditorView({richText:true});view.render();view.show();expect(view.richText).toBe(true);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(1)})});describe("Default richText",function(){describe("If user default is true",function(){beforeEach(function(){RB.UserSession.instance.set("defaultUseRichText",true)});it("And richText unset",function(){view=new RB.TextEditorView;view.render();view.show();expect(view.richText).toBe(true);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(1)});it("And richText=true",function(){view=new RB.TextEditorView({richText:true});view.render();view.show();expect(view.richText).toBe(true);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(1)});it("And richText=false",function(){view=new RB.TextEditorView({richText:false});view.render();view.show();expect(view.richText).toBe(true);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(1)})});describe("If user default is false",function(){beforeEach(function(){RB.UserSession.instance.set("defaultUseRichText",false)});it("And richText unset",function(){view=new RB.TextEditorView;view.render();view.show();expect(view.richText).toBe(false);expect(view.$el.children("textarea").length).toBe(1);expect(view.$el.children(".CodeMirror").length).toBe(0)});it("And richText=true",function(){view=new RB.TextEditorView({richText:true});view.render();view.show();expect(view.richText).toBe(true);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(1)});it("And richText=false",function(){view=new RB.TextEditorView({richText:false});view.render();view.show();expect(view.richText).toBe(false);expect(view.$el.children("textarea").length).toBe(1);expect(view.$el.children(".CodeMirror").length).toBe(0)})})})});describe("Operations",function(){describe("bindRichTextAttr",function(){var myModel;beforeEach(function(){myModel=new Backbone.Model({richText:false});view=new RB.TextEditorView});it("Updates on change",function(){view.bindRichTextAttr(myModel,"richText");expect(view.richText).toBe(false);myModel.set("richText",true);expect(view.richText).toBe(true)});describe("Initial richText value",function(){it("true",function(){myModel.set("richText",true);view.bindRichTextAttr(myModel,"richText");expect(view.richText).toBe(true)});it("false",function(){myModel.set("richText",false);view.bindRichTextAttr(myModel,"richText");expect(view.richText).toBe(false)})})});describe("bindRichTextCheckbox",function(){var $checkbox;beforeEach(function(){$checkbox=$('<input type="checkbox"/>');view=new RB.TextEditorView;view.setRichText(false)});it("Checkbox reflects richText",function(){view.bindRichTextCheckbox($checkbox);expect($checkbox.prop("checked")).toBe(false);view.setRichText(true);expect($checkbox.prop("checked")).toBe(true)});describe("richText reflects checkbox",function(){it("Checked",function(){view.setRichText(false);view.bindRichTextCheckbox($checkbox);$checkbox.prop("checked",true).triggerHandler("change");expect(view.richText).toBe(true)});it("Unchecked",function(){view.setRichText(true);view.bindRichTextCheckbox($checkbox);$checkbox.prop("checked",false).triggerHandler("change");expect(view.richText).toBe(false)})});describe("Initial checked state",function(){it("richText=true",function(){view.setRichText(true);view.bindRichTextCheckbox($checkbox);expect($checkbox.prop("checked")).toBe(true)});it("richText=false",function(){view.setRichText(false);view.bindRichTextCheckbox($checkbox);expect($checkbox.prop("checked")).toBe(false)})})});describe("bindRichTextVisibility",function(){var $el;beforeEach(function(){$el=$("<div/>");view=new RB.TextEditorView;view.setRichText(false)});describe("Initial visibility",function(){it("richText=true",function(){$el.hide();view.setRichText(true);view.bindRichTextVisibility($el);expect($el.css("display")).toBe("block")});it("richText=false",function(){view.bindRichTextVisibility($el);expect($el.css("display")).toBe("none")})});describe("Toggles visibility on change",function(){it("richText=true",function(){$el.hide();view.bindRichTextVisibility($el);expect($el.css("display")).toBe("none");view.setRichText(true);expect($el.css("display")).toBe("block")});it("richText=false",function(){view.setRichText(true);view.bindRichTextVisibility($el);expect($el.css("display")).toBe("block");view.setRichText(false);expect($el.css("display")).toBe("none")})})});describe("setRichText",function(){it("Emits change:richText",function(){var emitted=false;view.on("change:richText",function(){emitted=true});view.show();view.richText=false;view.setRichText(true);expect(emitted).toBe(true)});it("Emits change",function(){var emitted=false;view.on("change",function(){emitted=true});view.show();view.richText=false;view.setRichText(true);expect(emitted).toBe(true)});it("Marks dirty",function(){view.show();view.richText=false;expect(view.isDirty()).toBe(false);view.setRichText(true);expect(view.isDirty()).toBe(true)});describe("Markdown to Text",function(){beforeEach(function(){view=new RB.TextEditorView({richText:true});view.render()});it("If shown",function(){view.show();view.setRichText(false);expect(view.richText).toBe(false);expect(view.$el.children("textarea").length).toBe(1);expect(view.$el.children(".CodeMirror").length).toBe(0)});it("If hidden",function(){view.setRichText(false);expect(view.richText).toBe(false);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(0)})});describe("Text to Markdown",function(){beforeEach(function(){view=new RB.TextEditorView({richText:false});view.render()});it("If shown",function(){view.show();view.setRichText(true);expect(view.richText).toBe(true);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(1)});it("If hidden",function(){view.setRichText(true);expect(view.richText).toBe(true);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(0)})})});describe("setText",function(){describe("If shown",function(){it("If plain text",function(){view=new RB.TextEditorView({richText:false});view.show();view.setText("Test");expect(view.$("textarea").val()).toBe("Test")});it("If Markdown",function(){view=new RB.TextEditorView({richText:true});view.show();view.setText("Test");expect(view._editor._codeMirror.getValue()).toBe("Test")})});it("If hidden",function(){view=new RB.TextEditorView;view.setText("Test");expect(view.getText()).toBe("Test")})});describe("getText",function(){it("If plain text",function(){view=new RB.TextEditorView({richText:false});view.show();view.setText("Test");expect(view.getText()).toBe("Test")});it("If Markdown",function(){view=new RB.TextEditorView({richText:true});view.show();view.setText("Test");expect(view.getText()).toBe("Test")})});describe("insertLine",function(){it("If plain text",function(){view=new RB.TextEditorView({richText:false});view.show();view.setText("Test");view.insertLine("Test");expect(view.getText()).toBe("Test\nTest")});it("If Markdown",function(){view=new RB.TextEditorView({richText:true});view.show();view.setText("Test");view.insertLine("Test");expect(view.getText()).toBe("Test\nTest")})});describe("show",function(){it("registers drop target if rich text",function(){spyOn(RB.DnDUploader.instance,"registerDropTarget");view=new RB.TextEditorView({richText:true});view.show();expect(RB.DnDUploader.instance.registerDropTarget).toHaveBeenCalled()});it("does not register drop target if plain text",function(){spyOn(RB.DnDUploader.instance,"registerDropTarget");view=new RB.TextEditorView({richText:false});view.show();expect(RB.DnDUploader.instance.registerDropTarget).not.toHaveBeenCalled()})});describe("hide",function(){it("disables drop target",function(){spyOn(RB.DnDUploader.instance,"unregisterDropTarget");view=new RB.TextEditorView({richText:true});view.show();view.hide();expect(RB.DnDUploader.instance.unregisterDropTarget).toHaveBeenCalled()})})});describe("inlineEditor options",function(){var $el,$buttons,$markdownCheckbox;function setupEditor(options){$el=$("<textarea>").inlineEditor(RB.TextEditorView.getInlineEditorOptions(options));view=$el.inlineEditor("field").data("text-editor");$el.inlineEditor("startEdit");$buttons=$el.inlineEditor("buttons");expect($buttons.length).toBe(1);$markdownCheckbox=$buttons.find("input[type=checkbox]");expect($markdownCheckbox.length).toBe(1)}describe("Rich text checkbox",function(){function setChecked(checked){$markdownCheckbox.click().prop("checked",checked).trigger("change")}it("Checking",function(){setupEditor({richText:false});expect($markdownCheckbox.prop("checked")).toBe(false);setChecked(true);expect($markdownCheckbox.prop("checked")).toBe(true);expect(view.richText).toBe(true)});it("Unchecking",function(){setupEditor({richText:true});expect($markdownCheckbox.prop("checked")).toBe(true);setChecked(false);expect($markdownCheckbox.prop("checked")).toBe(false);expect(view.richText).toBe(false)});it("Resets after cancel",function(){setupEditor({richText:true});setChecked(false);$el.inlineEditor("cancel");expect($markdownCheckbox.prop("checked")).toBe(true);expect(view.richText).toBe(true);expect(view.isDirty()).toBe(false)});describe("Initial state",function(){it("If plain text",function(){setupEditor({richText:false});expect($markdownCheckbox.prop("checked")).toBe(false)});it("If Markdown",function(){setupEditor({richText:true});expect($markdownCheckbox.prop("checked")).toBe(true)})})})});describe("Drag and Drop",function(){beforeEach(function(){view=new RB.TextEditorView({richText:true})});describe("_isImage",function(){it("correctly checks mimetype",function(){file={type:"image/jpeg",name:"testimage.jpg"};expect(view._isImage(file)).toBe(true)});it("checks filename extension",function(){file={name:"testimage.jpg"};expect(view._isImage(file)).toBe(true)});it("returns false when given invalid type",function(){file={type:"application/json",name:"testimage.jps"};expect(view._isImage(file)).toBe(false)})})})});"use strict";var _typeof=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(obj){return typeof obj}:function(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj};suite("rb/utils/dataUtils",function(){it("readBlobAsArrayBuffer",function(done){var str="abc123";var blob=new Blob([str]);RB.DataUtils.readBlobAsArrayBuffer(blob,function(result){expect(result.byteLength).toBe(6);var dataView=new DataView(result);for(var i=0;i<result.byteLength;i++){expect(dataView.getUint8(i)).toBe(str.charCodeAt(i))}done()})});it("readBlobAsString",function(done){var blob=new Blob(["This is a test."]);RB.DataUtils.readBlobAsString(blob,function(result){expect(typeof result==="undefined"?"undefined":_typeof(result)).toBe("string");expect(result).toBe("This is a test.");done()})});it("readManyBlobsAsArrayBuffers",function(done){var str1="abc123";var str2="foo";var blob1=new Blob([str1]);var blob2=new Blob([str2]);RB.DataUtils.readManyBlobsAsArrayBuffers([blob1,blob2],function(result1,result2){expect(result1.byteLength).toBe(6);expect(result2.byteLength).toBe(3);var dataView1=new DataView(result1);for(var i=0;i<result1.byteLength;i++){expect(dataView1.getUint8(i)).toBe(str1.charCodeAt(i))}var dataView2=new DataView(result2);for(var _i=0;_i<result2.byteLength;_i++){expect(dataView2.getUint8(_i)).toBe(str2.charCodeAt(_i))}done()})});it("readManyBlobsAsStrings",function(done){var blob1=new Blob(["This is a test."]);var blob2=new Blob(["hello world"]);RB.DataUtils.readManyBlobsAsStrings([blob1,blob2],function(result1,result2){expect(typeof result1==="undefined"?"undefined":_typeof(result1)).toBe("string");expect(typeof result2==="undefined"?"undefined":_typeof(result2)).toBe("string");expect(result1).toBe("This is a test.");expect(result2).toBe("hello world");done()})});describe("buildArrayBuffer",function(){it("With int8",function(){var values=[-1,0,1];var arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"int8",values:values}]);expect(arrayBuffer.byteLength).toBe(3);var dataView=new DataView(arrayBuffer);for(var i=0;i<values.length;i++){expect(dataView.getInt8(i)).toBe(values[i])}});it("With uint8",function(){var values=[1,2,3];var arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"uint8",values:values}]);expect(arrayBuffer.byteLength).toBe(3);var dataView=new DataView(arrayBuffer);for(var i=0;i<values.length;i++){expect(dataView.getUint8(i)).toBe(values[i])}});describe("With int16",function(){var values=[-1,0,1];it("Little endian",function(){var arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"int16",values:values}]);expect(arrayBuffer.byteLength).toBe(6);var dataView=new DataView(arrayBuffer);for(var i=0;i<values.length;i++){expect(dataView.getInt16(i*2,true)).toBe(values[i])}});it("Big endian",function(){var arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"int16",values:values,bigEndian:true}]);expect(arrayBuffer.byteLength).toBe(6);var dataView=new DataView(arrayBuffer);for(var i=0;i<values.length;i++){expect(dataView.getInt16(i*2)).toBe(values[i])}})});describe("With uint16",function(){var values=[1,2,3];it("Little endian",function(){var arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"uint16",values:values}]);expect(arrayBuffer.byteLength).toBe(6);var dataView=new DataView(arrayBuffer);for(var i=0;i<values.length;i++){expect(dataView.getUint16(i*2,true)).toBe(values[i])}});it("Big endian",function(){var arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"uint16",values:values,bigEndian:true}]);expect(arrayBuffer.byteLength).toBe(6);var dataView=new DataView(arrayBuffer);for(var i=0;i<values.length;i++){expect(dataView.getUint16(i*2)).toBe(values[i])}})});describe("With int32",function(){var values=[-1,0,1];it("Little endian",function(){var arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"int32",values:values}]);expect(arrayBuffer.byteLength).toBe(12);var dataView=new DataView(arrayBuffer);for(var i=0;i<values.length;i++){expect(dataView.getInt32(i*4,true)).toBe(values[i])}});it("Big endian",function(){var arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"int32",values:values,bigEndian:true}]);expect(arrayBuffer.byteLength).toBe(12);var dataView=new DataView(arrayBuffer);for(var i=0;i<values.length;i++){expect(dataView.getInt32(i*4)).toBe(values[i])}})});describe("With uint32",function(){var values=[1,2,3];it("Little endian",function(){var arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"uint32",values:values}]);expect(arrayBuffer.byteLength).toBe(12);var dataView=new DataView(arrayBuffer);for(var i=0;i<values.length;i++){expect(dataView.getUint32(i*4,true)).toBe(values[i])}});it("Big endian",function(){var arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"uint32",values:values,bigEndian:true}]);expect(arrayBuffer.byteLength).toBe(12);var dataView=new DataView(arrayBuffer);for(var i=0;i<values.length;i++){expect(dataView.getUint32(i*4)).toBe(values[i])}})});describe("With float32",function(){var values=[1,2,3];it("Little endian",function(){var arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"float32",values:values}]);expect(arrayBuffer.byteLength).toBe(12);var dataView=new DataView(arrayBuffer);for(var i=0;i<values.length;i++){expect(dataView.getFloat32(i*4,true)).toBe(values[i])}});it("Big endian",function(){var arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"float32",values:values,bigEndian:true}]);expect(arrayBuffer.byteLength).toBe(12);var dataView=new DataView(arrayBuffer);for(var i=0;i<values.length;i++){expect(dataView.getFloat32(i*4)).toBe(values[i])}})});describe("With float64",function(){var values=[1,2,3];it("Little endian",function(){var arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"float64",values:values}]);expect(arrayBuffer.byteLength).toBe(24);var dataView=new DataView(arrayBuffer);for(var i=0;i<values.length;i++){expect(dataView.getFloat64(i*8,true)).toBe(values[i])}});it("Big endian",function(){var arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"float64",values:values,bigEndian:true}]);expect(arrayBuffer.byteLength).toBe(24);var dataView=new DataView(arrayBuffer);for(var i=0;i<values.length;i++){expect(dataView.getFloat64(i*8)).toBe(values[i])}})});it("With complex schema",function(){var arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"int32",values:[10,20],bigEndian:true},{type:"uint8",values:[100]},{type:"uint16",values:[64]},{type:"float64",values:[1.234]}]);expect(arrayBuffer.byteLength).toBe(19);var dataView=new DataView(arrayBuffer);expect(dataView.getInt32(0)).toBe(10);expect(dataView.getInt32(4)).toBe(20);expect(dataView.getUint8(8)).toBe(100);expect(dataView.getUint16(9,true)).toBe(64);expect(dataView.getFloat64(11,true)).toEqual(1.234)})});it("buildBlob",function(done){var blob=RB.DataUtils.buildBlob(["abc",[{type:"uint8",values:[1,2]},{type:"uint32",values:[100]}],new Blob(["def"])]);RB.DataUtils.readBlobAsArrayBuffer(blob,function(arrayBuffer){expect(arrayBuffer.byteLength).toBe(12);var dataView=new DataView(arrayBuffer);expect(dataView.getUint8(0)).toBe("a".charCodeAt(0));expect(dataView.getUint8(1)).toBe("b".charCodeAt(0));expect(dataView.getUint8(2)).toBe("c".charCodeAt(0));expect(dataView.getUint8(3)).toBe(1);expect(dataView.getUint8(4)).toBe(2);expect(dataView.getUint32(5,true)).toBe(100);expect(dataView.getUint8(9)).toBe("d".charCodeAt(0));expect(dataView.getUint8(10)).toBe("e".charCodeAt(0));expect(dataView.getUint8(11)).toBe("f".charCodeAt(0));done()})})});suite("rb/utils/keyBindingUtils",function(){describe("KeyBindingsMixin",function(){var MyView,view;function sendKeyPress($el,keyCode,handled){var evt=jQuery.Event("keypress");evt.which=keyCode.charCodeAt(0);$el.trigger(evt);expect(evt.isDefaultPrevented()).toBe(handled);expect(evt.isPropagationStopped()).toBe(handled)}it("Registered on create",function(){MyView=Backbone.View.extend({keyBindings:{}});_.extend(MyView.prototype,RB.KeyBindingsMixin);spyOn(MyView.prototype,"delegateKeyBindings");view=new MyView;expect(MyView.prototype.delegateKeyBindings).toHaveBeenCalled()});it("Unregistered on undelegateEvents",function(){MyView=Backbone.View.extend({keyBindings:{}});_.extend(MyView.prototype,RB.KeyBindingsMixin);view=new MyView;spyOn(MyView.prototype,"undelegateKeyBindings");view.undelegateEvents();expect(MyView.prototype.undelegateKeyBindings).toHaveBeenCalled()});it("Keys to function name",function(){MyView=Backbone.View.extend({keyBindings:{abc:"myFunc1",def:"myFunc2"},myFunc1:function(){},myFunc2:function(){}});_.extend(MyView.prototype,RB.KeyBindingsMixin);view=new MyView;view.render().$el.appendTo($testsScratch);spyOn(view,"myFunc1");spyOn(view,"myFunc2");sendKeyPress(view.$el,"e",true);expect(view.myFunc1).not.toHaveBeenCalled();expect(view.myFunc2).toHaveBeenCalled()});it("Keys to function",function(){MyView=Backbone.View.extend({keyBindings:{abc:function(){},def:function(){}}});_.extend(MyView.prototype,RB.KeyBindingsMixin);view=new MyView;view.render().$el.appendTo($testsScratch);spyOn(view.keyBindings,"abc");spyOn(view.keyBindings,"def");sendKeyPress(view.$el,"b",true);expect(view.keyBindings.abc).toHaveBeenCalled();expect(view.keyBindings.def).not.toHaveBeenCalled()});it("Unmatched keys",function(){MyView=Backbone.View.extend({keyBindings:{abc:function(){},def:function(){}}});_.extend(MyView.prototype,RB.KeyBindingsMixin);view=new MyView;view.render().$el.appendTo($testsScratch);spyOn(view.keyBindings,"abc");spyOn(view.keyBindings,"def");sendKeyPress(view.$el,"!",false);expect(view.keyBindings.abc).not.toHaveBeenCalled();expect(view.keyBindings.def).not.toHaveBeenCalled()})})});"use strict";suite("rb/utils/linkifyUtils",function(){var bugTrackerURL="http://issues/?id=--bug_id--";describe("linkifyChildren",function(){it("URLs",function(){var $el=$("<p><span>http://example.com</span></p>");RB.LinkifyUtils.linkifyChildren($el[0]);var $span=$el.children("span");expect($span.length).toBe(1);var $a=$span.children("a");expect($a.length).toBe(1);expect($a.attr("target")).toBe("_blank");expect($a.attr("href")).toBe("http://example.com");expect($a.text()).toBe("http://example.com")});it("Bugs",function(){var $el=$("<p><span>Bug #123</span></p>");RB.LinkifyUtils.linkifyChildren($el[0],bugTrackerURL);var $span=$el.children("span");expect($span.length).toBe(1);var $a=$span.children("a");expect($a.length).toBe(1);expect($a.attr("target")).toBe("_blank");expect($a.attr("href")).toBe("http://issues/?id=123");expect($a.text()).toBe("Bug #123")});it("/r/ paths",function(){var $el=$("<p><span>/r/123/</span></p>");RB.LinkifyUtils.linkifyChildren($el[0]);var $span=$el.children("span");expect($span.length).toBe(1);var $a=$span.children("a");expect($a.length).toBe(1);expect($a.attr("target")).toBe("_blank");expect($a.attr("href")).toBe("/r/123/");expect($a.attr("class")).toBe("review-request-link");expect($a.text()).toBe("/r/123/")});it("Skips <a> elements",function(){var $el=$('<p><span><a href="http://example.com">/r/123</a>'+"</span></p>");RB.LinkifyUtils.linkifyChildren($el[0]);var $span=$el.children("span");expect($span.length).toBe(1);var $a=$span.children("a");expect($a.length).toBe(1);expect($a.attr("target")).toBe(undefined);expect($a.attr("href")).toBe("http://example.com");expect($a.text()).toBe("/r/123")});it("Skips <pre> elements",function(){var $el=$("<div><pre>/r/123</pre></div>");RB.LinkifyUtils.linkifyChildren($el[0]);expect($el.html()).toBe("<pre>/r/123</pre>")})});describe("linkifyText",function(){describe("URLs",function(){it("http://",function(){expect(RB.LinkifyUtils.linkifyText("http://example.com")).toBe('<a target="_blank" href="http://example.com">'+"http://example.com</a>")});it("https://",function(){expect(RB.LinkifyUtils.linkifyText("https://example.com")).toBe('<a target="_blank" href="https://example.com">'+"https://example.com</a>")});it("ftp://",function(){expect(RB.LinkifyUtils.linkifyText("ftp://example.com")).toBe('<a target="_blank" href="ftp://example.com">'+"ftp://example.com</a>")});it("ftps://",function(){expect(RB.LinkifyUtils.linkifyText("ftps://example.com")).toBe('<a target="_blank" href="ftps://example.com">'+"ftps://example.com</a>")});it("gopher://",function(){expect(RB.LinkifyUtils.linkifyText("gopher://example.com")).toBe('<a target="_blank" href="gopher://example.com">'+"gopher://example.com</a>")});it("mailto:",function(){expect(RB.LinkifyUtils.linkifyText("mailto:user@example.com")).toBe('<a target="_blank" href="mailto:user@example.com">'+"mailto:user@example.com</a>")});it("news:",function(){expect(RB.LinkifyUtils.linkifyText("news:example.com")).toBe('<a target="_blank" href="news:example.com">'+"news:example.com</a>")
});it("sms:",function(){expect(RB.LinkifyUtils.linkifyText("sms:example.com")).toBe('<a target="_blank" href="sms:example.com">'+"sms:example.com</a>")});it("javascript: (unlinked)",function(){expect(RB.LinkifyUtils.linkifyText("javascript:test")).toBe("javascript:test")});it("javascript:// (unlinked)",function(){expect(RB.LinkifyUtils.linkifyText("javascript://test")).toBe("javascript://test")});it("Trailing slashes",function(){expect(RB.LinkifyUtils.linkifyText("http://example.com/foo/")).toBe('<a target="_blank" href="http://example.com/foo/">'+"http://example.com/foo/</a>")});it("Anchors",function(){expect(RB.LinkifyUtils.linkifyText("http://example.com/#my-anchor")).toBe('<a target="_blank" href="'+'http://example.com/#my-anchor">'+"http://example.com/#my-anchor</a>")});it("Query strings",function(){expect(RB.LinkifyUtils.linkifyText("http://example.com/?a=b&c=d")).toBe('<a target="_blank" href="'+'http://example.com/?a=b&amp;c=d">'+"http://example.com/?a=b&amp;c=d</a>")});describe("Surrounded by",function(){it("(...)",function(){expect(RB.LinkifyUtils.linkifyText("(http://example.com/)")).toBe('(<a target="_blank" href="http://example.com/">'+"http://example.com/</a>)")});it("[...]",function(){expect(RB.LinkifyUtils.linkifyText("[http://example.com/]")).toBe('[<a target="_blank" href="http://example.com/">'+"http://example.com/</a>]")});it("{...}",function(){expect(RB.LinkifyUtils.linkifyText("{http://example.com/}")).toBe('{<a target="_blank" href="http://example.com/">'+"http://example.com/</a>}")});it("<...>",function(){expect(RB.LinkifyUtils.linkifyText("<http://example.com/>")).toBe('&lt;<a target="_blank" href="'+'http://example.com/">http://example.com/</a>&gt;')})})});describe("/r/ paths",function(){describe("Review requests",function(){it("/r/123",function(){expect(RB.LinkifyUtils.linkifyText("/r/123")).toBe('<a target="_blank" href="/r/123/" '+'class="review-request-link">/r/123</a>')});it("/r/123/",function(){expect(RB.LinkifyUtils.linkifyText("/r/123/")).toBe('<a target="_blank" href="/r/123/" '+'class="review-request-link">/r/123/</a>')})});describe("Diffs",function(){it("/r/123/diff",function(){expect(RB.LinkifyUtils.linkifyText("/r/123/diff")).toBe('<a target="_blank" href="/r/123/diff/" '+'class="review-request-link">/r/123/diff</a>')});it("/r/123/diff/",function(){expect(RB.LinkifyUtils.linkifyText("/r/123/diff/")).toBe('<a target="_blank" href="/r/123/diff/" '+'class="review-request-link">/r/123/diff/</a>')})})});describe("Surrounded by",function(){it("(...)",function(){expect(RB.LinkifyUtils.linkifyText("(/r/123/)")).toBe('(<a target="_blank" href="/r/123/" '+'class="review-request-link">/r/123/</a>)')});it("[...]",function(){expect(RB.LinkifyUtils.linkifyText("[/r/123/]")).toBe('[<a target="_blank" href="/r/123/" '+'class="review-request-link">/r/123/</a>]')});it("{...}",function(){expect(RB.LinkifyUtils.linkifyText("{/r/123/}")).toBe('{<a target="_blank" href="/r/123/" '+'class="review-request-link">/r/123/</a>}')});it("<...>",function(){expect(RB.LinkifyUtils.linkifyText("</r/123/>")).toBe('&lt;<a target="_blank" href="/r/123/" '+'class="review-request-link">/r/123/</a>&gt;')});it("text",function(){expect(RB.LinkifyUtils.linkifyText("foo/r/123/bar")).toBe("foo/r/123/bar")})})});describe("Bug References",function(){describe("With bugTrackerURL",function(){it("bug 123",function(){expect(RB.LinkifyUtils.linkifyText("bug 123",bugTrackerURL)).toBe('<a target="_blank" href="http://issues/?id=123">'+"bug 123</a>")});it("bug #123",function(){expect(RB.LinkifyUtils.linkifyText("bug #123",bugTrackerURL)).toBe('<a target="_blank" href="http://issues/?id=123">'+"bug #123</a>")});it("issue 123",function(){expect(RB.LinkifyUtils.linkifyText("issue 123",bugTrackerURL)).toBe('<a target="_blank" href="http://issues/?id=123">'+"issue 123</a>")});it("issue #123",function(){expect(RB.LinkifyUtils.linkifyText("issue #123",bugTrackerURL)).toBe('<a target="_blank" href="http://issues/?id=123">'+"issue #123</a>")});it("bug #abc",function(){expect(RB.LinkifyUtils.linkifyText("bug #abc",bugTrackerURL)).toBe('<a target="_blank" href="http://issues/?id=abc">'+"bug #abc</a>")});it("issue #abc",function(){expect(RB.LinkifyUtils.linkifyText("issue #abc",bugTrackerURL)).toBe('<a target="_blank" href="http://issues/?id=abc">'+"issue #abc</a>")});it("issue #abc, issue 2",function(){expect(RB.LinkifyUtils.linkifyText("issue #abc, issue 2",bugTrackerURL)).toBe('<a target="_blank" href="http://issues/?id=abc">'+'issue #abc</a>, <a target="_blank" '+'href="http://issues/?id=2">issue 2</a>')})});describe("Without bugTrackerURL",function(){it("bug 123",function(){expect(RB.LinkifyUtils.linkifyText("bug 123")).toBe("bug 123")});it("issue 123",function(){expect(RB.LinkifyUtils.linkifyText("issue 123")).toBe("issue 123")})})})});suite("rb/utils/urlUtils",function(){describe("getLocationHash",function(){var url="http://www.example.com/#<img/src/onerror=window.xss()>",hash=RB.getLocationHash(url),done;beforeEach(function(){done=false;window.xss=function(){}});afterEach(function(){if(window.hasOwnProperty("xss")){delete window.xss}});it("Prevents XSS injection",function(done){spyOn(window,"xss");$('a[name="'+hash+'"]');_.delay(function(){expect(window.xss).not.toHaveBeenCalled();done()})})})});suite("rb/views/CollectionView",function(){var TestModel,TestCollection,TestModelView,TestCollectionView,collection,view;TestModel=Backbone.Model.extend({defaults:_.defaults({data:""})});TestCollection=Backbone.Collection.extend({model:TestModel});TestModelView=Backbone.View.extend({className:"test-class",render:function(){this.$el.text(this.model.get("data"));return this}});TestCollectionView=RB.CollectionView.extend({itemViewType:TestModelView});beforeEach(function(){collection=new TestCollection;view=new TestCollectionView({collection:collection})});describe("Rendering",function(){it("When empty",function(){view.render();expect(view.$el.children().length).toBe(0)});it("With items",function(){var $children;collection.add([{data:"Item 1"},{data:"Item 2"}]);view.render();$children=view.$el.children();expect($children.length).toBe(2);expect($children[0].innerHTML).toBe("Item 1");expect($children[1].innerHTML).toBe("Item 2")});it("Item model type",function(){collection.add([{data:"Item 1"}]);view.render();expect(view.$el.children().hasClass("test-class")).toBe(true)})});describe("Live updating",function(){it("Adding items after rendering",function(){var $children;collection.add([{data:"Item 1"}]);view.render();expect(view.$el.children().length).toBe(1);collection.add([{data:"Item 2"},{data:"Item 3"}]);$children=view.$el.children();expect($children.length).toBe(3);expect($children[2].innerHTML).toBe("Item 3")});it("Removing items after rendering",function(){var model1=new TestModel({data:"Item 1"}),model2=new TestModel({data:"Item 2"}),model3=new TestModel({data:"Item 3"}),$children;collection.add([model1,model2,model3]);view.render();expect(view.$el.children().length).toBe(3);collection.remove([model1,model3]);$children=view.$el.children();expect($children.length).toBe(1);expect($children[0].innerHTML).toBe("Item 2")});it("Changing sort order",function(){var $children;collection.add([{data:"Item 2"},{data:"Item 3"},{data:"Item 1"}]);view.render();$children=view.$el.children();expect($children.length).toBe(3);expect($children[0].innerHTML).toBe("Item 2");expect($children[1].innerHTML).toBe("Item 3");expect($children[2].innerHTML).toBe("Item 1");collection.comparator="data";collection.sort();$children=view.$el.children();expect($children[0].innerHTML).toBe("Item 1");expect($children[1].innerHTML).toBe("Item 2");expect($children[2].innerHTML).toBe("Item 3")});it("When reset",function(){var $children;collection.add([{data:"Item 1"},{data:"Item 2"}]);view.render();$children=view.$el.children();expect($children.length).toBe(2);expect($children[0].innerHTML).toBe("Item 1");expect($children[1].innerHTML).toBe("Item 2");collection.reset([{data:"Item 3"},{data:"Item 4"},{data:"Item 5"}]);$children=view.$el.children();expect($children.length).toBe(3);expect($children[0].innerHTML).toBe("Item 3");expect($children[1].innerHTML).toBe("Item 4");expect($children[2].innerHTML).toBe("Item 5")})})});suite("rb/views/CommentDialogView",function(){var reviewRequestEditor,reviewRequest;beforeEach(function(){RB.DnDUploader.create();reviewRequest=new RB.ReviewRequest;reviewRequestEditor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest})});afterEach(function(){RB.DnDUploader.instance=null});describe("Class methods",function(){describe("create",function(){it("Without a comment",function(){expect(function(){RB.CommentDialogView.create({animate:false,container:$testsScratch,reviewRequestEditor:reviewRequestEditor})}).toThrow();expect(RB.CommentDialogView._instance).toBeFalsy();expect($testsScratch.children().length).toBe(0)});it("With a comment",function(){var dlg=RB.CommentDialogView.create({animate:false,comment:new RB.DiffComment,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect(dlg).toBeTruthy();expect(RB.CommentDialogView._instance).toBe(dlg);expect($testsScratch.children().length).toBe(1)});it("Replacing an open dialog",function(){var dlg1,dlg2;dlg1=RB.CommentDialogView.create({animate:false,comment:new RB.DiffComment,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect(dlg1).toBeTruthy();dlg2=RB.CommentDialogView.create({animate:false,comment:new RB.DiffComment,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect(dlg2).toBeTruthy();expect(dlg2).not.toBe(dlg1);expect(dlg1.$el.parents().length).toBe(0);expect(RB.CommentDialogView._instance).toBe(dlg2);expect($testsScratch.children().length).toBe(1)})})});describe("Instances",function(){var editor,dlg;beforeEach(function(){editor=new RB.CommentEditor({comment:new RB.DiffComment,canEdit:true,reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor});dlg=new RB.CommentDialogView({animate:false,model:editor,commentIssueManager:new RB.CommentIssueManager});dlg.on("closed",function(){dlg=null});dlg.render().$el.appendTo($testsScratch)});afterEach(function(){if(dlg){dlg.close()}});describe("Buttons",function(){beforeEach(function(){dlg.open()});describe("Cancel",function(){var $button;beforeEach(function(){$button=dlg.$el.find(".buttons .cancel")});it("Enabled",function(){expect($button.is(":disabled")).toBe(false)});it("Cancels editor when clicked",function(){spyOn(editor,"cancel");$button.click();expect(editor.cancel).toHaveBeenCalled()});it("Closes dialog when clicked",function(){spyOn(editor,"cancel");spyOn(dlg,"close");$button.click();expect(dlg.close).toHaveBeenCalled()});it("Confirms before cancelling unsaved comment",function(){spyOn(editor,"cancel");spyOn(dlg,"close");spyOn(window,"confirm").and.returnValue(true);editor.set("dirty",true);$button.click();expect(dlg.close).toHaveBeenCalled()});it("Cancel close when unsaved comment",function(){spyOn(editor,"cancel");spyOn(dlg,"close");spyOn(window,"confirm").and.returnValue(false);editor.set("dirty",true);$button.click();expect(dlg.close).not.toHaveBeenCalled()});describe("Visibility",function(){it("Shown when canEdit=true",function(){editor.set("canEdit",true);expect($button.is(":visible")).toBe(true)});it("Hidden when canEdit=false",function(){editor.set("canEdit",false);expect($button.is(":visible")).toBe(false)})})});describe("Close",function(){var $button;beforeEach(function(){$button=dlg.$el.find(".buttons .close")});it("Cancels editor when clicked",function(){spyOn(editor,"cancel");$button.click();expect(editor.cancel).toHaveBeenCalled()});it("Closes dialog when clicked",function(){spyOn(editor,"cancel");spyOn(dlg,"close");$button.click();expect(dlg.close).toHaveBeenCalled()});describe("Visibility",function(){it("Shown when canEdit=false",function(){editor.set("canEdit",false);expect($button.is(":visible")).toBe(true)});it("Hidden when canEdit=true",function(){editor.set("canEdit",true);expect($button.is(":visible")).toBe(false)})})});describe("Delete",function(){var $button;beforeEach(function(){$button=dlg.$el.find(".buttons .delete")});it("Cancels editor when clicked",function(){editor.set("canDelete",true);spyOn(editor,"deleteComment");$button.click();expect(editor.deleteComment).toHaveBeenCalled()});it("Closes dialog when clicked",function(){editor.set("canDelete",true);spyOn(editor,"deleteComment");spyOn(dlg,"close");$button.click();expect(dlg.close).toHaveBeenCalled()});describe("Enabled state",function(){it("Enabled when editor.canDelete=true",function(){editor.set("canDelete",true);expect($button.is(":disabled")).toBe(false)});it("Disabled when editor.canDelete=false",function(){editor.set("canDelete",false);expect($button.is(":disabled")).toBe(true)})});describe("Visibility",function(){it("Shown when canDelete=true",function(){editor.set("canDelete",true);expect($button.is(":visible")).toBe(true)});it("Hidden when caDelete=false",function(){editor.set("canDelete",false);expect($button.is(":visible")).toBe(false)})})});describe("Save",function(){var $button;beforeEach(function(){$button=dlg.$el.find(".buttons .save")});it("Cancels editor when clicked",function(){editor.set("canSave",true);spyOn(editor,"save");$button.click();expect(editor.save).toHaveBeenCalled()});it("Closes dialog when clicked",function(){editor.set("canSave",true);spyOn(editor,"save");spyOn(dlg,"close");$button.click();expect(dlg.close).toHaveBeenCalled()});describe("Enabled state",function(){it("Enabled when editor.canSave=true",function(){editor.set("canSave",true);expect($button.is(":disabled")).toBe(false)});it("Disabled when editor.canSave=false",function(){editor.set("canSave",false);expect($button.is(":disabled")).toBe(true)})});describe("Visibility",function(){it("Shown when canEdit=true",function(){editor.set("canEdit",true);expect($button.is(":visible")).toBe(true)});it("Hidden when canEdit=false",function(){editor.set("canEdit",false);expect($button.is(":visible")).toBe(false)})})})});describe("Fields",function(){beforeEach(function(){dlg.open()});describe("Open an Issue checkbox",function(){describe("Visibility",function(){it("Shown when canEdit=true",function(){editor.set("canEdit",true);expect(dlg._$issueOptions.is(":visible")).toBe(true)});it("Hidden when canEdit=false",function(){editor.set("canEdit",false);expect(dlg._$issueOptions.is(":visible")).toBe(false)})})});describe("Textbox",function(){describe("Visibility",function(){it("Shown when canEdit=true",function(){editor.set("canEdit",true);expect(dlg._textEditor.$el.is(":visible")).toBe(true)});it("Hidden when canEdit=false",function(){editor.set("canEdit",false);expect(dlg._textEditor.$el.is(":visible")).toBe(false)})})})});describe("Height",function(){beforeEach(function(){editor=new RB.CommentEditor({comment:new RB.DiffComment,reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor});dlg=new RB.CommentDialogView({animate:false,model:editor})});it("When canEdit=true",function(){editor.set("canEdit",true);dlg.render();dlg.open();expect(dlg.$el.height()).toBe(RB.CommentDialogView.prototype.DIALOG_TOTAL_HEIGHT)});it("When canEdit=false",function(){editor.set("canEdit",false);dlg.render();dlg.open();expect(dlg.$el.height()).toBe(RB.CommentDialogView.prototype.DIALOG_NON_EDITABLE_HEIGHT)})});describe("Other published comments list",function(){var $commentsList,$commentsPane;beforeEach(function(){$commentsPane=dlg.$el.find(".other-comments");$commentsList=$commentsPane.children("ul");expect($commentsList.length).toBe(1)});describe("Empty list",function(){it("Hidden pane",function(){expect($commentsPane.is(":visible")).toBe(false)})});describe("Populated list",function(){var comment,commentReply,parentCommentReplyLink;beforeEach(function(){comment=new RB.DiffComment;comment.user={name:"Test User"};comment.url="http://example.com/";comment.comment_id=1;comment.text="Sample comment.";comment.issue_opened=false;parentCommentReplyLink="/?reply_id="+comment.comment_id;commentReply=new RB.DiffComment;commentReply.user={name:"Test User"};commentReply.url="http://example.com/";commentReply.comment_id=2;commentReply.text="Sample comment.";commentReply.issue_opened=false;commentReply.reply_to_id=1});describe("Visible pane",function(){it("Setting list before opening dialog",function(){editor.set("publishedComments",[comment]);dlg.open();expect($commentsPane.is(":visible")).toBe(true)});it("Setting list after opening dialog",function(){dlg.open();editor.set("publishedComments",[comment]);expect($commentsPane.is(":visible")).toBe(true)})});it("List items added",function(){dlg.open();editor.set("publishedComments",[comment]);expect($commentsList.children().length).toBe(1)});it("Parent comment reply link links to itself",function(){var $replyLink;editor.set("publishedComments",[comment]);dlg.open();$replyLink=$commentsList.find(".comment-list-reply-action");expect($replyLink[0].href).toContain(parentCommentReplyLink)});it("Both parent and reply comment reply links link to parent comment",function(){var $replyLinks;editor.set("publishedComments",[comment,commentReply]);dlg.open();$replyLinks=$commentsList.find(".comment-list-reply-action");expect($replyLinks.length).toEqual(2);expect($replyLinks[0].href).toContain(parentCommentReplyLink);expect($replyLinks[1].href).toContain(parentCommentReplyLink)})});describe("Issue bar buttons",function(){var comment;beforeEach(function(){comment=new RB.DiffComment;comment.user={name:"Test User"};comment.url="http://example.com/";comment.comment_id=1;comment.text="Sample comment.";comment.issue_opened=true;comment.issue_status="open"});it("When interactive",function(){var $buttons;reviewRequestEditor.set("editable",true);editor.set("publishedComments",[comment]);dlg=new RB.CommentDialogView({animate:false,model:editor,commentIssueManager:new RB.CommentIssueManager});dlg.render().$el.appendTo($testsScratch);dlg.open();$buttons=dlg.$el.find(".other-comments .issue-button");expect($buttons.length).toBe(5);expect($buttons.is(":visible")).toBe(true)});it("When not interactive",function(){var $buttons;reviewRequestEditor.set("editable",false);editor.set("publishedComments",[comment]);dlg=new RB.CommentDialogView({animate:false,model:editor,commentIssueManager:new RB.CommentIssueManager});dlg.render().$el.appendTo($testsScratch);dlg.open();$buttons=dlg.$el.find(".other-comments .issue-button");expect($buttons.length).toBe(0)})})});describe("Methods",function(){describe("close",function(){it("Editor state",function(){dlg.open();expect(editor.get("editing")).toBe(true);dlg.close();expect(editor.get("editing")).toBe(false)});it("Dialog removed",function(){dlg.open();spyOn(dlg,"trigger");dlg.close();expect(dlg.trigger).toHaveBeenCalledWith("closed");expect(dlg.$el.parents().length).toBe(0);expect($testsScratch.children().length).toBe(0)})});describe("open",function(){it("Editor state",function(){expect(editor.get("editing")).toBe(false);dlg.open();expect(editor.get("editing")).toBe(true)});it("Visibility",function(){expect(dlg.$el.is(":visible")).toBe(false);dlg.open();expect(dlg.$el.is(":visible")).toBe(true)});it("Default focus",function(){var $textarea=dlg.$el.find("textarea");expect($textarea.is(":focus")).toBe(false);spyOn($textarea[0],"focus");dlg.open();expect($textarea[0].focus).toHaveBeenCalled()})})});describe("Special keys",function(){var $textarea;function simulateKeyPress(c,altKey,ctrlKey,metaKey){var e;$textarea.focus();_.each(["keydown","keypress","keyup"],function(type){e=$.Event(type);e.which=c;e.altKey=altKey;e.ctrlKey=ctrlKey;e.metaKey=metaKey;$textarea.trigger(e)})}function setupForRichText(richText,canSave){editor.set("richText",richText);editor.set("canSave",!!canSave);$textarea=dlg.$("textarea")}beforeEach(function(){dlg.open();$textarea=dlg.$("textarea")});describe("Control-Enter to save",function(){beforeEach(function(){spyOn(editor,"save");spyOn(dlg,"close")});describe("With editor.canSave=true",function(){describe("Keycode 10",function(){it("If Markdown",function(){setupForRichText(true,true);simulateKeyPress(10,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false,true);simulateKeyPress(10,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()})});describe("Keycode 13",function(){it("If Markdown",function(){setupForRichText(true,true);simulateKeyPress(13,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false,true);simulateKeyPress(13,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()})})});describe("With editor.canSave=false",function(){beforeEach(function(){editor.set("canSave",false)});describe("Keycode 10",function(){it("If Markdown",function(){setupForRichText(true);simulateKeyPress(10,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false);simulateKeyPress(10,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()})});describe("Keycode 13",function(){it("If Markdown",function(){setupForRichText(true);simulateKeyPress(13,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false);simulateKeyPress(13,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()})})})});describe("Command-Enter to save",function(){beforeEach(function(){spyOn(editor,"save");spyOn(dlg,"close")});describe("With editor.canSave=true",function(){describe("Keycode 10",function(){it("If Markdown",function(){setupForRichText(true,true);simulateKeyPress(10,false,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false,true);simulateKeyPress(10,false,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()})});describe("Keycode 13",function(){it("If Markdown",function(){setupForRichText(true,true);simulateKeyPress(13,false,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false,true);simulateKeyPress(13,false,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()})})});describe("With editor.canSave=false",function(){beforeEach(function(){editor.set("canSave",false)});describe("Keycode 10",function(){it("If Markdown",function(){setupForRichText(true);simulateKeyPress(10,false,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false);simulateKeyPress(10,false,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()})});describe("Keycode 13",function(){it("If Markdown",function(){setupForRichText(true);simulateKeyPress(13,false,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false);simulateKeyPress(13,false,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()})})})});describe("Escape to cancel",function(){describe("Pressing escape in text area",function(){beforeEach(function(){spyOn(editor,"cancel");spyOn(dlg,"close")});it("If Markdown",function(){spyOn(window,"confirm").and.returnValue(true);setupForRichText(true);simulateKeyPress($.ui.keyCode.ESCAPE,false,false);expect(editor.cancel).toHaveBeenCalled();expect(window.confirm).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false);simulateKeyPress($.ui.keyCode.ESCAPE,false,false);expect(editor.cancel).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()});it("If unsaved comment",function(){spyOn(window,"confirm").and.returnValue(true);editor.set("dirty",true);simulateKeyPress($.ui.keyCode.ESCAPE,false,false);expect(editor.cancel).toHaveBeenCalled();expect(window.confirm).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()});it("If unsaved comment, do not close",function(){spyOn(window,"confirm").and.returnValue(false);editor.set("dirty",true);simulateKeyPress($.ui.keyCode.ESCAPE,false,false);expect(editor.cancel).not.toHaveBeenCalled();expect(window.confirm).toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()})})});describe("Toggle open issue",function(){var $checkbox;function runToggleIssueTest(richText,startState,keyCode){setupForRichText(richText);$checkbox.prop("checked",startState);editor.set("openIssue",startState);simulateKeyPress(keyCode.charCodeAt(0),true,false);expect($checkbox.prop("checked")).toBe(!startState);expect(editor.get("openIssue")).toBe(!startState);expect($textarea.val()).toBe("")}beforeEach(function(){$checkbox=dlg.$el.find("input[type=checkbox]")});describe("Alt-I",function(){describe("Checked to unchecked",function(){it("If Markdown",function(){runToggleIssueTest(true,true,"I")});it("If Markdown",function(){runToggleIssueTest(false,true,"I")})});describe("Unchecked to checked",function(){it("If Markdown",function(){runToggleIssueTest(true,false,"I")});it("If plain text",function(){runToggleIssueTest(false,false,"I")})})});describe("Alt-i",function(){describe("Checked to unchecked",function(){it("If Markdown",function(){runToggleIssueTest(true,true,"i")});it("If plain text",function(){runToggleIssueTest(false,true,"i")})});describe("Unchecked to checked",function(){it("If Markdown",function(){runToggleIssueTest(true,false,"i")});it("If plain text",function(){runToggleIssueTest(false,false,"i")})})})})});describe("Title text",function(){var $title;beforeEach(function(){dlg.open();$title=dlg.$el.find("form .title")});it("Default state",function(){expect($title.text()).toBe("Your comment")});it("Setting dirty=true",function(){editor.set("dirty",true);expect($title.text()).toBe("Your comment (unsaved)")});it("Setting dirty=false",function(){editor.set("dirty",true);editor.set("dirty",false);expect($title.text()).toBe("Your comment")})});describe("State synchronization",function(){describe("Comment text",function(){var $textarea;beforeEach(function(){dlg.open();$textarea=$(dlg._textEditor.$("textarea"))});describe("Dialog to editor",function(){var text="foo";beforeEach(function(done){var i,c,e,t;dlg._textEditor.on("change",function(){changed=true});$textarea.focus();for(i=0;i<text.length;i++){c=text.charCodeAt(i);e=$.Event("keydown");e.which=c;$textarea.trigger(e);e=$.Event("keypress");e.which=c;$textarea.trigger(e);dlg._textEditor.setText(dlg._textEditor.getText()+text[i]);e=$.Event("keyup");e.which=c;$textarea.trigger(e)}t=setInterval(function(){if(dlg._textEditor.getText()===text){clearInterval(t);done()}},100)});it("",function(){expect(editor.get("text")).toEqual(text)})});it("Editor to dialog",function(){var text="bar";editor.set("text",text);expect(dlg._textEditor.getText()).toEqual(text)})});describe("Open Issue checkbox",function(){var $checkbox;beforeEach(function(){dlg.open();$checkbox=dlg.$("#comment_issue");$checkbox.prop("checked",false);editor.set("openIssue",false)});it("Dialog to editor",function(){$checkbox.click();expect(editor.get("openIssue")).toBe(true)});it("Editor to dialog",function(){editor.set("openIssue",true);expect($checkbox.prop("checked")).toBe(true)})});describe("Enable Markdown checkbox",function(){var $checkbox;beforeEach(function(){dlg.open();$checkbox=dlg.$("#enable_markdown");$checkbox.prop("checked",false);editor.set("richText",false);expect(dlg._textEditor.richText).toBe(false)});it("Dialog to editor",function(){$checkbox.click();expect(editor.get("richText")).toBe(true);expect(dlg._textEditor.richText).toBe(true)});it("Editor to dialog",function(){editor.set("richText",true);expect($checkbox.prop("checked")).toBe(true);expect(dlg._textEditor.richText).toBe(true)})})});describe("User preference defaults",function(){describe("Open Issue checkbox",function(){it("When commentsOpenAnIssue is true",function(){RB.UserSession.instance.set("commentsOpenAnIssue",true);editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();$checkbox=dlg.$("#comment_issue");expect(editor.get("openIssue")).toBe(true);expect($checkbox.prop("checked")).toBe(true)});it("When commentsOpenAnIssue is false",function(){RB.UserSession.instance.set("commentsOpenAnIssue",false);editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();$checkbox=dlg.$("#comment_issue");expect(editor.get("openIssue")).toBe(false);expect($checkbox.prop("checked")).toBe(false)})});describe("Enable Markdown checkbox",function(){describe("When defaultUseRichText is true",function(){beforeEach(function(){RB.UserSession.instance.set("defaultUseRichText",true)});it("New comment",function(){editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();$checkbox=dlg.$("#enable_markdown");expect(editor.get("richText")).toBe(true);expect($checkbox.prop("checked")).toBe(true);expect(dlg._textEditor.richText).toBe(true)});it("Existing comment with richText=true",function(){editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor,comment:new RB.DiffComment({richText:true})});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();$checkbox=dlg.$("#enable_markdown");expect(editor.get("richText")).toBe(true);expect($checkbox.prop("checked")).toBe(true);expect(dlg._textEditor.richText).toBe(true)});it("Existing comment with richText=false",function(){editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor,comment:new RB.DiffComment({richText:false})});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();$checkbox=dlg.$("#enable_markdown");expect(editor.get("richText")).toBe(true);expect($checkbox.prop("checked")).toBe(true);expect(dlg._textEditor.richText).toBe(true)})});describe("When defaultUseRichText is false",function(){beforeEach(function(){RB.UserSession.instance.set("defaultUseRichText",false)});it("New comment",function(){editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();$checkbox=dlg.$("#enable_markdown");expect(editor.get("richText")).toBe(false);expect($checkbox.prop("checked")).toBe(false);expect(dlg._textEditor.richText).toBe(false)});it("Existing comment with richText=true",function(){editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor,comment:new RB.DiffComment({richText:true})});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();$checkbox=dlg.$("#enable_markdown");expect(editor.get("richText")).toBe(true);expect($checkbox.prop("checked")).toBe(true);expect(dlg._textEditor.richText).toBe(true)});it("Existing comment with richText=false",function(){editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor,comment:new RB.DiffComment({richText:false})});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();$checkbox=dlg.$("#enable_markdown");expect(editor.get("richText")).toBe(false);expect($checkbox.prop("checked")).toBe(false);expect(dlg._textEditor.richText).toBe(false)})})})});describe("Logged Out indicator",function(){it("When logged in",function(){RB.UserSession.instance.set("authenticated",true);dlg=new RB.CommentDialogView({animate:false,model:new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor})});dlg.render();expect(dlg.$el.find('p[class="login-text"]').length).toBe(0)
});it("When logged out",function(){RB.UserSession.instance.set("authenticated",false);dlg=new RB.CommentDialogView({animate:false,model:new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor})});dlg.render();expect(dlg.$el.find('p[class="login-text"]').length).toBe(1)})});describe("In Draft indicator",function(){it("Shown when hasDraft=true",function(){reviewRequest.set("hasDraft",true);dlg=new RB.CommentDialogView({animate:false,model:new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor})});dlg.render();expect(dlg.$el.find('p[class="draft-warning"]').length).toBe(1)});it("Hidden when hasDraft=false",function(){reviewRequest.set("hasDraft",false);dlg=new RB.CommentDialogView({animate:false,model:new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor})});dlg.render();expect(dlg.$el.find('p[class="draft-warning"]').length).toBe(0)})})})});suite("rb/views/CommentIssueBarView",function(){var commentIssueManager,view,$dropButton,$reopenButton,$fixedButton,$verifyFixedButton,$verifyDroppedButton;beforeEach(function(){commentIssueManager=new RB.CommentIssueManager({reviewRequest:new RB.ReviewRequest});view=new RB.CommentIssueBarView({commentIssueManager:commentIssueManager,issueStatus:"open",reviewID:1,commentID:2,commentType:"diff_comments",interactive:true,canVerify:true});view.render().$el.appendTo($testsScratch);$dropButton=view._$buttons.filter(".drop");$reopenButton=view._$buttons.filter(".reopen");$fixedButton=view._$buttons.filter(".resolve");$verifyFixedButton=view._$buttons.filter(".verify-resolved");$verifyDroppedButton=view._$buttons.filter(".verify-dropped")});describe("Actions",function(){var comment;beforeEach(function(){spyOn(commentIssueManager,"setCommentState");expect(view._$buttons.prop("disabled")).toBe(false);comment=commentIssueManager.getComment(1,2,"diff_comments");spyOn(comment,"ready").and.callFake(function(options){if(_.isFunction(options.ready)){options.ready.call(comment)}});spyOn(comment,"getAuthorUsername").and.callFake(function(){return"doc"})});it("Resolving as fixed",function(){$fixedButton.click();expect(view._$buttons.prop("disabled")).toBe(true);expect(commentIssueManager.setCommentState).toHaveBeenCalledWith(1,2,"diff_comments","resolved")});it("Dropping",function(){$dropButton.click();expect(view._$buttons.prop("disabled")).toBe(true);expect(commentIssueManager.setCommentState).toHaveBeenCalledWith(1,2,"diff_comments","dropped")});it("Re-opening",function(){view._showStatus(RB.BaseComment.STATE_RESOLVED);$reopenButton.click();expect(view._$buttons.prop("disabled")).toBe(true);expect(commentIssueManager.setCommentState).toHaveBeenCalledWith(1,2,"diff_comments","open")});it("Resolving with verification",function(){comment.get("extraData").require_verification=true;$fixedButton.click();expect(view._$buttons.prop("disabled")).toBe(true);expect(commentIssueManager.setCommentState).toHaveBeenCalledWith(1,2,"diff_comments","verifying-resolved")});it("Dropping with verification",function(){comment.get("extraData").require_verification=true;$dropButton.click();expect(view._$buttons.prop("disabled")).toBe(true);expect(commentIssueManager.setCommentState).toHaveBeenCalledWith(1,2,"diff_comments","verifying-dropped")})});describe("Event handling",function(){describe("CommentIssueManager.issueStatusUpdated",function(){beforeEach(function(){spyOn(view,"_showStatus")});it("When comment updated",function(){var comment=new RB.DiffComment({id:2,issueStatus:"resolved"});commentIssueManager.trigger("issueStatusUpdated",comment);expect(view._showStatus).toHaveBeenCalledWith("resolved")});it("When different comment updated",function(){var comment=new RB.DiffComment({id:10,issueStatus:"resolved"});commentIssueManager.trigger("issueStatusUpdated",comment);expect(view._showStatus).not.toHaveBeenCalled()})})});describe("Issue states",function(){describe("Open",function(){beforeEach(function(){view._showStatus(RB.BaseComment.STATE_OPEN)});it("CSS class",function(){expect(view._$state.hasClass("open")).toBe(true);expect(view._$state.hasClass("resolved")).toBe(false);expect(view._$state.hasClass("dropped")).toBe(false);expect(view._$state.hasClass("verifying-resolved")).toBe(false);expect(view._$state.hasClass("verifying-dropped")).toBe(false)});it("Text",function(){expect(view._$message.text()).toBe("An issue was opened.")});describe("Button visibility",function(){it('"Drop" shown',function(){expect($dropButton.is(":visible")).toBe(true)});it('"Fixed" shown',function(){expect($fixedButton.is(":visible")).toBe(true)});it('"Re-open" hidden',function(){expect($reopenButton.is(":visible")).toBe(false)});it('"Verify Fixed" hidden',function(){expect($verifyFixedButton.is(":visible")).toBe(false)});it('"Verify Dropped" hidden',function(){expect($verifyDroppedButton.is(":visible")).toBe(false)})})});describe("Fixed",function(){beforeEach(function(){view._showStatus(RB.BaseComment.STATE_RESOLVED)});it("CSS class",function(){expect(view._$state.hasClass("open")).toBe(false);expect(view._$state.hasClass("resolved")).toBe(true);expect(view._$state.hasClass("dropped")).toBe(false);expect(view._$state.hasClass("verifying-resolved")).toBe(false);expect(view._$state.hasClass("verifying-dropped")).toBe(false)});it("Text",function(){expect(view._$message.text()).toBe("The issue has been resolved.")});describe("Button visibility",function(){it('"Drop" hidden',function(){expect($dropButton.is(":visible")).toBe(false)});it('"Fixed" hidden',function(){expect($fixedButton.is(":visible")).toBe(false)});it('"Re-open" shown',function(){expect($reopenButton.is(":visible")).toBe(true)});it('"Verify Fixed" hidden',function(){expect($verifyFixedButton.is(":visible")).toBe(false)});it('"Verify Dropped" hidden',function(){expect($verifyDroppedButton.is(":visible")).toBe(false)})})});describe("Dropped",function(){beforeEach(function(){view._showStatus(RB.BaseComment.STATE_DROPPED)});it("CSS class",function(){expect(view._$state.hasClass("open")).toBe(false);expect(view._$state.hasClass("resolved")).toBe(false);expect(view._$state.hasClass("dropped")).toBe(true);expect(view._$state.hasClass("verifying-resolved")).toBe(false);expect(view._$state.hasClass("verifying-dropped")).toBe(false)});it("Text",function(){expect(view._$message.text()).toBe("The issue has been dropped.")});describe("Button visibility",function(){it('"Drop" hidden',function(){expect($dropButton.is(":visible")).toBe(false)});it('"Fixed" hidden',function(){expect($fixedButton.is(":visible")).toBe(false)});it('"Re-open" shown',function(){expect($reopenButton.is(":visible")).toBe(true)});it('"Verify Fixed" hidden',function(){expect($verifyFixedButton.is(":visible")).toBe(false)});it('"Verify Dropped" hidden',function(){expect($verifyDroppedButton.is(":visible")).toBe(false)})})});describe("Verifying Fixed",function(){beforeEach(function(){view._showStatus(RB.BaseComment.STATE_VERIFYING_RESOLVED)});it("CSS class",function(){expect(view._$state.hasClass("open")).toBe(false);expect(view._$state.hasClass("resolved")).toBe(false);expect(view._$state.hasClass("dropped")).toBe(false);expect(view._$state.hasClass("verifying-resolved")).toBe(true);expect(view._$state.hasClass("verifying-dropped")).toBe(false)});it("Text",function(){expect(view._$message.text()).toBe("Waiting for verification before resolving...")});describe("Button visibility",function(){it('"Drop" hidden',function(){expect($dropButton.is(":visible")).toBe(false)});it('"Fixed" hidden',function(){expect($fixedButton.is(":visible")).toBe(false)});it('"Re-open" shown',function(){expect($reopenButton.is(":visible")).toBe(true)});it('"Verify Fixed" shown',function(){expect($verifyFixedButton.is(":visible")).toBe(true)});it('"Verify Dropped" hidden',function(){expect($verifyDroppedButton.is(":visible")).toBe(false)})})});describe("Verifying Dropped",function(){beforeEach(function(){view._showStatus(RB.BaseComment.STATE_VERIFYING_DROPPED)});it("CSS class",function(){expect(view._$state.hasClass("open")).toBe(false);expect(view._$state.hasClass("resolved")).toBe(false);expect(view._$state.hasClass("dropped")).toBe(false);expect(view._$state.hasClass("verifying-resolved")).toBe(false);expect(view._$state.hasClass("verifying-dropped")).toBe(true)});it("Text",function(){expect(view._$message.text()).toBe("Waiting for verification before dropping...")});describe("Button visibility",function(){it('"Drop" hidden',function(){expect($dropButton.is(":visible")).toBe(false)});it('"Fixed" hidden',function(){expect($fixedButton.is(":visible")).toBe(false)});it('"Re-open" shown',function(){expect($reopenButton.is(":visible")).toBe(true)});it('"Verify Fixed" hidden',function(){expect($verifyFixedButton.is(":visible")).toBe(false)});it('"Verify Dropped" shown',function(){expect($verifyDroppedButton.is(":visible")).toBe(true)})})})})});"use strict";suite("rb/views/DiffFragmentQueueView",function(){var URL_PREFIX="/r/123/_fragments/diff-comments/";var fragmentQueue=void 0;beforeEach(function(){fragmentQueue=new RB.DiffFragmentQueueView({containerPrefix:"container1",reviewRequestPath:"/r/123/",queueName:"diff_fragments"})});describe("Diff fragment loading",function(){var $container1=void 0;var $container2=void 0;var $container3=void 0;var $container4=void 0;beforeEach(function(){$container1=$('<div id="container1_123"/>').appendTo(window.$testsScratch);$container2=$('<div id="container1_124"/>').appendTo(window.$testsScratch);$container3=$('<div id="container1_125"/>').appendTo(window.$testsScratch);$container4=$('<div id="container1_126"/>').appendTo(window.$testsScratch);fragmentQueue.queueLoad("123","key1");fragmentQueue.queueLoad("124","key1");fragmentQueue.queueLoad("125","key1");fragmentQueue.queueLoad("126","key2")});it("Fragment queueing",function(){var queue=fragmentQueue._queue;expect(queue.length).not.toBe(0);expect(queue.key1.length).toBe(3);expect(queue.key1).toContain({commentID:"123",onFragmentRendered:null});expect(queue.key1).toContain({commentID:"124",onFragmentRendered:null});expect(queue.key1).toContain({commentID:"125",onFragmentRendered:null});expect(queue.key2.length).toBe(1);expect(queue.key2).toContain({commentID:"126",onFragmentRendered:null})});it("Batch loading",function(done){spyOn($,"ajax").and.callFake(function(options){expect(options.dataType).toBe("arraybuffer");var url=options.url;var blob=void 0;if(url===URL_PREFIX+"123,124,125/"){var html1=new Blob(["<span>Comment one</span>"]);var html2=new Blob(["<span>Comment two</span>"]);var html3=new Blob(["<span>Comment three</span>"]);blob=RB.DataUtils.buildBlob([[{type:"uint32",values:[123,html1.size]}],html1,[{type:"uint32",values:[124,html2.size]}],html2,[{type:"uint32",values:[125,html3.size]}],html3])}else if(url===URL_PREFIX+"126/"){var html=new Blob(["<span>Comment 4</span>"]);blob=RB.DataUtils.buildBlob([[{type:"uint32",values:[126,html.size]}],html])}else{fail("Unexpected URL "+url);return}RB.DataUtils.readBlobAsArrayBuffer(blob,options.success)});fragmentQueue.loadFragments(function(){expect($.ajax.calls.count()).toBe(2);expect($container1.data("diff-fragment-view")).toBeTruthy();expect($container1.html()).toBe("<span>Comment one</span>");expect($container2.data("diff-fragment-view")).toBeTruthy();expect($container2.html()).toBe("<span>Comment two</span>");expect($container3.data("diff-fragment-view")).toBeTruthy();expect($container3.html()).toBe("<span>Comment three</span>");expect($container4.data("diff-fragment-view")).toBeTruthy();expect($container4.html()).toBe("<span>Comment 4</span>");done()})});it("With Unicode content",function(done){spyOn($,"ajax").and.callFake(function(options){expect(options.dataType).toBe("arraybuffer");var url=options.url;var arrayBuffer=void 0;if(url===URL_PREFIX+"123,124,125/"){var html1=[60,115,112,97,110,62,195,161,195,169,195,173,195,179,195,186,32,240,159,148,165,60,47,115,112,97,110,62];var html2=[60,115,112,97,110,62,195,132,195,139,195,143,195,150,195,156,197,184,32,240,159,152,177,60,47,115,112,97,110,62];var html3=[60,115,112,97,110,62,240,159,148,165,240,159,152,177,60,47,115,112,97,110,62];expect(html1.length).toBe(28);expect(html2.length).toBe(30);expect(html3.length).toBe(21);arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"uint32",values:[123,html1.length]},{type:"uint8",values:html1},{type:"uint32",values:[124,html2.length]},{type:"uint8",values:html2},{type:"uint32",values:[125,html3.length]},{type:"uint8",values:html3}])}else if(url===URL_PREFIX+"126/"){var html=[60,115,112,97,110,62,196,128,196,146,196,170,197,140,32,240,159,145,191,60,47,115,112,97,110,62];expect(html.length).toBe(26);arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"uint32",values:[126,html.length]},{type:"uint8",values:html}])}else{fail("Unexpected URL "+url);return}options.success(arrayBuffer)});fragmentQueue.loadFragments(function(){expect($.ajax.calls.count()).toBe(2);expect($container1.data("diff-fragment-view")).toBeTruthy();expect($container1.html()).toBe("<span>áéíóú 🔥</span>");expect($container2.data("diff-fragment-view")).toBeTruthy();expect($container2.html()).toBe("<span>ÄËÏÖÜŸ 😱</span>");expect($container3.data("diff-fragment-view")).toBeTruthy();expect($container3.html()).toBe("<span>🔥😱</span>");expect($container4.data("diff-fragment-view")).toBeTruthy();expect($container4.html()).toBe("<span>ĀĒĪŌ 👿</span>");done()})});it("With saved fragments",function(done){spyOn($,"ajax").and.callFake(function(options){expect(options.dataType).toBe("arraybuffer");var url=options.url;var blob=void 0;if(url===URL_PREFIX+"124/"){var html=new Blob(["<span>New comment 2</span>"]);blob=RB.DataUtils.buildBlob([[{type:"uint32",values:[124,html.size]}],html])}else if(url===URL_PREFIX+"126/"){var _html=new Blob(["<span>New comment 4</span>"]);blob=RB.DataUtils.buildBlob([[{type:"uint32",values:[126,_html.size]}],_html])}else{fail("Unexpected URL "+url);return}RB.DataUtils.readBlobAsArrayBuffer(blob,options.success)});var view1=new RB.DiffFragmentView;$container1.html("<span>Comment 1</span>").data("diff-fragment-view",view1);var view2=new RB.DiffFragmentView;$container2.html("<span>Comment 2</span>").data("diff-fragment-view",view2);var view3=new RB.DiffFragmentView;$container3.html("<span>Comment 3</span>").data("diff-fragment-view",view3);fragmentQueue.saveFragment("123");fragmentQueue.saveFragment("125");fragmentQueue.saveFragment("126");$container3.removeData("diff-fragment-view");fragmentQueue.loadFragments(function(){expect($.ajax.calls.count()).toBe(2);expect($container1.data("diff-fragment-view")).toBe(view1);expect($container1.html()).toBe("<span>Comment 1</span>");expect($container2.data("diff-fragment-view")).toBe(view2);expect($container2.html()).toBe("<span>New comment 2</span>");expect($container3.data("diff-fragment-view")).toBeTruthy();expect($container3.data("diff-fragment-view")).not.toBe(view3);expect($container3.html()).toBe("<span>Comment 3</span>");expect($container4.data("diff-fragment-view")).toBeTruthy();expect($container4.html()).toBe("<span>New comment 4</span>");expect(fragmentQueue._saved).toEqual({});done()})})})});"use strict";suite("rb/views/DiffFragmentView",function(){var fragmentTemplate=_.template('<table>\n <thead>\n </thead>\n <tbody class="diff-header diff-header-above">\n  <tr>\n   <td>\n    <div>\n     <a href="#" class="diff-expand-btn"\n        data-lines-of-context="20,0"></a>\n    </div>\n   </td>\n  </tr>\n </tbody>\n <tbody class="insert"></tbody>\n <tbody class="insert">\n  <tr>\n   <td>\n    <div class="diff-collapse-btn" data-lines-of-context="0,0"></div>\n   </td>\n  </tr>\n </tbody>\n <tbody class="diff-header diff-header-below">\n  <tr>\n   <td>\n    <div>\n     <a href="#" class="diff-expand-btn"\n        data-lines-of-context="0,20"></a>\n    </div>\n   </td>\n  </tr>\n </tbody>\n</table>');var view=void 0;var loadDiff=void 0;beforeEach(function(){loadDiff=jasmine.createSpy("loadDiff");view=new RB.DiffFragmentView({loadDiff:loadDiff,collapsible:true});view.$el.html(fragmentTemplate());$testsScratch.append(view.$el);spyOn(_,"defer").and.callFake(function(cb){return cb()});spyOn(_,"delay").and.callFake(function(cb){return cb()})});describe("render",function(){it("With visible and collapsible === true",function(){view.render();expect(view.$el.hasClass("allow-transitions")).toBe(true);expect(view._$table.hasClass("expanded")).toBe(false);expect(view._$table.hasClass("collapsed")).toBe(true);expect(view._$thead.css("transform")).not.toBe("none");_.each(view._$diffHeaders,function(headerEl){expect($(headerEl).css("transform")).not.toBe("none")})});it("With hidden and collapsible === true",function(){view.$el.hide();view.render();expect(view.$el.hasClass("allow-transitions")).toBe(true);expect(view._$table.hasClass("expanded")).toBe(true);expect(view._$table.hasClass("collapsed")).toBe(false);expect(view._$thead.css("transform")).toBe("none");_.each(view._$diffHeaders,function(headerEl){expect($(headerEl).css("transform")).toBe("none")})});it("With collapsible === false",function(){view._collapsible=false;view.render();expect(view.$el.hasClass("allow-transitions")).toBe(false);expect(view._$table.hasClass("expanded")).toBe(true);expect(view._$table.hasClass("collapsed")).toBe(false);expect(view._$thead.css("transform")).toBe("none");_.each(view._$diffHeaders,function(headerEl){expect($(headerEl).css("transform")).toBe("none")})})});describe("Events",function(){it("click expansion button",function(){view.render();view.$(".diff-expand-btn").eq(0).click();expect(loadDiff).toHaveBeenCalled();expect(loadDiff.calls.mostRecent().args[0].linesOfContext).toBe("20,0")});it("click collapse button",function(){view.render();view.$(".diff-collapse-btn").eq(0).click();expect(loadDiff).toHaveBeenCalled();expect(loadDiff.calls.mostRecent().args[0].linesOfContext).toBe("0,0")});describe("mouseenter",function(){it("With collapsible === true",function(){view.render();spyOn(view.$el,"is").and.callFake(function(sel){expect(sel).toBe(":hover");return true});view.$el.trigger("mouseenter");expect(view._$table.hasClass("collapsed")).toBe(false);expect(view._$table.hasClass("expanded")).toBe(true);expect(view._$thead.css("transform")).toBe("none");_.each(view._$diffHeaders,function(headerEl){expect($(headerEl).css("transform")).toBe("none")})});it("With collapsible === false",function(){view._collapsible=false;view.render();spyOn(view.$el,"is").and.callFake(function(sel){expect(sel).toBe(":hover");return true});view.$el.trigger("mouseenter");expect(view._$table.hasClass("collapsed")).toBe(false);expect(view._$table.hasClass("expanded")).toBe(true);expect(view._$thead.css("transform")).toBe("none");_.each(view._$diffHeaders,function(headerEl){expect($(headerEl).css("transform")).toBe("none")})})});describe("mouseleave",function(){it("With collapsible === true",function(){var isHovering=true;view.render();spyOn(view.$el,"is").and.callFake(function(sel){expect(sel).toBe(":hover");return isHovering});view.$el.trigger("mouseenter");isHovering=false;view.$el.trigger("mouseleave");expect(view._$table.hasClass("collapsed")).toBe(true);expect(view._$table.hasClass("expanded")).toBe(false);expect(view._$thead.css("transform")).not.toBe("none");_.each(view._$diffHeaders,function(headerEl){expect($(headerEl).css("transform")).not.toBe("none")})});it("With collapsible === false",function(){var isHovering=true;view._collapsible=false;view.render();spyOn(view.$el,"is").and.callFake(function(sel){expect(sel).toBe(":hover");return isHovering});view.$el.trigger("mouseenter");isHovering=false;view.$el.trigger("mouseleave");expect(view._$table.hasClass("collapsed")).toBe(false);expect(view._$table.hasClass("expanded")).toBe(true);expect(view._$thead.css("transform")).toBe("none");_.each(view._$diffHeaders,function(headerEl){expect($(headerEl).css("transform")).toBe("none")})})})})});suite("rb/views/DraftReviewBannerView",function(){var model,view,template=_.template(['<div id="review-banner" class="hidden">',' <div class="banner">',"  <h1>You have a pending review.</h1>",'  <input id="review-banner-edit" type="button" ','         value="Edit Review" />','  <input id="review-banner-publish-container" type="button" ','         value="Publish" />','  <input id="review-banner-discard" type="button" ','         value="Discard" />'," </div>","</div>"].join(""));beforeEach(function(){var $el=$(template()).appendTo($testsScratch);model=new RB.DraftReview;view=new RB.DraftReviewBannerView({el:$el,model:model});view.render()});afterEach(function(){view.remove()});describe("Button states",function(){var $buttons;beforeEach(function(){$buttons=view.$("input")});describe("Enabled",function(){it("Default",function(){expect($buttons.prop("disabled")).toBe(false)});it("When saved",function(){$buttons.prop("disabled",true);model.trigger("saved");expect($buttons.prop("disabled")).toBe(false)});it("When destroyed",function(){$buttons.prop("disabled",true);model.trigger("destroyed");expect($buttons.prop("disabled")).toBe(false)})});describe("Disabled",function(){it("When saving",function(){model.trigger("saving");expect($buttons.prop("disabled")).toBe(true)});it("When destroying",function(){model.trigger("destroying");expect($buttons.prop("disabled")).toBe(true)})})});describe("Button events",function(){it("Edit Review",function(){spyOn(RB.ReviewDialogView,"create");view.$("#review-banner-edit").click();expect(RB.ReviewDialogView.create).toHaveBeenCalled();expect(RB.ReviewDialogView.create.calls.argsFor(0)[0].review).toBe(model)});it("Publish",function(){spyOn(model,"publish");view.$("#review-banner-publish").click();expect(model.publish).toHaveBeenCalled()});it("Publish to Submitter Only",function(){spyOn(model,"publish");$("#review-banner-publish-submitter-only").click();expect(model.publish).toHaveBeenCalled()});it("Discard",function(){var $buttons=$();spyOn(model,"destroy");spyOn($.fn,"modalBox").and.callFake(function(options){_.each(options.buttons,function($btn){$buttons=$buttons.add($btn)});return{modalBox:function(cmd){expect(cmd).toBe("buttons");return $buttons}}});view.$("#review-banner-discard").click();expect($.fn.modalBox).toHaveBeenCalled();$buttons.filter('input[value="Discard"]').click();expect(model.destroy).toHaveBeenCalled()})});describe("Methods",function(){it("show",function(){expect(view.$el.hasClass("hidden")).toBe(true);view.show();expect(view.$el.hasClass("hidden")).toBe(false)});it("hide",function(){view.$el.addClass("hidden");view.hide();expect(view.$el.hasClass("hidden")).toBe(true)})})});suite("rb/views/FileAttachmentThumbnail",function(){var reviewRequest,model,view;beforeEach(function(){reviewRequest=new RB.ReviewRequest;model=new RB.FileAttachment({downloadURL:"http://example.com/file.png",filename:"file.png"});spyOn(model,"trigger").and.callThrough()});describe("Rendering",function(){function expectElements(){expect(view.$("a.edit").length).toBe(1);expect(view.$(".file-caption").length).toBe(1);expect(view.$(".file-actions").length).toBe(1);expect(view.$(".file-delete").length).toBe(view.options.canEdit&&model.get("loaded")?1:0);expect(view.$(".file-update").length).toBe(view.options.canEdit&&model.get("loaded")?1:0)}function expectAttributeMatches(){expect(view.$(".file-download").attr("href")).toBe(model.get("downloadURL"));expect(view.$(".file-caption .edit").text()).toBe(model.get("caption"))}it("Using existing elements",function(){var $el=$("<div/>").addClass(RB.FileAttachmentThumbnail.prototype.className).html(RB.FileAttachmentThumbnail.prototype.template(_.defaults({caption:"No caption",captionClass:"edit empty-caption"},model.attributes)));model.set("loaded",true);view=new RB.FileAttachmentThumbnail({renderThumbnail:true,reviewRequest:reviewRequest,el:$el,model:model});$testsScratch.append(view.$el);view.render();expectElements();expect(view.$(".file-actions").is(":visible")).toBe(true);expect(view.$(".fa-spinner").length).toBe(0)});it("Rendered thumbnail with unloaded model",function(){view=new RB.FileAttachmentThumbnail({reviewRequest:reviewRequest,renderThumbnail:true,model:model});$testsScratch.append(view.$el);view.render();expectElements();expect(view.$(".file-actions").children().length).toBe(0);expect(view.$(".fa-spinner").length).toBe(1)});describe("Rendered thumbnail with loaded model",function(){beforeEach(function(){model.id=123;model.set("caption","My Caption");model.set("loaded",true);model.url="/api/file-attachments/123/"});it("With review UI",function(){model.set("reviewURL","/review/");view=new RB.FileAttachmentThumbnail({reviewRequest:reviewRequest,renderThumbnail:true,model:model});$testsScratch.append(view.$el);view.render();expectElements();expectAttributeMatches();expect(view.$(".file-actions").children().length).toBe(2);expect(view.$(".fa-spinner").length).toBe(0);expect(view.$(".file-review").length).toBe(1);expect(view.$(".file-add-comment").length).toBe(0)});it("No review UI",function(){view=new RB.FileAttachmentThumbnail({reviewRequest:reviewRequest,renderThumbnail:true,model:model});$testsScratch.append(view.$el);view.render();expectElements();expectAttributeMatches();expect(view.$(".file-actions").children().length).toBe(2);expect(view.$(".fa-spinner").length).toBe(0);expect(view.$(".file-review").length).toBe(0);expect(view.$(".file-add-comment").length).toBe(1)})})});describe("Actions",function(){beforeEach(function(){model.id=123;model.set("loaded",true);model.url="/api/file-attachments/123/";view=new RB.FileAttachmentThumbnail({canEdit:true,reviewRequest:reviewRequest,renderThumbnail:true,model:model});$testsScratch.append(view.$el);view.render();spyOn(view,"trigger").and.callThrough()});it("Begin caption editing",function(){view._$caption.inlineEditor("startEdit");expect(view.trigger).toHaveBeenCalledWith("beginEdit")});it("Cancel caption editing",function(){view._$caption.inlineEditor("startEdit");expect(view.trigger).toHaveBeenCalledWith("beginEdit");view._$caption.inlineEditor("cancel");expect(view.trigger).toHaveBeenCalledWith("endEdit")});it("Save caption",function(){spyOn(model,"save");view._$caption.inlineEditor("startEdit");expect(view.trigger).toHaveBeenCalledWith("beginEdit");view.$("input").val("Foo").triggerHandler("keyup");view._$caption.inlineEditor("submit");expect(view.trigger).toHaveBeenCalledWith("endEdit");expect(model.get("caption")).toBe("Foo");expect(model.save).toHaveBeenCalled()});it("Delete",function(){spyOn(model,"destroy").and.callThrough();spyOn($,"ajax").and.callFake(function(options){options.success()});spyOn(view.$el,"fadeOut").and.callFake(function(done){done()});spyOn(view,"remove");view.$(".file-delete").click();expect($.ajax).toHaveBeenCalled();expect(model.destroy).toHaveBeenCalled();expect(model.trigger.calls.argsFor(2)[0]).toBe("destroying");expect(view.$el.fadeOut).toHaveBeenCalled();expect(view.remove).toHaveBeenCalled()})})});suite("rb/views/ReviewDialogView",function(){var baseEmptyCommentListPayload={stat:"ok",total_results:0,links:{}},emptyDiffCommentsPayload=_.defaults({diff_comments:[]},baseEmptyCommentListPayload),emptyFileAttachmentCommentsPayload=_.defaults({file_attachment_comments:[]},baseEmptyCommentListPayload),emptyGeneralCommentsPayload=_.defaults({general_comments:[]},baseEmptyCommentListPayload),emptyScreenshotCommentsPayload=_.defaults({screenshot_comments:[]},baseEmptyCommentListPayload),baseCommentPayload={id:1,issue_opened:true,issue_status:"opened",text:"My comment"},diffCommentPayload=_.defaults({first_line:10,num_lines:5,filediff:{id:1,source_file:"my-file",dest_file:"my-file",source_revision:"1"},interfilediff:{id:2,source_file:"my-file",dest_file:"my-file",source_revision:"2"}},baseCommentPayload),fileAttachmentCommentPayload=_.defaults({extra_data:{},link_text:"my-link-text",thumbnail_html:"<blink>Boo</blink>",review_url:"/review-ui/",file_attachment:{id:10,filename:"file.txt",icon_url:"data:image/gif;base64,"}},baseCommentPayload),generalCommentPayload=baseCommentPayload,screenshotCommentPayload=_.defaults({x:10,y:20,w:30,h:40,thumbnail_url:"data:image/gif;base64,",screenshot:{id:10,caption:"My caption",filename:"image.png",review_url:"/review-ui/"}},baseCommentPayload),origGeneralCommentsEnabled=RB.EnabledFeatures.generalComments,reviewRequestEditor,review,dlg;function createReviewDialog(){return RB.ReviewDialogView.create({review:review,container:$testsScratch,reviewRequestEditor:reviewRequestEditor})}beforeEach(function(){var origMove=$.fn.move,reviewRequest=new RB.ReviewRequest({summary:"My Review Request"});RB.DnDUploader.create();reviewRequestEditor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest});review=new RB.Review({parentObject:reviewRequest});spyOn(review,"ready").and.callFake(function(options,context){options.ready.call(context)});spyOn($.fn,"move").and.callFake(function(x,y,pos){if(pos==="fixed"){pos="absolute"}return origMove.call(this,x,y,pos)});spyOn(RB.DiffFragmentQueueView.prototype,"queueLoad");spyOn(RB.DiffFragmentQueueView.prototype,"loadFragments");RB.EnabledFeatures.generalComments=true});afterEach(function(){RB.DnDUploader.instance=null;RB.ReviewDialogView._instance=null;RB.EnabledFeatures.generalComments=origGeneralCommentsEnabled});describe("Class methods",function(){describe("create",function(){it("Without a review",function(){expect(function(){RB.ReviewDialogView.create({container:$testsScratch,reviewRequestEditor:reviewRequestEditor})}).toThrow();expect(RB.ReviewDialogView._instance).toBeFalsy();expect($testsScratch.children().length).toBe(0)});it("With a review",function(){dlg=createReviewDialog();expect(dlg).toBeTruthy();expect(RB.ReviewDialogView._instance).toBe(dlg);expect($testsScratch.children().length).toBe(2)});it("With existing instance",function(){dlg=createReviewDialog();expect(createReviewDialog).toThrow();expect(RB.ReviewDialogView._instance).toBe(dlg);expect($testsScratch.children().length).toBe(2)})})});describe("Instances",function(){describe("Methods",function(){it("close",function(){dlg=createReviewDialog();expect($testsScratch.children().length).toBe(2);dlg.close();expect($testsScratch.children().length).toBe(0);expect(RB.ReviewDialogView._instance).toBe(null)})});describe("Loading",function(){it("With new review",function(){expect(review.isNew()).toBe(true);dlg=RB.ReviewDialogView.create({review:review,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect(dlg._bodyTopView.$editor.text()).toBe("");expect(dlg._bodyBottomView.$editor.text()).toBe("");expect(dlg._bodyBottomView.$el.is(":visible")).toBe(false);expect(dlg._$shipIt.prop("checked")).toBe(false);expect(dlg._$spinner).toBe(null)});describe("With body and top text",function(){var bodyTopText="My body top",bodyBottomText="My body bottom";beforeEach(function(){review.set({bodyTop:bodyTopText,bodyBottom:bodyBottomText,loaded:true})});it("Clearing body bottom hides footer",function(){dlg=RB.ReviewDialogView.create({review:review,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect(dlg._bodyBottomView.$editor.text()).toBe(bodyBottomText);expect(dlg._bodyBottomView.$el.is(":visible")).toBe(true);review.set("bodyBottom","");expect(dlg._bodyBottomView.$el.is(":visible")).toBe(false)})});describe("With existing review",function(){var bodyTopText="My body top",bodyBottomText="My body bottom",shipIt=true,fileAttachmentCommentsPayload,generalCommentsPayload,diffCommentsPayload,screenshotCommentsPayload,commentView,ajaxData;beforeEach(function(){review.set({bodyTop:bodyTopText,bodyBottom:bodyBottomText,shipIt:shipIt,loaded:true,id:42,links:{diff_comments:{href:"/diff-comments/"},file_attachment_comments:{href:"/file-attachment-comments/"},general_comments:{href:"/general-comments/"},screenshot_comments:{href:"/screenshot-comments/"}}});diffCommentsPayload=_.clone(emptyDiffCommentsPayload);screenshotCommentsPayload=_.clone(emptyScreenshotCommentsPayload);fileAttachmentCommentsPayload=_.clone(emptyFileAttachmentCommentsPayload);generalCommentsPayload=_.clone(emptyGeneralCommentsPayload);spyOn($,"ajax").and.callFake(function(options){if(options.type==="DELETE"){options.success({})
}else if(options.url==="/file-attachment-comments/"){options.success(fileAttachmentCommentsPayload)}else if(options.url==="/diff-comments/"){options.success(diffCommentsPayload)}else if(options.url==="/screenshot-comments/"){options.success(screenshotCommentsPayload)}else if(options.url==="/general-comments/"){options.success(generalCommentsPayload)}})});describe("Review properties",function(){function testLoadReview(){dlg=RB.ReviewDialogView.create({review:review,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect(dlg._bodyTopView.$editor.text()).toBe(bodyTopText);expect(dlg._bodyBottomView.$editor.text()).toBe(bodyBottomText);expect(dlg._bodyBottomView.$el.is(":visible")).toBe(true);expect(dlg._$shipIt.prop("checked")).toBe(shipIt);expect(dlg.$(".review-comments .draft").length).toBe(2);expect(dlg._$spinner).toBe(null)}it("With defaultUseRichText=true",function(){RB.UserSession.instance.set("defaultUseRichText",true);testLoadReview();expect(review.ready.calls.argsFor(0)[0].data).toEqual({"force-text-type":"html","include-text-types":"raw,markdown"})});it("With defaultUseRichText=false",function(){RB.UserSession.instance.set("defaultUseRichText",false);testLoadReview();expect(review.ready.calls.argsFor(0)[0].data).toEqual({"force-text-type":"html","include-text-types":"raw"})})});describe("General comments",function(){it("Disabled",function(){var $button;RB.EnabledFeatures.generalComments=false;dlg=RB.ReviewDialogView.create({review:review,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});$button=dlg._$buttons.find('input[value="Add General Comment"]');expect($button.length).toBe(0);expect($.ajax).toHaveBeenCalled();expect($.ajax.calls.argsFor(0)[0].url).not.toBe("/general-comments/");expect(dlg._commentViews.length).toBe(0)});describe("Enabled",function(){function testLoadGeneralComments(){var $button;generalCommentsPayload.total_results=1;generalCommentsPayload.general_comments=[generalCommentPayload];dlg=RB.ReviewDialogView.create({review:review,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});$button=dlg._$buttons.find('input[value="Add General Comment"]');expect($button.length).toBe(1);expect($.ajax).toHaveBeenCalled();expect($.ajax.calls.argsFor(0)[0].url).toBe("/general-comments/");ajaxData=$.ajax.calls.argsFor(0)[0].data;expect(dlg._commentViews.length).toBe(1);commentView=dlg._commentViews[0];expect(commentView.$editor.text()).toBe(generalCommentPayload.text);expect(commentView.$issueOpened.prop("checked")).toBe(generalCommentPayload.issue_opened);expect(dlg._bodyBottomView.$el.is(":visible")).toBe(true);expect(dlg._$spinner).toBe(null)}it("With defaultUseRichText=true",function(){RB.UserSession.instance.set("defaultUseRichText",true);testLoadGeneralComments();expect(ajaxData).toEqual({api_format:"json","max-results":50,"force-text-type":"html","include-text-types":"raw,markdown"})});it("With defaultUseRichText=false",function(){RB.UserSession.instance.set("defaultUseRichText",false);testLoadGeneralComments();expect(ajaxData).toEqual({api_format:"json","max-results":50,"force-text-type":"html","include-text-types":"raw"})});it("Deleting comment",function(){spyOn(window,"confirm").and.callFake(function(){return true});testLoadGeneralComments();expect(dlg._generalCommentsCollection.length).toBe(1);dlg.$(".delete-comment").click();expect(dlg._generalCommentsCollection.length).toBe(0)});it("Deleting comment and cancelling",function(){spyOn(window,"confirm").and.callFake(function(){return false});testLoadGeneralComments();expect(dlg._generalCommentsCollection.length).toBe(1);dlg.$(".delete-comment").click();expect(dlg._generalCommentsCollection.length).toBe(1)})})});describe("Diff comments",function(){function testLoadDiffComments(){var diffQueueProto=RB.DiffFragmentQueueView.prototype;diffCommentsPayload.total_results=1;diffCommentsPayload.diff_comments=[diffCommentPayload];dlg=RB.ReviewDialogView.create({review:review,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect($.ajax).toHaveBeenCalled();expect($.ajax.calls.argsFor(3)[0].url).toBe("/diff-comments/");ajaxData=$.ajax.calls.argsFor(3)[0].data;expect(diffQueueProto.queueLoad.calls.count()).toBe(1);expect(diffQueueProto.loadFragments).toHaveBeenCalled();expect(dlg._commentViews.length).toBe(1);commentView=dlg._commentViews[0];expect(commentView.$editor.text()).toBe(diffCommentPayload.text);expect(commentView.$issueOpened.prop("checked")).toBe(diffCommentPayload.issue_opened);expect(dlg._bodyBottomView.$el.is(":visible")).toBe(true);expect(dlg._$spinner).toBe(null)}it("With defaultUseRichText=true",function(){RB.UserSession.instance.set("defaultUseRichText",true);testLoadDiffComments();expect(ajaxData).toEqual({api_format:"json","max-results":50,expand:"filediff,interfilediff","order-by":"filediff,first_line","force-text-type":"html","include-text-types":"raw,markdown"})});it("With defaultUseRichText=false",function(){RB.UserSession.instance.set("defaultUseRichText",false);testLoadDiffComments();expect(ajaxData).toEqual({api_format:"json","max-results":50,expand:"filediff,interfilediff","order-by":"filediff,first_line","force-text-type":"html","include-text-types":"raw"})});it("Deleting comment",function(){spyOn(window,"confirm").and.callFake(function(){return true});testLoadDiffComments();expect(dlg._diffCommentsCollection.length).toBe(1);dlg.$(".delete-comment").click();expect(dlg._diffCommentsCollection.length).toBe(0)});it("Deleting comment and cancelling",function(){spyOn(window,"confirm").and.callFake(function(){return false});testLoadDiffComments();expect(dlg._diffCommentsCollection.length).toBe(1);dlg.$(".delete-comment").click();expect(dlg._diffCommentsCollection.length).toBe(1)})});describe("File attachment comments",function(){function testLoadFileAttachmentComments(){fileAttachmentCommentsPayload.total_results=1;fileAttachmentCommentsPayload.file_attachment_comments=[fileAttachmentCommentPayload];dlg=RB.ReviewDialogView.create({review:review,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect($.ajax).toHaveBeenCalled();expect($.ajax.calls.argsFor(2)[0].url).toBe("/file-attachment-comments/");ajaxData=$.ajax.calls.argsFor(2)[0].data;expect(dlg._commentViews.length).toBe(1);commentView=dlg._commentViews[0];expect(commentView.$editor.text()).toBe(fileAttachmentCommentPayload.text);expect(commentView.$issueOpened.prop("checked")).toBe(fileAttachmentCommentPayload.issue_opened);expect(commentView.$(".filename a").attr("href")).toBe(fileAttachmentCommentPayload.review_url);expect(commentView.$(".filename a").text()).toBe(fileAttachmentCommentPayload.link_text);expect(commentView.$(".thumbnail").html()).toBe(fileAttachmentCommentPayload.thumbnail_html);expect(dlg._bodyBottomView.$el.is(":visible")).toBe(true);expect(dlg._$spinner).toBe(null)}it("With defaultUseRichText=true",function(){RB.UserSession.instance.set("defaultUseRichText",true);testLoadFileAttachmentComments();expect(ajaxData).toEqual({api_format:"json","max-results":50,expand:"diff_against_file_attachment,"+"file_attachment","force-text-type":"html","include-text-types":"raw,markdown"})});it("With defaultUseRichText=false",function(){RB.UserSession.instance.set("defaultUseRichText",false);testLoadFileAttachmentComments();expect(ajaxData).toEqual({api_format:"json","max-results":50,expand:"diff_against_file_attachment,"+"file_attachment","force-text-type":"html","include-text-types":"raw"})});it("Deleting comment",function(){spyOn(window,"confirm").and.callFake(function(){return true});testLoadFileAttachmentComments();expect(dlg._fileAttachmentCommentsCollection.length).toBe(1);dlg.$(".delete-comment").click();expect(dlg._fileAttachmentCommentsCollection.length).toBe(0)});it("Deleting comment and cancelling",function(){spyOn(window,"confirm").and.callFake(function(){return false});testLoadFileAttachmentComments();expect(dlg._fileAttachmentCommentsCollection.length).toBe(1);dlg.$(".delete-comment").click();expect(dlg._fileAttachmentCommentsCollection.length).toBe(1)})});describe("Screenshot comments",function(){function testLoadScreenshotComments(){var $img,$filenameA;screenshotCommentsPayload.total_results=1;screenshotCommentsPayload.screenshot_comments=[screenshotCommentPayload];dlg=createReviewDialog();expect($.ajax).toHaveBeenCalled();expect($.ajax.calls.argsFor(1)[0].url).toBe("/screenshot-comments/");ajaxData=$.ajax.calls.argsFor(1)[0].data;expect(dlg._commentViews.length).toBe(1);commentView=dlg._commentViews[0];expect(commentView.$editor.text()).toBe(screenshotCommentPayload.text);expect(commentView.$issueOpened.prop("checked")).toBe(screenshotCommentPayload.issue_opened);$img=commentView.$("img");expect($img.attr("src")).toBe(screenshotCommentPayload.thumbnail_url);expect($img.attr("width")).toBe(screenshotCommentPayload.w.toString());expect($img.attr("height")).toBe(screenshotCommentPayload.h.toString());expect($img.attr("alt")).toBe(screenshotCommentPayload.screenshot.caption);$filenameA=commentView.$(".filename a");expect($filenameA.attr("href")).toBe(screenshotCommentPayload.screenshot.review_url);expect($filenameA.text()).toBe(screenshotCommentPayload.screenshot.caption);expect(dlg._bodyBottomView.$el.is(":visible")).toBe(true);expect(dlg._$spinner).toBe(null)}it("With defaultUseRichText=true",function(){RB.UserSession.instance.set("defaultUseRichText",true);testLoadScreenshotComments();expect(ajaxData).toEqual({api_format:"json","max-results":50,expand:"screenshot","force-text-type":"html","include-text-types":"raw,markdown"})});it("With defaultUseRichText=false",function(){RB.UserSession.instance.set("defaultUseRichText",false);testLoadScreenshotComments();expect(ajaxData).toEqual({api_format:"json","max-results":50,expand:"screenshot","force-text-type":"html","include-text-types":"raw"})});it("Deleting comment",function(){spyOn(window,"confirm").and.callFake(function(){return true});testLoadScreenshotComments();expect(dlg._screenshotCommentsCollection.length).toBe(1);dlg.$(".delete-comment").click();expect(dlg._screenshotCommentsCollection.length).toBe(0)});it("Deleting comment and cancelling",function(){spyOn(window,"confirm").and.callFake(function(){return false});testLoadScreenshotComments();expect(dlg._screenshotCommentsCollection.length).toBe(1);dlg.$(".delete-comment").click();expect(dlg._screenshotCommentsCollection.length).toBe(1)})})})});describe("Saving",function(){var fileAttachmentCommentsPayload,generalCommentsPayload,diffCommentsPayload,screenshotCommentsPayload,commentView,comment;function testSaveComment(richText){var newCommentText="New comment text";dlg=createReviewDialog();expect(dlg._commentViews.length).toBe(1);commentView=dlg._commentViews[0];comment=commentView.model;spyOn(comment,"save");commentView.inlineEditorView.startEdit();commentView.inlineEditorView.setValue(newCommentText);commentView.textEditor.setRichText(richText);commentView.save();expect(comment.save).toHaveBeenCalled();expect(comment.get("text")).toBe(newCommentText);expect(comment.get("richText")).toBe(richText)}function testSaveCommentPreventsXSS(richText){var newCommentText='"><script>window.rbTestFoundXSS = true;</script>';delete window.rbTestFoundXSS;dlg=createReviewDialog();expect(dlg._commentViews.length).toBe(1);commentView=dlg._commentViews[0];comment=commentView.model;spyOn(comment,"save");commentView.inlineEditorView.startEdit();commentView.inlineEditorView.setValue(newCommentText);commentView.textEditor.setRichText(true);commentView.save();expect(comment.save).toHaveBeenCalled();expect(comment.get("text")).toBe(newCommentText);expect(window.rbTestFoundXSS).toBe(undefined)}beforeEach(function(){review.set({loaded:true,id:42,links:{diff_comments:{href:"/diff-comments/"},file_attachment_comments:{href:"/file-attachment-comments/"},general_comments:{href:"/general-comments/"},screenshot_comments:{href:"/screenshot-comments/"}}});diffCommentsPayload=_.clone(emptyDiffCommentsPayload);screenshotCommentsPayload=_.clone(emptyScreenshotCommentsPayload);fileAttachmentCommentsPayload=_.clone(emptyFileAttachmentCommentsPayload);generalCommentsPayload=_.clone(emptyGeneralCommentsPayload);spyOn(review,"save").and.callFake(function(options,context){if(options&&options.success){options.success.call(context)}});spyOn($,"ajax").and.callFake(function(options){if(options.url==="/file-attachment-comments/"){options.success(fileAttachmentCommentsPayload)}else if(options.url==="/diff-comments/"){options.success(diffCommentsPayload)}else if(options.url==="/screenshot-comments/"){options.success(screenshotCommentsPayload)}else if(options.url==="/general-comments/"){options.success(generalCommentsPayload)}})});describe("Review properties",function(){function testSelfXSS(bodyView,attrName){var text='"><script>window.rbTestFoundXSS = true;'+"</script>",editor=bodyView.textEditor;delete window.rbTestFoundXSS;bodyView.openEditor();editor.setText(text);editor.setRichText(true);bodyView.save();expect(editor.getText()).toBe(text);expect(review.save).toHaveBeenCalled();expect(review.get(attrName)).toBe(text);expect(window.rbTestFoundXSS).toBe(undefined)}beforeEach(function(){dlg=createReviewDialog()});describe("Body Top",function(){function runTest(richText){var text="My new text",bodyTopEditor=dlg._bodyTopView.textEditor;dlg._bodyTopView.openEditor();bodyTopEditor.setText(text);bodyTopEditor.setRichText(richText);dlg._bodyTopView.save();expect(bodyTopEditor.getText()).toBe(text);expect(review.save).toHaveBeenCalled();expect(review.get("bodyTop")).toBe(text);expect(review.get("bodyTopRichText")).toBe(richText)}it("For Markdown",function(){runTest(true)});it("For plain text",function(){runTest(false)});it("Prevents Self-XSS",function(){testSelfXSS(dlg._bodyTopView,"bodyTop")})});describe("Body Bottom",function(){function runTest(richText){var text="My new text",bodyBottomEditor=dlg._bodyBottomView.textEditor;dlg._bodyBottomView.openEditor();bodyBottomEditor.setText(text);bodyBottomEditor.setRichText(richText);dlg._bodyBottomView.save();expect(bodyBottomEditor.getText()).toBe(text);expect(review.save).toHaveBeenCalled();expect(review.get("bodyBottom")).toBe(text);expect(review.get("bodyBottomRichText")).toBe(richText)}it("For Markdown",function(){runTest(true)});it("For plain text",function(){runTest(false)});it("Prevents Self-XSS",function(){testSelfXSS(dlg._bodyBottomView,"bodyBottom")})});describe("Ship It",function(){function runTest(shipIt){dlg._$shipIt.prop("checked",shipIt);dlg._saveReview();expect(dlg._$shipIt.prop("checked")).toBe(shipIt)}it("Checked",function(){runTest(true)});it("Unchecked",function(){runTest(false)})})});describe("Diff comments",function(){beforeEach(function(){diffCommentsPayload.total_results=1;diffCommentsPayload.diff_comments=[diffCommentPayload]});it("For Markdown",function(){testSaveComment(true)});it("For plain text",function(){testSaveComment(false)});it("Prevents Self-XSS",function(){testSaveCommentPreventsXSS()})});describe("File attachment comments",function(){beforeEach(function(){fileAttachmentCommentsPayload.total_results=1;fileAttachmentCommentsPayload.file_attachment_comments=[fileAttachmentCommentPayload]});it("For Markdown",function(){testSaveComment(true)});it("For plain text",function(){testSaveComment(false)});it("Prevents Self-XSS",function(){testSaveCommentPreventsXSS()})});describe("General comments",function(){beforeEach(function(){generalCommentsPayload.total_results=1;generalCommentsPayload.general_comments=[generalCommentPayload]});it("For Markdown",function(){testSaveComment(true)});it("For plain text",function(){testSaveComment(false)})});describe("Screenshot comments",function(){beforeEach(function(){screenshotCommentsPayload.total_results=1;screenshotCommentsPayload.screenshot_comments=[screenshotCommentPayload]});it("For Markdown",function(){testSaveComment(true)});it("For plain text",function(){testSaveComment(false)});it("Prevents Self-XSS",function(){testSaveCommentPreventsXSS()})})})})});suite("rb/views/ReviewRequestEditorView",function(){var reviewRequest,editor,view,template=_.template(["<div>",' <div id="review-request-banners"></div>',' <div id="review-request-warning"></div>',' <div class="actions">','  <a href="#" id="discard-review-request-action"></a>','  <a href="#" id="submit-review-request-action"></a>','  <a href="#" id="delete-review-request-action"></a>'," </div>",' <div class="review-request">','  <div id="review-request-main">','   <span id="field_summary"','         data-field-id="summary"','         class="field editable"></span>','   <span id="field_branch"','         data-field-id="branch"','         class="field editable"></span>','   <span id="field_submitter"','         data-field-id="submitter"','         class="field editable"></span>','   <span id="field_bugs_closed"','         data-field-id="bugs_closed"','         class="field editable comma-editable"></span>','   <span id="field_depends_on"','         data-field-id="depends_on"','         class="field editable comma-editable"></span>','   <span id="field_target_groups"','         data-field-id="target_groups"','         class="field editable comma-editable"></span>','   <span id="field_target_people"','         data-field-id="target_people"','         class="field editable"></span>','   <div class="review-request-section">','    <pre id="field_description"','         data-field-id="description"','         class="field field-text-area editable"></pre>',"   </div>",'   <div class="review-request-section">','    <pre id="field_testing_done"','         data-field-id="testing_done"','         class="field field-text-area editable"></pre>',"   </div>",'   <div class="review-request-section">','    <div class="field-container">','     <pre id="field_my_custom"','          data-field-id="my_custom"','          class="field editable"></pre>','     <pre id="field_my_rich_text_custom"','          data-field-id="my_rich_text_custom"','          class="field field-text-area editable rich-text"','          data-allow-markdown="True"></pre>','     <pre id="field_text"','          data-field-id="text"','          class="field field-text-area editable"','          data-allow-markdown="True"></pre>','     <input id="field_checkbox"','            data-field-id="checkbox"','            class="field"','            type="checkbox">',"    </div>","   </div>","  </div>"," </div>",' <div id="review-request-extra">',"  <div>",'   <div id="file-list"><br /></div>',"  </div>","  <div>",'   <div id="screenshot-thumbnails"><br /></div>',"  </div>"," </div>","</div>"].join("")),screenshotThumbnailTemplate=_.template(['<div class="screenshot-container" data-screenshot-id="<%= id %>">',' <div class="screenshot-caption">','  <a class="edit"></a>'," </div>",' <a class="delete">X</a>',"</div>"].join("")),$filesContainer,$screenshotsContainer;beforeEach(function(){var $el=$(template()).appendTo($testsScratch);RB.DnDUploader.create();reviewRequest=new RB.ReviewRequest({id:123,"public":true,state:RB.ReviewRequest.PENDING});editor=new RB.ReviewRequestEditor({mutableByUser:true,statusMutableByUser:true,reviewRequest:reviewRequest,commentIssueManager:new RB.CommentIssueManager});view=new RB.ReviewRequestEditorView({el:$el,model:editor});view.addFieldView(new RB.ReviewRequestFields.SummaryFieldView({el:$el.find("#field_summary"),fieldID:"summary",model:editor}));view.addFieldView(new RB.ReviewRequestFields.BranchFieldView({el:$el.find("#field_branch"),fieldID:"branch",model:editor}));view.addFieldView(new RB.ReviewRequestFields.OwnerFieldView({el:$el.find("#field_submitter"),fieldID:"submitter",model:editor}));view.addFieldView(new RB.ReviewRequestFields.BugsFieldView({el:$el.find("#field_bugs_closed"),fieldID:"bugs_closed",model:editor}));view.addFieldView(new RB.ReviewRequestFields.DependsOnFieldView({el:$el.find("#field_depends_on"),fieldID:"depends_on",model:editor}));view.addFieldView(new RB.ReviewRequestFields.TargetGroupsFieldView({el:$el.find("#field_target_groups"),fieldID:"target_groups",model:editor}));view.addFieldView(new RB.ReviewRequestFields.TargetPeopleFieldView({el:$el.find("#field_target_people"),fieldID:"target_people",model:editor}));view.addFieldView(new RB.ReviewRequestFields.DescriptionFieldView({el:$el.find("#field_description"),fieldID:"description",model:editor}));view.addFieldView(new RB.ReviewRequestFields.TestingDoneFieldView({el:$el.find("#field_testing_done"),fieldID:"testing_done",model:editor}));view.addFieldView(new RB.ReviewRequestFields.TextFieldView({el:$el.find("#field_my_custom"),fieldID:"my_custom",model:editor}));view.addFieldView(new RB.ReviewRequestFields.MultilineTextFieldView({el:$el.find("#field_my_rich_text_custom"),fieldID:"my_rich_text_custom",model:editor}));view.addFieldView(new RB.ReviewRequestFields.MultilineTextFieldView({el:$el.find("#field_text"),fieldID:"text",model:editor}));view.addFieldView(new RB.ReviewRequestFields.CheckboxFieldView({el:$el.find("#field_checkbox"),fieldID:"checkbox",model:editor}));$filesContainer=$testsScratch.find("#file-list");$screenshotsContainer=$testsScratch.find("#screenshot-thumbnails");spyOn(view,"_refreshPage");spyOn(reviewRequest.draft,"ready").and.callFake(function(options,context){options.ready.call(context)})});afterEach(function(){RB.DnDUploader.instance=null});describe("Actions bar",function(){beforeEach(function(){view.render()});describe("Close",function(){it("Delete Permanently",function(){var $buttons=$();spyOn(reviewRequest,"destroy");spyOn($.fn,"modalBox").and.callFake(function(options){_.each(options.buttons,function($btn){$buttons=$buttons.add($btn)});return{modalBox:function(cmd){expect(cmd).toBe("buttons");return $buttons}}});$("#delete-review-request-action").click();expect($.fn.modalBox).toHaveBeenCalled();$buttons.filter('input[value="Delete"]').click();expect(reviewRequest.destroy).toHaveBeenCalled()});it("Discarded",function(){spyOn(reviewRequest,"close").and.callFake(function(options){expect(options.type).toBe(RB.ReviewRequest.CLOSE_DISCARDED)});spyOn(window,"confirm").and.returnValue(true);$("#discard-review-request-action").click();expect(reviewRequest.close).toHaveBeenCalled()});it("Submitted",function(){spyOn(reviewRequest,"close").and.callFake(function(options){expect(options.type).toBe(RB.ReviewRequest.CLOSE_SUBMITTED)});$("#submit-review-request-action").click();expect(reviewRequest.close).toHaveBeenCalled()})})});describe("Banners",function(){beforeEach(function(){view.render()});describe("Draft banner",function(){describe("Visibility",function(){it("Hidden when saving",function(){expect(view.banner).toBe(null);editor.trigger("saving");expect(view.banner).toBe(null)});it("Show when saved",function(){var summaryField=view.getFieldView("summary"),summaryEditor=summaryField.inlineEditorView;expect(view.banner).toBe(null);spyOn(reviewRequest.draft,"ensureCreated").and.callFake(function(options,context){options.success.call(context)});spyOn(reviewRequest.draft,"save").and.callFake(function(options,context){options.success.call(context)});summaryEditor.startEdit();summaryEditor.setValue("New summary");summaryEditor.save();expect(view.banner).not.toBe(null);expect(view.banner.$el.is(":visible")).toBe(true)})});describe("Buttons actions",function(){beforeEach(function(){reviewRequest.set({links:{submitter:{title:"submitter"}}})});it("Discard Draft",function(){view.model.set("hasDraft",true);view.showBanner();spyOn(reviewRequest.draft,"destroy");$("#btn-draft-discard").click();expect(reviewRequest.draft.destroy).toHaveBeenCalled()});it("Discard Review Request",function(){reviewRequest.set("public",false);view.model.set("hasDraft",true);view.showBanner();spyOn(reviewRequest,"close").and.callFake(function(options){expect(options.type).toBe(RB.ReviewRequest.CLOSE_DISCARDED)});$("#btn-review-request-discard").click();expect(reviewRequest.close).toHaveBeenCalled()});describe("Publish",function(){beforeEach(function(){view.model.set("hasDraft",true);spyOn(editor,"publishDraft").and.callThrough();spyOn(reviewRequest.draft,"ensureCreated").and.callFake(function(options,context){options.success.call(context)});spyOn(reviewRequest.draft,"publish");reviewRequest.draft.set({targetGroups:[{name:"foo",url:"/groups/foo"}],summary:"foo",links:{submitter:{title:"submitter"}},description:"foo"})});it("Basic publishing",function(){view.showBanner();$("#btn-draft-publish").click();expect(editor.get("publishing")).toBe(true);expect(editor.get("pendingSaveCount")).toBe(0);expect(editor.publishDraft).toHaveBeenCalled();expect(reviewRequest.draft.publish).toHaveBeenCalled()});it("With submitter changed",function(){reviewRequest.draft.set({links:{submitter:{title:"submitter2"}}});view.showBanner();spyOn(window,"confirm").and.returnValue(true);$("#btn-draft-publish").click();expect(editor.get("publishing")).toBe(true);expect(editor.get("pendingSaveCount")).toBe(0);expect(editor.publishDraft).toHaveBeenCalled();expect(window.confirm).toHaveBeenCalled();expect(reviewRequest.draft.publish).toHaveBeenCalled()});it("With Send E-Mail turned on",function(){view.model.set("showSendEmail",true);view.showBanner();$("#btn-draft-publish").click();expect(editor.get("publishing")).toBe(true);expect(editor.get("pendingSaveCount")).toBe(0);expect(editor.publishDraft).toHaveBeenCalled();expect(reviewRequest.draft.publish).toHaveBeenCalled();expect(reviewRequest.draft.publish.calls.argsFor(0)[0].trivial).toBe(0)});it("With Send E-Mail turned off",function(){view.model.set("showSendEmail",true);view.showBanner();$(".send-email").prop("checked",false);$("#btn-draft-publish").click();expect(editor.get("publishing")).toBe(true);expect(editor.get("pendingSaveCount")).toBe(0);expect(editor.publishDraft).toHaveBeenCalled();expect(reviewRequest.draft.publish).toHaveBeenCalled();expect(reviewRequest.draft.publish.calls.argsFor(0)[0].trivial).toBe(1)})})});describe("Button states",function(){var $buttons;beforeEach(function(){view.model.set("hasDraft",true);view.showBanner();$buttons=view.banner.$buttons});it("Enabled by default",function(){expect($buttons.prop("disabled")).toBe(false)});it("Disabled when saving",function(){expect($buttons.prop("disabled")).toBe(false);editor.trigger("saving");expect($buttons.prop("disabled")).toBe(true)});it("Enabled when saved",function(){expect($buttons.prop("disabled")).toBe(false);editor.trigger("saving");expect($buttons.prop("disabled")).toBe(true);editor.trigger("saved");expect($buttons.prop("disabled")).toBe(false)})})});describe("Discarded banner",function(){beforeEach(function(){reviewRequest.set("state",RB.ReviewRequest.CLOSE_DISCARDED)});it("Visibility",function(){expect(view.banner).toBe(null);view.showBanner();expect(view.banner).not.toBe(null);expect(view.banner.el.id).toBe("discard-banner");expect(view.banner.$el.is(":visible")).toBe(true)});describe("Buttons actions",function(){beforeEach(function(){expect(view.banner).toBe(null);view.showBanner()});it("Reopen",function(){spyOn(reviewRequest,"reopen");$("#btn-review-request-reopen").click();expect(reviewRequest.reopen).toHaveBeenCalled()})});describe("Close description",function(){var fieldEditor,$input;beforeEach(function(){view.showBanner();fieldEditor=view.banner.field.inlineEditorView;$input=fieldEditor.$field});function testCloseDescription(testName,richText){it(testName,function(done){var textEditor,t;fieldEditor.startEdit();textEditor=fieldEditor.textEditor;textEditor.setText("My description");textEditor.setRichText(richText);$input.triggerHandler("keyup");t=setInterval(function(){if(fieldEditor.isDirty()){clearInterval(t);spyOn(reviewRequest,"close").and.callFake(function(options){expect(options.type).toBe(RB.ReviewRequest.CLOSE_DISCARDED);expect(options.description).toBe("My description");expect(options.richText).toBe(richText)});fieldEditor.submit();expect(reviewRequest.close).toHaveBeenCalled();done()}},100)})}describe("Saves",function(){testCloseDescription("For Markdown",true);testCloseDescription("For plain text",false)})})});describe("Submitted banner",function(){beforeEach(function(){reviewRequest.set("state",RB.ReviewRequest.CLOSE_SUBMITTED)});it("Visibility",function(){expect(view.banner).toBe(null);view.showBanner();expect(view.banner).not.toBe(null);expect(view.banner.el.id).toBe("submitted-banner");expect(view.banner.$el.is(":visible")).toBe(true)});describe("Buttons actions",function(){beforeEach(function(){expect(view.banner).toBe(null);reviewRequest.set("state",RB.ReviewRequest.CLOSE_SUBMITTED);view.showBanner()});it("Reopen",function(){spyOn(reviewRequest,"reopen");$("#btn-review-request-reopen").click();expect(reviewRequest.reopen).toHaveBeenCalled()})});describe("Close description",function(){var fieldEditor,$input;beforeEach(function(){view.showBanner();fieldEditor=view.banner.field.inlineEditorView;$input=fieldEditor.$field});function testCloseDescription(testName,richText){it(testName,function(done){var textEditor,t;fieldEditor.startEdit();textEditor=fieldEditor.textEditor;textEditor.setText("My description");textEditor.setRichText(richText);$input.triggerHandler("keyup");t=setInterval(function(){if(fieldEditor.isDirty()){clearInterval(t);spyOn(reviewRequest,"close").and.callFake(function(options){expect(options.type).toBe(RB.ReviewRequest.CLOSE_SUBMITTED);expect(options.description).toBe("My description");expect(options.richText).toBe(richText)});fieldEditor.submit();expect(reviewRequest.close).toHaveBeenCalled();done()}},100)})}describe("Saves",function(){testCloseDescription("For Markdown",true);testCloseDescription("For plain text",false)})})})});describe("Fields",function(){var saveSpyFunc,fieldName,jsonFieldName,jsonTextTypeFieldName,supportsRichText,useExtraData,fieldView,$field,$input;beforeEach(function(){if(!saveSpyFunc){saveSpyFunc=function(options,context){expect(options.data[jsonFieldName]).toBe("My Value");options.success.call(context)}}spyOn(reviewRequest.draft,"save").and.callFake(saveSpyFunc);view.render()});function setupFieldTests(options){beforeEach(function(){fieldName=options.fieldName;jsonFieldName=options.jsonFieldName;jsonTextTypeFieldName=jsonFieldName==="text"?"text_type":jsonFieldName+"_text_type";supportsRichText=!!options.supportsRichText;useExtraData=options.useExtraData;fieldView=view.getFieldView(options.fieldID||options.jsonFieldName);fieldEditor=fieldView.inlineEditorView;$field=view.$(options.selector);$input=fieldEditor.$field})}function hasAutoCompleteTest(){it("Has auto-complete",function(){expect($input.data("rbautocomplete")).not.toBe(undefined)})}function hasEditorTest(){it("Has editor",function(){expect(fieldEditor).not.toBe(undefined)})}function runSavingTest(richText,textType,supportsRichTextEV){beforeEach(function(done){var textEditor,t;expect(supportsRichText).toBe(supportsRichTextEV);fieldEditor.startEdit();if(supportsRichText){expect($field.hasClass("field-text-area")).toBe(true);textEditor=fieldEditor.textEditor;textEditor.setText("My Value");textEditor.setRichText(richText)}else{$input.val("My Value")}$input.triggerHandler("keyup");expect(fieldEditor.getValue()).toBe("My Value");t=setInterval(function(){if(fieldEditor.isDirty()){clearInterval(t);done()}},100)});it("",function(){var expectedData={},fieldPrefix=useExtraData?"extra_data.":"";expectedData[fieldPrefix+jsonFieldName]="My Value";if(supportsRichText){expectedData[fieldPrefix+jsonTextTypeFieldName]=textType;expectedData.force_text_type="html";expectedData.include_text_types="raw"}expect(fieldEditor.isDirty()).toBe(true);fieldEditor.submit();expect(reviewRequest.draft.save).toHaveBeenCalled();expect(reviewRequest.draft.save.calls.argsFor(0)[0].data).toEqual(expectedData)})}function savingTest(){describe("Saves",function(){runSavingTest(undefined,undefined,false)})}function richTextSavingTest(){describe("Saves",function(){describe("For Markdown",function(){runSavingTest(true,"markdown",true)});describe("For plain text",function(){runSavingTest(false,"plain",true)})})}function editCountTests(){describe("Edit counts",function(){it("When opened",function(){expect(editor.get("editCount")).toBe(0);
fieldEditor.startEdit();expect(editor.get("editCount")).toBe(1)});it("When canceled",function(){fieldEditor.startEdit();fieldEditor.cancel();expect(editor.get("editCount")).toBe(0)});it("When submitted",function(){fieldEditor.startEdit();$input.val("My Value").triggerHandler("keyup");fieldEditor.submit();expect(editor.get("editCount")).toBe(0)})})}function securityTests(options){options=options||{};if(options.supportsRichText){describe("Security measures",function(){it("No self-XSS when draft field changes",function(){var fieldOwner;delete window.rbTestFoundXSS;if(options.fieldOnReviewRequest){fieldOwner=reviewRequest}else{fieldOwner=reviewRequest.draft}fieldOwner.set(fieldName,'"><script>window.rbTestFoundXSS = true;</script>');fieldOwner.trigger("change:"+fieldName);fieldOwner.trigger("fieldChange:"+fieldName);expect(window.rbTestFoundXSS).toBe(undefined)})})}}describe("Branch",function(){setupFieldTests({fieldName:"branch",jsonFieldName:"branch",selector:"#field_branch"});hasEditorTest();savingTest();editCountTests();securityTests()});describe("Bugs Closed",function(){setupFieldTests({fieldName:"bugsClosed",jsonFieldName:"bugs_closed",selector:"#field_bugs_closed"});hasEditorTest();savingTest();describe("Formatting",function(){it("With bugTrackerURL",function(){var $links,$link;reviewRequest.set("bugTrackerURL","http://issues/?id=--bug_id--");reviewRequest.draft.set("bugsClosed",[1,2,3]);editor.trigger("fieldChanged:bugsClosed");expect($field.text()).toBe("1, 2, 3");$links=$field.children("a");expect($links.length).toBe(3);$link=$links.eq(0);expect($link.hasClass("bug")).toBe(true);expect($link.text()).toBe("1");expect($link.attr("href")).toBe("http://issues/?id=1");$link=$links.eq(1);expect($link.hasClass("bug")).toBe(true);expect($link.text()).toBe("2");expect($link.attr("href")).toBe("http://issues/?id=2");$link=$links.eq(2);expect($link.hasClass("bug")).toBe(true);expect($link.text()).toBe("3");expect($link.attr("href")).toBe("http://issues/?id=3")});it("Without bugTrackerURL",function(){reviewRequest.set("bugTrackerURL","");reviewRequest.draft.set("bugsClosed",[1,2,3]);editor.trigger("fieldChanged:bugsClosed");expect($field.html()).toBe("1, 2, 3")})});editCountTests();securityTests()});describe("Depends On",function(){var field_children;setupFieldTests({fieldName:"dependsOn",jsonFieldName:"depends_on",selector:"#field_depends_on"});hasAutoCompleteTest();hasEditorTest();savingTest();it("Formatting",function(){reviewRequest.draft.set("dependsOn",[{id:"123",url:"/r/123/"},{id:"124",url:"/r/124/"}]);editor.trigger("fieldChanged:dependsOn");field_children=$field.children();expect($field.text()).toBe("123, 124");expect(field_children.eq(0).attr("href")).toBe("/r/123/");expect(field_children.eq(1).attr("href")).toBe("/r/124/")});editCountTests();securityTests()});describe("Change Descriptions",function(){function closeDescriptionTests(options){beforeEach(function(){reviewRequest.set("state",options.closeType);view.showBanner();spyOn(reviewRequest,"close").and.callThrough();spyOn(reviewRequest,"save")});setupFieldTests({fieldName:"closeDescription",jsonFieldName:"close_description",selector:options.bannerSel+" #field_close_description"});hasEditorTest();it("Starts closed",function(){expect($input.is(":visible")).toBe(false)});describe("Saves",function(){function testSave(richText,textType,setRichText){var textEditor,expectedData={status:options.jsonCloseType,force_text_type:"html",include_text_types:"raw"};expectedData[options.jsonTextTypeFieldName]=textType;expectedData[options.jsonFieldName]="My Value";fieldEditor.startEdit();textEditor=fieldEditor.textEditor;textEditor.setText("My Value");if(setRichText!==false){textEditor.setRichText(richText)}$input.triggerHandler("keyup");fieldEditor.submit();expect(reviewRequest.close).toHaveBeenCalled();expect(reviewRequest.save).toHaveBeenCalled();expect(reviewRequest.save.calls.argsFor(0)[0].data).toEqual(expectedData)}it("For Markdown",function(){testSave(true,"markdown")});it("For plain text",function(){testSave(false,"plain")})});describe("State when statusEditable",function(){it("Disabled when false",function(){editor.set("statusEditable",false);expect(fieldEditor.options.enabled).toBe(false)});it("Enabled when true",function(){editor.set("statusEditable",true);expect(fieldEditor.options.enabled).toBe(true)})});describe("Formatting",function(){it("Links",function(){reviewRequest.set("closeDescription","Testing /r/123");editor.trigger("fieldChanged:closeDescription");expect($field.text()).toBe("Testing /r/123");expect($field.find("a").attr("href")).toBe("/r/123/")})});editCountTests();securityTests({fieldOnReviewRequest:true,supportsRichText:true})}describe("Discarded review requests",function(){closeDescriptionTests({bannerSel:"#discard-banner",closeType:RB.ReviewRequest.CLOSE_DISCARDED,jsonCloseType:"discarded",jsonFieldName:"close_description",jsonTextTypeFieldName:"close_description_text_type"})});describe("Draft review requests",function(){beforeEach(function(){view.model.set("hasDraft",true);view.showBanner()});setupFieldTests({supportsRichText:true,fieldID:"change_description",fieldName:"changeDescription",jsonFieldName:"changedescription",selector:"#draft-banner #field_change_description"});hasEditorTest();richTextSavingTest();editCountTests();securityTests({fieldOnReviewRequest:true,supportsRichText:true})});describe("Submitted review requests",function(){closeDescriptionTests({bannerSel:"#submitted-banner",closeType:RB.ReviewRequest.CLOSE_SUBMITTED,jsonCloseType:"submitted",jsonFieldName:"close_description",jsonTextTypeFieldName:"close_description_text_type"})})});describe("Description",function(){setupFieldTests({supportsRichText:true,fieldName:"description",jsonFieldName:"description",selector:"#field_description"});hasEditorTest();richTextSavingTest();describe("Formatting",function(){it("Links",function(){reviewRequest.draft.set("description","Testing /r/123");editor.trigger("fieldChanged:description");expect($field.text()).toBe("Testing /r/123");expect($field.find("a").attr("href")).toBe("/r/123/")})});editCountTests();securityTests({supportsRichText:true})});describe("Summary",function(){setupFieldTests({fieldName:"summary",jsonFieldName:"summary",selector:"#field_summary"});hasEditorTest();savingTest();editCountTests();securityTests()});describe("Testing Done",function(){setupFieldTests({supportsRichText:true,fieldName:"testingDone",jsonFieldName:"testing_done",selector:"#field_testing_done"});hasEditorTest();richTextSavingTest();describe("Formatting",function(){it("Links",function(){reviewRequest.draft.set("testingDone","Testing /r/123");editor.trigger("fieldChanged:testingDone");expect($field.text()).toBe("Testing /r/123");expect($field.find("a").attr("href")).toBe("/r/123/")})});editCountTests();securityTests({supportsRichText:true})});describe("Reviewers",function(){describe("Groups",function(){setupFieldTests({fieldName:"targetGroups",jsonFieldName:"target_groups",selector:"#field_target_groups"});hasAutoCompleteTest();hasEditorTest();savingTest();it("Formatting",function(){reviewRequest.draft.set("targetGroups",[{name:"group1",url:"/groups/group1/"},{name:"group2",url:"/groups/group2/"}]);editor.trigger("fieldChanged:targetGroups");expect($field.html()).toBe('<a href="/groups/group1/">group1</a>, '+'<a href="/groups/group2/">group2</a>')});editCountTests();securityTests()});describe("People",function(){setupFieldTests({fieldName:"targetPeople",jsonFieldName:"target_people",selector:"#field_target_people"});hasAutoCompleteTest();hasEditorTest();savingTest();it("Formatting",function(){reviewRequest.draft.set("targetPeople",[{username:"user1",url:"/users/user1/"},{username:"user2",url:"/users/user2/"}]);editor.trigger("fieldChanged:targetPeople");expect($field.text()).toBe("user1, user2");expect($($field.children()[0]).attr("href")).toBe("/users/user1/");expect($($field.children()[1]).attr("href")).toBe("/users/user2/")});editCountTests();securityTests()})});describe("Owner",function(){setupFieldTests({jsonFieldName:"submitter",selector:"#field_submitter"});hasAutoCompleteTest();hasEditorTest();savingTest();it("Formatting",function(){reviewRequest.draft.set("submitter",{title:"user1",href:"/users/user1/"});editor.trigger("fieldChanged:submitter");expect($field.text()).toBe("user1");expect($field.children().attr("href")).toBe("/users/user1/")});editCountTests()});describe("Custom fields",function(){beforeEach(function(){saveSpyFunc=function(options,context){expect(options.data["extra_data."+jsonFieldName]).toBe("My Value");options.success.call(context)}});setupFieldTests({fieldID:"my_custom",jsonFieldName:"my_custom",selector:"#field_my_custom",useExtraData:true});hasEditorTest();savingTest();editCountTests();securityTests()});describe("Custom rich-text field",function(){beforeEach(function(){saveSpyFunc=function(options,context){expect(options.data["extra_data."+jsonFieldName]).toBe("My Value");options.success.call(context)}});setupFieldTests({supportsRichText:true,fieldID:"my_rich_text_custom",jsonFieldName:"my_rich_text_custom",selector:"#field_my_rich_text_custom",useExtraData:true});it("Initial rich text state",function(){expect(fieldEditor.textEditor.richText).toBe(true)});hasEditorTest();richTextSavingTest();editCountTests();securityTests()});describe("Custom rich-text field with special name",function(){beforeEach(function(){saveSpyFunc=function(options,context){expect(options.data["extra_data."+jsonFieldName]).toBe("My Value");options.success.call(context)}});setupFieldTests({supportsRichText:true,fieldID:"text",jsonFieldName:"text",selector:"#field_text",useExtraData:true});hasEditorTest();richTextSavingTest();editCountTests();securityTests()});describe("Custom checkbox field",function(){beforeEach(function(){$field=view.$("#field_checkbox");saveSpyFunc=function(options,context){expect(options.data["extra_data.checkbox"]).toBe(true);options.success.call(context)};reviewRequest.draft.save.and.callFake(saveSpyFunc)});it("Saves",function(){var expectedData={"extra_data.checkbox":true};$field.click();expect(reviewRequest.draft.save).toHaveBeenCalled();expect(reviewRequest.draft.save.calls.argsFor(0)[0].data).toEqual(expectedData)})})});describe("File attachments",function(){it("Rendering when added",function(){spyOn(RB.FileAttachmentThumbnail.prototype,"render").and.callThrough();expect($filesContainer.find(".file-container").length).toBe(0);view.render();editor.createFileAttachment();expect(RB.FileAttachmentThumbnail.prototype.render).toHaveBeenCalled();expect($filesContainer.find(".file-container").length).toBe(1)});describe("Events",function(){var $thumbnail,fileAttachment;beforeEach(function(){view.render();fileAttachment=editor.createFileAttachment();$thumbnail=$($filesContainer.find(".file-container")[0]);expect($thumbnail.length).toBe(1)});describe("beginEdit",function(){it("Increment edit count",function(){expect(editor.get("editCount")).toBe(0);$thumbnail.find(".file-caption .edit").inlineEditor("startEdit");expect(editor.get("editCount")).toBe(1)})});describe("endEdit",function(){describe("Decrement edit count",function(){var $caption;beforeEach(function(){expect(editor.get("editCount")).toBe(0);$caption=$thumbnail.find(".file-caption .edit").inlineEditor("startEdit")});it("On cancel",function(){$caption.inlineEditor("cancel");expect(editor.get("editCount")).toBe(0)});it("On submit",function(){spyOn(fileAttachment,"ready").and.callFake(function(options,context){options.ready.call(context)});spyOn(fileAttachment,"save");$thumbnail.find("input").val("Foo").triggerHandler("keyup");$caption.inlineEditor("submit");expect(editor.get("editCount")).toBe(0)})})})})});describe("Methods",function(){describe("getFieldView",function(){it("Correct field is returned",function(){var fieldView=view.getFieldView("target_groups");expect(fieldView).not.toBe(undefined);expect(fieldView.fieldID).toBe("target_groups");expect(view.getFieldView("some_random_id")).toBe(undefined)})})});describe("Screenshots",function(){describe("Importing on render",function(){it("No screenshots",function(){view.render();expect(editor.get("screenshots").length).toBe(0)});it("With screenshots",function(){var screenshots=editor.get("screenshots");$screenshotsContainer.append(screenshotThumbnailTemplate({id:42}));spyOn(RB.ScreenshotThumbnail.prototype,"render").and.callThrough();view.render();expect(RB.ScreenshotThumbnail.prototype.render).toHaveBeenCalled();expect(screenshots.length).toBe(1);expect(screenshots.at(0).id).toBe(42)})});describe("Events",function(){var $thumbnail,screenshot;beforeEach(function(){$thumbnail=$(screenshotThumbnailTemplate({id:42})).appendTo($screenshotsContainer);view.render();screenshot=editor.get("screenshots").at(0)});describe("beginEdit",function(){it("Increment edit count",function(){expect(editor.get("editCount")).toBe(0);$thumbnail.find(".screenshot-caption .edit").inlineEditor("startEdit");expect(editor.get("editCount")).toBe(1)})});describe("endEdit",function(){describe("Decrement edit count",function(){var $caption;beforeEach(function(){expect(editor.get("editCount")).toBe(0);$caption=$thumbnail.find(".screenshot-caption .edit").inlineEditor("startEdit")});it("On cancel",function(){$caption.inlineEditor("cancel");expect(editor.get("editCount")).toBe(0)});it("On submit",function(){spyOn(screenshot,"ready").and.callFake(function(options,context){options.ready.call(context)});spyOn(screenshot,"save");$thumbnail.find("input").val("Foo").triggerHandler("keyup");$caption.inlineEditor("submit");expect(editor.get("editCount")).toBe(0)})})})})});describe("beforeUnload event handler",function(){describe("editable=true",function(){beforeEach(function(){editor.set("statusEditable",true);editor.set("editable",true);expect(editor.get("statusEditable")).toBe(true);expect(editor.get("editable")).toBe(true);expect(editor.get("editCount")).toBe(0)});it("Warn user beforeUnload when editing",function(){view.model.incr("editCount");expect(editor.get("editCount")).toBe(1);expect(view._onBeforeUnload($.Event("beforeunload"))).toBeDefined()});it("Don't warn user beforeUnload when not editing",function(){expect(view._onBeforeUnload($.Event("beforeunload"))).toBeUndefined()})});describe("editable=false",function(){beforeEach(function(){editor.set("statusEditable",false);editor.set("editable",false);expect(editor.get("statusEditable")).toBe(false);expect(editor.get("editable")).toBe(false);expect(editor.get("editCount")).toBe(0)});it("Warn user beforeUnload when editing",function(){view.model.incr("editCount");expect(editor.get("editCount")).toBe(1);expect(view._onBeforeUnload($.Event("beforeunload"))).toBeDefined()});it("Don't warn user beforeUnload when not editing",function(){expect(view._onBeforeUnload($.Event("beforeunload"))).toBeUndefined()})})})});suite("rb/views/ScreenshotThumbnail",function(){var model,view,template=_.template(["<div>",'<a class="edit"></a>','<a class="delete">X</a>',"</div>"].join(""));beforeEach(function(){var $el=$(template()).appendTo($testsScratch);model=new RB.Screenshot;model.url="/screenshots/123/";model.id=123;model.set("loaded",true);view=new RB.ScreenshotThumbnail({el:$el,model:model});view.render();spyOn(model,"trigger").and.callThrough();spyOn(view,"trigger").and.callThrough()});describe("Actions",function(){it("Begin caption editing",function(){view.$caption.inlineEditor("startEdit");expect(view.trigger).toHaveBeenCalledWith("beginEdit")});it("Cancel caption editing",function(){view.$caption.inlineEditor("startEdit");expect(view.trigger).toHaveBeenCalledWith("beginEdit");view.$caption.inlineEditor("cancel");expect(view.trigger).toHaveBeenCalledWith("endEdit")});it("Save caption",function(){spyOn(model,"save");view.$caption.inlineEditor("startEdit");expect(view.trigger).toHaveBeenCalledWith("beginEdit");view.$el.find("input").val("Foo").triggerHandler("keyup");view.$caption.inlineEditor("submit");expect(view.trigger).toHaveBeenCalledWith("endEdit");expect(model.get("caption")).toBe("Foo");expect(model.save).toHaveBeenCalled()});it("Delete",function(){spyOn(model,"destroy").and.callThrough();spyOn($,"ajax").and.callFake(function(options){options.success()});spyOn(view.$el,"fadeOut").and.callFake(function(done){done()});spyOn(view,"remove");view.$el.find("a.delete").click();expect($.ajax).toHaveBeenCalled();expect(model.destroy).toHaveBeenCalled();expect(model.trigger.calls.argsFor(0)[0]).toBe("destroying");expect(view.$el.fadeOut).toHaveBeenCalled();expect(view.remove).toHaveBeenCalled()})})})}).call(this);