# Generated by Django 4.2.16 on 2025-04-10 19:17

import django.core.validators
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("corptools", "0120_corptoolsconfiguration_aggregate_lookback"),
        (
            "fittings",
            "0016_remove_dogmaattribute_type_remove_dogmaeffect_type_and_more",
        ),
        ("eveuniverse", "0010_alter_eveindustryactivityduration_eve_type_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="General",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "permissions": (
                    (
                        "basic_access",
                        "Can access this app and view corporation handouts",
                    ),
                    ("manager", "Can view handouts for all corporations"),
                ),
                "managed": False,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="DoctrineReport",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(help_text="Doctrine name", max_length=50)),
                (
                    "corporation_hangar_division",
                    models.IntegerField(
                        default=1,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(7),
                        ],
                    ),
                ),
                (
                    "corporation",
                    models.ForeignKey(
                        help_text="Corporation to get the assets from",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="corptools.corporationaudit",
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        help_text="Where the doctrine should be located",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="corptools.evelocation",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="FittingReport",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "expected_amount",
                    models.PositiveIntegerField(
                        blank=True,
                        help_text="Amount of fits expected in the corp hangar. Set to 0 to ignore this fit",
                        null=True,
                    ),
                ),
                (
                    "regex",
                    models.CharField(
                        blank=True,
                        help_text="Optional regex to get ships from",
                        max_length=40,
                        null=True,
                    ),
                ),
                (
                    "ok_ships",
                    models.PositiveIntegerField(
                        default=0, help_text="Current amount of ships fitted correctly"
                    ),
                ),
                (
                    "doctrine",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="fittings",
                        to="corphandouts.doctrinereport",
                    ),
                ),
                (
                    "fit",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="fittings.fitting",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="FittingToCorrect",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "item_name",
                    models.CharField(help_text="Name of the ship", max_length=40),
                ),
                ("item_id", models.BigIntegerField(help_text="Item id if the ship§")),
                (
                    "fit",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="fits_to_correct",
                        related_query_name="fit_to_correct",
                        to="corphandouts.fittingreport",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="FittingCorrection",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "correction",
                    models.IntegerField(
                        help_text="Amount to remove/add to the fit to match the template"
                    ),
                ),
                (
                    "correction_type",
                    models.CharField(
                        choices=[("CA", "Cargo"), ("FI", "Fitting")], max_length=2
                    ),
                ),
                (
                    "eve_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="eveuniverse.evetype",
                    ),
                ),
                (
                    "fit_to_correct",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="corrections",
                        related_query_name="correction",
                        to="corphandouts.fittingtocorrect",
                    ),
                ),
            ],
        ),
    ]
