import enumb

__all__ = ['MediaTypeType', 'MediaTypeSubtype', 'MediaTypeSuffix']

class KebabEnum(enumb.Kebab):
    def __repr__(self):
        return repr(self.value)

    def __str__(self):
        return str(self.value)

class MediaTypeType(KebabEnum):
    APPLICATION: str
    AUDIO:       str
    EXAMPLE:     str
    FONT:        str
    IMAGE:       str
    MESSAGE:     str
    MODEL:       str
    MULTIPART:   str
    TEXT:        str
    VIDEO:       str

class MediaTypeSuffix(KebabEnum):
    BER:         str
    CBOR:        str
    CBOR_SEQ:    str
    DER:         str
    FASTINFOSET: str
    GZIP:        str
    JSON:        str
    JSON_SEQ:    str
    JWT:         str
    SQLITE3:     str
    TLV:         str
    WBXML:       str
    XML:         str
    ZIP:         str
    ZSTD:        str

class MediaTypeSubtype(KebabEnum):
    _1D_INTERLEAVED_PARITYFEC                                           : str = '1d-interleaved-parityfec'
    _32KADPCM                                                           : str = '32kadpcm'
    _3GPDASH_QOE_REPORT                                                 : str = '3gpdash-qoe-report'
    _3GPP                                                               : str = '3gpp'
    _3GPP_IMS                                                           : str = '3gpp-ims'
    _3GPP_TT                                                            : str = '3gpp-tt'
    _3GPP2                                                              : str = '3gpp2'
    _3MF                                                                : str = '3mf'
    A2L                                                                 : str = 'a2l'
    AAC                                                                 : str = 'aac'
    AC3                                                                 : str = 'ac3'
    ACES                                                                : str = 'aces'
    ACTIVEMESSAGE                                                       : str = 'activemessage'
    ACTIVITY                                                            : str = 'activity'
    ALTO_COSTMAP                                                        : str = 'alto-costmap'
    ALTO_COSTMAPFILTER                                                  : str = 'alto-costmapfilter'
    ALTO_DIRECTORY                                                      : str = 'alto-directory'
    ALTO_ENDPOINTCOST                                                   : str = 'alto-endpointcost'
    ALTO_ENDPOINTCOSTPARAMS                                             : str = 'alto-endpointcostparams'
    ALTO_ENDPOINTPROP                                                   : str = 'alto-endpointprop'
    ALTO_ENDPOINTPROPPARAMS                                             : str = 'alto-endpointpropparams'
    ALTO_ERROR                                                          : str = 'alto-error'
    ALTO_NETWORKMAP                                                     : str = 'alto-networkmap'
    ALTO_NETWORKMAPFILTER                                               : str = 'alto-networkmapfilter'
    ALTO_UPDATESTREAMCONTROL                                            : str = 'alto-updatestreamcontrol'
    ALTO_UPDATESTREAMPARAMS                                             : str = 'alto-updatestreamparams'
    AML                                                                 : str = 'aml'
    AMR                                                                 : str = 'amr'
    AMR_WB                                                              : str = 'amr-wb'
    ANDREW_INSET                                                        : str = 'andrew-inset'
    APPLEDOUBLE                                                         : str = 'appledouble'
    APPLEFILE                                                           : str = 'applefile'
    APTX                                                                : str = 'aptx'
    ASC                                                                 : str = 'asc'
    ATF                                                                 : str = 'atf'
    ATFX                                                                : str = 'atfx'
    ATOM                                                                : str = 'atom'
    ATOMCAT                                                             : str = 'atomcat'
    ATOMDELETED                                                         : str = 'atomdeleted'
    ATOMICMAIL                                                          : str = 'atomicmail'
    ATOMSVC                                                             : str = 'atomsvc'
    ATRAC_ADVANCED_LOSSLESS                                             : str = 'atrac-advanced-lossless'
    ATRAC_X                                                             : str = 'atrac-x'
    ATRAC3                                                              : str = 'atrac3'
    ATSC_DWD                                                            : str = 'atsc-dwd'
    ATSC_DYNAMIC_EVENT_MESSAGE                                          : str = 'atsc-dynamic-event-message'
    ATSC_HELD                                                           : str = 'atsc-held'
    ATSC_RDT                                                            : str = 'atsc-rdt'
    ATSC_RSAT                                                           : str = 'atsc-rsat'
    ATXML                                                               : str = 'atxml'
    AUTH_POLICY                                                         : str = 'auth-policy'
    AV1                                                                 : str = 'av1'
    AVCI                                                                : str = 'avci'
    AVCS                                                                : str = 'avcs'
    AVIF                                                                : str = 'avif'
    BACNET_XDD                                                          : str = 'bacnet-xdd'
    BASIC                                                               : str = 'basic'
    BATCH_SMTP                                                          : str = 'batch-smtp'
    BEEP                                                                : str = 'beep'
    BMP                                                                 : str = 'bmp'
    BMPEG                                                               : str = 'bmpeg'
    BT656                                                               : str = 'bt656'
    BV16                                                                : str = 'bv16'
    BV32                                                                : str = 'bv32'
    BYTERANGES                                                          : str = 'byteranges'
    CACHE_MANIFEST                                                      : str = 'cache-manifest'
    CALENDAR                                                            : str = 'calendar'
    CALL_COMPLETION                                                     : str = 'call-completion'
    CALS_1840                                                           : str = 'cals-1840'
    CAPTIVE                                                             : str = 'captive'
    CBOR                                                                : str = 'cbor'
    CBOR_SEQ                                                            : str = 'cbor-seq'
    CCCEX                                                               : str = 'cccex'
    CCMP                                                                : str = 'ccmp'
    CCXML                                                               : str = 'ccxml'
    CDFX                                                                : str = 'cdfx'
    CDMI_CAPABILITY                                                     : str = 'cdmi-capability'
    CDMI_CONTAINER                                                      : str = 'cdmi-container'
    CDMI_DOMAIN                                                         : str = 'cdmi-domain'
    CDMI_OBJECT                                                         : str = 'cdmi-object'
    CDMI_QUEUE                                                          : str = 'cdmi-queue'
    CDNI                                                                : str = 'cdni'
    CEA                                                                 : str = 'cea'
    CEA_2018                                                            : str = 'cea-2018'
    CELB                                                                : str = 'celb'
    CELLML                                                              : str = 'cellml'
    CFW                                                                 : str = 'cfw'
    CGM                                                                 : str = 'cgm'
    CLEARMODE                                                           : str = 'clearmode'
    CLR                                                                 : str = 'clr'
    CLUE                                                                : str = 'clue'
    CLUE_INFO                                                           : str = 'clue_info'
    CMS                                                                 : str = 'cms'
    CN                                                                  : str = 'cn'
    CNRP                                                                : str = 'cnrp'
    COAP_GROUP                                                          : str = 'coap-group'
    COAP_PAYLOAD                                                        : str = 'coap-payload'
    COLLECTION                                                          : str = 'collection'
    COMMONGROUND                                                        : str = 'commonground'
    CONFERENCE_INFO                                                     : str = 'conference-info'
    COSE                                                                : str = 'cose'
    COSE_KEY                                                            : str = 'cose-key'
    COSE_KEY_SET                                                        : str = 'cose-key-set'
    CPIM                                                                : str = 'cpim'
    CPL                                                                 : str = 'cpl'
    CQL                                                                 : str = 'cql'
    CQL_EXPRESSION                                                      : str = 'cql-expression'
    CQL_IDENTIFIER                                                      : str = 'cql-identifier'
    CSRATTRS                                                            : str = 'csrattrs'
    CSS                                                                 : str = 'css'
    CSTA                                                                : str = 'csta'
    CSTADATA                                                            : str = 'cstadata'
    CSV                                                                 : str = 'csv'
    CSV_SCHEMA                                                          : str = 'csv-schema'
    CSVM                                                                : str = 'csvm'
    CWT                                                                 : str = 'cwt'
    CYBERCASH                                                           : str = 'cybercash'
    DASH                                                                : str = 'dash'
    DASHDELTA                                                           : str = 'dashdelta'
    DAT12                                                               : str = 'dat12'
    DAVMOUNT                                                            : str = 'davmount'
    DCA_RFT                                                             : str = 'dca-rft'
    DCD                                                                 : str = 'dcd'
    DEC_DX                                                              : str = 'dec-dx'
    DELIVERY_STATUS                                                     : str = 'delivery-status'
    DIALOG_INFO                                                         : str = 'dialog-info'
    DICOM                                                               : str = 'dicom'
    DICOM_RLE                                                           : str = 'dicom-rle'
    DII                                                                 : str = 'dii'
    DIRECTORY                                                           : str = 'directory'
    DISPOSITION_NOTIFICATION                                            : str = 'disposition-notification'
    DIT                                                                 : str = 'dit'
    DLS                                                                 : str = 'dls'
    DNS                                                                 : str = 'dns'
    DNS_MESSAGE                                                         : str = 'dns-message'
    DOTS                                                                : str = 'dots'
    DSKPP                                                               : str = 'dskpp'
    DSR_ES201108                                                        : str = 'dsr-es201108'
    DSR_ES202050                                                        : str = 'dsr-es202050'
    DSR_ES202211                                                        : str = 'dsr-es202211'
    DSR_ES202212                                                        : str = 'dsr-es202212'
    DSSC                                                                : str = 'dssc'
    DV                                                                  : str = 'dv'
    DVCS                                                                : str = 'dvcs'
    DVI4                                                                : str = 'dvi4'
    E57                                                                 : str = 'e57'
    EAC3                                                                : str = 'eac3'
    ECMASCRIPT                                                          : str = 'ecmascript'
    EDI_CONSENT                                                         : str = 'edi-consent'
    EDI_X12                                                             : str = 'edi-x12'
    EDIFACT                                                             : str = 'edifact'
    EFI                                                                 : str = 'efi'
    ELM                                                                 : str = 'elm'
    EMERGENCYCALLDATA_CAP                                               : str = 'emergencycalldata.cap'
    EMERGENCYCALLDATA_COMMENT                                           : str = 'emergencycalldata.comment'
    EMERGENCYCALLDATA_CONTROL                                           : str = 'emergencycalldata.control'
    EMERGENCYCALLDATA_DEVICEINFO                                        : str = 'emergencycalldata.deviceinfo'
    EMERGENCYCALLDATA_ECALL_MSD                                         : str = 'emergencycalldata.ecall.msd'
    EMERGENCYCALLDATA_PROVIDERINFO                                      : str = 'emergencycalldata.providerinfo'
    EMERGENCYCALLDATA_SERVICEINFO                                       : str = 'emergencycalldata.serviceinfo'
    EMERGENCYCALLDATA_SUBSCRIBERINFO                                    : str = 'emergencycalldata.subscriberinfo'
    EMERGENCYCALLDATA_VEDS                                              : str = 'emergencycalldata.veds'
    EMF                                                                 : str = 'emf'
    EMMA                                                                : str = 'emma'
    EMOTIONML                                                           : str = 'emotionml'
    ENCAPRTP                                                            : str = 'encaprtp'
    ENCRYPTED                                                           : str = 'encrypted'
    EPP                                                                 : str = 'epp'
    EPUB                                                                : str = 'epub'
    ESHOP                                                               : str = 'eshop'
    EVRC                                                                : str = 'evrc'
    EVRC_QCP                                                            : str = 'evrc-qcp'
    EVRC0                                                               : str = 'evrc0'
    EVRC1                                                               : str = 'evrc1'
    EVRCB                                                               : str = 'evrcb'
    EVRCB0                                                              : str = 'evrcb0'
    EVRCB1                                                              : str = 'evrcb1'
    EVRCNW                                                              : str = 'evrcnw'
    EVRCNW0                                                             : str = 'evrcnw0'
    EVRCNW1                                                             : str = 'evrcnw1'
    EVRCWB                                                              : str = 'evrcwb'
    EVRCWB0                                                             : str = 'evrcwb0'
    EVRCWB1                                                             : str = 'evrcwb1'
    EVS                                                                 : str = 'evs'
    EXAMPLE                                                             : str = 'example'
    EXI                                                                 : str = 'exi'
    EXPECT_CT_REPORT                                                    : str = 'expect-ct-report'
    FASTINFOSET                                                         : str = 'fastinfoset'
    FASTSOAP                                                            : str = 'fastsoap'
    FDT                                                                 : str = 'fdt'
    FEEDBACK_REPORT                                                     : str = 'feedback-report'
    FFV1                                                                : str = 'ffv1'
    FHIR                                                                : str = 'fhir'
    FHIRPATH                                                            : str = 'fhirpath'
    FITS                                                                : str = 'fits'
    FLEXFEC                                                             : str = 'flexfec'
    FONT_SFNT                                                           : str = 'font-sfnt'
    FONT_TDPFR                                                          : str = 'font-tdpfr'
    FONT_WOFF                                                           : str = 'font-woff'
    FORM_DATA                                                           : str = 'form-data'
    FRAMEWORK_ATTRIBUTES                                                : str = 'framework-attributes'
    FWDRED                                                              : str = 'fwdred'
    G3FAX                                                               : str = 'g3fax'
    G711_0                                                              : str = 'g711-0'
    G719                                                                : str = 'g719'
    G722                                                                : str = 'g722'
    G7221                                                               : str = 'g7221'
    G723                                                                : str = 'g723'
    G726_16                                                             : str = 'g726-16'
    G726_24                                                             : str = 'g726-24'
    G726_32                                                             : str = 'g726-32'
    G726_40                                                             : str = 'g726-40'
    G728                                                                : str = 'g728'
    G729                                                                : str = 'g729'
    G7291                                                               : str = 'g7291'
    G729D                                                               : str = 'g729d'
    G729E                                                               : str = 'g729e'
    GEO                                                                 : str = 'geo'
    GEOPACKAGE                                                          : str = 'geopackage'
    GEOXACML                                                            : str = 'geoxacml'
    GFF3                                                                : str = 'gff3'
    GLOBAL                                                              : str = 'global'
    GLOBAL_DELIVERY_STATUS                                              : str = 'global-delivery-status'
    GLOBAL_DISPOSITION_NOTIFICATION                                     : str = 'global-disposition-notification'
    GLOBAL_HEADERS                                                      : str = 'global-headers'
    GLTF                                                                : str = 'gltf'
    GLTF_BINARY                                                         : str = 'gltf-binary'
    GLTF_BUFFER                                                         : str = 'gltf-buffer'
    GML                                                                 : str = 'gml'
    GRAMMAR_REF_LIST                                                    : str = 'grammar-ref-list'
    GSM                                                                 : str = 'gsm'
    GSM_EFR                                                             : str = 'gsm-efr'
    GSM_HR_08                                                           : str = 'gsm-hr-08'
    GZIP                                                                : str = 'gzip'
    H224                                                                : str = 'h224'
    H261                                                                : str = 'h261'
    H263                                                                : str = 'h263'
    H263_1998                                                           : str = 'h263-1998'
    H263_2000                                                           : str = 'h263-2000'
    H264                                                                : str = 'h264'
    H264_RCDO                                                           : str = 'h264-rcdo'
    H264_SVC                                                            : str = 'h264-svc'
    H265                                                                : str = 'h265'
    HEADER_SET                                                          : str = 'header-set'
    HEIC                                                                : str = 'heic'
    HEIC_SEQUENCE                                                       : str = 'heic-sequence'
    HEIF                                                                : str = 'heif'
    HEIF_SEQUENCE                                                       : str = 'heif-sequence'
    HEJ2K                                                               : str = 'hej2k'
    HELD                                                                : str = 'held'
    HSJ2                                                                : str = 'hsj2'
    HTML                                                                : str = 'html'
    HTTP                                                                : str = 'http'
    HYPERSTUDIO                                                         : str = 'hyperstudio'
    IBE_KEY_REQUEST                                                     : str = 'ibe-key-request'
    IBE_PKG_REPLY                                                       : str = 'ibe-pkg-reply'
    IBE_PP_DATA                                                         : str = 'ibe-pp-data'
    IGES                                                                : str = 'iges'
    ILBC                                                                : str = 'ilbc'
    IM_ISCOMPOSING                                                      : str = 'im-iscomposing'
    IMDN                                                                : str = 'imdn'
    INDEX                                                               : str = 'index'
    INDEX_CMD                                                           : str = 'index.cmd'
    INDEX_OBJ                                                           : str = 'index.obj'
    INDEX_RESPONSE                                                      : str = 'index.response'
    INDEX_VND                                                           : str = 'index.vnd'
    INKML                                                               : str = 'inkml'
    IOTP                                                                : str = 'iotp'
    IP_MR_V2_5                                                          : str = 'ip-mr_v2.5'
    IPFIX                                                               : str = 'ipfix'
    IPP                                                                 : str = 'ipp'
    ISO_SEGMENT                                                         : str = 'iso.segment'
    ISUP                                                                : str = 'isup'
    ITS                                                                 : str = 'its'
    JAVASCRIPT                                                          : str = 'javascript'
    JCR_CND                                                             : str = 'jcr-cnd'
    JF2FEED                                                             : str = 'jf2feed'
    JLS                                                                 : str = 'jls'
    JOSE                                                                : str = 'jose'
    JP2                                                                 : str = 'jp2'
    JPEG                                                                : str = 'jpeg'
    JPEG2000                                                            : str = 'jpeg2000'
    JPH                                                                 : str = 'jph'
    JPHC                                                                : str = 'jphc'
    JPM                                                                 : str = 'jpm'
    JPX                                                                 : str = 'jpx'
    JRD                                                                 : str = 'jrd'
    JSCALENDAR                                                          : str = 'jscalendar'
    JSON                                                                : str = 'json'
    JSON_PATCH                                                          : str = 'json-patch'
    JSON_SEQ                                                            : str = 'json-seq'
    JWK                                                                 : str = 'jwk'
    JWK_SET                                                             : str = 'jwk-set'
    JWT                                                                 : str = 'jwt'
    JXR                                                                 : str = 'jxr'
    JXRA                                                                : str = 'jxra'
    JXRS                                                                : str = 'jxrs'
    JXS                                                                 : str = 'jxs'
    JXSC                                                                : str = 'jxsc'
    JXSI                                                                : str = 'jxsi'
    JXSS                                                                : str = 'jxss'
    KPML_REQUEST                                                        : str = 'kpml-request'
    KPML_RESPONSE                                                       : str = 'kpml-response'
    KTX                                                                 : str = 'ktx'
    KTX2                                                                : str = 'ktx2'
    L16                                                                 : str = 'l16'
    L20                                                                 : str = 'l20'
    L24                                                                 : str = 'l24'
    L8                                                                  : str = 'l8'
    LD                                                                  : str = 'ld'
    LGR                                                                 : str = 'lgr'
    LINK_FORMAT                                                         : str = 'link-format'
    LOAD_CONTROL                                                        : str = 'load-control'
    LOST                                                                : str = 'lost'
    LOSTSYNC                                                            : str = 'lostsync'
    LPC                                                                 : str = 'lpc'
    LPF                                                                 : str = 'lpf'
    LXF                                                                 : str = 'lxf'
    MAC_BINHEX40                                                        : str = 'mac-binhex40'
    MACWRITEII                                                          : str = 'macwriteii'
    MADS                                                                : str = 'mads'
    MARC                                                                : str = 'marc'
    MARCXML                                                             : str = 'marcxml'
    MARKDOWN                                                            : str = 'markdown'
    MATHEMATICA                                                         : str = 'mathematica'
    MATHML                                                              : str = 'mathml'
    MATHML_CONTENT                                                      : str = 'mathml-content'
    MATHML_PRESENTATION                                                 : str = 'mathml-presentation'
    MBMS_ASSOCIATED_PROCEDURE_DESCRIPTION                               : str = 'mbms-associated-procedure-description'
    MBMS_DEREGISTER                                                     : str = 'mbms-deregister'
    MBMS_ENVELOPE                                                       : str = 'mbms-envelope'
    MBMS_MSK                                                            : str = 'mbms-msk'
    MBMS_MSK_RESPONSE                                                   : str = 'mbms-msk-response'
    MBMS_PROTECTION_DESCRIPTION                                         : str = 'mbms-protection-description'
    MBMS_RECEPTION_REPORT                                               : str = 'mbms-reception-report'
    MBMS_REGISTER                                                       : str = 'mbms-register'
    MBMS_REGISTER_RESPONSE                                              : str = 'mbms-register-response'
    MBMS_SCHEDULE                                                       : str = 'mbms-schedule'
    MBMS_USER_SERVICE_DESCRIPTION                                       : str = 'mbms-user-service-description'
    MBOX                                                                : str = 'mbox'
    MEDIA_POLICY_DATASET                                                : str = 'media-policy-dataset'
    MEDIA_CONTROL                                                       : str = 'media_control'
    MEDIASERVERCONTROL                                                  : str = 'mediaservercontrol'
    MELP                                                                : str = 'melp'
    MELP1200                                                            : str = 'melp1200'
    MELP2400                                                            : str = 'melp2400'
    MELP600                                                             : str = 'melp600'
    MERGE_PATCH                                                         : str = 'merge-patch'
    METALINK4                                                           : str = 'metalink4'
    METS                                                                : str = 'mets'
    MF4                                                                 : str = 'mf4'
    MHAS                                                                : str = 'mhas'
    MIKEY                                                               : str = 'mikey'
    MIPC                                                                : str = 'mipc'
    MIZAR                                                               : str = 'mizar'
    MJ2                                                                 : str = 'mj2'
    MMT_AEI                                                             : str = 'mmt-aei'
    MMT_USD                                                             : str = 'mmt-usd'
    MOBILE_XMF                                                          : str = 'mobile-xmf'
    MODS                                                                : str = 'mods'
    MOSS_KEYS                                                           : str = 'moss-keys'
    MOSS_SIGNATURE                                                      : str = 'moss-signature'
    MOSSKEY_DATA                                                        : str = 'mosskey-data'
    MOSSKEY_REQUEST                                                     : str = 'mosskey-request'
    MP1S                                                                : str = 'mp1s'
    MP21                                                                : str = 'mp21'
    MP2P                                                                : str = 'mp2p'
    MP2T                                                                : str = 'mp2t'
    MP4                                                                 : str = 'mp4'
    MP4A_LATM                                                           : str = 'mp4a-latm'
    MP4V_ES                                                             : str = 'mp4v-es'
    MPA                                                                 : str = 'mpa'
    MPA_ROBUST                                                          : str = 'mpa-robust'
    MPEG                                                                : str = 'mpeg'
    MPEG4_GENERIC                                                       : str = 'mpeg4-generic'
    MPEG4_IOD                                                           : str = 'mpeg4-iod'
    MPEG4_IOD_XMT                                                       : str = 'mpeg4-iod-xmt'
    MPV                                                                 : str = 'mpv'
    MRB_CONSUMER                                                        : str = 'mrb-consumer'
    MRB_PUBLISH                                                         : str = 'mrb-publish'
    MSC_IVR                                                             : str = 'msc-ivr'
    MSC_MIXER                                                           : str = 'msc-mixer'
    MSWORD                                                              : str = 'msword'
    MTL                                                                 : str = 'mtl'
    MUD                                                                 : str = 'mud'
    MULTILINGUAL                                                        : str = 'multilingual'
    MULTIPART_CORE                                                      : str = 'multipart-core'
    MXF                                                                 : str = 'mxf'
    N_QUADS                                                             : str = 'n-quads'
    N_TRIPLES                                                           : str = 'n-triples'
    N3                                                                  : str = 'n3'
    NAPLPS                                                              : str = 'naplps'
    NASDATA                                                             : str = 'nasdata'
    NEWS                                                                : str = 'news'
    NEWS_CHECKGROUPS                                                    : str = 'news-checkgroups'
    NEWS_GROUPINFO                                                      : str = 'news-groupinfo'
    NEWS_TRANSMISSION                                                   : str = 'news-transmission'
    NLSML                                                               : str = 'nlsml'
    NODE                                                                : str = 'node'
    NSS                                                                 : str = 'nss'
    NV                                                                  : str = 'nv'
    OAUTH_AUTHZ_REQ                                                     : str = 'oauth-authz-req'
    OBJ                                                                 : str = 'obj'
    OCSP_REQUEST                                                        : str = 'ocsp-request'
    OCSP_RESPONSE                                                       : str = 'ocsp-response'
    OCTET_STREAM                                                        : str = 'octet-stream'
    ODA                                                                 : str = 'oda'
    ODM                                                                 : str = 'odm'
    ODX                                                                 : str = 'odx'
    OEBPS_PACKAGE                                                       : str = 'oebps-package'
    OGG                                                                 : str = 'ogg'
    OPC_NODESET                                                         : str = 'opc-nodeset'
    OPUS                                                                : str = 'opus'
    OSCORE                                                              : str = 'oscore'
    OTF                                                                 : str = 'otf'
    OXPS                                                                : str = 'oxps'
    P2P_OVERLAY                                                         : str = 'p2p-overlay'
    PARAMETERS                                                          : str = 'parameters'
    PARITYFEC                                                           : str = 'parityfec'
    PASSPORT                                                            : str = 'passport'
    PATCH_OPS_ERROR                                                     : str = 'patch-ops-error'
    PCMA                                                                : str = 'pcma'
    PCMA_WB                                                             : str = 'pcma-wb'
    PCMU                                                                : str = 'pcmu'
    PCMU_WB                                                             : str = 'pcmu-wb'
    PDF                                                                 : str = 'pdf'
    PDX                                                                 : str = 'pdx'
    PEM_CERTIFICATE_CHAIN                                               : str = 'pem-certificate-chain'
    PGP_ENCRYPTED                                                       : str = 'pgp-encrypted'
    PGP_KEYS                                                            : str = 'pgp-keys'
    PGP_SIGNATURE                                                       : str = 'pgp-signature'
    PIDF                                                                : str = 'pidf'
    PIDF_DIFF                                                           : str = 'pidf-diff'
    PKCS10                                                              : str = 'pkcs10'
    PKCS12                                                              : str = 'pkcs12'
    PKCS7_MIME                                                          : str = 'pkcs7-mime'
    PKCS7_SIGNATURE                                                     : str = 'pkcs7-signature'
    PKCS8                                                               : str = 'pkcs8'
    PKCS8_ENCRYPTED                                                     : str = 'pkcs8-encrypted'
    PKIX_ATTR_CERT                                                      : str = 'pkix-attr-cert'
    PKIX_CERT                                                           : str = 'pkix-cert'
    PKIX_CRL                                                            : str = 'pkix-crl'
    PKIX_PKIPATH                                                        : str = 'pkix-pkipath'
    PKIXCMP                                                             : str = 'pkixcmp'
    PLS                                                                 : str = 'pls'
    PNG                                                                 : str = 'png'
    POC_SETTINGS                                                        : str = 'poc-settings'
    POINTER                                                             : str = 'pointer'
    POSTSCRIPT                                                          : str = 'postscript'
    PPSP_TRACKER                                                        : str = 'ppsp-tracker'
    PROBLEM                                                             : str = 'problem'
    PROVENANCE                                                          : str = 'provenance'
    PROVENANCE_NOTATION                                                 : str = 'provenance-notation'
    PRS_ALVESTRAND_TITRAX_SHEET                                         : str = 'prs.alvestrand.titrax-sheet'
    PRS_BTIF                                                            : str = 'prs.btif'
    PRS_CWW                                                             : str = 'prs.cww'
    PRS_CYN                                                             : str = 'prs.cyn'
    PRS_FALLENSTEIN_RST                                                 : str = 'prs.fallenstein.rst'
    PRS_HPUB                                                            : str = 'prs.hpub'
    PRS_LINES_TAG                                                       : str = 'prs.lines.tag'
    PRS_NPREND                                                          : str = 'prs.nprend'
    PRS_PLUCKER                                                         : str = 'prs.plucker'
    PRS_PROP_LOGIC                                                      : str = 'prs.prop.logic'
    PRS_PTI                                                             : str = 'prs.pti'
    PRS_RDF_XML_CRYPT                                                   : str = 'prs.rdf-xml-crypt'
    PRS_SID                                                             : str = 'prs.sid'
    PRS_XSF                                                             : str = 'prs.xsf'
    PSKC                                                                : str = 'pskc'
    PVD                                                                 : str = 'pvd'
    PWG_RASTER                                                          : str = 'pwg-raster'
    QSIG                                                                : str = 'qsig'
    QUICKTIME                                                           : str = 'quicktime'
    RAPTORFEC                                                           : str = 'raptorfec'
    RAW                                                                 : str = 'raw'
    RDAP                                                                : str = 'rdap'
    RDF                                                                 : str = 'rdf'
    RED                                                                 : str = 'red'
    REGINFO                                                             : str = 'reginfo'
    RELATED                                                             : str = 'related'
    RELAX_NG_COMPACT_SYNTAX                                             : str = 'relax-ng-compact-syntax'
    REMOTE_PRINTING                                                     : str = 'remote-printing'
    REPORT                                                              : str = 'report'
    REPUTON                                                             : str = 'reputon'
    RESOURCE_LISTS                                                      : str = 'resource-lists'
    RESOURCE_LISTS_DIFF                                                 : str = 'resource-lists-diff'
    RFC                                                                 : str = 'rfc'
    RFC822_HEADERS                                                      : str = 'rfc822-headers'
    RISCOS                                                              : str = 'riscos'
    RLMI                                                                : str = 'rlmi'
    RLS_SERVICES                                                        : str = 'rls-services'
    ROUTE_APD                                                           : str = 'route-apd'
    ROUTE_S_TSID                                                        : str = 'route-s-tsid'
    ROUTE_USD                                                           : str = 'route-usd'
    RPKI_GHOSTBUSTERS                                                   : str = 'rpki-ghostbusters'
    RPKI_MANIFEST                                                       : str = 'rpki-manifest'
    RPKI_PUBLICATION                                                    : str = 'rpki-publication'
    RPKI_ROA                                                            : str = 'rpki-roa'
    RPKI_UPDOWN                                                         : str = 'rpki-updown'
    RTF                                                                 : str = 'rtf'
    RTP_ENC_AESCM128                                                    : str = 'rtp-enc-aescm128'
    RTP_MIDI                                                            : str = 'rtp-midi'
    RTPLOOPBACK                                                         : str = 'rtploopback'
    RTX                                                                 : str = 'rtx'
    S_HTTP                                                              : str = 's-http'
    SAMLASSERTION                                                       : str = 'samlassertion'
    SAMLMETADATA                                                        : str = 'samlmetadata'
    SARIF                                                               : str = 'sarif'
    SARIF_EXTERNAL_PROPERTIES                                           : str = 'sarif-external-properties'
    SBE                                                                 : str = 'sbe'
    SBML                                                                : str = 'sbml'
    SCAIP                                                               : str = 'scaip'
    SCIM                                                                : str = 'scim'
    SCIP                                                                : str = 'scip'
    SCVP_CV_REQUEST                                                     : str = 'scvp-cv-request'
    SCVP_CV_RESPONSE                                                    : str = 'scvp-cv-response'
    SCVP_VP_REQUEST                                                     : str = 'scvp-vp-request'
    SCVP_VP_RESPONSE                                                    : str = 'scvp-vp-response'
    SDP                                                                 : str = 'sdp'
    SECEVENT                                                            : str = 'secevent'
    SENML                                                               : str = 'senml'
    SENML_ETCH                                                          : str = 'senml-etch'
    SENML_EXI                                                           : str = 'senml-exi'
    SENSML                                                              : str = 'sensml'
    SENSML_EXI                                                          : str = 'sensml-exi'
    SEP                                                                 : str = 'sep'
    SEP_EXI                                                             : str = 'sep-exi'
    SESSION_INFO                                                        : str = 'session-info'
    SET_PAYMENT                                                         : str = 'set-payment'
    SET_PAYMENT_INITIATION                                              : str = 'set-payment-initiation'
    SET_REGISTRATION                                                    : str = 'set-registration'
    SET_REGISTRATION_INITIATION                                         : str = 'set-registration-initiation'
    SFNT                                                                : str = 'sfnt'
    SGML                                                                : str = 'sgml'
    SGML_OPEN_CATALOG                                                   : str = 'sgml-open-catalog'
    SHACLC                                                              : str = 'shaclc'
    SHF                                                                 : str = 'shf'
    SIEVE                                                               : str = 'sieve'
    SIGNED                                                              : str = 'signed'
    SIMPLE_FILTER                                                       : str = 'simple-filter'
    SIMPLE_MESSAGE_SUMMARY                                              : str = 'simple-message-summary'
    SIMPLESYMBOLCONTAINER                                               : str = 'simplesymbolcontainer'
    SIP                                                                 : str = 'sip'
    SIPC                                                                : str = 'sipc'
    SIPFRAG                                                             : str = 'sipfrag'
    SLATE                                                               : str = 'slate'
    SMIL                                                                : str = 'smil'
    SMPTE291                                                            : str = 'smpte291'
    SMPTE292M                                                           : str = 'smpte292m'
    SMPTE336M                                                           : str = 'smpte336m'
    SMV                                                                 : str = 'smv'
    SMV_QCP                                                             : str = 'smv-qcp'
    SMV0                                                                : str = 'smv0'
    SOAP                                                                : str = 'soap'
    SOFA                                                                : str = 'sofa'
    SP_MIDI                                                             : str = 'sp-midi'
    SPARQL_QUERY                                                        : str = 'sparql-query'
    SPARQL_RESULTS                                                      : str = 'sparql-results'
    SPDX                                                                : str = 'spdx'
    SPEEX                                                               : str = 'speex'
    SPIRITS_EVENT                                                       : str = 'spirits-event'
    SQL                                                                 : str = 'sql'
    SRGS                                                                : str = 'srgs'
    SRU                                                                 : str = 'sru'
    SSML                                                                : str = 'ssml'
    STIX                                                                : str = 'stix'
    STL                                                                 : str = 'stl'
    STRINGS                                                             : str = 'strings'
    SVG                                                                 : str = 'svg'
    SWID                                                                : str = 'swid'
    T140                                                                : str = 't140'
    T140C                                                               : str = 't140c'
    T38                                                                 : str = 't38'
    TAB_SEPARATED_VALUES                                                : str = 'tab-separated-values'
    TAMP_APEX_UPDATE                                                    : str = 'tamp-apex-update'
    TAMP_APEX_UPDATE_CONFIRM                                            : str = 'tamp-apex-update-confirm'
    TAMP_COMMUNITY_UPDATE                                               : str = 'tamp-community-update'
    TAMP_COMMUNITY_UPDATE_CONFIRM                                       : str = 'tamp-community-update-confirm'
    TAMP_ERROR                                                          : str = 'tamp-error'
    TAMP_SEQUENCE_ADJUST                                                : str = 'tamp-sequence-adjust'
    TAMP_SEQUENCE_ADJUST_CONFIRM                                        : str = 'tamp-sequence-adjust-confirm'
    TAMP_STATUS_QUERY                                                   : str = 'tamp-status-query'
    TAMP_STATUS_RESPONSE                                                : str = 'tamp-status-response'
    TAMP_UPDATE                                                         : str = 'tamp-update'
    TAMP_UPDATE_CONFIRM                                                 : str = 'tamp-update-confirm'
    TAXII                                                               : str = 'taxii'
    TD                                                                  : str = 'td'
    TEI                                                                 : str = 'tei'
    TELEPHONE_EVENT                                                     : str = 'telephone-event'
    TETRA_ACELP                                                         : str = 'tetra_acelp'
    TETRA_ACELP_BB                                                      : str = 'tetra_acelp_bb'
    TETRA_ISI                                                           : str = 'tetra_isi'
    THRAUD                                                              : str = 'thraud'
    TIFF                                                                : str = 'tiff'
    TIFF_FX                                                             : str = 'tiff-fx'
    TIMESTAMP_QUERY                                                     : str = 'timestamp-query'
    TIMESTAMP_REPLY                                                     : str = 'timestamp-reply'
    TIMESTAMPED_DATA                                                    : str = 'timestamped-data'
    TLSRPT                                                              : str = 'tlsrpt'
    TNAUTHLIST                                                          : str = 'tnauthlist'
    TONE                                                                : str = 'tone'
    TRACKING_STATUS                                                     : str = 'tracking-status'
    TRICKLE_ICE_SDPFRAG                                                 : str = 'trickle-ice-sdpfrag'
    TRIG                                                                : str = 'trig'
    TROFF                                                               : str = 'troff'
    TSVCIS                                                              : str = 'tsvcis'
    TTF                                                                 : str = 'ttf'
    TTML                                                                : str = 'ttml'
    TURTLE                                                              : str = 'turtle'
    TVE_TRIGGER                                                         : str = 'tve-trigger'
    TZIF                                                                : str = 'tzif'
    TZIF_LEAP                                                           : str = 'tzif-leap'
    UEMCLIP                                                             : str = 'uemclip'
    ULPFEC                                                              : str = 'ulpfec'
    URC_GRPSHEET                                                        : str = 'urc-grpsheet'
    URC_RESSHEET                                                        : str = 'urc-ressheet'
    URC_TARGETDESC                                                      : str = 'urc-targetdesc'
    URC_UISOCKETDESC                                                    : str = 'urc-uisocketdesc'
    URI_LIST                                                            : str = 'uri-list'
    USAC                                                                : str = 'usac'
    VC1                                                                 : str = 'vc1'
    VC2                                                                 : str = 'vc2'
    VCARD                                                               : str = 'vcard'
    VDVI                                                                : str = 'vdvi'
    VEMMI                                                               : str = 'vemmi'
    VMR_WB                                                              : str = 'vmr-wb'
    VND_1000MINDS_DECISION_MODEL                                        : str = 'vnd.1000minds.decision-model'
    VND_3GPP_PROSE                                                      : str = 'vnd.3gpp-prose'
    VND_3GPP_PROSE_PC3CH                                                : str = 'vnd.3gpp-prose-pc3ch'
    VND_3GPP_V2X_LOCAL_SERVICE_INFORMATION                              : str = 'vnd.3gpp-v2x-local-service-information'
    VND_3GPP_5GNAS                                                      : str = 'vnd.3gpp.5gnas'
    VND_3GPP_ACCESS_TRANSFER_EVENTS                                     : str = 'vnd.3gpp.access-transfer-events'
    VND_3GPP_BSF                                                        : str = 'vnd.3gpp.bsf'
    VND_3GPP_GMOP                                                       : str = 'vnd.3gpp.gmop'
    VND_3GPP_GTPC                                                       : str = 'vnd.3gpp.gtpc'
    VND_3GPP_INTERWORKING_DATA                                          : str = 'vnd.3gpp.interworking-data'
    VND_3GPP_IUFP                                                       : str = 'vnd.3gpp.iufp'
    VND_3GPP_LPP                                                        : str = 'vnd.3gpp.lpp'
    VND_3GPP_MC_SIGNALLING_EAR                                          : str = 'vnd.3gpp.mc-signalling-ear'
    VND_3GPP_MCDATA_AFFILIATION_COMMAND                                 : str = 'vnd.3gpp.mcdata-affiliation-command'
    VND_3GPP_MCDATA_INFO                                                : str = 'vnd.3gpp.mcdata-info'
    VND_3GPP_MCDATA_PAYLOAD                                             : str = 'vnd.3gpp.mcdata-payload'
    VND_3GPP_MCDATA_SERVICE_CONFIG                                      : str = 'vnd.3gpp.mcdata-service-config'
    VND_3GPP_MCDATA_SIGNALLING                                          : str = 'vnd.3gpp.mcdata-signalling'
    VND_3GPP_MCDATA_UE_CONFIG                                           : str = 'vnd.3gpp.mcdata-ue-config'
    VND_3GPP_MCDATA_USER_PROFILE                                        : str = 'vnd.3gpp.mcdata-user-profile'
    VND_3GPP_MCPTT_AFFILIATION_COMMAND                                  : str = 'vnd.3gpp.mcptt-affiliation-command'
    VND_3GPP_MCPTT_FLOOR_REQUEST                                        : str = 'vnd.3gpp.mcptt-floor-request'
    VND_3GPP_MCPTT_INFO                                                 : str = 'vnd.3gpp.mcptt-info'
    VND_3GPP_MCPTT_LOCATION_INFO                                        : str = 'vnd.3gpp.mcptt-location-info'
    VND_3GPP_MCPTT_MBMS_USAGE_INFO                                      : str = 'vnd.3gpp.mcptt-mbms-usage-info'
    VND_3GPP_MCPTT_SERVICE_CONFIG                                       : str = 'vnd.3gpp.mcptt-service-config'
    VND_3GPP_MCPTT_SIGNED                                               : str = 'vnd.3gpp.mcptt-signed'
    VND_3GPP_MCPTT_UE_CONFIG                                            : str = 'vnd.3gpp.mcptt-ue-config'
    VND_3GPP_MCPTT_UE_INIT_CONFIG                                       : str = 'vnd.3gpp.mcptt-ue-init-config'
    VND_3GPP_MCPTT_USER_PROFILE                                         : str = 'vnd.3gpp.mcptt-user-profile'
    VND_3GPP_MCVIDEO_AFFILIATION_COMMAND                                : str = 'vnd.3gpp.mcvideo-affiliation-command'
    VND_3GPP_MCVIDEO_AFFILIATION_INFO                                   : str = 'vnd.3gpp.mcvideo-affiliation-info'
    VND_3GPP_MCVIDEO_INFO                                               : str = 'vnd.3gpp.mcvideo-info'
    VND_3GPP_MCVIDEO_LOCATION_INFO                                      : str = 'vnd.3gpp.mcvideo-location-info'
    VND_3GPP_MCVIDEO_MBMS_USAGE_INFO                                    : str = 'vnd.3gpp.mcvideo-mbms-usage-info'
    VND_3GPP_MCVIDEO_SERVICE_CONFIG                                     : str = 'vnd.3gpp.mcvideo-service-config'
    VND_3GPP_MCVIDEO_TRANSMISSION_REQUEST                               : str = 'vnd.3gpp.mcvideo-transmission-request'
    VND_3GPP_MCVIDEO_UE_CONFIG                                          : str = 'vnd.3gpp.mcvideo-ue-config'
    VND_3GPP_MCVIDEO_USER_PROFILE                                       : str = 'vnd.3gpp.mcvideo-user-profile'
    VND_3GPP_MID_CALL                                                   : str = 'vnd.3gpp.mid-call'
    VND_3GPP_NGAP                                                       : str = 'vnd.3gpp.ngap'
    VND_3GPP_PFCP                                                       : str = 'vnd.3gpp.pfcp'
    VND_3GPP_PIC_BW_LARGE                                               : str = 'vnd.3gpp.pic-bw-large'
    VND_3GPP_PIC_BW_SMALL                                               : str = 'vnd.3gpp.pic-bw-small'
    VND_3GPP_PIC_BW_VAR                                                 : str = 'vnd.3gpp.pic-bw-var'
    VND_3GPP_S1AP                                                       : str = 'vnd.3gpp.s1ap'
    VND_3GPP_SMS                                                        : str = 'vnd.3gpp.sms'
    VND_3GPP_SRVCC_EXT                                                  : str = 'vnd.3gpp.srvcc-ext'
    VND_3GPP_SRVCC_INFO                                                 : str = 'vnd.3gpp.srvcc-info'
    VND_3GPP_STATE_AND_EVENT_INFO                                       : str = 'vnd.3gpp.state-and-event-info'
    VND_3GPP_USSD                                                       : str = 'vnd.3gpp.ussd'
    VND_3GPP2_BCMCSINFO                                                 : str = 'vnd.3gpp2.bcmcsinfo'
    VND_3GPP2_SMS                                                       : str = 'vnd.3gpp2.sms'
    VND_3GPP2_TCAP                                                      : str = 'vnd.3gpp2.tcap'
    VND_3LIGHTSSOFTWARE_IMAGESCAL                                       : str = 'vnd.3lightssoftware.imagescal'
    VND_3M_POST_IT_NOTES                                                : str = 'vnd.3m.post-it-notes'
    VND_4SB                                                             : str = 'vnd.4sb'
    VND_A                                                               : str = 'vnd.a'
    VND_ABC                                                             : str = 'vnd.abc'
    VND_ACCPAC_SIMPLY_ASO                                               : str = 'vnd.accpac.simply.aso'
    VND_ACCPAC_SIMPLY_IMP                                               : str = 'vnd.accpac.simply.imp'
    VND_ACUCOBOL                                                        : str = 'vnd.acucobol'
    VND_ACUCORP                                                         : str = 'vnd.acucorp'
    VND_ADOBE_FLASH_MOVIE                                               : str = 'vnd.adobe.flash.movie'
    VND_ADOBE_FORMSCENTRAL_FCDT                                         : str = 'vnd.adobe.formscentral.fcdt'
    VND_ADOBE_FXP                                                       : str = 'vnd.adobe.fxp'
    VND_ADOBE_PARTIAL_UPLOAD                                            : str = 'vnd.adobe.partial-upload'
    VND_ADOBE_PHOTOSHOP                                                 : str = 'vnd.adobe.photoshop'
    VND_ADOBE_XDP                                                       : str = 'vnd.adobe.xdp'
    VND_ADOBE_XFDF                                                      : str = 'vnd.adobe.xfdf'
    VND_AETHER_IMP                                                      : str = 'vnd.aether.imp'
    VND_AFPC_AFPLINEDATA                                                : str = 'vnd.afpc.afplinedata'
    VND_AFPC_AFPLINEDATA_PAGEDEF                                        : str = 'vnd.afpc.afplinedata-pagedef'
    VND_AFPC_CMOCA_CMRESOURCE                                           : str = 'vnd.afpc.cmoca-cmresource'
    VND_AFPC_FOCA_CHARSET                                               : str = 'vnd.afpc.foca-charset'
    VND_AFPC_FOCA_CODEDFONT                                             : str = 'vnd.afpc.foca-codedfont'
    VND_AFPC_FOCA_CODEPAGE                                              : str = 'vnd.afpc.foca-codepage'
    VND_AFPC_MODCA                                                      : str = 'vnd.afpc.modca'
    VND_AFPC_MODCA_CMTABLE                                              : str = 'vnd.afpc.modca-cmtable'
    VND_AFPC_MODCA_FORMDEF                                              : str = 'vnd.afpc.modca-formdef'
    VND_AFPC_MODCA_MEDIUMMAP                                            : str = 'vnd.afpc.modca-mediummap'
    VND_AFPC_MODCA_OBJECTCONTAINER                                      : str = 'vnd.afpc.modca-objectcontainer'
    VND_AFPC_MODCA_OVERLAY                                              : str = 'vnd.afpc.modca-overlay'
    VND_AFPC_MODCA_PAGESEGMENT                                          : str = 'vnd.afpc.modca-pagesegment'
    VND_AH_BARCODE                                                      : str = 'vnd.ah-barcode'
    VND_AHEAD_SPACE                                                     : str = 'vnd.ahead.space'
    VND_AIRZIP_ACCELERATOR_AZV                                          : str = 'vnd.airzip.accelerator.azv'
    VND_AIRZIP_FILESECURE_AZF                                           : str = 'vnd.airzip.filesecure.azf'
    VND_AIRZIP_FILESECURE_AZS                                           : str = 'vnd.airzip.filesecure.azs'
    VND_AMADEUS                                                         : str = 'vnd.amadeus'
    VND_AMAZON_MOBI8_EBOOK                                              : str = 'vnd.amazon.mobi8-ebook'
    VND_AMERICANDYNAMICS_ACC                                            : str = 'vnd.americandynamics.acc'
    VND_AMIGA_AMI                                                       : str = 'vnd.amiga.ami'
    VND_AMUNDSEN_MAZE                                                   : str = 'vnd.amundsen.maze'
    VND_ANDROID_OTA                                                     : str = 'vnd.android.ota'
    VND_ANKI                                                            : str = 'vnd.anki'
    VND_ANSER_WEB_CERTIFICATE_ISSUE_INITIATION                          : str = 'vnd.anser-web-certificate-issue-initiation'
    VND_ANTIX_GAME_COMPONENT                                            : str = 'vnd.antix.game-component'
    VND_APACHE_THRIFT_BINARY                                            : str = 'vnd.apache.thrift.binary'
    VND_APACHE_THRIFT_COMPACT                                           : str = 'vnd.apache.thrift.compact'
    VND_APACHE_THRIFT_JSON                                              : str = 'vnd.apache.thrift.json'
    VND_API                                                             : str = 'vnd.api'
    VND_APLEXTOR_WARRP                                                  : str = 'vnd.aplextor.warrp'
    VND_APOTHEKENDE_RESERVATION                                         : str = 'vnd.apothekende.reservation'
    VND_APPLE_INSTALLER                                                 : str = 'vnd.apple.installer'
    VND_APPLE_KEYNOTE                                                   : str = 'vnd.apple.keynote'
    VND_APPLE_MPEGURL                                                   : str = 'vnd.apple.mpegurl'
    VND_APPLE_NUMBERS                                                   : str = 'vnd.apple.numbers'
    VND_APPLE_PAGES                                                     : str = 'vnd.apple.pages'
    VND_ARASTRA_SWI                                                     : str = 'vnd.arastra.swi'
    VND_ARISTANETWORKS_SWI                                              : str = 'vnd.aristanetworks.swi'
    VND_ARTISAN                                                         : str = 'vnd.artisan'
    VND_ARTSQUARE                                                       : str = 'vnd.artsquare'
    VND_ASCII_ART                                                       : str = 'vnd.ascii-art'
    VND_ASTRAEA_SOFTWARE_IOTA                                           : str = 'vnd.astraea-software.iota'
    VND_AUDIOGRAPH                                                      : str = 'vnd.audiograph'
    VND_AUDIOKOZ                                                        : str = 'vnd.audiokoz'
    VND_AUTOPACKAGE                                                     : str = 'vnd.autopackage'
    VND_AVALON                                                          : str = 'vnd.avalon'
    VND_AVISTAR                                                         : str = 'vnd.avistar'
    VND_BALSAMIQ_BMML                                                   : str = 'vnd.balsamiq.bmml'
    VND_BALSAMIQ_BMPR                                                   : str = 'vnd.balsamiq.bmpr'
    VND_BANANA_ACCOUNTING                                               : str = 'vnd.banana-accounting'
    VND_BBF_USP_ERROR                                                   : str = 'vnd.bbf.usp.error'
    VND_BBF_USP_MSG                                                     : str = 'vnd.bbf.usp.msg'
    VND_BEKITZUR_STECH                                                  : str = 'vnd.bekitzur-stech'
    VND_BINT_MED_CONTENT                                                : str = 'vnd.bint.med-content'
    VND_BINT_MED_PLUS                                                   : str = 'vnd.bint.med-plus'
    VND_BIOPAX_RDF                                                      : str = 'vnd.biopax.rdf'
    VND_BLINK_IDB_VALUE_WRAPPER                                         : str = 'vnd.blink-idb-value-wrapper'
    VND_BLUEICE_MULTIPASS                                               : str = 'vnd.blueice.multipass'
    VND_BLUETOOTH_EP_OOB                                                : str = 'vnd.bluetooth.ep.oob'
    VND_BLUETOOTH_LE_OOB                                                : str = 'vnd.bluetooth.le.oob'
    VND_BMI                                                             : str = 'vnd.bmi'
    VND_BPF                                                             : str = 'vnd.bpf'
    VND_BPF3                                                            : str = 'vnd.bpf3'
    VND_BUSINESSOBJECTS                                                 : str = 'vnd.businessobjects'
    VND_BYU_UAPI                                                        : str = 'vnd.byu.uapi'
    VND_CAB_JSCRIPT                                                     : str = 'vnd.cab-jscript'
    VND_CANON_CPDL                                                      : str = 'vnd.canon-cpdl'
    VND_CANON_LIPS                                                      : str = 'vnd.canon-lips'
    VND_CAPASYSTEMS_PG                                                  : str = 'vnd.capasystems-pg'
    VND_CCTV                                                            : str = 'vnd.cctv'
    VND_CELP                                                            : str = 'vnd.celp'
    VND_CENDIO_THINLINC_CLIENTCONF                                      : str = 'vnd.cendio.thinlinc.clientconf'
    VND_CENTURY_SYSTEMS_TCP_STREAM                                      : str = 'vnd.century-systems.tcp_stream'
    VND_CHEMDRAW                                                        : str = 'vnd.chemdraw'
    VND_CHESS_PGN                                                       : str = 'vnd.chess-pgn'
    VND_CHIPNUTS_KARAOKE_MMD                                            : str = 'vnd.chipnuts.karaoke-mmd'
    VND_CIEDI                                                           : str = 'vnd.ciedi'
    VND_CINDERELLA                                                      : str = 'vnd.cinderella'
    VND_CIRPACK_ISDN_EXT                                                : str = 'vnd.cirpack.isdn-ext'
    VND_CISCO_NSE                                                       : str = 'vnd.cisco.nse'
    VND_CITATIONSTYLES_STYLE                                            : str = 'vnd.citationstyles.style'
    VND_CLAYMORE                                                        : str = 'vnd.claymore'
    VND_CLOANTO_RP9                                                     : str = 'vnd.cloanto.rp9'
    VND_CLONK_C4GROUP                                                   : str = 'vnd.clonk.c4group'
    VND_CLUETRUST_CARTOMOBILE_CONFIG                                    : str = 'vnd.cluetrust.cartomobile-config'
    VND_CLUETRUST_CARTOMOBILE_CONFIG_PKG                                : str = 'vnd.cluetrust.cartomobile-config-pkg'
    VND_CMLES_RADIO_EVENTS                                              : str = 'vnd.cmles.radio-events'
    VND_CNS_ANP1                                                        : str = 'vnd.cns.anp1'
    VND_CNS_INF1                                                        : str = 'vnd.cns.inf1'
    VND_CNS_INF2                                                        : str = 'vnd.cns.inf2'
    VND_COFFEESCRIPT                                                    : str = 'vnd.coffeescript'
    VND_COLLABIO_XODOCUMENTS_DOCUMENT                                   : str = 'vnd.collabio.xodocuments.document'
    VND_COLLABIO_XODOCUMENTS_DOCUMENT_TEMPLATE                          : str = 'vnd.collabio.xodocuments.document-template'
    VND_COLLABIO_XODOCUMENTS_PRESENTATION                               : str = 'vnd.collabio.xodocuments.presentation'
    VND_COLLABIO_XODOCUMENTS_PRESENTATION_TEMPLATE                      : str = 'vnd.collabio.xodocuments.presentation-template'
    VND_COLLABIO_XODOCUMENTS_SPREADSHEET                                : str = 'vnd.collabio.xodocuments.spreadsheet'
    VND_COLLABIO_XODOCUMENTS_SPREADSHEET_TEMPLATE                       : str = 'vnd.collabio.xodocuments.spreadsheet-template'
    VND_COLLADA                                                         : str = 'vnd.collada'
    VND_COLLECTION                                                      : str = 'vnd.collection'
    VND_COLLECTION_DOC                                                  : str = 'vnd.collection.doc'
    VND_COLLECTION_NEXT                                                 : str = 'vnd.collection.next'
    VND_COMICBOOK                                                       : str = 'vnd.comicbook'
    VND_COMICBOOK_RAR                                                   : str = 'vnd.comicbook-rar'
    VND_COMMERCE_BATTELLE                                               : str = 'vnd.commerce-battelle'
    VND_COMMONSPACE                                                     : str = 'vnd.commonspace'
    VND_CONTACT_CMSG                                                    : str = 'vnd.contact.cmsg'
    VND_COREOS_IGNITION                                                 : str = 'vnd.coreos.ignition'
    VND_COSMOCALLER                                                     : str = 'vnd.cosmocaller'
    VND_CRICK_CLICKER                                                   : str = 'vnd.crick.clicker'
    VND_CRICK_CLICKER_KEYBOARD                                          : str = 'vnd.crick.clicker.keyboard'
    VND_CRICK_CLICKER_PALETTE                                           : str = 'vnd.crick.clicker.palette'
    VND_CRICK_CLICKER_TEMPLATE                                          : str = 'vnd.crick.clicker.template'
    VND_CRICK_CLICKER_WORDBANK                                          : str = 'vnd.crick.clicker.wordbank'
    VND_CRITICALTOOLS_WBS                                               : str = 'vnd.criticaltools.wbs'
    VND_CRYPTII_PIPE                                                    : str = 'vnd.cryptii.pipe'
    VND_CRYPTO_SHADE_FILE                                               : str = 'vnd.crypto-shade-file'
    VND_CRYPTOMATOR_ENCRYPTED                                           : str = 'vnd.cryptomator.encrypted'
    VND_CRYPTOMATOR_VAULT                                               : str = 'vnd.cryptomator.vault'
    VND_CTC_POSML                                                       : str = 'vnd.ctc-posml'
    VND_CTCT_WS                                                         : str = 'vnd.ctct.ws'
    VND_CUPS_PDF                                                        : str = 'vnd.cups-pdf'
    VND_CUPS_POSTSCRIPT                                                 : str = 'vnd.cups-postscript'
    VND_CUPS_PPD                                                        : str = 'vnd.cups-ppd'
    VND_CUPS_RASTER                                                     : str = 'vnd.cups-raster'
    VND_CUPS_RAW                                                        : str = 'vnd.cups-raw'
    VND_CURL                                                            : str = 'vnd.curl'
    VND_CYAN_DEAN_ROOT                                                  : str = 'vnd.cyan.dean.root'
    VND_CYBANK                                                          : str = 'vnd.cybank'
    VND_CYCLONEDX                                                       : str = 'vnd.cyclonedx'
    VND_D2L_COURSEPACKAGE1P0                                            : str = 'vnd.d2l.coursepackage1p0'
    VND_D3M_DATASET                                                     : str = 'vnd.d3m-dataset'
    VND_D3M_PROBLEM                                                     : str = 'vnd.d3m-problem'
    VND_DART                                                            : str = 'vnd.dart'
    VND_DATA_VISION_RDZ                                                 : str = 'vnd.data-vision.rdz'
    VND_DATAPACKAGE                                                     : str = 'vnd.datapackage'
    VND_DATARESOURCE                                                    : str = 'vnd.dataresource'
    VND_DBF                                                             : str = 'vnd.dbf'
    VND_DEBIAN_BINARY_PACKAGE                                           : str = 'vnd.debian.binary-package'
    VND_DEBIAN_COPYRIGHT                                                : str = 'vnd.debian.copyright'
    VND_DECE_AUDIO                                                      : str = 'vnd.dece.audio'
    VND_DECE_DATA                                                       : str = 'vnd.dece.data'
    VND_DECE_GRAPHIC                                                    : str = 'vnd.dece.graphic'
    VND_DECE_HD                                                         : str = 'vnd.dece.hd'
    VND_DECE_MOBILE                                                     : str = 'vnd.dece.mobile'
    VND_DECE_MP4                                                        : str = 'vnd.dece.mp4'
    VND_DECE_PD                                                         : str = 'vnd.dece.pd'
    VND_DECE_SD                                                         : str = 'vnd.dece.sd'
    VND_DECE_TTML                                                       : str = 'vnd.dece.ttml'
    VND_DECE_UNSPECIFIED                                                : str = 'vnd.dece.unspecified'
    VND_DECE_VIDEO                                                      : str = 'vnd.dece.video'
    VND_DECE_ZIP                                                        : str = 'vnd.dece.zip'
    VND_DENOVO_FCSELAYOUT_LINK                                          : str = 'vnd.denovo.fcselayout-link'
    VND_DESMUME_MOVIE                                                   : str = 'vnd.desmume.movie'
    VND_DIGITAL_WINDS                                                   : str = 'vnd.digital-winds'
    VND_DIR_BI_PLATE_DL_NOSUFFIX                                        : str = 'vnd.dir-bi.plate-dl-nosuffix'
    VND_DIRECTV_MPEG                                                    : str = 'vnd.directv.mpeg'
    VND_DIRECTV_MPEG_TTS                                                : str = 'vnd.directv.mpeg-tts'
    VND_DJVU                                                            : str = 'vnd.djvu'
    VND_DLNA_ADTS                                                       : str = 'vnd.dlna.adts'
    VND_DLNA_MPEG_TTS                                                   : str = 'vnd.dlna.mpeg-tts'
    VND_DM_DELEGATION                                                   : str = 'vnd.dm.delegation'
    VND_DMCLIENTSCRIPT                                                  : str = 'vnd.dmclientscript'
    VND_DNA                                                             : str = 'vnd.dna'
    VND_DOCUMENT                                                        : str = 'vnd.document'
    VND_DOLBY_HEAAC_1                                                   : str = 'vnd.dolby.heaac.1'
    VND_DOLBY_HEAAC_2                                                   : str = 'vnd.dolby.heaac.2'
    VND_DOLBY_MLP                                                       : str = 'vnd.dolby.mlp'
    VND_DOLBY_MOBILE_1                                                  : str = 'vnd.dolby.mobile.1'
    VND_DOLBY_MOBILE_2                                                  : str = 'vnd.dolby.mobile.2'
    VND_DOLBY_MPS                                                       : str = 'vnd.dolby.mps'
    VND_DOLBY_PL2                                                       : str = 'vnd.dolby.pl2'
    VND_DOLBY_PL2X                                                      : str = 'vnd.dolby.pl2x'
    VND_DOLBY_PL2Z                                                      : str = 'vnd.dolby.pl2z'
    VND_DOLBY_PULSE_1                                                   : str = 'vnd.dolby.pulse.1'
    VND_DOREMIR_SCORECLOUD_BINARY_DOCUMENT                              : str = 'vnd.doremir.scorecloud-binary-document'
    VND_DPGRAPH                                                         : str = 'vnd.dpgraph'
    VND_DRA                                                             : str = 'vnd.dra'
    VND_DREAMFACTORY                                                    : str = 'vnd.dreamfactory'
    VND_DRIVE                                                           : str = 'vnd.drive'
    VND_DTG_LOCAL                                                       : str = 'vnd.dtg.local'
    VND_DTG_LOCAL_FLASH                                                 : str = 'vnd.dtg.local.flash'
    VND_DTG_LOCAL_HTML                                                  : str = 'vnd.dtg.local.html'
    VND_DTS                                                             : str = 'vnd.dts'
    VND_DTS_HD                                                          : str = 'vnd.dts.hd'
    VND_DTS_UHD                                                         : str = 'vnd.dts.uhd'
    VND_DVB_AIT                                                         : str = 'vnd.dvb.ait'
    VND_DVB_DVBISL                                                      : str = 'vnd.dvb.dvbisl'
    VND_DVB_DVBJ                                                        : str = 'vnd.dvb.dvbj'
    VND_DVB_ESGCONTAINER                                                : str = 'vnd.dvb.esgcontainer'
    VND_DVB_FILE                                                        : str = 'vnd.dvb.file'
    VND_DVB_IPDCDFTNOTIFACCESS                                          : str = 'vnd.dvb.ipdcdftnotifaccess'
    VND_DVB_IPDCESGACCESS                                               : str = 'vnd.dvb.ipdcesgaccess'
    VND_DVB_IPDCESGACCESS2                                              : str = 'vnd.dvb.ipdcesgaccess2'
    VND_DVB_IPDCESGPDD                                                  : str = 'vnd.dvb.ipdcesgpdd'
    VND_DVB_IPDCROAMING                                                 : str = 'vnd.dvb.ipdcroaming'
    VND_DVB_IPTV_ALFEC_BASE                                             : str = 'vnd.dvb.iptv.alfec-base'
    VND_DVB_IPTV_ALFEC_ENHANCEMENT                                      : str = 'vnd.dvb.iptv.alfec-enhancement'
    VND_DVB_NOTIF_AGGREGATE_ROOT                                        : str = 'vnd.dvb.notif-aggregate-root'
    VND_DVB_NOTIF_CONTAINER                                             : str = 'vnd.dvb.notif-container'
    VND_DVB_NOTIF_GENERIC                                               : str = 'vnd.dvb.notif-generic'
    VND_DVB_NOTIF_IA_MSGLIST                                            : str = 'vnd.dvb.notif-ia-msglist'
    VND_DVB_NOTIF_IA_REGISTRATION_REQUEST                               : str = 'vnd.dvb.notif-ia-registration-request'
    VND_DVB_NOTIF_IA_REGISTRATION_RESPONSE                              : str = 'vnd.dvb.notif-ia-registration-response'
    VND_DVB_NOTIF_INIT                                                  : str = 'vnd.dvb.notif-init'
    VND_DVB_PFR                                                         : str = 'vnd.dvb.pfr'
    VND_DVB_SERVICE                                                     : str = 'vnd.dvb.service'
    VND_DVB_SUBTITLE                                                    : str = 'vnd.dvb.subtitle'
    VND_DWF                                                             : str = 'vnd.dwf'
    VND_DWG                                                             : str = 'vnd.dwg'
    VND_DXF                                                             : str = 'vnd.dxf'
    VND_DXR                                                             : str = 'vnd.dxr'
    VND_DYNAGEO                                                         : str = 'vnd.dynageo'
    VND_DZR                                                             : str = 'vnd.dzr'
    VND_EASYKARAOKE_CDGDOWNLOAD                                         : str = 'vnd.easykaraoke.cdgdownload'
    VND_ECDIS_UPDATE                                                    : str = 'vnd.ecdis-update'
    VND_ECIP_RLP                                                        : str = 'vnd.ecip.rlp'
    VND_ECOWIN_CHART                                                    : str = 'vnd.ecowin.chart'
    VND_ECOWIN_FILEREQUEST                                              : str = 'vnd.ecowin.filerequest'
    VND_ECOWIN_FILEUPDATE                                               : str = 'vnd.ecowin.fileupdate'
    VND_ECOWIN_SERIES                                                   : str = 'vnd.ecowin.series'
    VND_ECOWIN_SERIESREQUEST                                            : str = 'vnd.ecowin.seriesrequest'
    VND_ECOWIN_SERIESUPDATE                                             : str = 'vnd.ecowin.seriesupdate'
    VND_EFI_IMG                                                         : str = 'vnd.efi.img'
    VND_EFI_ISO                                                         : str = 'vnd.efi.iso'
    VND_EMCLIENT_ACCESSREQUEST                                          : str = 'vnd.emclient.accessrequest'
    VND_ENLIVEN                                                         : str = 'vnd.enliven'
    VND_ENPHASE_ENVOY                                                   : str = 'vnd.enphase.envoy'
    VND_EPRINTS_DATA                                                    : str = 'vnd.eprints.data'
    VND_EPSON_ESF                                                       : str = 'vnd.epson.esf'
    VND_EPSON_MSF                                                       : str = 'vnd.epson.msf'
    VND_EPSON_QUICKANIME                                                : str = 'vnd.epson.quickanime'
    VND_EPSON_SALT                                                      : str = 'vnd.epson.salt'
    VND_EPSON_SSF                                                       : str = 'vnd.epson.ssf'
    VND_ERICSSON_QUICKCALL                                              : str = 'vnd.ericsson.quickcall'
    VND_ESMERTEC_THEME_DESCRIPTOR                                       : str = 'vnd.esmertec.theme-descriptor'
    VND_ESPASS_ESPASS                                                   : str = 'vnd.espass-espass'
    VND_ESZIGNO3                                                        : str = 'vnd.eszigno3'
    VND_ETSI_AOC                                                        : str = 'vnd.etsi.aoc'
    VND_ETSI_ASIC_E                                                     : str = 'vnd.etsi.asic-e'
    VND_ETSI_ASIC_S                                                     : str = 'vnd.etsi.asic-s'
    VND_ETSI_CUG                                                        : str = 'vnd.etsi.cug'
    VND_ETSI_IPTVCOMMAND                                                : str = 'vnd.etsi.iptvcommand'
    VND_ETSI_IPTVDISCOVERY                                              : str = 'vnd.etsi.iptvdiscovery'
    VND_ETSI_IPTVPROFILE                                                : str = 'vnd.etsi.iptvprofile'
    VND_ETSI_IPTVSAD_BC                                                 : str = 'vnd.etsi.iptvsad-bc'
    VND_ETSI_IPTVSAD_COD                                                : str = 'vnd.etsi.iptvsad-cod'
    VND_ETSI_IPTVSAD_NPVR                                               : str = 'vnd.etsi.iptvsad-npvr'
    VND_ETSI_IPTVSERVICE                                                : str = 'vnd.etsi.iptvservice'
    VND_ETSI_IPTVSYNC                                                   : str = 'vnd.etsi.iptvsync'
    VND_ETSI_IPTVUEPROFILE                                              : str = 'vnd.etsi.iptvueprofile'
    VND_ETSI_MCID                                                       : str = 'vnd.etsi.mcid'
    VND_ETSI_MHEG5                                                      : str = 'vnd.etsi.mheg5'
    VND_ETSI_OVERLOAD_CONTROL_POLICY_DATASET                            : str = 'vnd.etsi.overload-control-policy-dataset'
    VND_ETSI_PSTN                                                       : str = 'vnd.etsi.pstn'
    VND_ETSI_SCI                                                        : str = 'vnd.etsi.sci'
    VND_ETSI_SIMSERVS                                                   : str = 'vnd.etsi.simservs'
    VND_ETSI_TIMESTAMP_TOKEN                                            : str = 'vnd.etsi.timestamp-token'
    VND_ETSI_TSL                                                        : str = 'vnd.etsi.tsl'
    VND_ETSI_TSL_DER                                                    : str = 'vnd.etsi.tsl.der'
    VND_EUDORA_DATA                                                     : str = 'vnd.eudora.data'
    VND_EVERAD_PLJ                                                      : str = 'vnd.everad.plj'
    VND_EVOLV_ECIG_PROFILE                                              : str = 'vnd.evolv.ecig.profile'
    VND_EVOLV_ECIG_SETTINGS                                             : str = 'vnd.evolv.ecig.settings'
    VND_EVOLV_ECIG_THEME                                                : str = 'vnd.evolv.ecig.theme'
    VND_EXSTREAM_EMPOWER                                                : str = 'vnd.exstream-empower'
    VND_EXSTREAM_PACKAGE                                                : str = 'vnd.exstream-package'
    VND_EZPIX_ALBUM                                                     : str = 'vnd.ezpix-album'
    VND_EZPIX_PACKAGE                                                   : str = 'vnd.ezpix-package'
    VND_F_SECURE_MOBILE                                                 : str = 'vnd.f-secure.mobile'
    VND_FASTBIDSHEET                                                    : str = 'vnd.fastbidsheet'
    VND_FASTCOPY_DISK_IMAGE                                             : str = 'vnd.fastcopy-disk-image'
    VND_FDF                                                             : str = 'vnd.fdf'
    VND_FDSN_MSEED                                                      : str = 'vnd.fdsn.mseed'
    VND_FDSN_SEED                                                       : str = 'vnd.fdsn.seed'
    VND_FFSNS                                                           : str = 'vnd.ffsns'
    VND_FICLAB_FLB                                                      : str = 'vnd.ficlab.flb'
    VND_FICLAB_FLT                                                      : str = 'vnd.ficlab.flt'
    VND_FILMIT_ZFC                                                      : str = 'vnd.filmit.zfc'
    VND_FINTS                                                           : str = 'vnd.fints'
    VND_FIREMONKEYS_CLOUDCELL                                           : str = 'vnd.firemonkeys.cloudcell'
    VND_FLATLAND_3DML                                                   : str = 'vnd.flatland.3dml'
    VND_FLOGRAPHIT                                                      : str = 'vnd.flographit'
    VND_FLUXTIME_CLIP                                                   : str = 'vnd.fluxtime.clip'
    VND_FLY                                                             : str = 'vnd.fly'
    VND_FMI_FLEXSTOR                                                    : str = 'vnd.fmi.flexstor'
    VND_FONT_FONTFORGE_SFD                                              : str = 'vnd.font-fontforge-sfd'
    VND_FPX                                                             : str = 'vnd.fpx'
    VND_FRAMEMAKER                                                      : str = 'vnd.framemaker'
    VND_FROGANS_FNC                                                     : str = 'vnd.frogans.fnc'
    VND_FROGANS_LTF                                                     : str = 'vnd.frogans.ltf'
    VND_FSC_WEBLAUNCH                                                   : str = 'vnd.fsc.weblaunch'
    VND_FST                                                             : str = 'vnd.fst'
    VND_FUJIFILM_FB_DOCUWORKS                                           : str = 'vnd.fujifilm.fb.docuworks'
    VND_FUJIFILM_FB_DOCUWORKS_BINDER                                    : str = 'vnd.fujifilm.fb.docuworks.binder'
    VND_FUJIFILM_FB_DOCUWORKS_CONTAINER                                 : str = 'vnd.fujifilm.fb.docuworks.container'
    VND_FUJITSU_OASYS                                                   : str = 'vnd.fujitsu.oasys'
    VND_FUJITSU_OASYS2                                                  : str = 'vnd.fujitsu.oasys2'
    VND_FUJITSU_OASYS3                                                  : str = 'vnd.fujitsu.oasys3'
    VND_FUJITSU_OASYSGP                                                 : str = 'vnd.fujitsu.oasysgp'
    VND_FUJITSU_OASYSPRS                                                : str = 'vnd.fujitsu.oasysprs'
    VND_FUJIXEROX_ART_EX                                                : str = 'vnd.fujixerox.art-ex'
    VND_FUJIXEROX_ART4                                                  : str = 'vnd.fujixerox.art4'
    VND_FUJIXEROX_DDD                                                   : str = 'vnd.fujixerox.ddd'
    VND_FUJIXEROX_DOCUWORKS                                             : str = 'vnd.fujixerox.docuworks'
    VND_FUJIXEROX_DOCUWORKS_BINDER                                      : str = 'vnd.fujixerox.docuworks.binder'
    VND_FUJIXEROX_DOCUWORKS_CONTAINER                                   : str = 'vnd.fujixerox.docuworks.container'
    VND_FUJIXEROX_EDMICS_MMR                                            : str = 'vnd.fujixerox.edmics-mmr'
    VND_FUJIXEROX_EDMICS_RLC                                            : str = 'vnd.fujixerox.edmics-rlc'
    VND_FUJIXEROX_HBPL                                                  : str = 'vnd.fujixerox.hbpl'
    VND_FUT_MISNET                                                      : str = 'vnd.fut-misnet'
    VND_FUTOIN                                                          : str = 'vnd.futoin'
    VND_FUZZYSHEET                                                      : str = 'vnd.fuzzysheet'
    VND_FVT                                                             : str = 'vnd.fvt'
    VND_GDL                                                             : str = 'vnd.gdl'
    VND_GENOMATIX_TUXEDO                                                : str = 'vnd.genomatix.tuxedo'
    VND_GENTICS_GRD                                                     : str = 'vnd.gentics.grd'
    VND_GEO                                                             : str = 'vnd.geo'
    VND_GEOCUBE                                                         : str = 'vnd.geocube'
    VND_GEOGEBRA_FILE                                                   : str = 'vnd.geogebra.file'
    VND_GEOGEBRA_SLIDES                                                 : str = 'vnd.geogebra.slides'
    VND_GEOGEBRA_TOOL                                                   : str = 'vnd.geogebra.tool'
    VND_GEOMETRY_EXPLORER                                               : str = 'vnd.geometry-explorer'
    VND_GEONEXT                                                         : str = 'vnd.geonext'
    VND_GEOPLAN                                                         : str = 'vnd.geoplan'
    VND_GEOSPACE                                                        : str = 'vnd.geospace'
    VND_GERBER                                                          : str = 'vnd.gerber'
    VND_GLOBALGRAPHICS_PGB                                              : str = 'vnd.globalgraphics.pgb'
    VND_GLOBALPLATFORM_CARD_CONTENT_MGT                                 : str = 'vnd.globalplatform.card-content-mgt'
    VND_GLOBALPLATFORM_CARD_CONTENT_MGT_RESPONSE                        : str = 'vnd.globalplatform.card-content-mgt-response'
    VND_GML                                                             : str = 'vnd.gml'
    VND_GMX                                                             : str = 'vnd.gmx'
    VND_GOOGLE_EARTH_KML                                                : str = 'vnd.google-earth.kml'
    VND_GOOGLE_EARTH_KMZ                                                : str = 'vnd.google-earth.kmz'
    VND_GOV_SK_E_FORM                                                   : str = 'vnd.gov.sk.e-form'
    VND_GOV_SK_XMLDATACONTAINER                                         : str = 'vnd.gov.sk.xmldatacontainer'
    VND_GRAFEQ                                                          : str = 'vnd.grafeq'
    VND_GRAPHVIZ                                                        : str = 'vnd.graphviz'
    VND_GRIDMP                                                          : str = 'vnd.gridmp'
    VND_GROOVE_ACCOUNT                                                  : str = 'vnd.groove-account'
    VND_GROOVE_HELP                                                     : str = 'vnd.groove-help'
    VND_GROOVE_IDENTITY_MESSAGE                                         : str = 'vnd.groove-identity-message'
    VND_GROOVE_INJECTOR                                                 : str = 'vnd.groove-injector'
    VND_GROOVE_TOOL_MESSAGE                                             : str = 'vnd.groove-tool-message'
    VND_GROOVE_TOOL_TEMPLATE                                            : str = 'vnd.groove-tool-template'
    VND_GROOVE_VCARD                                                    : str = 'vnd.groove-vcard'
    VND_GS_GDL                                                          : str = 'vnd.gs-gdl'
    VND_GTW                                                             : str = 'vnd.gtw'
    VND_HAL                                                             : str = 'vnd.hal'
    VND_HANDHELD_ENTERTAINMENT                                          : str = 'vnd.handheld-entertainment'
    VND_HANS                                                            : str = 'vnd.hans'
    VND_HBCI                                                            : str = 'vnd.hbci'
    VND_HC                                                              : str = 'vnd.hc'
    VND_HCL_BIREPORTS                                                   : str = 'vnd.hcl-bireports'
    VND_HDT                                                             : str = 'vnd.hdt'
    VND_HEROKU                                                          : str = 'vnd.heroku'
    VND_HGL                                                             : str = 'vnd.hgl'
    VND_HHE_LESSON_PLAYER                                               : str = 'vnd.hhe.lesson-player'
    VND_HNS_AUDIO                                                       : str = 'vnd.hns.audio'
    VND_HNS_VIDEO                                                       : str = 'vnd.hns.video'
    VND_HP_HPGL                                                         : str = 'vnd.hp-hpgl'
    VND_HP_HPID                                                         : str = 'vnd.hp-hpid'
    VND_HP_HPS                                                          : str = 'vnd.hp-hps'
    VND_HP_JLYT                                                         : str = 'vnd.hp-jlyt'
    VND_HP_PCL                                                          : str = 'vnd.hp-pcl'
    VND_HP_PCLXL                                                        : str = 'vnd.hp-pclxl'
    VND_HTTPHONE                                                        : str = 'vnd.httphone'
    VND_HYDROSTATIX_SOF_DATA                                            : str = 'vnd.hydrostatix.sof-data'
    VND_HYPER                                                           : str = 'vnd.hyper'
    VND_HYPER_ITEM                                                      : str = 'vnd.hyper-item'
    VND_HYPERDRIVE                                                      : str = 'vnd.hyperdrive'
    VND_HZN_3D_CROSSWORD                                                : str = 'vnd.hzn-3d-crossword'
    VND_IBM_AFPLINEDATA                                                 : str = 'vnd.ibm.afplinedata'
    VND_IBM_ELECTRONIC_MEDIA                                            : str = 'vnd.ibm.electronic-media'
    VND_IBM_MINIPAY                                                     : str = 'vnd.ibm.minipay'
    VND_IBM_MODCAP                                                      : str = 'vnd.ibm.modcap'
    VND_IBM_RIGHTS_MANAGEMENT                                           : str = 'vnd.ibm.rights-management'
    VND_IBM_SECURE_CONTAINER                                            : str = 'vnd.ibm.secure-container'
    VND_ICCPROFILE                                                      : str = 'vnd.iccprofile'
    VND_IEEE_1905                                                       : str = 'vnd.ieee.1905'
    VND_IGLOADER                                                        : str = 'vnd.igloader'
    VND_IMAGEMETER_FOLDER                                               : str = 'vnd.imagemeter.folder'
    VND_IMAGEMETER_IMAGE                                                : str = 'vnd.imagemeter.image'
    VND_IMMERVISION_IVP                                                 : str = 'vnd.immervision-ivp'
    VND_IMMERVISION_IVU                                                 : str = 'vnd.immervision-ivu'
    VND_IMS_IMSCCV1P1                                                   : str = 'vnd.ims.imsccv1p1'
    VND_IMS_IMSCCV1P2                                                   : str = 'vnd.ims.imsccv1p2'
    VND_IMS_IMSCCV1P3                                                   : str = 'vnd.ims.imsccv1p3'
    VND_IMS_LIS_V2_RESULT                                               : str = 'vnd.ims.lis.v2.result'
    VND_IMS_LTI_V2_TOOLCONSUMERPROFILE                                  : str = 'vnd.ims.lti.v2.toolconsumerprofile'
    VND_IMS_LTI_V2_TOOLPROXY                                            : str = 'vnd.ims.lti.v2.toolproxy'
    VND_IMS_LTI_V2_TOOLPROXY_ID                                         : str = 'vnd.ims.lti.v2.toolproxy.id'
    VND_IMS_LTI_V2_TOOLSETTINGS                                         : str = 'vnd.ims.lti.v2.toolsettings'
    VND_IMS_LTI_V2_TOOLSETTINGS_SIMPLE                                  : str = 'vnd.ims.lti.v2.toolsettings.simple'
    VND_IN3D_3DML                                                       : str = 'vnd.in3d.3dml'
    VND_IN3D_SPOT                                                       : str = 'vnd.in3d.spot'
    VND_INFORMEDCONTROL_RMS                                             : str = 'vnd.informedcontrol.rms'
    VND_INFORMIX_VISIONARY                                              : str = 'vnd.informix-visionary'
    VND_INFOTECH_PROJECT                                                : str = 'vnd.infotech.project'
    VND_INNOPATH_WAMP_NOTIFICATION                                      : str = 'vnd.innopath.wamp.notification'
    VND_INSORS_IGM                                                      : str = 'vnd.insors.igm'
    VND_INTERCON_FORMNET                                                : str = 'vnd.intercon.formnet'
    VND_INTERGEO                                                        : str = 'vnd.intergeo'
    VND_INTERTRUST_DIGIBOX                                              : str = 'vnd.intertrust.digibox'
    VND_INTERTRUST_NNCP                                                 : str = 'vnd.intertrust.nncp'
    VND_INTU_QBO                                                        : str = 'vnd.intu.qbo'
    VND_INTU_QFX                                                        : str = 'vnd.intu.qfx'
    VND_IPTC_G2_CATALOGITEM                                             : str = 'vnd.iptc.g2.catalogitem'
    VND_IPTC_G2_CONCEPTITEM                                             : str = 'vnd.iptc.g2.conceptitem'
    VND_IPTC_G2_KNOWLEDGEITEM                                           : str = 'vnd.iptc.g2.knowledgeitem'
    VND_IPTC_G2_NEWSITEM                                                : str = 'vnd.iptc.g2.newsitem'
    VND_IPTC_G2_NEWSMESSAGE                                             : str = 'vnd.iptc.g2.newsmessage'
    VND_IPTC_G2_PACKAGEITEM                                             : str = 'vnd.iptc.g2.packageitem'
    VND_IPTC_G2_PLANNINGITEM                                            : str = 'vnd.iptc.g2.planningitem'
    VND_IPTC_NEWSML                                                     : str = 'vnd.iptc.newsml'
    VND_IPTC_NITF                                                       : str = 'vnd.iptc.nitf'
    VND_IPTVFORUM_1DPARITYFEC_1010                                      : str = 'vnd.iptvforum.1dparityfec-1010'
    VND_IPTVFORUM_1DPARITYFEC_2005                                      : str = 'vnd.iptvforum.1dparityfec-2005'
    VND_IPTVFORUM_2DPARITYFEC_1010                                      : str = 'vnd.iptvforum.2dparityfec-1010'
    VND_IPTVFORUM_2DPARITYFEC_2005                                      : str = 'vnd.iptvforum.2dparityfec-2005'
    VND_IPTVFORUM_TTSAVC                                                : str = 'vnd.iptvforum.ttsavc'
    VND_IPTVFORUM_TTSMPEG2                                              : str = 'vnd.iptvforum.ttsmpeg2'
    VND_IPUNPLUGGED_RCPROFILE                                           : str = 'vnd.ipunplugged.rcprofile'
    VND_IREPOSITORY_PACKAGE                                             : str = 'vnd.irepository.package'
    VND_IS_XPR                                                          : str = 'vnd.is-xpr'
    VND_ISAC_FCS                                                        : str = 'vnd.isac.fcs'
    VND_ISO11783_10                                                     : str = 'vnd.iso11783-10'
    VND_JAM                                                             : str = 'vnd.jam'
    VND_JAPANNET_DIRECTORY_SERVICE                                      : str = 'vnd.japannet-directory-service'
    VND_JAPANNET_JPNSTORE_WAKEUP                                        : str = 'vnd.japannet-jpnstore-wakeup'
    VND_JAPANNET_PAYMENT_WAKEUP                                         : str = 'vnd.japannet-payment-wakeup'
    VND_JAPANNET_REGISTRATION                                           : str = 'vnd.japannet-registration'
    VND_JAPANNET_REGISTRATION_WAKEUP                                    : str = 'vnd.japannet-registration-wakeup'
    VND_JAPANNET_SETSTORE_WAKEUP                                        : str = 'vnd.japannet-setstore-wakeup'
    VND_JAPANNET_VERIFICATION                                           : str = 'vnd.japannet-verification'
    VND_JAPANNET_VERIFICATION_WAKEUP                                    : str = 'vnd.japannet-verification-wakeup'
    VND_JCP_JAVAME_MIDLET_RMS                                           : str = 'vnd.jcp.javame.midlet-rms'
    VND_JISP                                                            : str = 'vnd.jisp'
    VND_JOOST_JODA_ARCHIVE                                              : str = 'vnd.joost.joda-archive'
    VND_JSK_ISDN_NGN                                                    : str = 'vnd.jsk.isdn-ngn'
    VND_KAHOOTZ                                                         : str = 'vnd.kahootz'
    VND_KDE_KARBON                                                      : str = 'vnd.kde.karbon'
    VND_KDE_KCHART                                                      : str = 'vnd.kde.kchart'
    VND_KDE_KFORMULA                                                    : str = 'vnd.kde.kformula'
    VND_KDE_KIVIO                                                       : str = 'vnd.kde.kivio'
    VND_KDE_KONTOUR                                                     : str = 'vnd.kde.kontour'
    VND_KDE_KPRESENTER                                                  : str = 'vnd.kde.kpresenter'
    VND_KDE_KSPREAD                                                     : str = 'vnd.kde.kspread'
    VND_KDE_KWORD                                                       : str = 'vnd.kde.kword'
    VND_KENAMEAAPP                                                      : str = 'vnd.kenameaapp'
    VND_KIDSPIRATION                                                    : str = 'vnd.kidspiration'
    VND_KINAR                                                           : str = 'vnd.kinar'
    VND_KOAN                                                            : str = 'vnd.koan'
    VND_KODAK_DESCRIPTOR                                                : str = 'vnd.kodak-descriptor'
    VND_LAS                                                             : str = 'vnd.las'
    VND_LAS_LAS                                                         : str = 'vnd.las.las'
    VND_LASZIP                                                          : str = 'vnd.laszip'
    VND_LATEX_Z                                                         : str = 'vnd.latex-z'
    VND_LEAP                                                            : str = 'vnd.leap'
    VND_LIBERTY_REQUEST                                                 : str = 'vnd.liberty-request'
    VND_LLAMAGRAPHICS_LIFE_BALANCE_DESKTOP                              : str = 'vnd.llamagraphics.life-balance.desktop'
    VND_LLAMAGRAPHICS_LIFE_BALANCE_EXCHANGE                             : str = 'vnd.llamagraphics.life-balance.exchange'
    VND_LOGIPIPE_CIRCUIT                                                : str = 'vnd.logipipe.circuit'
    VND_LOOM                                                            : str = 'vnd.loom'
    VND_LOTUS_1_2_3                                                     : str = 'vnd.lotus-1-2-3'
    VND_LOTUS_APPROACH                                                  : str = 'vnd.lotus-approach'
    VND_LOTUS_FREELANCE                                                 : str = 'vnd.lotus-freelance'
    VND_LOTUS_NOTES                                                     : str = 'vnd.lotus-notes'
    VND_LOTUS_ORGANIZER                                                 : str = 'vnd.lotus-organizer'
    VND_LOTUS_SCREENCAM                                                 : str = 'vnd.lotus-screencam'
    VND_LOTUS_WORDPRO                                                   : str = 'vnd.lotus-wordpro'
    VND_LUCENT_VOICE                                                    : str = 'vnd.lucent.voice'
    VND_MACPORTS_PORTPKG                                                : str = 'vnd.macports.portpkg'
    VND_MAPBOX_VECTOR_TILE                                              : str = 'vnd.mapbox-vector-tile'
    VND_MARLIN_DRM_ACTIONTOKEN                                          : str = 'vnd.marlin.drm.actiontoken'
    VND_MARLIN_DRM_CONFTOKEN                                            : str = 'vnd.marlin.drm.conftoken'
    VND_MARLIN_DRM_LICENSE                                              : str = 'vnd.marlin.drm.license'
    VND_MARLIN_DRM_MDCF                                                 : str = 'vnd.marlin.drm.mdcf'
    VND_MASON                                                           : str = 'vnd.mason'
    VND_MAXMIND_MAXMIND_DB                                              : str = 'vnd.maxmind.maxmind-db'
    VND_MCD                                                             : str = 'vnd.mcd'
    VND_MEDCALCDATA                                                     : str = 'vnd.medcalcdata'
    VND_MEDIASTATION_CDKEY                                              : str = 'vnd.mediastation.cdkey'
    VND_MERIDIAN_SLINGSHOT                                              : str = 'vnd.meridian-slingshot'
    VND_MFER                                                            : str = 'vnd.mfer'
    VND_MFMP                                                            : str = 'vnd.mfmp'
    VND_MICRO                                                           : str = 'vnd.micro'
    VND_MICROGRAFX_FLO                                                  : str = 'vnd.micrografx.flo'
    VND_MICROGRAFX_IGX                                                  : str = 'vnd.micrografx.igx'
    VND_MICROSOFT_ICON                                                  : str = 'vnd.microsoft.icon'
    VND_MICROSOFT_PORTABLE_EXECUTABLE                                   : str = 'vnd.microsoft.portable-executable'
    VND_MICROSOFT_WINDOWS_THUMBNAIL_CACHE                               : str = 'vnd.microsoft.windows.thumbnail-cache'
    VND_MIELE                                                           : str = 'vnd.miele'
    VND_MIF                                                             : str = 'vnd.mif'
    VND_MINISOFT_HP3000_SAVE                                            : str = 'vnd.minisoft-hp3000-save'
    VND_MITSUBISHI_MISTY_GUARD_TRUSTWEB                                 : str = 'vnd.mitsubishi.misty-guard.trustweb'
    VND_MIX                                                             : str = 'vnd.mix'
    VND_MOBIUS_DAF                                                      : str = 'vnd.mobius.daf'
    VND_MOBIUS_DIS                                                      : str = 'vnd.mobius.dis'
    VND_MOBIUS_MBK                                                      : str = 'vnd.mobius.mbk'
    VND_MOBIUS_MQY                                                      : str = 'vnd.mobius.mqy'
    VND_MOBIUS_MSL                                                      : str = 'vnd.mobius.msl'
    VND_MOBIUS_PLC                                                      : str = 'vnd.mobius.plc'
    VND_MOBIUS_TXF                                                      : str = 'vnd.mobius.txf'
    VND_MOML                                                            : str = 'vnd.moml'
    VND_MOPHUN_APPLICATION                                              : str = 'vnd.mophun.application'
    VND_MOPHUN_CERTIFICATE                                              : str = 'vnd.mophun.certificate'
    VND_MOTOROLA_FLEXSUITE                                              : str = 'vnd.motorola.flexsuite'
    VND_MOTOROLA_FLEXSUITE_ADSI                                         : str = 'vnd.motorola.flexsuite.adsi'
    VND_MOTOROLA_FLEXSUITE_FIS                                          : str = 'vnd.motorola.flexsuite.fis'
    VND_MOTOROLA_FLEXSUITE_GOTAP                                        : str = 'vnd.motorola.flexsuite.gotap'
    VND_MOTOROLA_FLEXSUITE_KMR                                          : str = 'vnd.motorola.flexsuite.kmr'
    VND_MOTOROLA_FLEXSUITE_TTC                                          : str = 'vnd.motorola.flexsuite.ttc'
    VND_MOTOROLA_FLEXSUITE_WEM                                          : str = 'vnd.motorola.flexsuite.wem'
    VND_MOTOROLA_IPRM                                                   : str = 'vnd.motorola.iprm'
    VND_MOTOROLA_REFLEX                                                 : str = 'vnd.motorola.reflex'
    VND_MOTOROLA_VIDEO                                                  : str = 'vnd.motorola.video'
    VND_MOTOROLA_VIDEOP                                                 : str = 'vnd.motorola.videop'
    VND_MOZILLA_APNG                                                    : str = 'vnd.mozilla.apng'
    VND_MOZILLA_XUL                                                     : str = 'vnd.mozilla.xul'
    VND_MPEGURL                                                         : str = 'vnd.mpegurl'
    VND_MS_3MFDOCUMENT                                                  : str = 'vnd.ms-3mfdocument'
    VND_MS_ARTGALRY                                                     : str = 'vnd.ms-artgalry'
    VND_MS_ASF                                                          : str = 'vnd.ms-asf'
    VND_MS_CAB_COMPRESSED                                               : str = 'vnd.ms-cab-compressed'
    VND_MS_EXCEL                                                        : str = 'vnd.ms-excel'
    VND_MS_EXCEL_ADDIN_MACROENABLED_12                                  : str = 'vnd.ms-excel.addin.macroenabled.12'
    VND_MS_EXCEL_SHEET_BINARY_MACROENABLED_12                           : str = 'vnd.ms-excel.sheet.binary.macroenabled.12'
    VND_MS_EXCEL_SHEET_MACROENABLED_12                                  : str = 'vnd.ms-excel.sheet.macroenabled.12'
    VND_MS_EXCEL_TEMPLATE_MACROENABLED_12                               : str = 'vnd.ms-excel.template.macroenabled.12'
    VND_MS_FONTOBJECT                                                   : str = 'vnd.ms-fontobject'
    VND_MS_HTMLHELP                                                     : str = 'vnd.ms-htmlhelp'
    VND_MS_IMS                                                          : str = 'vnd.ms-ims'
    VND_MS_LRM                                                          : str = 'vnd.ms-lrm'
    VND_MS_MEDIAPACKAGE                                                 : str = 'vnd.ms-mediapackage'
    VND_MS_MODI                                                         : str = 'vnd.ms-modi'
    VND_MS_OFFICE_ACTIVEX                                               : str = 'vnd.ms-office.activex'
    VND_MS_OFFICETHEME                                                  : str = 'vnd.ms-officetheme'
    VND_MS_PLAYREADY_INITIATOR                                          : str = 'vnd.ms-playready.initiator'
    VND_MS_PLAYREADY_MEDIA_PYA                                          : str = 'vnd.ms-playready.media.pya'
    VND_MS_PLAYREADY_MEDIA_PYV                                          : str = 'vnd.ms-playready.media.pyv'
    VND_MS_POWERPOINT                                                   : str = 'vnd.ms-powerpoint'
    VND_MS_POWERPOINT_ADDIN_MACROENABLED_12                             : str = 'vnd.ms-powerpoint.addin.macroenabled.12'
    VND_MS_POWERPOINT_PRESENTATION_MACROENABLED_12                      : str = 'vnd.ms-powerpoint.presentation.macroenabled.12'
    VND_MS_POWERPOINT_SLIDE_MACROENABLED_12                             : str = 'vnd.ms-powerpoint.slide.macroenabled.12'
    VND_MS_POWERPOINT_SLIDESHOW_MACROENABLED_12                         : str = 'vnd.ms-powerpoint.slideshow.macroenabled.12'
    VND_MS_POWERPOINT_TEMPLATE_MACROENABLED_12                          : str = 'vnd.ms-powerpoint.template.macroenabled.12'
    VND_MS_PRINTDEVICECAPABILITIES                                      : str = 'vnd.ms-printdevicecapabilities'
    VND_MS_PRINTSCHEMATICKET                                            : str = 'vnd.ms-printschematicket'
    VND_MS_PROJECT                                                      : str = 'vnd.ms-project'
    VND_MS_TNEF                                                         : str = 'vnd.ms-tnef'
    VND_MS_WINDOWS_DEVICEPAIRING                                        : str = 'vnd.ms-windows.devicepairing'
    VND_MS_WINDOWS_NWPRINTING_OOB                                       : str = 'vnd.ms-windows.nwprinting.oob'
    VND_MS_WINDOWS_PRINTERPAIRING                                       : str = 'vnd.ms-windows.printerpairing'
    VND_MS_WINDOWS_WSD_OOB                                              : str = 'vnd.ms-windows.wsd.oob'
    VND_MS_WMDRM_LIC_CHLG_REQ                                           : str = 'vnd.ms-wmdrm.lic-chlg-req'
    VND_MS_WMDRM_LIC_RESP                                               : str = 'vnd.ms-wmdrm.lic-resp'
    VND_MS_WMDRM_METER_CHLG_REQ                                         : str = 'vnd.ms-wmdrm.meter-chlg-req'
    VND_MS_WMDRM_METER_RESP                                             : str = 'vnd.ms-wmdrm.meter-resp'
    VND_MS_WORD_DOCUMENT_MACROENABLED_12                                : str = 'vnd.ms-word.document.macroenabled.12'
    VND_MS_WORD_TEMPLATE_MACROENABLED_12                                : str = 'vnd.ms-word.template.macroenabled.12'
    VND_MS_WORKS                                                        : str = 'vnd.ms-works'
    VND_MS_WPL                                                          : str = 'vnd.ms-wpl'
    VND_MS_XPSDOCUMENT                                                  : str = 'vnd.ms-xpsdocument'
    VND_MSA_DISK_IMAGE                                                  : str = 'vnd.msa-disk-image'
    VND_MSEQ                                                            : str = 'vnd.mseq'
    VND_MSIGN                                                           : str = 'vnd.msign'
    VND_MTS                                                             : str = 'vnd.mts'
    VND_MULTIAD_CREATOR                                                 : str = 'vnd.multiad.creator'
    VND_MULTIAD_CREATOR_CIF                                             : str = 'vnd.multiad.creator.cif'
    VND_MUSIC_NIFF                                                      : str = 'vnd.music-niff'
    VND_MUSICIAN                                                        : str = 'vnd.musician'
    VND_MUVEE_STYLE                                                     : str = 'vnd.muvee.style'
    VND_MYNFC                                                           : str = 'vnd.mynfc'
    VND_NCD_CONTROL                                                     : str = 'vnd.ncd.control'
    VND_NCD_REFERENCE                                                   : str = 'vnd.ncd.reference'
    VND_NEARST_INV                                                      : str = 'vnd.nearst.inv'
    VND_NEBUMIND_LINE                                                   : str = 'vnd.nebumind.line'
    VND_NERVANA                                                         : str = 'vnd.nervana'
    VND_NET_FPX                                                         : str = 'vnd.net-fpx'
    VND_NET2PHONE_COMMCENTER_COMMAND                                    : str = 'vnd.net2phone.commcenter.command'
    VND_NETFPX                                                          : str = 'vnd.netfpx'
    VND_NEUROLANGUAGE_NLU                                               : str = 'vnd.neurolanguage.nlu'
    VND_NIMN                                                            : str = 'vnd.nimn'
    VND_NINTENDO_NITRO_ROM                                              : str = 'vnd.nintendo.nitro.rom'
    VND_NINTENDO_SNES_ROM                                               : str = 'vnd.nintendo.snes.rom'
    VND_NITF                                                            : str = 'vnd.nitf'
    VND_NOBLENET_DIRECTORY                                              : str = 'vnd.noblenet-directory'
    VND_NOBLENET_SEALER                                                 : str = 'vnd.noblenet-sealer'
    VND_NOBLENET_WEB                                                    : str = 'vnd.noblenet-web'
    VND_NOKIA_CATALOGS                                                  : str = 'vnd.nokia.catalogs'
    VND_NOKIA_CONML                                                     : str = 'vnd.nokia.conml'
    VND_NOKIA_INTERLEAVED_MULTIMEDIA                                    : str = 'vnd.nokia.interleaved-multimedia'
    VND_NOKIA_IPTV_CONFIG                                               : str = 'vnd.nokia.iptv.config'
    VND_NOKIA_ISDS_RADIO_PRESETS                                        : str = 'vnd.nokia.isds-radio-presets'
    VND_NOKIA_LANDMARK                                                  : str = 'vnd.nokia.landmark'
    VND_NOKIA_LANDMARKCOLLECTION                                        : str = 'vnd.nokia.landmarkcollection'
    VND_NOKIA_MOBILE_XMF                                                : str = 'vnd.nokia.mobile-xmf'
    VND_NOKIA_MP4VR                                                     : str = 'vnd.nokia.mp4vr'
    VND_NOKIA_N_GAGE_AC                                                 : str = 'vnd.nokia.n-gage.ac'
    VND_NOKIA_N_GAGE_DATA                                               : str = 'vnd.nokia.n-gage.data'
    VND_NOKIA_N_GAGE_SYMBIAN_INSTALL                                    : str = 'vnd.nokia.n-gage.symbian.install'
    VND_NOKIA_NCD                                                       : str = 'vnd.nokia.ncd'
    VND_NOKIA_PCD                                                       : str = 'vnd.nokia.pcd'
    VND_NOKIA_RADIO_PRESET                                              : str = 'vnd.nokia.radio-preset'
    VND_NOKIA_RADIO_PRESETS                                             : str = 'vnd.nokia.radio-presets'
    VND_NOKIA_VIDEOVOIP                                                 : str = 'vnd.nokia.videovoip'
    VND_NORTEL_VBK                                                      : str = 'vnd.nortel.vbk'
    VND_NOVADIGM_EDM                                                    : str = 'vnd.novadigm.edm'
    VND_NOVADIGM_EDX                                                    : str = 'vnd.novadigm.edx'
    VND_NOVADIGM_EXT                                                    : str = 'vnd.novadigm.ext'
    VND_NTT_LOCAL_CONTENT_SHARE                                         : str = 'vnd.ntt-local.content-share'
    VND_NTT_LOCAL_FILE_TRANSFER                                         : str = 'vnd.ntt-local.file-transfer'
    VND_NTT_LOCAL_OGW_REMOTE_ACCESS                                     : str = 'vnd.ntt-local.ogw_remote-access'
    VND_NTT_LOCAL_SIP_TA_REMOTE                                         : str = 'vnd.ntt-local.sip-ta_remote'
    VND_NTT_LOCAL_SIP_TA_TCP_STREAM                                     : str = 'vnd.ntt-local.sip-ta_tcp_stream'
    VND_NUERA_ECELP4800                                                 : str = 'vnd.nuera.ecelp4800'
    VND_NUERA_ECELP7470                                                 : str = 'vnd.nuera.ecelp7470'
    VND_NUERA_ECELP9600                                                 : str = 'vnd.nuera.ecelp9600'
    VND_OASIS_OPENDOCUMENT_CHART                                        : str = 'vnd.oasis.opendocument.chart'
    VND_OASIS_OPENDOCUMENT_CHART_TEMPLATE                               : str = 'vnd.oasis.opendocument.chart-template'
    VND_OASIS_OPENDOCUMENT_DATABASE                                     : str = 'vnd.oasis.opendocument.database'
    VND_OASIS_OPENDOCUMENT_FORMULA                                      : str = 'vnd.oasis.opendocument.formula'
    VND_OASIS_OPENDOCUMENT_FORMULA_TEMPLATE                             : str = 'vnd.oasis.opendocument.formula-template'
    VND_OASIS_OPENDOCUMENT_GRAPHICS                                     : str = 'vnd.oasis.opendocument.graphics'
    VND_OASIS_OPENDOCUMENT_GRAPHICS_TEMPLATE                            : str = 'vnd.oasis.opendocument.graphics-template'
    VND_OASIS_OPENDOCUMENT_IMAGE                                        : str = 'vnd.oasis.opendocument.image'
    VND_OASIS_OPENDOCUMENT_IMAGE_TEMPLATE                               : str = 'vnd.oasis.opendocument.image-template'
    VND_OASIS_OPENDOCUMENT_PRESENTATION                                 : str = 'vnd.oasis.opendocument.presentation'
    VND_OASIS_OPENDOCUMENT_PRESENTATION_TEMPLATE                        : str = 'vnd.oasis.opendocument.presentation-template'
    VND_OASIS_OPENDOCUMENT_SPREADSHEET                                  : str = 'vnd.oasis.opendocument.spreadsheet'
    VND_OASIS_OPENDOCUMENT_SPREADSHEET_TEMPLATE                         : str = 'vnd.oasis.opendocument.spreadsheet-template'
    VND_OASIS_OPENDOCUMENT_TEXT                                         : str = 'vnd.oasis.opendocument.text'
    VND_OASIS_OPENDOCUMENT_TEXT_MASTER                                  : str = 'vnd.oasis.opendocument.text-master'
    VND_OASIS_OPENDOCUMENT_TEXT_TEMPLATE                                : str = 'vnd.oasis.opendocument.text-template'
    VND_OASIS_OPENDOCUMENT_TEXT_WEB                                     : str = 'vnd.oasis.opendocument.text-web'
    VND_OBJECTVIDEO                                                     : str = 'vnd.objectvideo'
    VND_OBN                                                             : str = 'vnd.obn'
    VND_OCF                                                             : str = 'vnd.ocf'
    VND_OCI_IMAGE_MANIFEST_V1                                           : str = 'vnd.oci.image.manifest.v1'
    VND_OCTEL_SBC                                                       : str = 'vnd.octel.sbc'
    VND_OFTN_L10N                                                       : str = 'vnd.oftn.l10n'
    VND_OIPF_CONTENTACCESSDOWNLOAD                                      : str = 'vnd.oipf.contentaccessdownload'
    VND_OIPF_CONTENTACCESSSTREAMING                                     : str = 'vnd.oipf.contentaccessstreaming'
    VND_OIPF_CSPG_HEXBINARY                                             : str = 'vnd.oipf.cspg-hexbinary'
    VND_OIPF_DAE_SVG                                                    : str = 'vnd.oipf.dae.svg'
    VND_OIPF_DAE_XHTML                                                  : str = 'vnd.oipf.dae.xhtml'
    VND_OIPF_MIPPVCONTROLMESSAGE                                        : str = 'vnd.oipf.mippvcontrolmessage'
    VND_OIPF_PAE_GEM                                                    : str = 'vnd.oipf.pae.gem'
    VND_OIPF_SPDISCOVERY                                                : str = 'vnd.oipf.spdiscovery'
    VND_OIPF_SPDLIST                                                    : str = 'vnd.oipf.spdlist'
    VND_OIPF_UEPROFILE                                                  : str = 'vnd.oipf.ueprofile'
    VND_OIPF_USERPROFILE                                                : str = 'vnd.oipf.userprofile'
    VND_OLPC_SUGAR                                                      : str = 'vnd.olpc-sugar'
    VND_OMA_SCWS_CONFIG                                                 : str = 'vnd.oma-scws-config'
    VND_OMA_SCWS_HTTP_REQUEST                                           : str = 'vnd.oma-scws-http-request'
    VND_OMA_SCWS_HTTP_RESPONSE                                          : str = 'vnd.oma-scws-http-response'
    VND_OMA_BCAST_ASSOCIATED_PROCEDURE_PARAMETER                        : str = 'vnd.oma.bcast.associated-procedure-parameter'
    VND_OMA_BCAST_DRM_TRIGGER                                           : str = 'vnd.oma.bcast.drm-trigger'
    VND_OMA_BCAST_IMD                                                   : str = 'vnd.oma.bcast.imd'
    VND_OMA_BCAST_LTKM                                                  : str = 'vnd.oma.bcast.ltkm'
    VND_OMA_BCAST_NOTIFICATION                                          : str = 'vnd.oma.bcast.notification'
    VND_OMA_BCAST_PROVISIONINGTRIGGER                                   : str = 'vnd.oma.bcast.provisioningtrigger'
    VND_OMA_BCAST_SGBOOT                                                : str = 'vnd.oma.bcast.sgboot'
    VND_OMA_BCAST_SGDD                                                  : str = 'vnd.oma.bcast.sgdd'
    VND_OMA_BCAST_SGDU                                                  : str = 'vnd.oma.bcast.sgdu'
    VND_OMA_BCAST_SIMPLE_SYMBOL_CONTAINER                               : str = 'vnd.oma.bcast.simple-symbol-container'
    VND_OMA_BCAST_SMARTCARD_TRIGGER                                     : str = 'vnd.oma.bcast.smartcard-trigger'
    VND_OMA_BCAST_SPROV                                                 : str = 'vnd.oma.bcast.sprov'
    VND_OMA_BCAST_STKM                                                  : str = 'vnd.oma.bcast.stkm'
    VND_OMA_CAB_ADDRESS_BOOK                                            : str = 'vnd.oma.cab-address-book'
    VND_OMA_CAB_FEATURE_HANDLER                                         : str = 'vnd.oma.cab-feature-handler'
    VND_OMA_CAB_PCC                                                     : str = 'vnd.oma.cab-pcc'
    VND_OMA_CAB_SUBS_INVITE                                             : str = 'vnd.oma.cab-subs-invite'
    VND_OMA_CAB_USER_PREFS                                              : str = 'vnd.oma.cab-user-prefs'
    VND_OMA_DCD                                                         : str = 'vnd.oma.dcd'
    VND_OMA_DCDC                                                        : str = 'vnd.oma.dcdc'
    VND_OMA_DD2                                                         : str = 'vnd.oma.dd2'
    VND_OMA_DRM_RISD                                                    : str = 'vnd.oma.drm.risd'
    VND_OMA_GROUP_USAGE_LIST                                            : str = 'vnd.oma.group-usage-list'
    VND_OMA_LWM2M                                                       : str = 'vnd.oma.lwm2m'
    VND_OMA_PAL                                                         : str = 'vnd.oma.pal'
    VND_OMA_POC_DETAILED_PROGRESS_REPORT                                : str = 'vnd.oma.poc.detailed-progress-report'
    VND_OMA_POC_FINAL_REPORT                                            : str = 'vnd.oma.poc.final-report'
    VND_OMA_POC_GROUPS                                                  : str = 'vnd.oma.poc.groups'
    VND_OMA_POC_INVOCATION_DESCRIPTOR                                   : str = 'vnd.oma.poc.invocation-descriptor'
    VND_OMA_POC_OPTIMIZED_PROGRESS_REPORT                               : str = 'vnd.oma.poc.optimized-progress-report'
    VND_OMA_PUSH                                                        : str = 'vnd.oma.push'
    VND_OMA_SCIDM_MESSAGES                                              : str = 'vnd.oma.scidm.messages'
    VND_OMA_XCAP_DIRECTORY                                              : str = 'vnd.oma.xcap-directory'
    VND_OMADS_EMAIL                                                     : str = 'vnd.omads-email'
    VND_OMADS_FILE                                                      : str = 'vnd.omads-file'
    VND_OMADS_FOLDER                                                    : str = 'vnd.omads-folder'
    VND_OMALOC_SUPL_INIT                                                : str = 'vnd.omaloc-supl-init'
    VND_ONEPAGER                                                        : str = 'vnd.onepager'
    VND_ONEPAGERTAMP                                                    : str = 'vnd.onepagertamp'
    VND_ONEPAGERTAMX                                                    : str = 'vnd.onepagertamx'
    VND_ONEPAGERTAT                                                     : str = 'vnd.onepagertat'
    VND_ONEPAGERTATP                                                    : str = 'vnd.onepagertatp'
    VND_ONEPAGERTATX                                                    : str = 'vnd.onepagertatx'
    VND_OPENBLOX_GAME                                                   : str = 'vnd.openblox.game'
    VND_OPENBLOX_GAME_BINARY                                            : str = 'vnd.openblox.game-binary'
    VND_OPENEYE_OEB                                                     : str = 'vnd.openeye.oeb'
    VND_OPENGEX                                                         : str = 'vnd.opengex'
    VND_OPENSTREETMAP_DATA                                              : str = 'vnd.openstreetmap.data'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_CUSTOM_PROPERTIES                 : str = 'vnd.openxmlformats-officedocument.custom-properties'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_CUSTOMXMLPROPERTIES               : str = 'vnd.openxmlformats-officedocument.customxmlproperties'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWING                           : str = 'vnd.openxmlformats-officedocument.drawing'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_CHART                   : str = 'vnd.openxmlformats-officedocument.drawingml.chart'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_CHARTSHAPES             : str = 'vnd.openxmlformats-officedocument.drawingml.chartshapes'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_DIAGRAMCOLORS           : str = 'vnd.openxmlformats-officedocument.drawingml.diagramcolors'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_DIAGRAMDATA             : str = 'vnd.openxmlformats-officedocument.drawingml.diagramdata'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_DIAGRAMLAYOUT           : str = 'vnd.openxmlformats-officedocument.drawingml.diagramlayout'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_DIAGRAMSTYLE            : str = 'vnd.openxmlformats-officedocument.drawingml.diagramstyle'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_EXTENDED_PROPERTIES               : str = 'vnd.openxmlformats-officedocument.extended-properties'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_COMMENTAUTHORS     : str = 'vnd.openxmlformats-officedocument.presentationml.commentauthors'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_COMMENTS           : str = 'vnd.openxmlformats-officedocument.presentationml.comments'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_HANDOUTMASTER      : str = 'vnd.openxmlformats-officedocument.presentationml.handoutmaster'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_NOTESMASTER        : str = 'vnd.openxmlformats-officedocument.presentationml.notesmaster'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_NOTESSLIDE         : str = 'vnd.openxmlformats-officedocument.presentationml.notesslide'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_PRESENTATION       : str = 'vnd.openxmlformats-officedocument.presentationml.presentation'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_PRESENTATION_MAIN  : str = 'vnd.openxmlformats-officedocument.presentationml.presentation.main'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_PRESPROPS          : str = 'vnd.openxmlformats-officedocument.presentationml.presprops'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDE              : str = 'vnd.openxmlformats-officedocument.presentationml.slide'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDELAYOUT        : str = 'vnd.openxmlformats-officedocument.presentationml.slidelayout'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDEMASTER        : str = 'vnd.openxmlformats-officedocument.presentationml.slidemaster'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDESHOW          : str = 'vnd.openxmlformats-officedocument.presentationml.slideshow'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDESHOW_MAIN     : str = 'vnd.openxmlformats-officedocument.presentationml.slideshow.main'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDEUPDATEINFO    : str = 'vnd.openxmlformats-officedocument.presentationml.slideupdateinfo'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_TABLESTYLES        : str = 'vnd.openxmlformats-officedocument.presentationml.tablestyles'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_TAGS               : str = 'vnd.openxmlformats-officedocument.presentationml.tags'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_TEMPLATE           : str = 'vnd.openxmlformats-officedocument.presentationml.template'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_TEMPLATE_MAIN      : str = 'vnd.openxmlformats-officedocument.presentationml.template.main'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_VIEWPROPS          : str = 'vnd.openxmlformats-officedocument.presentationml.viewprops'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_CALCCHAIN           : str = 'vnd.openxmlformats-officedocument.spreadsheetml.calcchain'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_CHARTSHEET          : str = 'vnd.openxmlformats-officedocument.spreadsheetml.chartsheet'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_COMMENTS            : str = 'vnd.openxmlformats-officedocument.spreadsheetml.comments'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_CONNECTIONS         : str = 'vnd.openxmlformats-officedocument.spreadsheetml.connections'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_DIALOGSHEET         : str = 'vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_EXTERNALLINK        : str = 'vnd.openxmlformats-officedocument.spreadsheetml.externallink'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_PIVOTCACHEDEFINITION: str = 'vnd.openxmlformats-officedocument.spreadsheetml.pivotcachedefinition'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_PIVOTCACHERECORDS   : str = 'vnd.openxmlformats-officedocument.spreadsheetml.pivotcacherecords'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_PIVOTTABLE          : str = 'vnd.openxmlformats-officedocument.spreadsheetml.pivottable'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_QUERYTABLE          : str = 'vnd.openxmlformats-officedocument.spreadsheetml.querytable'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_REVISIONHEADERS     : str = 'vnd.openxmlformats-officedocument.spreadsheetml.revisionheaders'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_REVISIONLOG         : str = 'vnd.openxmlformats-officedocument.spreadsheetml.revisionlog'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_SHAREDSTRINGS       : str = 'vnd.openxmlformats-officedocument.spreadsheetml.sharedstrings'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_SHEET               : str = 'vnd.openxmlformats-officedocument.spreadsheetml.sheet'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_SHEET_MAIN          : str = 'vnd.openxmlformats-officedocument.spreadsheetml.sheet.main'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_SHEETMETADATA       : str = 'vnd.openxmlformats-officedocument.spreadsheetml.sheetmetadata'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_STYLES              : str = 'vnd.openxmlformats-officedocument.spreadsheetml.styles'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_TABLE               : str = 'vnd.openxmlformats-officedocument.spreadsheetml.table'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_TABLESINGLECELLS    : str = 'vnd.openxmlformats-officedocument.spreadsheetml.tablesinglecells'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_TEMPLATE            : str = 'vnd.openxmlformats-officedocument.spreadsheetml.template'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_TEMPLATE_MAIN       : str = 'vnd.openxmlformats-officedocument.spreadsheetml.template.main'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_USERNAMES           : str = 'vnd.openxmlformats-officedocument.spreadsheetml.usernames'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_VOLATILEDEPENDENCIES: str = 'vnd.openxmlformats-officedocument.spreadsheetml.volatiledependencies'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_WORKSHEET           : str = 'vnd.openxmlformats-officedocument.spreadsheetml.worksheet'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_THEME                             : str = 'vnd.openxmlformats-officedocument.theme'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_THEMEOVERRIDE                     : str = 'vnd.openxmlformats-officedocument.themeoverride'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_VMLDRAWING                        : str = 'vnd.openxmlformats-officedocument.vmldrawing'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_COMMENTS         : str = 'vnd.openxmlformats-officedocument.wordprocessingml.comments'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_DOCUMENT         : str = 'vnd.openxmlformats-officedocument.wordprocessingml.document'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_DOCUMENT_GLOSSARY: str = 'vnd.openxmlformats-officedocument.wordprocessingml.document.glossary'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_DOCUMENT_MAIN    : str = 'vnd.openxmlformats-officedocument.wordprocessingml.document.main'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_ENDNOTES         : str = 'vnd.openxmlformats-officedocument.wordprocessingml.endnotes'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_FONTTABLE        : str = 'vnd.openxmlformats-officedocument.wordprocessingml.fonttable'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_FOOTER           : str = 'vnd.openxmlformats-officedocument.wordprocessingml.footer'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_FOOTNOTES        : str = 'vnd.openxmlformats-officedocument.wordprocessingml.footnotes'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_NUMBERING        : str = 'vnd.openxmlformats-officedocument.wordprocessingml.numbering'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_SETTINGS         : str = 'vnd.openxmlformats-officedocument.wordprocessingml.settings'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_STYLES           : str = 'vnd.openxmlformats-officedocument.wordprocessingml.styles'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_TEMPLATE         : str = 'vnd.openxmlformats-officedocument.wordprocessingml.template'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_TEMPLATE_MAIN    : str = 'vnd.openxmlformats-officedocument.wordprocessingml.template.main'
    VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_WEBSETTINGS      : str = 'vnd.openxmlformats-officedocument.wordprocessingml.websettings'
    VND_OPENXMLFORMATS_PACKAGE_CORE_PROPERTIES                          : str = 'vnd.openxmlformats-package.core-properties'
    VND_OPENXMLFORMATS_PACKAGE_DIGITAL_SIGNATURE_XMLSIGNATURE           : str = 'vnd.openxmlformats-package.digital-signature-xmlsignature'
    VND_OPENXMLFORMATS_PACKAGE_RELATIONSHIPS                            : str = 'vnd.openxmlformats-package.relationships'
    VND_ORACLE_RESOURCE                                                 : str = 'vnd.oracle.resource'
    VND_ORANGE_INDATA                                                   : str = 'vnd.orange.indata'
    VND_OSA_NETDEPLOY                                                   : str = 'vnd.osa.netdeploy'
    VND_OSGEO_MAPGUIDE_PACKAGE                                          : str = 'vnd.osgeo.mapguide.package'
    VND_OSGI_BUNDLE                                                     : str = 'vnd.osgi.bundle'
    VND_OSGI_DP                                                         : str = 'vnd.osgi.dp'
    VND_OSGI_SUBSYSTEM                                                  : str = 'vnd.osgi.subsystem'
    VND_OTPS_CT_KIP                                                     : str = 'vnd.otps.ct-kip'
    VND_OXLI_COUNTGRAPH                                                 : str = 'vnd.oxli.countgraph'
    VND_PAGERDUTY                                                       : str = 'vnd.pagerduty'
    VND_PALM                                                            : str = 'vnd.palm'
    VND_PANOPLY                                                         : str = 'vnd.panoply'
    VND_PAOS_XML                                                        : str = 'vnd.paos.xml'
    VND_PARASOLID_TRANSMIT_BINARY                                       : str = 'vnd.parasolid.transmit.binary'
    VND_PARASOLID_TRANSMIT_TEXT                                         : str = 'vnd.parasolid.transmit.text'
    VND_PATENTDIVE                                                      : str = 'vnd.patentdive'
    VND_PATIENTECOMMSDOC                                                : str = 'vnd.patientecommsdoc'
    VND_PAWAAFILE                                                       : str = 'vnd.pawaafile'
    VND_PCO_B16                                                         : str = 'vnd.pco.b16'
    VND_PCOS                                                            : str = 'vnd.pcos'
    VND_PG_FORMAT                                                       : str = 'vnd.pg.format'
    VND_PG_OSASLI                                                       : str = 'vnd.pg.osasli'
    VND_PIACCESS_APPLICATION_LICENCE                                    : str = 'vnd.piaccess.application-licence'
    VND_PICSEL                                                          : str = 'vnd.picsel'
    VND_PMI_WIDGET                                                      : str = 'vnd.pmi.widget'
    VND_POC_GROUP_ADVERTISEMENT                                         : str = 'vnd.poc.group-advertisement'
    VND_POCKETLEARN                                                     : str = 'vnd.pocketlearn'
    VND_POWERBUILDER6                                                   : str = 'vnd.powerbuilder6'
    VND_POWERBUILDER6_S                                                 : str = 'vnd.powerbuilder6-s'
    VND_POWERBUILDER7                                                   : str = 'vnd.powerbuilder7'
    VND_POWERBUILDER7_S                                                 : str = 'vnd.powerbuilder7-s'
    VND_POWERBUILDER75                                                  : str = 'vnd.powerbuilder75'
    VND_POWERBUILDER75_S                                                : str = 'vnd.powerbuilder75-s'
    VND_PREMINET                                                        : str = 'vnd.preminet'
    VND_PRESONUS_MULTITRACK                                             : str = 'vnd.presonus.multitrack'
    VND_PREVIEWSYSTEMS_BOX                                              : str = 'vnd.previewsystems.box'
    VND_PROTEUS_MAGAZINE                                                : str = 'vnd.proteus.magazine'
    VND_PSFS                                                            : str = 'vnd.psfs'
    VND_PUBLISHARE_DELTA_TREE                                           : str = 'vnd.publishare-delta-tree'
    VND_PVI_PTID1                                                       : str = 'vnd.pvi.ptid1'
    VND_PWG_MULTIPLEXED                                                 : str = 'vnd.pwg-multiplexed'
    VND_PWG_XHTML_PRINT                                                 : str = 'vnd.pwg-xhtml-print'
    VND_PYTHA_PYOX                                                      : str = 'vnd.pytha.pyox'
    VND_QCELP                                                           : str = 'vnd.qcelp'
    VND_QUALCOMM_BREW_APP_RES                                           : str = 'vnd.qualcomm.brew-app-res'
    VND_QUARANTAINENET                                                  : str = 'vnd.quarantainenet'
    VND_QUARK_QUARKXPRESS                                               : str = 'vnd.quark.quarkxpress'
    VND_QUOBJECT_QUOXDOCUMENT                                           : str = 'vnd.quobject-quoxdocument'
    VND_RADGAMETTOOLS_BINK                                              : str = 'vnd.radgamettools.bink'
    VND_RADGAMETTOOLS_SMACKER                                           : str = 'vnd.radgamettools.smacker'
    VND_RADIANCE                                                        : str = 'vnd.radiance'
    VND_RADISYS_MOML                                                    : str = 'vnd.radisys.moml'
    VND_RADISYS_MSML                                                    : str = 'vnd.radisys.msml'
    VND_RADISYS_MSML_AUDIT                                              : str = 'vnd.radisys.msml-audit'
    VND_RADISYS_MSML_AUDIT_CONF                                         : str = 'vnd.radisys.msml-audit-conf'
    VND_RADISYS_MSML_AUDIT_CONN                                         : str = 'vnd.radisys.msml-audit-conn'
    VND_RADISYS_MSML_AUDIT_DIALOG                                       : str = 'vnd.radisys.msml-audit-dialog'
    VND_RADISYS_MSML_AUDIT_STREAM                                       : str = 'vnd.radisys.msml-audit-stream'
    VND_RADISYS_MSML_BASIC_LAYOUT                                       : str = 'vnd.radisys.msml-basic-layout'
    VND_RADISYS_MSML_CONF                                               : str = 'vnd.radisys.msml-conf'
    VND_RADISYS_MSML_DIALOG                                             : str = 'vnd.radisys.msml-dialog'
    VND_RADISYS_MSML_DIALOG_BASE                                        : str = 'vnd.radisys.msml-dialog-base'
    VND_RADISYS_MSML_DIALOG_FAX_DETECT                                  : str = 'vnd.radisys.msml-dialog-fax-detect'
    VND_RADISYS_MSML_DIALOG_FAX_SENDRECV                                : str = 'vnd.radisys.msml-dialog-fax-sendrecv'
    VND_RADISYS_MSML_DIALOG_GROUP                                       : str = 'vnd.radisys.msml-dialog-group'
    VND_RADISYS_MSML_DIALOG_SPEECH                                      : str = 'vnd.radisys.msml-dialog-speech'
    VND_RADISYS_MSML_DIALOG_TRANSFORM                                   : str = 'vnd.radisys.msml-dialog-transform'
    VND_RAINSTOR_DATA                                                   : str = 'vnd.rainstor.data'
    VND_RAPID                                                           : str = 'vnd.rapid'
    VND_RAR                                                             : str = 'vnd.rar'
    VND_REALVNC_BED                                                     : str = 'vnd.realvnc.bed'
    VND_RECORDARE_MUSICXML                                              : str = 'vnd.recordare.musicxml'
    VND_RENLEARN_RLPRINT                                                : str = 'vnd.renlearn.rlprint'
    VND_RESTFUL                                                         : str = 'vnd.restful'
    VND_RHETOREX_32KADPCM                                               : str = 'vnd.rhetorex.32kadpcm'
    VND_RIG_CRYPTONOTE                                                  : str = 'vnd.rig.cryptonote'
    VND_RIP                                                             : str = 'vnd.rip'
    VND_ROSETTE_ANNOTATED_DATA_MODEL                                    : str = 'vnd.rosette.annotated-data-model'
    VND_ROUTE66_LINK66                                                  : str = 'vnd.route66.link66'
    VND_RS_274X                                                         : str = 'vnd.rs-274x'
    VND_RUCKUS_DOWNLOAD                                                 : str = 'vnd.ruckus.download'
    VND_S3SMS                                                           : str = 'vnd.s3sms'
    VND_SAILINGTRACKER_TRACK                                            : str = 'vnd.sailingtracker.track'
    VND_SAP_VDS                                                         : str = 'vnd.sap.vds'
    VND_SAR                                                             : str = 'vnd.sar'
    VND_SBM_CID                                                         : str = 'vnd.sbm.cid'
    VND_SBM_MID2                                                        : str = 'vnd.sbm.mid2'
    VND_SCRIBUS                                                         : str = 'vnd.scribus'
    VND_SEALED_3DF                                                      : str = 'vnd.sealed.3df'
    VND_SEALED_CSF                                                      : str = 'vnd.sealed.csf'
    VND_SEALED_DOC                                                      : str = 'vnd.sealed.doc'
    VND_SEALED_EML                                                      : str = 'vnd.sealed.eml'
    VND_SEALED_MHT                                                      : str = 'vnd.sealed.mht'
    VND_SEALED_MPEG1                                                    : str = 'vnd.sealed.mpeg1'
    VND_SEALED_MPEG4                                                    : str = 'vnd.sealed.mpeg4'
    VND_SEALED_NET                                                      : str = 'vnd.sealed.net'
    VND_SEALED_PNG                                                      : str = 'vnd.sealed.png'
    VND_SEALED_PPT                                                      : str = 'vnd.sealed.ppt'
    VND_SEALED_SWF                                                      : str = 'vnd.sealed.swf'
    VND_SEALED_TIFF                                                     : str = 'vnd.sealed.tiff'
    VND_SEALED_XLS                                                      : str = 'vnd.sealed.xls'
    VND_SEALEDMEDIA_SOFTSEAL_GIF                                        : str = 'vnd.sealedmedia.softseal.gif'
    VND_SEALEDMEDIA_SOFTSEAL_HTML                                       : str = 'vnd.sealedmedia.softseal.html'
    VND_SEALEDMEDIA_SOFTSEAL_JPG                                        : str = 'vnd.sealedmedia.softseal.jpg'
    VND_SEALEDMEDIA_SOFTSEAL_MOV                                        : str = 'vnd.sealedmedia.softseal.mov'
    VND_SEALEDMEDIA_SOFTSEAL_MPEG                                       : str = 'vnd.sealedmedia.softseal.mpeg'
    VND_SEALEDMEDIA_SOFTSEAL_PDF                                        : str = 'vnd.sealedmedia.softseal.pdf'
    VND_SEEMAIL                                                         : str = 'vnd.seemail'
    VND_SEIS                                                            : str = 'vnd.seis'
    VND_SEMA                                                            : str = 'vnd.sema'
    VND_SEMD                                                            : str = 'vnd.semd'
    VND_SEMF                                                            : str = 'vnd.semf'
    VND_SENX_WARPSCRIPT                                                 : str = 'vnd.senx.warpscript'
    VND_SHADE_SAVE_FILE                                                 : str = 'vnd.shade-save-file'
    VND_SHANA_INFORMED_FORMDATA                                         : str = 'vnd.shana.informed.formdata'
    VND_SHANA_INFORMED_FORMTEMPLATE                                     : str = 'vnd.shana.informed.formtemplate'
    VND_SHANA_INFORMED_INTERCHANGE                                      : str = 'vnd.shana.informed.interchange'
    VND_SHANA_INFORMED_PACKAGE                                          : str = 'vnd.shana.informed.package'
    VND_SHOOTPROOF                                                      : str = 'vnd.shootproof'
    VND_SHOPKICK                                                        : str = 'vnd.shopkick'
    VND_SHP                                                             : str = 'vnd.shp'
    VND_SHX                                                             : str = 'vnd.shx'
    VND_SI_SIMP                                                         : str = 'vnd.si.simp'
    VND_SI_URICATALOGUE                                                 : str = 'vnd.si.uricatalogue'
    VND_SIGROK_SESSION                                                  : str = 'vnd.sigrok.session'
    VND_SIMTECH_MINDMAPPER                                              : str = 'vnd.simtech-mindmapper'
    VND_SIREN                                                           : str = 'vnd.siren'
    VND_SMAF                                                            : str = 'vnd.smaf'
    VND_SMART_NOTEBOOK                                                  : str = 'vnd.smart.notebook'
    VND_SMART_TEACHER                                                   : str = 'vnd.smart.teacher'
    VND_SNESDEV_PAGE_TABLE                                              : str = 'vnd.snesdev-page-table'
    VND_SOFTWARE602_FILLER_FORM                                         : str = 'vnd.software602.filler.form'
    VND_SOFTWARE602_FILLER_FORM_XML_ZIP                                 : str = 'vnd.software602.filler.form-xml-zip'
    VND_SOLENT_SDKM                                                     : str = 'vnd.solent.sdkm'
    VND_SOSI                                                            : str = 'vnd.sosi'
    VND_SPOTFIRE_DXP                                                    : str = 'vnd.spotfire.dxp'
    VND_SPOTFIRE_SFS                                                    : str = 'vnd.spotfire.sfs'
    VND_SQLITE3                                                         : str = 'vnd.sqlite3'
    VND_SSS_COD                                                         : str = 'vnd.sss-cod'
    VND_SSS_DTF                                                         : str = 'vnd.sss-dtf'
    VND_SSS_NTF                                                         : str = 'vnd.sss-ntf'
    VND_STEPMANIA_PACKAGE                                               : str = 'vnd.stepmania.package'
    VND_STEPMANIA_STEPCHART                                             : str = 'vnd.stepmania.stepchart'
    VND_STREET_STREAM                                                   : str = 'vnd.street-stream'
    VND_SUN_J2ME_APP_DESCRIPTOR                                         : str = 'vnd.sun.j2me.app-descriptor'
    VND_SUN_WADL                                                        : str = 'vnd.sun.wadl'
    VND_SUS_CALENDAR                                                    : str = 'vnd.sus-calendar'
    VND_SVD                                                             : str = 'vnd.svd'
    VND_SVF                                                             : str = 'vnd.svf'
    VND_SWIFTVIEW_ICS                                                   : str = 'vnd.swiftview-ics'
    VND_SYCLE                                                           : str = 'vnd.sycle'
    VND_SYNCML                                                          : str = 'vnd.syncml'
    VND_SYNCML_DM                                                       : str = 'vnd.syncml.dm'
    VND_SYNCML_DM_NOTIFICATION                                          : str = 'vnd.syncml.dm.notification'
    VND_SYNCML_DMDDF                                                    : str = 'vnd.syncml.dmddf'
    VND_SYNCML_DMTNDS                                                   : str = 'vnd.syncml.dmtnds'
    VND_SYNCML_DS_NOTIFICATION                                          : str = 'vnd.syncml.ds.notification'
    VND_TABLESCHEMA                                                     : str = 'vnd.tableschema'
    VND_TAO_INTENT_MODULE_ARCHIVE                                       : str = 'vnd.tao.intent-module-archive'
    VND_TCPDUMP_PCAP                                                    : str = 'vnd.tcpdump.pcap'
    VND_TENCENT_TAP                                                     : str = 'vnd.tencent.tap'
    VND_THINK_CELL_PPTTC                                                : str = 'vnd.think-cell.ppttc'
    VND_TMD_MEDIAFLEX_API                                               : str = 'vnd.tmd.mediaflex.api'
    VND_TML                                                             : str = 'vnd.tml'
    VND_TMOBILE_LIVETV                                                  : str = 'vnd.tmobile-livetv'
    VND_TRI_ONESOURCE                                                   : str = 'vnd.tri.onesource'
    VND_TRID_TPT                                                        : str = 'vnd.trid.tpt'
    VND_TRISCAPE_MXS                                                    : str = 'vnd.triscape.mxs'
    VND_TROLLTECH_LINGUIST                                              : str = 'vnd.trolltech.linguist'
    VND_TRUEAPP                                                         : str = 'vnd.trueapp'
    VND_TRUEDOC                                                         : str = 'vnd.truedoc'
    VND_UBISOFT_WEBPLAYER                                               : str = 'vnd.ubisoft.webplayer'
    VND_UFDL                                                            : str = 'vnd.ufdl'
    VND_UIQ_THEME                                                       : str = 'vnd.uiq.theme'
    VND_UMAJIN                                                          : str = 'vnd.umajin'
    VND_UNITY                                                           : str = 'vnd.unity'
    VND_UOML                                                            : str = 'vnd.uoml'
    VND_UPLANET_ALERT                                                   : str = 'vnd.uplanet.alert'
    VND_UPLANET_ALERT_WBXML                                             : str = 'vnd.uplanet.alert-wbxml'
    VND_UPLANET_BEARER_CHOICE                                           : str = 'vnd.uplanet.bearer-choice'
    VND_UPLANET_BEARER_CHOICE_WBXML                                     : str = 'vnd.uplanet.bearer-choice-wbxml'
    VND_UPLANET_CACHEOP                                                 : str = 'vnd.uplanet.cacheop'
    VND_UPLANET_CACHEOP_WBXML                                           : str = 'vnd.uplanet.cacheop-wbxml'
    VND_UPLANET_CHANNEL                                                 : str = 'vnd.uplanet.channel'
    VND_UPLANET_CHANNEL_WBXML                                           : str = 'vnd.uplanet.channel-wbxml'
    VND_UPLANET_LIST                                                    : str = 'vnd.uplanet.list'
    VND_UPLANET_LIST_WBXML                                              : str = 'vnd.uplanet.list-wbxml'
    VND_UPLANET_LISTCMD                                                 : str = 'vnd.uplanet.listcmd'
    VND_UPLANET_LISTCMD_WBXML                                           : str = 'vnd.uplanet.listcmd-wbxml'
    VND_UPLANET_SIGNAL                                                  : str = 'vnd.uplanet.signal'
    VND_URI_MAP                                                         : str = 'vnd.uri-map'
    VND_USDZ                                                            : str = 'vnd.usdz'
    VND_UVVU_MP4                                                        : str = 'vnd.uvvu.mp4'
    VND_VALVE_SOURCE_COMPILED_MAP                                       : str = 'vnd.valve.source.compiled-map'
    VND_VALVE_SOURCE_MATERIAL                                           : str = 'vnd.valve.source.material'
    VND_VALVE_SOURCE_TEXTURE                                            : str = 'vnd.valve.source.texture'
    VND_VCX                                                             : str = 'vnd.vcx'
    VND_VD_STUDY                                                        : str = 'vnd.vd-study'
    VND_VECTORWORKS                                                     : str = 'vnd.vectorworks'
    VND_VEL                                                             : str = 'vnd.vel'
    VND_VERIMATRIX_VCAS                                                 : str = 'vnd.verimatrix.vcas'
    VND_VERYANT_THIN                                                    : str = 'vnd.veryant.thin'
    VND_VES_ENCRYPTED                                                   : str = 'vnd.ves.encrypted'
    VND_VIDSOFT_VIDCONFERENCE                                           : str = 'vnd.vidsoft.vidconference'
    VND_VISIO                                                           : str = 'vnd.visio'
    VND_VISIONARY                                                       : str = 'vnd.visionary'
    VND_VIVIDENCE_SCRIPTFILE                                            : str = 'vnd.vividence.scriptfile'
    VND_VIVO                                                            : str = 'vnd.vivo'
    VND_VMX_CVSD                                                        : str = 'vnd.vmx.cvsd'
    VND_VSF                                                             : str = 'vnd.vsf'
    VND_VTU                                                             : str = 'vnd.vtu'
    VND_WAP_SI                                                          : str = 'vnd.wap.si'
    VND_WAP_SIC                                                         : str = 'vnd.wap.sic'
    VND_WAP_SL                                                          : str = 'vnd.wap.sl'
    VND_WAP_SLC                                                         : str = 'vnd.wap.slc'
    VND_WAP_WBMP                                                        : str = 'vnd.wap.wbmp'
    VND_WAP_WBXML                                                       : str = 'vnd.wap.wbxml'
    VND_WAP_WML                                                         : str = 'vnd.wap.wml'
    VND_WAP_WMLC                                                        : str = 'vnd.wap.wmlc'
    VND_WAP_WMLSCRIPT                                                   : str = 'vnd.wap.wmlscript'
    VND_WAP_WMLSCRIPTC                                                  : str = 'vnd.wap.wmlscriptc'
    VND_WEBTURBO                                                        : str = 'vnd.webturbo'
    VND_WFA_DPP                                                         : str = 'vnd.wfa.dpp'
    VND_WFA_P2P                                                         : str = 'vnd.wfa.p2p'
    VND_WFA_WSC                                                         : str = 'vnd.wfa.wsc'
    VND_WINDOWS_DEVICEPAIRING                                           : str = 'vnd.windows.devicepairing'
    VND_WMC                                                             : str = 'vnd.wmc'
    VND_WMF_BOOTSTRAP                                                   : str = 'vnd.wmf.bootstrap'
    VND_WOLFRAM_MATHEMATICA                                             : str = 'vnd.wolfram.mathematica'
    VND_WOLFRAM_MATHEMATICA_PACKAGE                                     : str = 'vnd.wolfram.mathematica.package'
    VND_WOLFRAM_PLAYER                                                  : str = 'vnd.wolfram.player'
    VND_WORDPERFECT                                                     : str = 'vnd.wordperfect'
    VND_WQD                                                             : str = 'vnd.wqd'
    VND_WRQ_HP3000_LABELLED                                             : str = 'vnd.wrq-hp3000-labelled'
    VND_WT_STF                                                          : str = 'vnd.wt.stf'
    VND_WV_CSP                                                          : str = 'vnd.wv.csp'
    VND_WV_SSP                                                          : str = 'vnd.wv.ssp'
    VND_XACML                                                           : str = 'vnd.xacml'
    VND_XARA                                                            : str = 'vnd.xara'
    VND_XFDL                                                            : str = 'vnd.xfdl'
    VND_XFDL_WEBFORM                                                    : str = 'vnd.xfdl.webform'
    VND_XIFF                                                            : str = 'vnd.xiff'
    VND_XMI                                                             : str = 'vnd.xmi'
    VND_XMPIE_CPKG                                                      : str = 'vnd.xmpie.cpkg'
    VND_XMPIE_DPKG                                                      : str = 'vnd.xmpie.dpkg'
    VND_XMPIE_PLAN                                                      : str = 'vnd.xmpie.plan'
    VND_XMPIE_PPKG                                                      : str = 'vnd.xmpie.ppkg'
    VND_XMPIE_XLIM                                                      : str = 'vnd.xmpie.xlim'
    VND_YAMAHA_HV_DIC                                                   : str = 'vnd.yamaha.hv-dic'
    VND_YAMAHA_HV_SCRIPT                                                : str = 'vnd.yamaha.hv-script'
    VND_YAMAHA_HV_VOICE                                                 : str = 'vnd.yamaha.hv-voice'
    VND_YAMAHA_OPENSCOREFORMAT                                          : str = 'vnd.yamaha.openscoreformat'
    VND_YAMAHA_OPENSCOREFORMAT_OSFPVG                                   : str = 'vnd.yamaha.openscoreformat.osfpvg'
    VND_YAMAHA_REMOTE_SETUP                                             : str = 'vnd.yamaha.remote-setup'
    VND_YAMAHA_SMAF_AUDIO                                               : str = 'vnd.yamaha.smaf-audio'
    VND_YAMAHA_SMAF_PHRASE                                              : str = 'vnd.yamaha.smaf-phrase'
    VND_YAMAHA_THROUGH_NGN                                              : str = 'vnd.yamaha.through-ngn'
    VND_YAMAHA_TUNNEL_UDPENCAP                                          : str = 'vnd.yamaha.tunnel-udpencap'
    VND_YAOWEME                                                         : str = 'vnd.yaoweme'
    VND_YELLOWRIVER_CUSTOM_MENU                                         : str = 'vnd.yellowriver-custom-menu'
    VND_YOUTUBE_YT                                                      : str = 'vnd.youtube.yt'
    VND_ZBRUSH_PCX                                                      : str = 'vnd.zbrush.pcx'
    VND_ZUL                                                             : str = 'vnd.zul'
    VND_ZZAZZ_DECK                                                      : str = 'vnd.zzazz.deck'
    VOICE_MESSAGE                                                       : str = 'voice-message'
    VOICEXML                                                            : str = 'voicexml'
    VORBIS                                                              : str = 'vorbis'
    VORBIS_CONFIG                                                       : str = 'vorbis-config'
    VOUCHER_CMS                                                         : str = 'voucher-cms'
    VP8                                                                 : str = 'vp8'
    VQ_RTCPXR                                                           : str = 'vq-rtcpxr'
    VTT                                                                 : str = 'vtt'
    WASM                                                                : str = 'wasm'
    WATCHERINFO                                                         : str = 'watcherinfo'
    WEBPUSH_OPTIONS                                                     : str = 'webpush-options'
    WHOISPP_QUERY                                                       : str = 'whoispp-query'
    WHOISPP_RESPONSE                                                    : str = 'whoispp-response'
    WIDGET                                                              : str = 'widget'
    WITA                                                                : str = 'wita'
    WMF                                                                 : str = 'wmf'
    WOFF                                                                : str = 'woff'
    WOFF2                                                               : str = 'woff2'
    WORDPERFECT5_1                                                      : str = 'wordperfect5.1'
    WSDL                                                                : str = 'wsdl'
    WSPOLICY                                                            : str = 'wspolicy'
    X_MIXED_REPLACE                                                     : str = 'x-mixed-replace'
    X_PKI_MESSAGE                                                       : str = 'x-pki-message'
    X_WWW_FORM_URLENCODED                                               : str = 'x-www-form-urlencoded'
    X_X509_CA_CERT                                                      : str = 'x-x509-ca-cert'
    X_X509_CA_RA_CERT                                                   : str = 'x-x509-ca-ra-cert'
    X_X509_NEXT_CA_CERT                                                 : str = 'x-x509-next-ca-cert'
    X3D                                                                 : str = 'x3d'
    X3D_VRML                                                            : str = 'x3d-vrml'
    X400_BP                                                             : str = 'x400-bp'
    XACML                                                               : str = 'xacml'
    XCAP_ATT                                                            : str = 'xcap-att'
    XCAP_CAPS                                                           : str = 'xcap-caps'
    XCAP_DIFF                                                           : str = 'xcap-diff'
    XCAP_EL                                                             : str = 'xcap-el'
    XCAP_ERROR                                                          : str = 'xcap-error'
    XCAP_NS                                                             : str = 'xcap-ns'
    XCON_CONFERENCE_INFO                                                : str = 'xcon-conference-info'
    XCON_CONFERENCE_INFO_DIFF                                           : str = 'xcon-conference-info-diff'
    XENC                                                                : str = 'xenc'
    XHTML                                                               : str = 'xhtml'
    XLIFF                                                               : str = 'xliff'
    XML                                                                 : str = 'xml'
    XML_DTD                                                             : str = 'xml-dtd'
    XML_EXTERNAL_PARSED_ENTITY                                          : str = 'xml-external-parsed-entity'
    XML_PATCH                                                           : str = 'xml-patch'
    XMPP                                                                : str = 'xmpp'
    XOP                                                                 : str = 'xop'
    XSLT                                                                : str = 'xslt'
    XV                                                                  : str = 'xv'
    YANG                                                                : str = 'yang'
    YANG_DATA                                                           : str = 'yang-data'
    YANG_PATCH                                                          : str = 'yang-patch'
    YIN                                                                 : str = 'yin'
    ZIP                                                                 : str = 'zip'
    ZLIB                                                                : str = 'zlib'
    ZSTD                                                                : str = 'zstd'
