class BugsterColors:
    """Bugster CLI color scheme based on Blue Crayola branding"""
    PRIMARY = "medium_purple1"         
    PRIMARY_LIGHT = "cornflower_blue"  # Light accent - #6495ED
    PRIMARY_DARK = "navy_blue"  # Dark contrast - #000080

    # Semantic Colors
    SUCCESS = "green"           # Success states - #008000
    WARNING = "yellow"          # Warnings, cautions - #FFFF00
    ERROR = "red"              # Errors, failures - #FF0000
    INFO = "cyan"              # Information - #00FFFF

    # Text Hierarchy
    TEXT_PRIMARY = "white"      # Main text - #FFFFFF
    TEXT_SECONDARY = "bright_white"  # Important secondary - #FFFFFF
    TEXT_DIM = "grey70"         # Helper text - #B3B3B3
    TEXT_SUBTLE = "grey50"      # Very subtle - #808080

    # Interactive Elements
    LINK = "blue"              # URLs, links - #0000FF
    COMMAND = "bright_cyan"     # CLI commands - #00FFFF
    VALUE = "bright_green"      # Important values - #00FF00
    KEY = "magenta"            # API keys, tokens - #FF00FF
