# coding: utf-8

"""
    YNAB API Endpoints

    Our API uses a REST based design, leverages the JSON data format, and relies upon HTTPS for transport. We respond with meaningful HTTP response codes and if an error occurs, we include error details in the response body.  API Documentation is at https://api.youneedabudget.com  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ynab_api.configuration import Configuration


class BulkResponseDataBulk(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'transaction_ids': 'list[str]',
        'duplicate_import_ids': 'list[str]'
    }

    attribute_map = {
        'transaction_ids': 'transaction_ids',
        'duplicate_import_ids': 'duplicate_import_ids'
    }

    def __init__(self, transaction_ids=None, duplicate_import_ids=None, local_vars_configuration=None):  # noqa: E501
        """BulkResponseDataBulk - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._transaction_ids = None
        self._duplicate_import_ids = None
        self.discriminator = None

        self.transaction_ids = transaction_ids
        self.duplicate_import_ids = duplicate_import_ids

    @property
    def transaction_ids(self):
        """Gets the transaction_ids of this BulkResponseDataBulk.  # noqa: E501

        The list of Transaction ids that were created.  # noqa: E501

        :return: The transaction_ids of this BulkResponseDataBulk.  # noqa: E501
        :rtype: list[str]
        """
        return self._transaction_ids

    @transaction_ids.setter
    def transaction_ids(self, transaction_ids):
        """Sets the transaction_ids of this BulkResponseDataBulk.

        The list of Transaction ids that were created.  # noqa: E501

        :param transaction_ids: The transaction_ids of this BulkResponseDataBulk.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and transaction_ids is None:  # noqa: E501
            raise ValueError("Invalid value for `transaction_ids`, must not be `None`")  # noqa: E501

        self._transaction_ids = transaction_ids

    @property
    def duplicate_import_ids(self):
        """Gets the duplicate_import_ids of this BulkResponseDataBulk.  # noqa: E501

        If any Transactions were not created because they had an import_id matching a transaction already on the same account, the specified import_id(s) will be included in this list.  # noqa: E501

        :return: The duplicate_import_ids of this BulkResponseDataBulk.  # noqa: E501
        :rtype: list[str]
        """
        return self._duplicate_import_ids

    @duplicate_import_ids.setter
    def duplicate_import_ids(self, duplicate_import_ids):
        """Sets the duplicate_import_ids of this BulkResponseDataBulk.

        If any Transactions were not created because they had an import_id matching a transaction already on the same account, the specified import_id(s) will be included in this list.  # noqa: E501

        :param duplicate_import_ids: The duplicate_import_ids of this BulkResponseDataBulk.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and duplicate_import_ids is None:  # noqa: E501
            raise ValueError("Invalid value for `duplicate_import_ids`, must not be `None`")  # noqa: E501

        self._duplicate_import_ids = duplicate_import_ids

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BulkResponseDataBulk):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BulkResponseDataBulk):
            return True

        return self.to_dict() != other.to_dict()
