"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetCurrentOrganizationAddressTypedDict(TypedDict):
    r"""The address of the organization."""

    street_and_number: NotRequired[str]
    r"""A street and street number."""
    postal_code: NotRequired[str]
    r"""A postal code. This field may be required if the provided country has a postal code system."""
    city: NotRequired[str]
    country: NotRequired[str]
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""


class GetCurrentOrganizationAddress(BaseModel):
    r"""The address of the organization."""

    street_and_number: Annotated[
        Optional[str], pydantic.Field(alias="streetAndNumber")
    ] = None
    r"""A street and street number."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""A postal code. This field may be required if the provided country has a postal code system."""

    city: Optional[str] = None

    country: Optional[str] = None
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""


class GetCurrentOrganizationSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetCurrentOrganizationSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetCurrentOrganizationDashboardTypedDict(TypedDict):
    r"""Direct link to the organization's Mollie dashboard."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetCurrentOrganizationDashboard(BaseModel):
    r"""Direct link to the organization's Mollie dashboard."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetCurrentOrganizationDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetCurrentOrganizationDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetCurrentOrganizationLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetCurrentOrganizationSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    dashboard: NotRequired[GetCurrentOrganizationDashboardTypedDict]
    r"""Direct link to the organization's Mollie dashboard."""
    documentation: NotRequired[GetCurrentOrganizationDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetCurrentOrganizationLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[
        Optional[GetCurrentOrganizationSelf], pydantic.Field(alias="self")
    ] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    dashboard: Optional[GetCurrentOrganizationDashboard] = None
    r"""Direct link to the organization's Mollie dashboard."""

    documentation: Optional[GetCurrentOrganizationDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetCurrentOrganizationResponseBodyTypedDict(TypedDict):
    r"""The current organization object."""

    resource: NotRequired[str]
    r"""Indicates the response contains an organization object. Will always contain the string `organization` for this resource type."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this organization. Example: `org_12345678`."""
    name: NotRequired[str]
    r"""The name of the organization."""
    email: NotRequired[str]
    r"""The email address associated with the organization."""
    locale: NotRequired[str]
    r"""The preferred locale of the merchant, as set in their Mollie dashboard."""
    address: NotRequired[GetCurrentOrganizationAddressTypedDict]
    r"""The address of the organization."""
    registration_number: NotRequired[str]
    r"""The registration number of the organization at their local chamber of commerce."""
    vat_number: NotRequired[Nullable[str]]
    r"""The VAT number of the organization, if based in the European Union or in The United Kingdom. VAT numbers are verified against the international registry *VIES*.

    The field is not present for merchants residing in other countries.
    """
    vat_regulation: NotRequired[Nullable[str]]
    r"""Mollie applies Dutch VAT for merchants based in The Netherlands, British VAT for merchants based in The United Kingdom, and shifted VAT for merchants in the European Union.

    The field is not present for merchants residing in other countries.

    Possible values: `dutch` `british` `shifted`
    """
    links: NotRequired[GetCurrentOrganizationLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetCurrentOrganizationResponseBody(BaseModel):
    r"""The current organization object."""

    resource: Optional[str] = "organization"
    r"""Indicates the response contains an organization object. Will always contain the string `organization` for this resource type."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this organization. Example: `org_12345678`."""

    name: Optional[str] = None
    r"""The name of the organization."""

    email: Optional[str] = None
    r"""The email address associated with the organization."""

    locale: Optional[str] = None
    r"""The preferred locale of the merchant, as set in their Mollie dashboard."""

    address: Optional[GetCurrentOrganizationAddress] = None
    r"""The address of the organization."""

    registration_number: Annotated[
        Optional[str], pydantic.Field(alias="registrationNumber")
    ] = None
    r"""The registration number of the organization at their local chamber of commerce."""

    vat_number: Annotated[OptionalNullable[str], pydantic.Field(alias="vatNumber")] = (
        UNSET
    )
    r"""The VAT number of the organization, if based in the European Union or in The United Kingdom. VAT numbers are verified against the international registry *VIES*.

    The field is not present for merchants residing in other countries.
    """

    vat_regulation: Annotated[
        OptionalNullable[str], pydantic.Field(alias="vatRegulation")
    ] = UNSET
    r"""Mollie applies Dutch VAT for merchants based in The Netherlands, British VAT for merchants based in The United Kingdom, and shifted VAT for merchants in the European Union.

    The field is not present for merchants residing in other countries.

    Possible values: `dutch` `british` `shifted`
    """

    links: Annotated[
        Optional[GetCurrentOrganizationLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "name",
            "email",
            "locale",
            "address",
            "registrationNumber",
            "vatNumber",
            "vatRegulation",
            "_links",
        ]
        nullable_fields = ["vatNumber", "vatRegulation"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
