/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ArcKubernetesClusterExtensionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/arc_kubernetes_cluster_extension#cluster_id ArcKubernetesClusterExtension#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/arc_kubernetes_cluster_extension#configuration_protected_settings ArcKubernetesClusterExtension#configuration_protected_settings}
    */
    readonly configurationProtectedSettings?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/arc_kubernetes_cluster_extension#configuration_settings ArcKubernetesClusterExtension#configuration_settings}
    */
    readonly configurationSettings?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/arc_kubernetes_cluster_extension#extension_type ArcKubernetesClusterExtension#extension_type}
    */
    readonly extensionType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/arc_kubernetes_cluster_extension#id ArcKubernetesClusterExtension#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/arc_kubernetes_cluster_extension#name ArcKubernetesClusterExtension#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/arc_kubernetes_cluster_extension#release_namespace ArcKubernetesClusterExtension#release_namespace}
    */
    readonly releaseNamespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/arc_kubernetes_cluster_extension#release_train ArcKubernetesClusterExtension#release_train}
    */
    readonly releaseTrain?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/arc_kubernetes_cluster_extension#target_namespace ArcKubernetesClusterExtension#target_namespace}
    */
    readonly targetNamespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/arc_kubernetes_cluster_extension#version ArcKubernetesClusterExtension#version}
    */
    readonly version?: string;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/arc_kubernetes_cluster_extension#identity ArcKubernetesClusterExtension#identity}
    */
    readonly identity: ArcKubernetesClusterExtensionIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/arc_kubernetes_cluster_extension#timeouts ArcKubernetesClusterExtension#timeouts}
    */
    readonly timeouts?: ArcKubernetesClusterExtensionTimeouts;
}
export interface ArcKubernetesClusterExtensionIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/arc_kubernetes_cluster_extension#type ArcKubernetesClusterExtension#type}
    */
    readonly type: string;
}
export declare function arcKubernetesClusterExtensionIdentityToTerraform(struct?: ArcKubernetesClusterExtensionIdentityOutputReference | ArcKubernetesClusterExtensionIdentity): any;
export declare function arcKubernetesClusterExtensionIdentityToHclTerraform(struct?: ArcKubernetesClusterExtensionIdentityOutputReference | ArcKubernetesClusterExtensionIdentity): any;
export declare class ArcKubernetesClusterExtensionIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArcKubernetesClusterExtensionIdentity | undefined;
    set internalValue(value: ArcKubernetesClusterExtensionIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ArcKubernetesClusterExtensionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/arc_kubernetes_cluster_extension#create ArcKubernetesClusterExtension#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/arc_kubernetes_cluster_extension#delete ArcKubernetesClusterExtension#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/arc_kubernetes_cluster_extension#read ArcKubernetesClusterExtension#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/arc_kubernetes_cluster_extension#update ArcKubernetesClusterExtension#update}
    */
    readonly update?: string;
}
export declare function arcKubernetesClusterExtensionTimeoutsToTerraform(struct?: ArcKubernetesClusterExtensionTimeouts | cdktf.IResolvable): any;
export declare function arcKubernetesClusterExtensionTimeoutsToHclTerraform(struct?: ArcKubernetesClusterExtensionTimeouts | cdktf.IResolvable): any;
export declare class ArcKubernetesClusterExtensionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArcKubernetesClusterExtensionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ArcKubernetesClusterExtensionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/arc_kubernetes_cluster_extension azurerm_arc_kubernetes_cluster_extension}
*/
export declare class ArcKubernetesClusterExtension extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_arc_kubernetes_cluster_extension";
    /**
    * Generates CDKTF code for importing a ArcKubernetesClusterExtension resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ArcKubernetesClusterExtension to import
    * @param importFromId The id of the existing ArcKubernetesClusterExtension that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/arc_kubernetes_cluster_extension#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ArcKubernetesClusterExtension to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/arc_kubernetes_cluster_extension azurerm_arc_kubernetes_cluster_extension} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ArcKubernetesClusterExtensionConfig
    */
    constructor(scope: Construct, id: string, config: ArcKubernetesClusterExtensionConfig);
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _configurationProtectedSettings?;
    get configurationProtectedSettings(): {
        [key: string]: string;
    };
    set configurationProtectedSettings(value: {
        [key: string]: string;
    });
    resetConfigurationProtectedSettings(): void;
    get configurationProtectedSettingsInput(): {
        [key: string]: string;
    } | undefined;
    private _configurationSettings?;
    get configurationSettings(): {
        [key: string]: string;
    };
    set configurationSettings(value: {
        [key: string]: string;
    });
    resetConfigurationSettings(): void;
    get configurationSettingsInput(): {
        [key: string]: string;
    } | undefined;
    get currentVersion(): string;
    private _extensionType?;
    get extensionType(): string;
    set extensionType(value: string);
    get extensionTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _releaseNamespace?;
    get releaseNamespace(): string;
    set releaseNamespace(value: string);
    resetReleaseNamespace(): void;
    get releaseNamespaceInput(): string | undefined;
    private _releaseTrain?;
    get releaseTrain(): string;
    set releaseTrain(value: string);
    resetReleaseTrain(): void;
    get releaseTrainInput(): string | undefined;
    private _targetNamespace?;
    get targetNamespace(): string;
    set targetNamespace(value: string);
    resetTargetNamespace(): void;
    get targetNamespaceInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _identity;
    get identity(): ArcKubernetesClusterExtensionIdentityOutputReference;
    putIdentity(value: ArcKubernetesClusterExtensionIdentity): void;
    get identityInput(): ArcKubernetesClusterExtensionIdentity | undefined;
    private _timeouts;
    get timeouts(): ArcKubernetesClusterExtensionTimeoutsOutputReference;
    putTimeouts(value: ArcKubernetesClusterExtensionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ArcKubernetesClusterExtensionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
